/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.payablebill;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class PayableEleBillEdit
extends AbstractTmcBillEdit {
    private static final String BAR_DRAWBILL = "bar_drawbill";
    private static final String[] needUpdateOpKeyArr = new String[]{"submitele", "issureticket", "canceldrawbill", "audit", "unaudit"};

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BAR_DRAWBILL.equals(itemKey)) {
            String billStatus = (String)this.getModel().getValue("billstatus");
            String draftTranStatus = (String)this.getModel().getValue("draftbilltranstatus");
            if (!billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u786e\u8ba4\u51fa\u7968\u3002", (String)"PayableBillEdit_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)draftTranStatus) && !DraftTranStatusEnum.FAILING.getValue().equals(draftTranStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u7968\u636e\u4ea4\u6613\u72b6\u6001\u4e3a\u7a7a\u6216\u4ea4\u6613\u5931\u8d25\u624d\u53ef\u4ee5\u786e\u8ba4\u51fa\u7968", (String)"PayableBillEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject draftBillType = (DynamicObject)this.getModel().getValue("draftbilltype");
            String billMedium = draftBillType.getString("billmedium");
            if ("2".equals(billMedium)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7535\u7968\u53ef\u4ee5\u5728\u7ebf\u51fa\u7968\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayableBillEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(BAR_DRAWBILL, (IFormPlugin)this));
                evt.setCancel(true);
            } else {
                OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"drawbillsave", (String)"cdm_payablebill", (Object[])new Object[]{this.getModel().getDataEntity().getPkValue()}, (OperateOption)OperateOption.create());
                if (operationResult.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u51fa\u7968\u6210\u529f\u3002", (String)"PayableBillEdit_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    this.getView().updateView();
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u51fa\u7968\u5931\u8d25\u3002", (String)"PayableBillEdit_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)BAR_DRAWBILL, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject company = dataEntity.getDynamicObject("company");
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            boolean isHaveDraftbillno = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)company.getLong("id"), (String)"ishavedraftbillno");
            if (!isHaveDraftbillno) {
                String draftbillno = dataEntity.getString("draftbillno");
                if (EmptyUtil.isEmpty((String)draftbillno)) {
                    this.showDraftBIllnoView();
                } else {
                    this.callDrawBillSave();
                }
            } else {
                this.showDraftBIllnoView();
            }
        } else if ("SUMITELEC_CONFIRM".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getView().invokeOperation("submitele");
        }
    }

    private void showDraftBIllnoView() {
        Date expireDate = (Date)this.getModel().getValue("draftbillexpiredate");
        String draftBillNo = (String)this.getModel().getValue("draftbillno");
        Date issueDate = (Date)this.getModel().getValue("issuedate");
        Date acceptdate = (Date)this.getModel().getValue("acceptdate");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cdm_confirmdrawbill");
        formShowParameter.setCustomParam("expireDate", (Object)expireDate);
        formShowParameter.setCustomParam("draftBillNo", (Object)draftBillNo);
        formShowParameter.setCustomParam("issueDate", (Object)issueDate);
        formShowParameter.setCustomParam("acceptdate", (Object)acceptdate);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, BAR_DRAWBILL);
        formShowParameter.setCloseCallBack(callBack);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)BAR_DRAWBILL)) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            String draftBillNo = (String)returnData.get("draftbillno");
            Date drawDate = (Date)returnData.get("drawdate");
            Date acceptDate = (Date)returnData.get("acceptdate");
            this.getModel().setValue("draftbillno", (Object)draftBillNo);
            this.getModel().setValue("issuedate", (Object)drawDate);
            this.getModel().setValue("acceptdate", (Object)acceptDate);
            this.getModel().setValue("draftbilltranstatus", (Object)DraftTranStatusEnum.SUCCESS.getValue());
            this.callDrawBillSave();
        }
    }

    private void callDrawBillSave() {
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ischekrepeat", "true");
        OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"drawbillsave", (String)"cdm_payablebill", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)operateOption);
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u51fa\u7968\u6210\u529f\u3002", (String)"PayableBillEdit_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            this.getView().updateView();
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u51fa\u7968\u5931\u8d25\u3002", (String)"PayableBillEdit_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        DynamicObject data;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("submit".equals(operateKey) && opResult.isSuccess() && !EmptyUtil.isEmpty((String)(data = this.getModel().getDataEntity(true)).getString("sourcebillid")) && SourceEnum.CAS.getValue().equals(data.getString("source")) && DraftHelper.isPromissory((Object)data.getDynamicObject("draftbilltype"))) {
            this.getModel().setValue("draftbilltranstatus", (Object)DraftTranStatusEnum.SUCCESS.getValue());
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"drawbillsave", (String)"cdm_payablebill", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                this.getView().updateView();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u51fa\u7968\u5931\u8d25\u3002", (String)"PayableBillEdit_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            }
        }
        if (Arrays.asList(needUpdateOpKeyArr).contains(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
        if ("submiteleconfirm".equals(operateKey) && opResult.isSuccess() && opResult.getSuccessPkIds().size() > 0) {
            List ids = opResult.getSuccessPkIds();
            DynamicObject[] payBills = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_payablebill"));
            boolean billNoIsNotNull = Arrays.stream(payBills).anyMatch(payableBill -> !EmptyUtil.isEmpty((String)payableBill.getString("draftbillno")) || !EmptyUtil.isEmpty((String)payableBill.getString("basedraftbillno")));
            if (billNoIsNotNull) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u63d0\u4ea4\u7535\u7968\u540e\uff0c\u5c06\u6e05\u7a7a\u5df2\u586b\u5199\u7684\u7968\u636e\u53f7\u7801\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayableBillSubmitEleValidator_6", (String)"tmc-cdm-business", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("SUMITELEC_CONFIRM", (IFormPlugin)this));
            } else {
                this.getView().invokeOperation("submitele");
            }
        }
    }
}

