/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.payablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.BillTypeUnitEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class PayableEleBillList
extends AbstractTmcBillBaseList {
    private static final Log logger = LogFactory.getLog(PayableEleBillList.class);
    public static final String BAR_DRAWBILL = "bar_drawbill";
    private static final String[] needUpdateOpKeyArr = new String[]{"submitele", "drawbillsave", "canceldrawbill"};
    private static final String SURETYREMAINAMOUNT = "suretyremainamount";
    private static final String AMOUNTOFCREDIT = "amountofcredit";

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (key.equals(BAR_DRAWBILL)) {
            List selectIds = this.getSelectedIdList();
            if (selectIds.size() == 0) {
                return;
            }
            QFilter filterId = new QFilter("id", "in", (Object)selectIds);
            QFilter[] filtersId = new QFilter[]{filterId};
            Object[] dynamicObjects = BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)"draftbilltranstatus,billstatus,draftbilltype,company,draftbillno", (QFilter[])filtersId);
            HashSet<Boolean> booleanSet = new HashSet<Boolean>();
            boolean isNeedShowView = true;
            if (EmptyUtil.isNoEmpty((Object[])dynamicObjects)) {
                Set comapnyIdSet = Arrays.stream(dynamicObjects).map(e -> e.getDynamicObject("company").getLong("id")).collect(Collectors.toSet());
                String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
                Iterator iterator = comapnyIdSet.iterator();
                while (iterator.hasNext()) {
                    Long companyId = (Long)iterator.next();
                    boolean isHaveDraftbillno = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)companyId, (String)"ishavedraftbillno");
                    booleanSet.add(isHaveDraftbillno);
                }
                if (booleanSet.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u9009\u62e9\u591a\u6761\u6570\u636e\u786e\u8ba4\u51fa\u7968\u3002", (String)"PayableEleBillList_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (booleanSet.size() == 1) {
                    if (booleanSet.contains(true)) {
                        if (selectIds.size() > 1) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u9009\u62e9\u591a\u6761\u6570\u636e\u786e\u8ba4\u51fa\u7968\u3002", (String)"PayableEleBillList_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                            return;
                        }
                    } else {
                        List noDraftbillnoList = Arrays.stream(dynamicObjects).filter(e -> EmptyUtil.isEmpty((String)e.getString("draftbillno"))).collect(Collectors.toList());
                        if (EmptyUtil.isNoEmpty(noDraftbillnoList)) {
                            if (selectIds.size() != 1) {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u786e\u8ba4\u51fa\u7968\u4ec5\u652f\u6301\u64cd\u4f5c\u5df2\u586b\u5199\u7968\u636e\u53f7\u7801\u7684\u5355\u636e", (String)"PayableEleBillList_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                                return;
                            }
                        } else {
                            isNeedShowView = false;
                        }
                    }
                }
            }
            for (Object dynamicObject : dynamicObjects) {
                String billStatus = dynamicObject.getString("billstatus");
                String draftTranStatus = dynamicObject.getString("draftbilltranstatus");
                if (!billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u786e\u8ba4\u51fa\u7968\u3002", (String)"PayableEleBillList_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!StringUtils.isNotEmpty((CharSequence)draftTranStatus) || DraftTranStatusEnum.FAILING.getValue().equals(draftTranStatus)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7968\u636e\u4ea4\u6613\u72b6\u6001\u4e3a\u7a7a\u6216\u4ea4\u6613\u5931\u8d25\u65f6\uff0c\u624d\u80fd\u8fdb\u884c\u786e\u8ba4\u51fa\u7968\u3002", (String)"PayableEleBillList_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject draftBillType = dynamicObjects[0].getDynamicObject("draftbilltype");
            String billMedium = draftBillType.getString("billmedium");
            if ("2".equals(billMedium) && isNeedShowView) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7535\u7968\u53ef\u4ee5\u5728\u7ebf\u51fa\u7968\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayableEleBillList_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(BAR_DRAWBILL, (IFormPlugin)this));
            } else {
                Object[] objects = Arrays.stream(dynamicObjects).map(DataEntityBase::getPkValue).toArray();
                OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"drawbillsave", (String)"cdm_payablebill", (Object[])objects, (OperateOption)OperateOption.create());
                this.callDrawbillSave(operationResult);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)BAR_DRAWBILL, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            List selectIds = this.getSelectedIdList();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cdm_payablebill");
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])selectIds.toArray(), (DynamicObjectType)type);
            Date expireDate = (Date)dynamicObjects[0].get("draftbillexpiredate");
            Date issueDate = (Date)dynamicObjects[0].get("issuedate");
            Date acceptdate = (Date)dynamicObjects[0].get("acceptdate");
            String draftBillNo = (String)dynamicObjects[0].get("draftbillno");
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("cdm_confirmdrawbill");
            formShowParameter.setCustomParam("expireDate", (Object)expireDate);
            formShowParameter.setCustomParam("draftBillNo", (Object)draftBillNo);
            formShowParameter.setCustomParam("issueDate", (Object)issueDate);
            formShowParameter.setCustomParam("acceptdate", (Object)acceptdate);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, BAR_DRAWBILL);
            formShowParameter.setCloseCallBack(callBack);
            this.getView().showForm(formShowParameter);
        } else if ("SUMITELEC_CONFIRM".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getView().invokeOperation("submitele");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)BAR_DRAWBILL)) {
            if (closedCallBackEvent.getReturnData() == null) {
                return;
            }
            List selectIds = this.getSelectedIdList();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cdm_payablebill");
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])selectIds.toArray(), (DynamicObjectType)type);
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            String draftBillNo = (String)returnData.get("draftbillno");
            Date drawDate = (Date)returnData.get("drawdate");
            Date acceptdate = (Date)returnData.get("acceptdate");
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("draftbillno", (Object)draftBillNo);
                dynamicObject.set("issuedate", (Object)drawDate);
                dynamicObject.set("acceptdate", (Object)acceptdate);
                dynamicObject.set("draftbilltranstatus", (Object)DraftTranStatusEnum.SUCCESS.getValue());
                this.issuedateChange(dynamicObject);
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ischekrepeat", "true");
            logger.info("is set param");
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"drawbillsave", (String)"cdm_payablebill", (DynamicObject[])dynamicObjects, (OperateOption)operateOption);
            this.callDrawbillSave(operationResult);
        }
    }

    private void callDrawbillSave(OperationResult operationResult) {
        if (EmptyUtil.isNoEmpty((Object)operationResult) && operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u51fa\u7968\u6210\u529f\u3002", (String)"PayableEleBillList_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u51fa\u7968\u5931\u8d25\u3002", (String)"PayableEleBillList_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("submitele".equals(operateKey) && opResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        if (Arrays.asList(needUpdateOpKeyArr).contains(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
        if ("submiteleconfirm".equals(operateKey) && opResult.isSuccess() && opResult.getSuccessPkIds().size() > 0) {
            List ids = opResult.getSuccessPkIds();
            DynamicObject[] payBills = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_payablebill"));
            boolean billNoIsNotNull = Arrays.stream(payBills).anyMatch(payableBill -> !EmptyUtil.isEmpty((String)payableBill.getString("draftbillno")) || !EmptyUtil.isEmpty((String)payableBill.getString("basedraftbillno")));
            if (billNoIsNotNull) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u63d0\u4ea4\u7535\u7968\u540e\uff0c\u5c06\u6e05\u7a7a\u5df2\u586b\u5199\u7684\u7968\u636e\u53f7\u7801\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayableBillSubmitEleValidator_6", (String)"tmc-cdm-business", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("SUMITELEC_CONFIRM", (IFormPlugin)this));
            } else {
                this.getView().invokeOperation("submitele");
            }
        }
        if ("relationtrackdown".equals(operateKey) && opResult.isSuccess() && opResult.getSuccessPkIds().size() > 0) {
            Object pkValue = args.getOperationResult().getSuccessPkIds().get(0);
            QFilter qFilter = new QFilter("sourceid", "=", pkValue);
            Object[] electronicPayDeals = TmcDataServiceHelper.load((String)"cdm_electronic_pay_deal", (String)"id,sourceid", (QFilter[])qFilter.toArray());
            if (!EmptyUtil.isEmpty((Object[])electronicPayDeals)) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setAppId("cdm");
                parameter.setFormId("cdm_electronic_pay_deal");
                parameter.setPkId((Object)electronicPayDeals[0].getLong("id"));
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8054\u67e5\u6570\u636e\u3002", (String)"CdmBizResource_167", (String)"tmc-cdm-common", (Object[])new Object[0]));
            }
        }
        if ("submit".equals(operateKey) && opResult.isSuccess()) {
            List selectIds = this.getSelectedIdList();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cdm_payablebill");
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])selectIds.toArray(), (DynamicObjectType)type);
            ArrayList<DynamicObject> needCallDrawSaveList = new ArrayList<DynamicObject>(6);
            for (DynamicObject payBill : dynamicObjects) {
                if (EmptyUtil.isEmpty((Long)payBill.getLong("sourcebillid")) || !SourceEnum.CAS.getValue().equals(payBill.getString("source")) || !DraftHelper.isPromissory((Object)payBill.getDynamicObject("draftbilltype"))) continue;
                needCallDrawSaveList.add(payBill);
            }
            if (EmptyUtil.isNoEmpty(needCallDrawSaveList)) {
                OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"drawbillsave", (String)"cdm_payablebill", (DynamicObject[])needCallDrawSaveList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                if (operationResult.isSuccess()) {
                    this.getView().invokeOperation("refresh");
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u51fa\u7968\u5931\u8d25\u3002", (String)"PayableBillEdit_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void issuedateChange(DynamicObject payBillDy) {
        Date draftBillExpireDate = this.getDraftBillDefaultExpireDate(payBillDy);
        Date date = payBillDy.getDate("draftbillexpiredate");
        if (date == null && draftBillExpireDate != null || draftBillExpireDate != null && date != null && date.after(draftBillExpireDate)) {
            payBillDy.set("draftbillexpiredate", (Object)draftBillExpireDate);
        }
    }

    private Date getDraftBillDefaultExpireDate(DynamicObject payBillDy) {
        DynamicObject draftbilltypeDO = payBillDy.getDynamicObject("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltypeDO)) {
            Date draftbillexpiredate = null;
            int validitytime = draftbilltypeDO.getInt("defaulttime");
            String unit = draftbilltypeDO.getString("defaultunit");
            Date issuedate = payBillDy.getDate("issuedate");
            if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.MONTH.getValue()) && issuedate != null) {
                draftbillexpiredate = DateUtils.getNextMonth((Date)issuedate, (int)validitytime);
                if (draftbillexpiredate.getDate() != issuedate.getDate()) {
                    draftbillexpiredate = DateUtils.getNextDay((Date)draftbillexpiredate, (int)(-draftbillexpiredate.getDate()));
                }
            } else if (StringUtils.equals((CharSequence)unit, (CharSequence)BillTypeUnitEnum.DAY.getValue()) && issuedate != null) {
                draftbillexpiredate = DateUtils.getNextDay((Date)issuedate, (int)validitytime);
            }
            return draftbillexpiredate;
        }
        return null;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new GetListDataProvider());
    }

    static class GetListDataProvider
    extends ListDataProvider {
        GetListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            ArrayList ids = new ArrayList(rows.size());
            boolean isContainSurety = false;
            boolean isContainCredit = false;
            DataEntityPropertyCollection properties = ((DynamicObject)rows.get(0)).getDataEntityType().getProperties();
            if (properties.containsKey((Object)PayableEleBillList.SURETYREMAINAMOUNT)) {
                isContainSurety = true;
            }
            if (properties.containsKey((Object)PayableEleBillList.AMOUNTOFCREDIT)) {
                isContainCredit = true;
            }
            logger.info("isContainCredit is:" + isContainCredit + ",isContainCredit:" + isContainCredit);
            if (!isContainSurety && !isContainCredit) {
                return rows;
            }
            rows.forEach(row -> ids.add(row.getLong("id")));
            if (ids.size() == 0) {
                return rows;
            }
            Map<Object, Object> draftIdAndCreditMap = new HashMap(8);
            Map<Object, Object> draftIdAndSuretyMap = new HashMap(8);
            if (isContainCredit || isContainSurety) {
                DynamicObjectCollection suretybills;
                Set hasSuretyPayDraftIdSet;
                QFilter source_qFilter;
                Set hasCreditPayDraftIdSet;
                DynamicObjectCollection payDraftList = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id,creditlimit,paybilltype,source,sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", ids), new QFilter("rptype", "=", (Object)"paybill")});
                if (isContainCredit && EmptyUtil.isNoEmpty(hasCreditPayDraftIdSet = payDraftList.stream().filter(e -> EmptyUtil.isNoEmpty((Long)e.getLong("creditlimit"))).map(x -> x.getLong("id")).collect(Collectors.toSet()))) {
                    source_qFilter = new QFilter("sourcebillid", "in", hasCreditPayDraftIdSet);
                    QFilter isrele_qFilter = new QFilter("isrelease", "=", (Object)"0");
                    QFilter status_qFilter = new QFilter("billstatus", "=", (Object)"C");
                    DynamicObjectCollection creditUses = QueryServiceHelper.query((String)"cfm_credituse", (String)"sourcebillentryid,sourcebillid, realamt", (QFilter[])new QFilter[]{source_qFilter, isrele_qFilter, status_qFilter});
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)creditUses)) {
                        draftIdAndCreditMap = creditUses.stream().collect(Collectors.groupingBy(e -> e.getLong("sourcebillid")));
                    }
                    if (EmptyUtil.isNoEmpty(draftIdAndCreditMap) && draftIdAndCreditMap.size() > 0) {
                        Map<Object, Object> finalDraftIdAndCreditMap = draftIdAndCreditMap;
                        List fromApplyPayBills = payDraftList.stream().filter(e -> !finalDraftIdAndCreditMap.containsKey(e.getLong("sourcebillid")) && "apply".equals(e.getString("source"))).collect(Collectors.toList());
                        HashMap applyIdAndDraftIdMap = new HashMap(8);
                        if (EmptyUtil.isNoEmpty(fromApplyPayBills)) {
                            for (DynamicObject fromApplyPayBill : fromApplyPayBills) {
                                long applyId = fromApplyPayBill.getLong("sourcebillid");
                                long draftId = fromApplyPayBill.getLong("id");
                                if (applyIdAndDraftIdMap.containsKey(applyId)) {
                                    ((Set)applyIdAndDraftIdMap.get(applyId)).add(draftId);
                                    continue;
                                }
                                HashSet<Long> draftIdSet = new HashSet<Long>(8);
                                draftIdSet.add(draftId);
                                applyIdAndDraftIdMap.put(applyId, draftIdSet);
                            }
                        }
                    }
                }
                if (isContainSurety && EmptyUtil.isNoEmpty(hasSuretyPayDraftIdSet = payDraftList.stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getString("paybilltype")) && e.getString("paybilltype").contains("guarantee")).map(x -> x.getLong("id")).collect(Collectors.toSet())) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(suretybills = QueryServiceHelper.query((String)"fbd_suretybill", (String)"entry.debtbillid,surplusamount,id", (QFilter[])new QFilter[]{source_qFilter = new QFilter("entry.debtbillid", "in", hasSuretyPayDraftIdSet)})))) {
                    draftIdAndSuretyMap = suretybills.stream().collect(Collectors.groupingBy(e -> e.getLong("entry.debtbillid")));
                }
            }
            for (DynamicObject row2 : rows) {
                long draftBillId = row2.getLong("id");
                if (isContainCredit && EmptyUtil.isNoEmpty(draftIdAndCreditMap) && draftIdAndCreditMap.size() > 0 && EmptyUtil.isNoEmpty(draftIdAndCreditMap.get(draftBillId))) {
                    List creditDyList = (List)draftIdAndCreditMap.get(draftBillId);
                    DynamicObject creditDy = (DynamicObject)creditDyList.get(0);
                    BigDecimal realamt = creditDy.getBigDecimal("realamt");
                    row2.set(PayableEleBillList.AMOUNTOFCREDIT, (Object)realamt);
                } else if (isContainCredit) {
                    row2.set(PayableEleBillList.AMOUNTOFCREDIT, (Object)BigDecimal.ZERO);
                }
                if (isContainSurety && EmptyUtil.isNoEmpty(draftIdAndSuretyMap) && draftIdAndSuretyMap.size() > 0 && EmptyUtil.isNoEmpty(draftIdAndSuretyMap.get(draftBillId))) {
                    List suretyDyList = (List)draftIdAndSuretyMap.get(draftBillId);
                    DynamicObject suretyDy = (DynamicObject)suretyDyList.get(0);
                    BigDecimal surplusamount = suretyDy.getBigDecimal("surplusamount");
                    row2.set(PayableEleBillList.SURETYREMAINAMOUNT, (Object)surplusamount);
                    continue;
                }
                if (!isContainSurety) continue;
                row2.set(PayableEleBillList.SURETYREMAINAMOUNT, (Object)BigDecimal.ZERO);
            }
            return rows;
        }
    }
}

