/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.payablebill;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.RlatedPreBillHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RelatedPreBillPlugin
extends AbstractFormPlugin
implements ListRowClickListener {
    private static Long[] ids = new Long[0];
    private static DynamicObject[] paybills = new DynamicObject[0];
    private static DynamicObject[] elebills = new DynamicObject[0];

    public void initialize() {
        super.initialize();
        BillList payableBilllist = (BillList)this.getControl("billlistap_payablebill");
        payableBilllist.setOrderBy("amount,billno,draftbillno,issuedate");
        BillList electronicpaybill = (BillList)this.getControl("billlistap_electronic_pay");
        electronicpaybill.setOrderBy("amount,billno,issueticketdate");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.drafttypeRegisterListener();
        this.addItemClickListeners(new String[]{"toolbarap", "comfirmrelated", "cancelrelated", "reletedcreate", "refresh", "exit", "billlistap_payablebill", "billlistap_electronic_pay"});
        BillList payableBillList = (BillList)this.getControl("billlistap_payablebill");
        BillList electronicpaybillList = (BillList)this.getControl("billlistap_electronic_pay");
        if (this.getModel().getDataEntity() != null) {
            String srcbilltype = (String)this.getModel().getValue("srcbilltype");
            if ("cdm_payablebill".equals(srcbilltype)) {
                payableBillList.setFilter(this.getPaybillStateFilter(ids));
                electronicpaybillList.setFilter(this.getElectronicBillFilter(ids));
            } else {
                payableBillList.setFilter(this.getPaybillFilter(ids));
                electronicpaybillList.setFilter(this.getElectronicPayDealFilter(ids));
            }
        }
    }

    private void drafttypeRegisterListener() {
        BasedataEdit drafttype;
        if (this.getModel().getProperty("draftbilltype") != null && (drafttype = (BasedataEdit)this.getControl("draftbilltype")) != null) {
            drafttype.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter filter = new QFilter("settlementtype", "=", (Object)SettleMentTypeEnum.BANK.getValue());
                filter.and("billmedium", "=", (Object)BillMediumEnum.ELECTRIC.getValue());
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "draftbilltype");
                showParameter.setCloseCallBack(closeCallBack);
                showParameter.getListFilterParameter().setFilter(filter);
            });
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray billids = (JSONArray)customParams.get("id");
        if (billids != null) {
            ids = (Long[])billids.stream().toArray(Long[]::new);
        }
        String srcbilltype = (String)customParams.get("srcbilltype");
        DynamicObject bill = new DynamicObject();
        bill = "cdm_payablebill".equals(srcbilltype) ? this.getPaybillByid(ids[0]) : this.getelebillByid(ids[0]);
        if ("cdm_payablebill".equals(srcbilltype)) {
            DynamicObject draweraccount = bill.getDynamicObject("draweraccount");
            if (EmptyUtil.isNoEmpty((DynamicObject)draweraccount)) {
                model.setValue("accountbank", draweraccount.get("number"));
            }
            model.setValue("currencyid", (Object)bill.getDynamicObject("currency"));
            model.setValue("draftbilltype", bill.get("draftbilltype"));
            model.setValue("org", (Object)bill.getDynamicObject("company").getString("name"));
            model.setValue("currency", (Object)bill.getDynamicObject("currency").getString("name"));
            model.setValue("acceptno", bill.get("acceptno"));
            model.setValue("contractno", bill.get("contractno"));
            model.setValue("receiverallname", (Object)bill.getString("receivername"));
            model.setValue("drawerorg", (Object)bill.getString("drawername"));
            model.setValue("srcbilltype", (Object)"cdm_payablebill");
            model.setValue("srcbillid", (Object)ids[0]);
            view.setVisible(Boolean.valueOf(false), new String[]{"reletedcreate"});
        } else {
            QFilter filter = new QFilter("id", "=", (Object)742546335227549696L);
            DynamicObject billType = BusinessDataServiceHelper.loadSingle((String)"cdm_billtype", (String)"id,name,code,settlementtype", (QFilter[])new QFilter[]{filter});
            model.setValue("draftbilltype", (Object)billType);
            model.setValue("currencyid", (Object)bill.getDynamicObject("currency"));
            model.setValue("org", (Object)bill.getDynamicObject("company").getString("name"));
            model.setValue("accountbank", (Object)bill.getString("issueticketacctext"));
            model.setValue("currency", (Object)bill.getDynamicObject("currency").getString("name"));
            model.setValue("contractno", bill.get("tradecontractno"));
            model.setValue("receiverallname", (Object)bill.getString("collectionertext"));
            model.setValue("drawerorg", (Object)bill.getString("issueticketertext"));
            model.setValue("srcbilltype", (Object)"cdm_electronic_pay_deal");
            model.setValue("srcbillid", (Object)ids[0]);
        }
        this.refresh(ids);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "comfirmrelated": {
                if (!this.comfirmRelated()) break;
                this.refresh(ids);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u5173\u8054\u6210\u529f\u3002", (String)"RelatedPreBillPlugin_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "reletedcreate": {
                if (!this.reletedCreate()) break;
                this.refresh(ids);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u8054\u751f\u6210\u6210\u529f\u3002", (String)"RelatedPreBillPlugin_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "refresh": {
                this.refresh(ids);
                break;
            }
        }
    }

    private boolean comfirmRelated() {
        IFormView view = this.getView();
        BigDecimal paybillmoney = (BigDecimal)this.getModel().getValue("paybillmoney");
        BigDecimal prebillmoney = (BigDecimal)this.getModel().getValue("prebillmoney");
        int paybillnumber = (Integer)this.getModel().getValue("paybillnumber");
        int prebillnumber = (Integer)this.getModel().getValue("prebillnumber");
        if (paybillmoney.compareTo(prebillmoney) != 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9884\u51fa\u7968\u91d1\u989d\u4e0e\u5e94\u4ed8\u7968\u636e\u91d1\u989d\u4e0d\u7b26\uff0c\u4e0d\u80fd\u786e\u8ba4\u5173\u8054\uff0c\u8bf7\u8865\u5f55\u5e94\u4ed8\u7968\u636e\u6216\u91cd\u65b0\u83b7\u53d6\u9884\u51fa\u7968\u6570\u636e!", (String)"RelatedPreBillPlugin_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (paybillnumber != prebillnumber) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9884\u51fa\u7968\u5f20\u6570\u4e0e\u5e94\u4ed8\u7968\u636e\u5f20\u6570\u4e0d\u7b26\uff0c\u4e0d\u80fd\u786e\u8ba4\u5173\u8054\uff0c\u8bf7\u8865\u5f55\u5e94\u4ed8\u7968\u636e\u6216\u91cd\u65b0\u83b7\u53d6\u9884\u51fa\u7968\u6570\u636e!", (String)"RelatedPreBillPlugin_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (paybills.length < 1 || elebills.length < 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u6216\u9884\u51fa\u7968\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u5173\u8054\u3002", (String)"RelatedPreBillPlugin_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return RlatedPreBillHelper.comfirmBill((DynamicObject[])paybills, (DynamicObject[])elebills, (IFormView)view);
    }

    private boolean reletedCreate() {
        IFormView view = this.getView();
        BigDecimal paybillmoney = (BigDecimal)this.getModel().getValue("paybillmoney");
        DynamicObject dratbilltype = (DynamicObject)this.getModel().getValue("draftbilltype");
        if (elebills.length < 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9884\u51fa\u7968\u6570\u636e\uff0c\u65e0\u6cd5\u5173\u8054\u751f\u6210\u3002", (String)"RelatedPreBillPlugin_9", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (paybillmoney.compareTo(new BigDecimal(0)) != 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u5e94\u4ed8\u7968\u636e\uff0c\u4e0d\u80fd\u518d\u5173\u8054\u751f\u6210!", (String)"RelatedPreBillPlugin_10", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return RlatedPreBillHelper.reletedCreate((DynamicObject[])elebills, (DynamicObject)dratbilltype, (IFormView)view);
    }

    private void refresh(Long[] ids) {
        BillList payableBilllist = (BillList)this.getControl("billlistap_payablebill");
        String srcbilltype = (String)this.getModel().getValue("srcbilltype");
        if ("cdm_payablebill".equals(srcbilltype)) {
            payableBilllist.setFilter(this.getPaybillStateFilter(ids));
        } else {
            payableBilllist.setFilter(this.getPaybillFilter(ids));
        }
        payableBilllist.clearSelection();
        payableBilllist.refresh();
        BillList electronicPayBillList = (BillList)this.getControl("billlistap_electronic_pay");
        if ("cdm_payablebill".equals(srcbilltype)) {
            electronicPayBillList.setFilter(this.getElectronicBillFilter(ids));
        } else {
            electronicPayBillList.setFilter(this.getElectronicPayDealFilter(ids));
        }
        electronicPayBillList.clearSelection();
        electronicPayBillList.refresh();
        DynamicObject[] paybills = this.getPaybills(ids);
        DynamicObject[] elebills = this.getElebills(ids);
        this.setTotal(paybills, elebills);
    }

    private void setTotal(DynamicObject[] paybills, DynamicObject[] elebills) {
        BigDecimal payBillmoney = BigDecimal.ZERO;
        BigDecimal eleBillmoney = BigDecimal.ZERO;
        int paybillnumber = 0;
        int eleBillnumber = 0;
        if (EmptyUtil.isNoEmpty((Object[])paybills)) {
            for (DynamicObject paybill : paybills) {
                payBillmoney = payBillmoney.add(paybill.getBigDecimal("amount"));
                ++paybillnumber;
            }
        }
        if (EmptyUtil.isNoEmpty((Object[])elebills)) {
            for (DynamicObject elebill : elebills) {
                eleBillmoney = eleBillmoney.add(elebill.getBigDecimal("amount"));
                ++eleBillnumber;
            }
        }
        this.getModel().setValue("paybillmoney", (Object)payBillmoney);
        this.getModel().setValue("prebillmoney", (Object)eleBillmoney);
        this.getModel().setValue("paybillnumber", (Object)paybillnumber);
        this.getModel().setValue("prebillnumber", (Object)eleBillnumber);
    }

    private DynamicObject getPaybillByid(Long id) {
        DynamicObject paybill = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cdm_payablebill", (String)"company,currency,accountbank,acceptno,contractno,draftbilltype,receiverallname,draweraccount,drawername,draweraccountname,receivername");
        return paybill;
    }

    private DynamicObject getelebillByid(Long id) {
        DynamicObject elebill = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cdm_electronic_pay_deal", (String)"company,currency,issueticketacctext,tradecontractno,drafttype,collectionertext,issueticketertext");
        return elebill;
    }

    private DynamicObject[] getPaybills(Long[] ids) {
        String srcbilltype = (String)this.getModel().getValue("srcbilltype");
        if ("cdm_payablebill".equals(srcbilltype)) {
            QFilter filter = this.getPaybillStateFilter(ids);
            paybills = BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)"id,amount", (QFilter[])new QFilter[]{filter});
            return paybills;
        }
        QFilter filter = this.getPaybillFilter(ids);
        paybills = BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)"id,amount", (QFilter[])new QFilter[]{filter});
        return paybills;
    }

    private DynamicObject[] getElebills(Long[] ids) {
        String srcbilltype = (String)this.getModel().getValue("srcbilltype");
        if ("cdm_payablebill".equals(srcbilltype)) {
            QFilter filter = this.getElectronicBillFilter(ids);
            elebills = BusinessDataServiceHelper.load((String)"cdm_electronic_pay_deal", (String)"id,amount", (QFilter[])new QFilter[]{filter});
            return elebills;
        }
        QFilter filter = this.getElectronicPayDealFilter(ids);
        elebills = BusinessDataServiceHelper.load((String)"cdm_electronic_pay_deal", (String)"id,amount", (QFilter[])new QFilter[]{filter});
        return elebills;
    }

    private QFilter getPaybillStateFilter(Long[] ids) {
        QFilter filter = new QFilter("id", "in", (Object)ids);
        filter.and("isrelatedprebill", "=", (Object)Character.valueOf('0'));
        return filter;
    }

    private QFilter getElectronicBillFilter(Long[] ids) {
        QFilter idfilter = new QFilter("id", "in", (Object)ids);
        DynamicObject[] paybills = BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)"id,amount", (QFilter[])new QFilter[]{idfilter});
        ArrayList<BigDecimal> moneys = new ArrayList<BigDecimal>();
        if (paybills != null && paybills.length > 0) {
            for (DynamicObject paybill : paybills) {
                moneys.add(paybill.getBigDecimal("amount"));
            }
        }
        String org = (String)this.getModel().getValue("org");
        String accountBank = (String)this.getModel().getValue("accountbank");
        String currency = (String)this.getModel().getValue("currency");
        String batchno = (String)this.getModel().getValue("batchno");
        String drawerorg = (String)this.getModel().getValue("drawerorg");
        String receiverallname = (String)this.getModel().getValue("receiverallname");
        String contractno = (String)this.getModel().getValue("contractno");
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter = filter.and("currencytext", "=", (Object)currency);
        filter = filter.and("company.name", "=", (Object)org);
        filter = filter.and("sourceid", "=", (Object)0L);
        filter = filter.and("connchannel.type_code", "=", (Object)"105");
        filter = filter.and("drafttype", "=", (Object)"AC01");
        filter = filter.and("issueticketertext", "=", (Object)drawerorg);
        filter = filter.and("issueticketacctext", "=", (Object)accountBank);
        filter = filter.and("collectionertext", "=", (Object)receiverallname);
        filter = filter.and("amount", "in", (Object)moneys.toArray(new BigDecimal[0]));
        if (EmptyUtil.isNoEmpty((String)contractno)) {
            filter = filter.and("tradecontractno", "=", (Object)contractno);
        }
        return filter;
    }

    private QFilter getElectronicPayDealFilter(Long[] ids) {
        QFilter filter = new QFilter("id", "in", (Object)ids);
        filter = filter.and("sourceid", "=", (Object)0L);
        return filter;
    }

    private QFilter getPaybillFilter(Long[] ids) {
        QFilter idfilter = new QFilter("id", "in", (Object)ids);
        DynamicObject[] elebills = BusinessDataServiceHelper.load((String)"cdm_electronic_pay_deal", (String)"id,amount", (QFilter[])new QFilter[]{idfilter});
        ArrayList<BigDecimal> moneys = new ArrayList<BigDecimal>();
        if (elebills != null && elebills.length > 0) {
            for (DynamicObject elebill : elebills) {
                moneys.add(elebill.getBigDecimal("amount"));
            }
        }
        String org = (String)this.getModel().getValue("org");
        String currency = (String)this.getModel().getValue("currency");
        String drawerOrg = (String)this.getModel().getValue("drawerorg");
        String accountBank = (String)this.getModel().getValue("accountbank");
        String receiverAllName = (String)this.getModel().getValue("receiverallname");
        QFilter filter = new QFilter("draweraccount.bank.bank_cate.type_code", "=", (Object)"105");
        filter = filter.and("draftbilltype.settlementtype", "=", (Object)SettleMentTypeEnum.BANK.getValue());
        filter = filter.and("draftbilltype.billmedium", "=", (Object)BillMediumEnum.ELECTRIC.getValue());
        filter = filter.and("drawername", "=", (Object)drawerOrg);
        filter = filter.and("draweraccount.number", "=", (Object)accountBank);
        filter = filter.and("receivername", "=", (Object)receiverAllName);
        filter = filter.and("company.name", "=", (Object)org);
        filter = filter.and("currency.name", "=", (Object)currency);
        filter = filter.and("amount", "in", (Object)moneys.toArray(new BigDecimal[0]));
        filter = filter.and("billstatus", "=", (Object)Character.valueOf('C'));
        filter = filter.and("draftbilltranstatus", "!=", (Object)DraftTranStatusEnum.SUCCESS.getValue());
        filter = filter.and("relatedelcbillid", "=", (Object)0);
        return filter;
    }
}

