/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.receivablebill;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.common.enums.AcceptPromiseTypeEnum;
import kd.tmc.cdm.common.enums.IssuePromiseTypeEnum;
import kd.tmc.cdm.common.enums.PayeeTypeEnum;
import kd.tmc.cdm.common.helper.BaseDataHelper;
import kd.tmc.cdm.common.helper.ListConstructorHelper;
import kd.tmc.cdm.common.helper.SCAccountInfo;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class RecBillMultiCatePlugin
extends AbstractTmcBillEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.issuePromiseListener();
        this.issuePromiseAccListener();
        this.acceptPromiseListener();
        this.acceptPromiseAccListener();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRow row;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        if (rows != null && EmptyUtil.isNoEmpty((Object)(row = rows.get(0)))) {
            switch (actionId) {
                case "issuepromiser": {
                    this.issPromiseCloseCallBack(row);
                    break;
                }
                case "issuepromiseraccount": {
                    this.issPromiseAccCloseCallBack(row);
                    break;
                }
                case "acceptpromiser": {
                    this.accPromiseCloseCallBack(row);
                    break;
                }
                case "acceptpromiseraccount": {
                    this.accPromiseAccCloseCallBack(row);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (key) {
            case "issuepromisertype": {
                this.issuePromiseTypeChange();
                break;
            }
            case "acceptpromisertype": {
                this.accPromiseTypeChange();
                break;
            }
            case "issueticketgrade": {
                this.issueTicketGradeChange();
                break;
            }
            case "promisegrade": {
                this.promiseGradeChange();
                break;
            }
            case "issuepromiser": {
                DynamicObject issuePromiserNewValue = (DynamicObject)changeSet[0].getNewValue();
                if (issuePromiserNewValue != null) {
                    this.getModel().setValue("issuepromisername", (Object)issuePromiserNewValue.getString("name"));
                    break;
                }
                this.getModel().setValue("issuepromisername", null);
                break;
            }
            case "acceptpromiser": {
                DynamicObject accptPromiserNewValue = (DynamicObject)changeSet[0].getNewValue();
                if (accptPromiserNewValue != null) {
                    this.getModel().setValue("acceptpromisername", (Object)accptPromiserNewValue.getString("name"));
                    break;
                }
                this.getModel().setValue("acceptpromisername", null);
            }
        }
    }

    private void issueTicketGradeChange() {
        Object issueTicketGrade = this.getModel().getValue("issueticketgrade");
        if (issueTicketGrade != null) {
            ((FieldEdit)this.getView().getControl("issueticketcreditlevel")).setMustInput(true);
            ((FieldEdit)this.getView().getControl("issueticketexpiredate")).setMustInput(true);
        } else {
            ((FieldEdit)this.getView().getControl("issueticketcreditlevel")).setMustInput(false);
            ((FieldEdit)this.getView().getControl("issueticketexpiredate")).setMustInput(false);
        }
    }

    private void promiseGradeChange() {
        Object promiseGrade = this.getModel().getValue("promisegrade");
        if (promiseGrade != null) {
            ((FieldEdit)this.getView().getControl("promisecreditlevel")).setMustInput(true);
            ((FieldEdit)this.getView().getControl("promiseexpiredate")).setMustInput(true);
        } else {
            ((FieldEdit)this.getView().getControl("promisecreditlevel")).setMustInput(false);
            ((FieldEdit)this.getView().getControl("promiseexpiredate")).setMustInput(false);
        }
    }

    private void setUpIssuePromiseMustInput() {
        String issuePromiseType = this.getModel().getValue("issuepromisertype").toString();
        if (!"".equals(issuePromiseType)) {
            ((FieldEdit)this.getView().getControl("issuepromiseraccount")).setMustInput(true);
            ((FieldEdit)this.getView().getControl("issuepromiseraddr")).setMustInput(true);
            ((FieldEdit)this.getView().getControl("issuepromiserdate")).setMustInput(true);
            if (StringUtils.equals((CharSequence)issuePromiseType, (CharSequence)IssuePromiseTypeEnum.OTHER.getValue())) {
                ((FieldEdit)this.getView().getControl("issuepromiser")).setMustInput(false);
                ((FieldEdit)this.getView().getControl("issuepromisername")).setMustInput(true);
            } else {
                ((FieldEdit)this.getView().getControl("issuepromiser")).setMustInput(true);
                ((FieldEdit)this.getView().getControl("issuepromisername")).setMustInput(false);
            }
        } else {
            ((FieldEdit)this.getView().getControl("issuepromiseraccount")).setMustInput(false);
            ((FieldEdit)this.getView().getControl("issuepromiseraddr")).setMustInput(false);
            ((FieldEdit)this.getView().getControl("issuepromiserdate")).setMustInput(false);
            ((FieldEdit)this.getView().getControl("issuepromiser")).setMustInput(false);
            ((FieldEdit)this.getView().getControl("issuepromisername")).setMustInput(false);
        }
    }

    private void issuePromiseTypeChange() {
        this.getModel().beginInit();
        this.getModel().setValue("issuepromiser", null);
        this.getModel().setValue("issuepromisername", null);
        this.getModel().setValue("issuepromiseraccount", null);
        this.getModel().endInit();
        this.setUpIssuePromiseMustInput();
        this.getView().updateView();
    }

    private void setUpAccPromiseMustInput() {
        String issuePromiseType = this.getModel().getValue("acceptpromisertype").toString();
        if (!"".equals(issuePromiseType)) {
            ((FieldEdit)this.getView().getControl("acceptpromiseraccount")).setMustInput(true);
            ((FieldEdit)this.getView().getControl("acceptpromiseraddr")).setMustInput(true);
            ((FieldEdit)this.getView().getControl("acceptpromiserdate")).setMustInput(true);
            if (StringUtils.equals((CharSequence)issuePromiseType, (CharSequence)AcceptPromiseTypeEnum.OTHER.getValue())) {
                ((FieldEdit)this.getView().getControl("acceptpromiser")).setMustInput(false);
                ((FieldEdit)this.getView().getControl("acceptpromisername")).setMustInput(true);
            } else {
                ((FieldEdit)this.getView().getControl("acceptpromiser")).setMustInput(true);
                ((FieldEdit)this.getView().getControl("acceptpromisername")).setMustInput(false);
            }
        } else {
            ((FieldEdit)this.getView().getControl("acceptpromiseraccount")).setMustInput(false);
            ((FieldEdit)this.getView().getControl("acceptpromiseraddr")).setMustInput(false);
            ((FieldEdit)this.getView().getControl("acceptpromiserdate")).setMustInput(false);
            ((FieldEdit)this.getView().getControl("acceptpromiser")).setMustInput(false);
            ((FieldEdit)this.getView().getControl("acceptpromisername")).setMustInput(false);
        }
    }

    private void accPromiseTypeChange() {
        this.getModel().beginInit();
        this.getModel().setValue("acceptpromiser", null);
        this.getModel().setValue("acceptpromisername", null);
        this.getModel().setValue("acceptpromiseraccount", null);
        this.getModel().endInit();
        this.setUpAccPromiseMustInput();
        this.getView().updateView();
    }

    private void issuePromiseAccListener() {
        this.accLinkAgeContr("issuepromiseraccount", "issuepromiser", "issuepromisername");
    }

    private void acceptPromiseAccListener() {
        this.accLinkAgeContr("acceptpromiseraccount", "acceptpromiser", "acceptpromisername");
    }

    private void issuePromiseListener() {
        if (this.getModel().getProperty("issuepromiser") != null) {
            BasedataEdit issuePromiseEdit = (BasedataEdit)this.getControl("issuepromiser");
            Object issueTypeObj = this.getModel().getValue("issuepromisertype");
            this.orgFilter(issueTypeObj, issuePromiseEdit, "issuepromiser");
        }
    }

    private void acceptPromiseListener() {
        if (this.getModel().getProperty("acceptpromiser") != null) {
            BasedataEdit issuePromiseEdit = (BasedataEdit)this.getControl("acceptpromiser");
            Object issueTypeObj = this.getModel().getValue("acceptpromisertype");
            this.orgFilter(issueTypeObj, issuePromiseEdit, "acceptpromiser");
        }
    }

    private void issPromiseCloseCallBack(ListSelectedRow row) {
        this.getModel().setValue("issuepromisername", (Object)row.getName());
        this.getModel().setValue("issuepromiser", row.getPrimaryKeyValue());
    }

    private void issPromiseAccCloseCallBack(ListSelectedRow row) {
        DynamicObject deliver = this.getModel().getDataEntity().getDynamicObject("issuepromiser");
        String entityName = deliver.getDataEntityType().getName();
        String acctType = (String)this.getModel().getValue("issuepromisertype");
        DynamicObject innerOrg = null;
        if ("bd_supplier".equals(entityName) || "bd_customer".equals(entityName)) {
            innerOrg = BaseDataHelper.getInternalOrg((DynamicObject)deliver);
        }
        if ((StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) && innerOrg == null) {
            Long entryId = (Long)row.getEntryPrimaryKeyValue();
            SCAccountInfo acctInfo = BaseDataHelper.loadBankInfo((String)acctType, (Long)entryId);
            if (acctInfo != null) {
                this.getModel().setValue("issuepromiseraccount", (Object)acctInfo.getAccount());
            } else {
                this.getModel().setValue("issuepromiseraccount", null);
            }
        } else {
            this.getModel().setValue("issuepromiseraccount", (Object)row.getNumber());
        }
    }

    private void accPromiseCloseCallBack(ListSelectedRow row) {
        this.getModel().setValue("acceptpromisername", (Object)row.getName());
        this.getModel().setValue("acceptpromiser", row.getPrimaryKeyValue());
    }

    private void accPromiseAccCloseCallBack(ListSelectedRow row) {
        DynamicObject deliver = this.getModel().getDataEntity().getDynamicObject("acceptpromiser");
        String entityName = deliver.getDataEntityType().getName();
        String acctType = (String)this.getModel().getValue("acceptpromisertype");
        DynamicObject innerOrg = null;
        if ("bd_supplier".equals(entityName) || "bd_customer".equals(entityName)) {
            innerOrg = BaseDataHelper.getInternalOrg((DynamicObject)deliver);
        }
        if ((StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) && innerOrg == null) {
            Long entryId = (Long)row.getEntryPrimaryKeyValue();
            SCAccountInfo acctInfo = BaseDataHelper.loadBankInfo((String)acctType, (Long)entryId);
            if (acctInfo != null) {
                this.getModel().setValue("acceptpromiseraccount", (Object)acctInfo.getAccount());
            } else {
                this.getModel().setValue("acceptpromiseraccount", null);
            }
        } else {
            this.getModel().setValue("acceptpromiseraccount", (Object)row.getNumber());
        }
    }

    private void orgFilter(Object type, BasedataEdit edit, String closeCallBackId) {
        if (edit != null) {
            edit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                if (type == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4fdd\u8bc1\u4eba\u7c7b\u578b\u3002", (String)"RecBillMultiCatePlugin_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                }
                if (StringUtils.equals((CharSequence)type.toString(), (CharSequence)PayeeTypeEnum.BOS_ORG.getValue())) {
                    QFilter filter = new QFilter("fisbankroll", "=", (Object)"1");
                    showParameter.setCustomParam("orgFuncId", (Object)"08");
                    List qfilter = showParameter.getListFilterParameter().getQFilters();
                    qfilter.add(filter);
                }
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, closeCallBackId);
                showParameter.setCloseCallBack(closeCallBack);
            });
        }
    }

    private void accLinkAgeContr(final String accFieldKey, final String nameObjFieldKey, final String nameFieldKey) {
        TextEdit accTextEdit = (TextEdit)this.getControl(accFieldKey);
        accTextEdit.addButtonClickListener(new ClickListener(){

            public void click(EventObject evt) {
                IDataModel model = RecBillMultiCatePlugin.this.getModel();
                DynamicObject draftTradeBill = model.getDataEntity();
                DynamicObject nameObj = draftTradeBill.getDynamicObject(nameObjFieldKey);
                String name = model.getValue(nameFieldKey).toString();
                if (EmptyUtil.isNoEmpty((DynamicObject)nameObj) && StringUtils.equals((CharSequence)name, (CharSequence)nameObj.getString("name"))) {
                    String entityType = nameObj.getDataEntityType().getName();
                    Object id = nameObj.getPkValue();
                    Object innerOrgId = null;
                    if (StringUtils.equals((CharSequence)entityType, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityType, (CharSequence)"bd_customer")) {
                        DynamicObject innerOrg = BaseDataHelper.getInternalOrg((DynamicObject)nameObj);
                        if (innerOrg == null) {
                            String qFilter = new QFilter("id", "=", id);
                            DynamicObject entryBankDO = TmcDataServiceHelper.loadSingle((String)entityType, (String)"entry_bank", (QFilter[])qFilter.toArray());
                            if (entryBankDO.getDynamicObjectCollection("entry_bank").size() == 0) {
                                RecBillMultiCatePlugin.this.getView().showTipNotification(new CdmBizResource().getTipCsNull());
                                return;
                            }
                        } else {
                            innerOrgId = innerOrg.getPkValue();
                        }
                    }
                    ListShowParameter lsp = new ListShowParameter();
                    switch (entityType) {
                        case "bd_supplier": {
                            if (innerOrgId != null) {
                                lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                                break;
                            }
                            lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)id);
                            break;
                        }
                        case "bd_customer": {
                            if (innerOrgId != null) {
                                lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                                break;
                            }
                            lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)id);
                            break;
                        }
                        case "bos_org": {
                            lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)id);
                            break;
                        }
                        case "bos_user": {
                            lsp = ListConstructorHelper.getPayeerInfoShowParameter((Object)id);
                            break;
                        }
                    }
                    if (lsp != null) {
                        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)RecBillMultiCatePlugin.this, accFieldKey);
                        lsp.setCloseCallBack(closeCallBack);
                        RecBillMultiCatePlugin.this.getView().showForm((FormShowParameter)lsp);
                    }
                }
            }
        });
    }
}

