/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.receivablebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.helper.RecBillAutoMatchHelper;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.helper.CdmCommonHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.GuaranteeHelper;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class ReceivableBillList
extends AbstractTmcBillBaseList {
    private static Log logger = LogFactory.getLog(ReceivableBillList.class);
    private static String DRAFT_TYPE_CONSTANT_BENPIAO = "2";

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue()));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "invalid": {
                if (selectedRows.size() <= 1) break;
                this.getView().showErrorNotification(new CdmBizResource().getTipInvalidCheck());
                args.setCancel(true);
                break;
            }
            case "refund": {
                if (selectedRows.size() > 1) {
                    this.getView().showErrorNotification(new CdmBizResource().getNobatchReFund());
                    args.setCancel(true);
                    break;
                }
                if (DraftHelper.isRefund((Object[])selectedRows.getPrimaryKeyValues(), (boolean)false)) break;
                this.getView().showErrorNotification(new CdmBizResource().getNoReFund());
                args.setCancel(true);
                break;
            }
            case "billsplitsub": {
                if (selectedRows.size() <= 1) break;
                this.getView().showErrorNotification(new CdmBizResource().getSplitNumWrong());
                args.setCancel(true);
                break;
            }
            case "guarantee": 
            case "unguarantee": {
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(new CdmBizResource().getTipInvalidNorow());
                    break;
                }
                Set idSet = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                String result = GuaranteeHelper.validatedGuaranteeTrade(idSet, (String)ReceivePayTypeEnum.RECEIVEBILL.getValue(), (String)operateKey);
                if (EmptyUtil.isNoEmpty((String)result)) {
                    this.getView().showTipNotification(result);
                    args.setCancel(true);
                    break;
                }
                result = GuaranteeHelper.validatedIsReleaseGuaranteeBill(idSet, (String)operateKey);
                if (!EmptyUtil.isNoEmpty((String)result)) break;
                this.getView().showTipNotification(result);
                args.setCancel(true);
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        String itemKey = evt.getItemKey();
        Object[] cdmRecBillIdArr = selectedRows.getPrimaryKeyValues();
        ListShowParameter parameterRec = new ListShowParameter();
        switch (itemKey) {
            case "tblunaudit": {
                QFilter qFilter2;
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(new CdmBizResource().getTipInvalidNorow());
                    break;
                }
                Set idsSet = selectedRows.stream().map(e -> e.getPrimaryKeyValue()).collect(Collectors.toSet());
                QFilter qFilter1 = new QFilter("id", "in", idsSet);
                DynamicObjectCollection cdmPayBillList = QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id,isvoucher,billno", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("isvoucher", "=", (Object)"1")});
                if (null == cdmPayBillList || cdmPayBillList.size() <= 0) break;
                Set filterIds = cdmPayBillList.stream().map(e -> e.getString("billno")).collect(Collectors.toSet());
                logger.info("isVoucher list is:" + filterIds);
                StringJoiner msg = new StringJoiner("");
                for (String idstr : filterIds) {
                    msg.add(idstr);
                    msg.add(";\r\n");
                }
                String billnoStr = msg.toString();
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"(%s)\u5355\u636e\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1 ,\u662f\u5426\u7ee7\u7eed\u53cd\u5ba1\u6838\uff1f", (String)"ReceivableBillList_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), billnoStr), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_UNAUDITBILLRECLIST_CALLBACK", (IFormPlugin)this));
                evt.setCancel(true);
                break;
            }
            case "tbldraftinfoedit": {
                if (selectedRows.size() <= 1) break;
                this.getView().showTipNotification(new CdmBizResource().getNotMulitSelected());
                evt.setCancel(true);
                break;
            }
            case "viewcaspaybill": {
                Set casPayBillIdSetAll = DraftHelper.getCasBillId((Object[])cdmRecBillIdArr, (String)"receivebill", (String)"cas_paybill", (ListShowParameter)parameterRec);
                if (EmptyUtil.isEmpty((Collection)casPayBillIdSetAll)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u4e0d\u5b58\u5728\u51fa\u7eb3\u5355\u636e\u3002", (String)"PayableApplyBillBatchList_3_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showForm((FormShowParameter)parameterRec);
                break;
            }
            case "viewcasrecbill": {
                Set casRecBillIdSetAll = DraftHelper.getCasBillId((Object[])cdmRecBillIdArr, (String)"receivebill", (String)"cas_recbill", (ListShowParameter)parameterRec);
                if (EmptyUtil.isEmpty((Collection)casRecBillIdSetAll)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u4e0d\u5b58\u5728\u51fa\u7eb3\u5355\u636e\u3002", (String)"PayableApplyBillBatchList_3_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showForm((FormShowParameter)parameterRec);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("CONFIRM_UNAUDITBILLRECLIST_CALLBACK".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getView().invokeOperation("unaudit");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        IListView listview = (IListView)this.getView();
        Object focusRowPkId = listview.getFocusRowPkId();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        ArrayList<String> pkValues = new ArrayList<String>();
        ArrayList<Object> ids = new ArrayList<Object>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            pkValues.add(row.getPrimaryKeyValue().toString());
            ids.add(row.getPrimaryKeyValue());
        }
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        Boolean isTransfer = true;
        DynamicObject[] receivableBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,istransfer,draftbilltype,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        for (DynamicObject receivableBill : receivableBills) {
            String settlementType;
            if (!receivableBill.getBoolean("istransfer")) {
                isTransfer = false;
            }
            if (!DRAFT_TYPE_CONSTANT_BENPIAO.equals(settlementType = receivableBill.getDynamicObject("draftbilltype").getString("settlementtype")) || !"discount".equals(operateKey) && !"mandator".equals(operateKey) && !"retrieve".equals(operateKey) && !"billsplitsub".equals(operateKey)) continue;
            this.getView().showErrorNotification(String.format(new CdmBizResource().getIsDoWhat(), receivableBill.getString("billno")));
            return;
        }
        switch (operateKey) {
            case "modifydata": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                BillShowParameter parameter = new BillShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setPkId(focusRowPkId);
                parameter.setFormId("cdm_receivablebill");
                parameter.getCustomParams().put("modifydata", true);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "transer": {
                if (!isTransfer.booleanValue()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u80fd\u5426\u8f6c\u8ba9\u201d\u4e3a\u5426\u7684\u7968\u636e\u4e0d\u5141\u8bb8\u8fdb\u884c\u80cc\u4e66\u8f6c\u8ba9\u64cd\u4f5c\u3002", (String)"ReceivableBillEdit_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.transerOperate(operationResult, pkValues, "endorse");
                break;
            }
            case "discount": {
                this.transerOperate(operationResult, pkValues, "discount");
                break;
            }
            case "pledge": {
                this.transerOperate(operationResult, pkValues, "pledge");
                break;
            }
            case "collect": {
                this.transerOperate(operationResult, pkValues, "collect");
                break;
            }
            case "mandator": {
                this.transerOperate(operationResult, pkValues, "trusteeship");
                break;
            }
            case "refund": {
                this.transerOperate(operationResult, pkValues, "refund");
                break;
            }
            case "retrieve": {
                this.transerOperate(operationResult, pkValues, "retrieve");
                break;
            }
            case "rlspledge": {
                this.transerOperate(operationResult, pkValues, "rlspledge");
                break;
            }
            case "billsplitsub": {
                this.transerOperate(operationResult, pkValues, "billsplit");
                break;
            }
            case "payinterestdeal": {
                this.transerOperate(operationResult, pkValues, "payinterest");
                break;
            }
            case "relationtrackdown": {
                this.relationTrackDown(operationResult);
                break;
            }
            case "draftinfoupdate": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
            case "guarantee": 
            case "unguarantee": {
                HashMap<String, Object> param = new HashMap<String, Object>();
                HashMap<String, Object> customParam = new HashMap<String, Object>();
                customParam.put("biztype", operateKey);
                customParam.put("billIds", ids);
                param.put("customParam", customParam);
                param.put("formId", "cdm_guarantee_discount");
                param.put("showType", ShowType.MainNewTabPage);
                CdmCommonHelper.showWebBill(param, (AbstractFormPlugin)this);
                break;
            }
            case "matchrecbill": {
                Map successCdmRecBillMap;
                ArrayList successCdmRecBills;
                List selectIds = selectedRows.stream().map(o -> Long.parseLong(o.getPrimaryKeyValue().toString())).collect(Collectors.toList());
                QFilter recFilter = new QFilter("id", "in", selectIds);
                Object[] recBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,claimnoticebillno,draftbillno,rectype,company,draftbillstatus", (QFilter[])new QFilter[]{recFilter});
                if (EmptyUtil.isNoEmpty((Object[])recBills)) {
                    List draftBillNos = Arrays.stream(recBills).filter(o -> StringUtils.isNotEmpty((CharSequence)o.getString("claimnoticebillno"))).map(e -> e.getString("draftbillno")).collect(Collectors.toList());
                    if (draftBillNos.size() > 0) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5df2\u53d1\u8d77\u8fc7\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u4e0d\u80fd\u64cd\u4f5c\u6309\u89c4\u5219\u5339\u914d", (String)"ReceivableBillList_11", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), String.join((CharSequence)";", draftBillNos)));
                    }
                    List recTypeDraftBillNos = Arrays.stream(recBills).filter(o -> StringUtils.isNotEmpty((CharSequence)o.getString("rectype"))).map(e -> e.getString("draftbillno")).collect(Collectors.toList());
                    if (recTypeDraftBillNos.size() > 0) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5df2\u5173\u8054\u6536\u6b3e\uff0c\u4e0d\u80fd\u64cd\u4f5c\u6309\u89c4\u5219\u5339\u914d", (String)"ReceivableBillList_12", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), String.join((CharSequence)";", recTypeDraftBillNos)));
                    }
                    Map<Long, List<DynamicObject>> companyMaps = Arrays.stream(recBills).collect(Collectors.groupingBy(o -> o.getDynamicObject("company").getLong("id")));
                    String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
                    for (Map.Entry<Long, List<DynamicObject>> longListEntry : companyMaps.entrySet()) {
                        List<DynamicObject> recBillGroup = longListEntry.getValue();
                        long companyId = longListEntry.getKey();
                        String noticeClaimAllowStatus = (String)TmcParameterHelper.getAppParameter((String)appId, (Long)companyId, (String)"noticeclaimallowstatus");
                        List allowStatusDraftBillNos = recBillGroup.stream().filter(o -> !noticeClaimAllowStatus.contains(o.getString("draftbillstatus"))).map(e -> e.getString("draftbillno")).collect(Collectors.toList());
                        if (allowStatusDraftBillNos.size() <= 0) continue;
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7968\u636e\u72b6\u6001\u4e0d\u652f\u6301\u6309\u89c4\u5219\u5339\u914d", (String)"ReceivableBillList_13", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), String.join((CharSequence)";", allowStatusDraftBillNos)));
                    }
                }
                if ((successCdmRecBills = new ArrayList((successCdmRecBillMap = RecBillAutoMatchHelper.autoMatch(selectIds)).values())).size() > 0) {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u8bb0\u5f55\uff0c\u5df2\u5339\u914d%2$s\u6761\uff0c\u672a\u5339\u914d%3$s\u6761", (String)"ReceivableBillList_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), selectIds.size(), successCdmRecBills.size(), selectIds.size() - successCdmRecBills.size()), "", MessageTypes.Default);
                    this.getView().invokeOperation("refresh");
                    break;
                }
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u8bb0\u5f55\uff0c\u5df2\u5339\u914d%2$s\u6761\uff0c\u672a\u5339\u914d%3$s\u6761", (String)"ReceivableBillList_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), selectIds.size(), 0, selectIds.size()), "", MessageTypes.Default);
            }
        }
    }

    private void transerOperate(OperationResult operationResult, ArrayList<String> pkValues, String type) {
        if (operationResult != null && operationResult.isSuccess()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("tradeType", type);
            this.getView().invokeOperation("pushtradebill", option);
        }
    }

    private void relationTrackDown(OperationResult opResult) {
        if (opResult != null && opResult.isSuccess() && opResult.getSuccessPkIds().size() > 0) {
            Object pkValue = opResult.getSuccessPkIds().get(0);
            QFilter sourceIdFilter = new QFilter("sourceid", "=", pkValue);
            Object[] electronicSignDeal = TmcDataServiceHelper.load((String)"cdm_electronic_sign_deal", (String)"id,sourceid", (QFilter[])new QFilter[]{sourceIdFilter});
            if (!EmptyUtil.isEmpty((Object[])electronicSignDeal) && EmptyUtil.isNoEmpty((Long)electronicSignDeal[0].getLong("sourceid")) && electronicSignDeal[0].getLong("sourceid") > 0L) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setAppId("cdm");
                parameter.setFormId("cdm_electronic_sign_deal");
                parameter.setPkId((Object)electronicSignDeal[0].getLong("id"));
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8054\u67e5\u6570\u636e\u3002", (String)"CdmBizResource_167", (String)"tmc-cdm-common", (Object[])new Object[0]));
            }
        }
    }
}

