/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.tradebill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.business.service.EleBillDiscountHelper;
import kd.tmc.cdm.common.bean.EleBillDiscountCalDetail;
import kd.tmc.cdm.common.bean.EleBillDiscountCalResult;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class TradeBillDisCountlEdit
extends AbstractTmcBillEdit {
    private static Log logger = LogFactory.getLog(TradeBillDisCountlEdit.class);
    private static final BigDecimal PERCENT = new BigDecimal("0.01");

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"bar_discountcalc", (CharSequence)itemKey)) {
            DynamicObject tradeBill = this.getModel().getDataEntity();
            boolean isValidateOk = this.validateDiscountCalc(tradeBill);
            if (!isValidateOk) {
                evt.setCancel(true);
                return;
            }
            EleBillDiscountCalResult billDiscountByTradeBill = EleBillDiscountHelper.getBillDiscountByTradeBill((DynamicObject)tradeBill);
            boolean successFlg = billDiscountByTradeBill.isSuccessFlg();
            if (successFlg) {
                List details = billDiscountByTradeBill.getDetails();
                boolean iseditdiscountentry = tradeBill.getBoolean("iseditdiscountentry");
                int amtprecision = tradeBill.getDynamicObject("currency").getInt("amtprecision");
                boolean ispaybyagree = tradeBill.getBoolean("ispaybyagree");
                BigDecimal agreerate = tradeBill.getBigDecimal("agreerate").multiply(PERCENT);
                BigDecimal ownInterestAmount_bank = BigDecimal.ZERO;
                BigDecimal payInterestAmount_bank = BigDecimal.ZERO;
                Map<String, String> billnoAndDiscountMap = details.stream().collect(Collectors.toMap(EleBillDiscountCalDetail::getNoteNo, EleBillDiscountCalDetail::getRecInt));
                logger.info("billnoAndDiscountMap is that:" + SerializationUtils.toJsonString(billnoAndDiscountMap));
                if (iseditdiscountentry) {
                    DynamicObjectCollection discountentrys = (DynamicObjectCollection)this.getModel().getValue("discountentry");
                    for (int i = 0; i < discountentrys.size(); ++i) {
                        DynamicObject discountentry = (DynamicObject)discountentrys.get(i);
                        String draftbillno = discountentry.getDynamicObject("dis_selectbillid").getString("draftbillno");
                        String discountAmount_bankStr = billnoAndDiscountMap.get(draftbillno);
                        if (!EmptyUtil.isNoEmpty((String)discountAmount_bankStr)) continue;
                        BigDecimal discountAmount_bank = new BigDecimal(discountAmount_bankStr).setScale(amtprecision, RoundingMode.HALF_UP);
                        if (ispaybyagree) {
                            BigDecimal dis_payInterestAmount = discountAmount_bank.multiply(agreerate).setScale(amtprecision, RoundingMode.HALF_UP);
                            BigDecimal dis_ownInterestAmount = discountAmount_bank.subtract(dis_payInterestAmount);
                            this.getModel().setValue("dis_payinterest_bank", (Object)dis_payInterestAmount, i);
                            this.getModel().setValue("dis_payinterestamount", (Object)dis_payInterestAmount, i);
                            this.getModel().setValue("dis_owninterest_bank", (Object)dis_ownInterestAmount, i);
                            this.getModel().setValue("dis_interest", (Object)dis_ownInterestAmount, i);
                            ownInterestAmount_bank = ownInterestAmount_bank.add(dis_ownInterestAmount);
                            payInterestAmount_bank = payInterestAmount_bank.add(dis_payInterestAmount);
                            continue;
                        }
                        BigDecimal dis_ownInterestAmount = discountAmount_bank.setScale(amtprecision, RoundingMode.HALF_UP);
                        this.getModel().setValue("dis_owninterest_bank", (Object)dis_ownInterestAmount, i);
                        this.getModel().setValue("dis_interest", (Object)dis_ownInterestAmount, i);
                        ownInterestAmount_bank = ownInterestAmount_bank.add(dis_ownInterestAmount);
                    }
                } else {
                    for (Map.Entry<String, String> entry : billnoAndDiscountMap.entrySet()) {
                        String discountAmountStr = entry.getValue();
                        if (!EmptyUtil.isNoEmpty((String)discountAmountStr)) continue;
                        BigDecimal discountAmount_bank = new BigDecimal(discountAmountStr).setScale(amtprecision, RoundingMode.HALF_UP);
                        if (ispaybyagree) {
                            BigDecimal billPayInterestAmount = discountAmount_bank.multiply(agreerate).setScale(amtprecision, RoundingMode.HALF_UP);
                            BigDecimal ownPayInterestAmount = discountAmount_bank.subtract(billPayInterestAmount);
                            payInterestAmount_bank = payInterestAmount_bank.add(billPayInterestAmount);
                            ownInterestAmount_bank = ownInterestAmount_bank.add(ownPayInterestAmount);
                            continue;
                        }
                        BigDecimal ownPayInterestAmount = discountAmount_bank.setScale(amtprecision, RoundingMode.HALF_UP);
                        ownInterestAmount_bank = ownInterestAmount_bank.add(ownPayInterestAmount);
                    }
                }
                this.getModel().setValue("payinteramount_bank", (Object)payInterestAmount_bank);
                this.getModel().setValue("payinterestamount", (Object)payInterestAmount_bank);
                this.getModel().setValue("owndiscountinterest", (Object)ownInterestAmount_bank);
                this.getModel().setValue("alldiscountinterest", (Object)ownInterestAmount_bank);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bd5\u7b97\u5b8c\u6210\u3002", (String)"TradeBillDisCountlEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            } else {
                String responseMsg = billDiscountByTradeBill.getResponseMsg();
                this.getView().showErrorNotification(responseMsg);
                evt.setCancel(true);
            }
        }
    }

    private boolean validateDiscountCalc(DynamicObject tradeBill) {
        BigDecimal discountRate;
        DynamicObject drafttype = tradeBill.getDynamicObject("drafttype");
        String draftbilltranstatus = tradeBill.getString("draftbilltranstatus");
        String tradeTypeStr = tradeBill.getString("tradetype");
        String billstatus = tradeBill.getString("billstatus");
        DynamicObject recbody = tradeBill.getDynamicObject("recbody");
        BigDecimal amount = tradeBill.getBigDecimal("amount");
        boolean ispaybyagree = tradeBill.getBoolean("ispaybyagree");
        if (EmptyUtil.isNoEmpty((DynamicObject)drafttype)) {
            if (!"2".equals(drafttype.getString("billmedium"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u7535\u7968\u624d\u80fd\u64cd\u4f5c\u8d34\u73b0\u8bd5\u7b97\u3002", (String)"TradeBillDrawBillValidator_0_3", (String)"tmc-cdm-business", (Object[])new Object[0]));
                return false;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d34\u73b0\u7684\u7968\u636e\u3002", (String)"TradeBillDrawBillValidator_0_4", (String)"tmc-cdm-business", (Object[])new Object[0]));
            return false;
        }
        if (!"A".equals(billstatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u8d34\u73b0\u8bd5\u7b97", (String)"TradeBillDrawBillValidator_0_5_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isNoEmpty((String)draftbilltranstatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4ea4\u6613\u72b6\u6001\u4e3a\u7a7a\u7684\u5355\u636e\u624d\u80fd\u8d34\u73b0\u8bd5\u7b97", (String)"TradeBillDrawBillValidator_0_5_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
            return false;
        }
        if (!"discount".equals(tradeTypeStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7968\u636e\u8d34\u73b0\u65f6\u624d\u80fd\u64cd\u4f5c\u8d34\u73b0\u8bd5\u7b97\u3002", (String)"TradeBillDisCountlEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!EmptyUtil.isNoEmpty((DynamicObject)recbody)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d7\u7406\u673a\u6784", (String)"TradeBillDrawBillValidator_0_6", (String)"tmc-cdm-business", (Object[])new Object[0]));
            return false;
        }
        if (BigDecimal.ZERO.compareTo(amount) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d34\u73b0\u7684\u7968\u636e\u3002", (String)"TradeBillDrawBillValidator_0_4", (String)"tmc-cdm-business", (Object[])new Object[0]));
            return false;
        }
        if (ispaybyagree) {
            BigDecimal agreerate = tradeBill.getBigDecimal("agreerate");
            DynamicObject payerofinterest = tradeBill.getDynamicObject("payerofinterest");
            String payinterbankaccount = tradeBill.getString("payinterbankaccount");
            String agreepayertype = tradeBill.getString("agreepayertype");
            String payerofinterestname = tradeBill.getString("payerofinterestname");
            DynamicObject payinteropenbank = tradeBill.getDynamicObject("payinteropenbank");
            Boolean isAgreerateEmpty = BigDecimal.ZERO.compareTo(agreerate) == 0;
            Boolean isPayerofInterestEmpty = EmptyUtil.isEmpty((DynamicObject)payerofinterest);
            Boolean isPayerofinterestnameEmpty = EmptyUtil.isEmpty((String)payerofinterestname);
            Boolean isPayinterbankaccountEmpty = EmptyUtil.isEmpty((String)payinterbankaccount);
            Boolean isPayinteropenbankEmpty = EmptyUtil.isEmpty((DynamicObject)payinteropenbank);
            boolean isEmpty = false;
            if ("other".equals(agreepayertype)) {
                isEmpty = isAgreerateEmpty != false || isPayerofinterestnameEmpty != false || isPayinterbankaccountEmpty != false || isPayinteropenbankEmpty != false;
            } else {
                boolean bl = isEmpty = isAgreerateEmpty != false || isPayerofInterestEmpty != false || isPayinterbankaccountEmpty != false || isPayinteropenbankEmpty != false;
            }
            if (isEmpty) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u534f\u8bae\u4ed8\u606f\u6bd4\u4f8b\u53ca\u534f\u8bae\u4ed8\u606f\u4eba\u76f8\u5173\u8981\u7d20", (String)"TradeBillDrawBillValidator_0_7", (String)"tmc-cdm-business", (Object[])new Object[0]));
                return false;
            }
        }
        if ((discountRate = tradeBill.getBigDecimal("rate")).compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d34\u73b0\u5229\u7387\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"TradeBillDisCountlEdit_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

