/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.tradebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.helper.TradeBillAmountHelper;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.param.ParamMap;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class TradeBillList
extends AbstractTmcBillBaseList {
    private static Log logger = LogFactory.getLog(TradeBillList.class);
    private boolean confirm = true;
    private static final String[] needUpdateOpKeyArr = new String[]{"submitele", "drawbillsave", "canceldrawbill", "syncebstatus"};

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult opResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (Arrays.asList(needUpdateOpKeyArr).contains(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
        if ("relationtrackdown".equals(operateKey) && opResult.isSuccess() && opResult.getSuccessPkIds().size() > 0) {
            Object pkValue = args.getOperationResult().getSuccessPkIds().get(0);
            DynamicObject electronicSignDeal = TmcDataServiceHelper.loadSingle(pkValue, (String)"cdm_drafttradebill", (String)"id,sourceid,entrys.draftbill");
            ArrayList<Long> idList = new ArrayList<Long>(8);
            if (electronicSignDeal != null) {
                DynamicObjectCollection entrys = electronicSignDeal.getDynamicObjectCollection("entrys");
                for (DynamicObject dynamicObject : entrys) {
                    idList.add(dynamicObject.getDynamicObject("draftbill").getLong("id"));
                }
            }
            QFilter sourceIdFilter = new QFilter("sourceid", "in", idList);
            DynamicObject[] receivableBill = TmcDataServiceHelper.load((String)"cdm_electronic_rec_deal", (String)"id,sourceid", (QFilter[])new QFilter[]{sourceIdFilter});
            ArrayList<Long> ids = new ArrayList<Long>(8);
            for (DynamicObject dynamicObject : receivableBill) {
                ids.add(dynamicObject.getLong("id"));
            }
            ArrayList<Tuple> tuples = new ArrayList<Tuple>();
            if (!EmptyUtil.isEmpty(ids)) {
                tuples.add(new Tuple((Object)"cdm_electronic_rec_deal", ids));
            }
            TmcBotpHelper.showTrackParameter(tuples, (IFormView)this.getView());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        switch (itemKey = evt.getItemKey()) {
            case "tblunaudit": {
                QFilter qFilter2;
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(new CdmBizResource().getTipInvalidNorow());
                    break;
                }
                Set idsSet = selectedRows.stream().map(e -> e.getPrimaryKeyValue()).collect(Collectors.toSet());
                QFilter qFilter1 = new QFilter("id", "in", idsSet);
                DynamicObjectCollection cdmPayBillList = QueryServiceHelper.query((String)"cdm_drafttradebill", (String)"id,isvoucher,billno", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("isvoucher", "=", (Object)"1")});
                if (null == cdmPayBillList || cdmPayBillList.size() <= 0) break;
                Set filterIds = cdmPayBillList.stream().map(e -> e.getString("billno")).collect(Collectors.toSet());
                logger.info("isVoucher list is:" + filterIds);
                StringJoiner msg = new StringJoiner("");
                for (String idstr : filterIds) {
                    msg.add(idstr);
                    msg.add(";\r\n");
                }
                String billnoStr = msg.toString();
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"(%s)\u5355\u636e\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1 ,\u662f\u5426\u7ee7\u7eed\u53cd\u5ba1\u6838\uff1f", (String)"TradeBillList_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), billnoStr), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_UNAUDITBILLTRADELIST_CALLBACK", (IFormPlugin)this));
                evt.setCancel(true);
                break;
            }
            case "bar_drawbill": {
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(new CdmBizResource().getTipInvalidNorow());
                    break;
                }
                Set idsSet = selectedRows.stream().map(e -> e.getPrimaryKeyValue()).collect(Collectors.toSet());
                QFilter qFilter1 = new QFilter("id", "in", idsSet);
                DynamicObject[] cdmPayBillList = BusinessDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id,company,bizdate,electag,drafttype,bizfinishdate,tradetype,source,draftbilltranstatus,billno", (QFilter[])new QFilter[]{qFilter1});
                HashSet<Long> willUpdateSet = new HashSet<Long>();
                HashSet<Date> dateSet = new HashSet<Date>();
                for (DynamicObject cdmPayBill : cdmPayBillList) {
                    String draftbilltranstatus = cdmPayBill.getString("draftbilltranstatus");
                    if (EmptyUtil.isNoEmpty((String)draftbilltranstatus) && "success".equals(draftbilltranstatus)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e %s:\u7968\u636e\u4ea4\u6613\u72b6\u6001\u4e3a\u7a7a\u6216\u4ea4\u6613\u5931\u8d25\u624d\u5141\u8bb8\u786e\u8ba4\u5b8c\u6210", (String)"TradeBillDrawBillValidator_9", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), cdmPayBill.getString("billno")));
                        evt.setCancel(true);
                        return;
                    }
                    String tradetype = cdmPayBill.getString("tradetype");
                    if (!DraftTradeTypeEnum.ENDORSE.getValue().equals(tradetype)) continue;
                    String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
                    boolean isAllowmodifydate = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)cdmPayBill.getDynamicObject("company").getLong("id"), (String)"isallowmodifydate");
                    boolean isElect = Objects.equals(cdmPayBill.getDynamicObject("drafttype").get("billmedium"), BillMediumEnum.ELECTRIC.getValue());
                    boolean isElectTag = cdmPayBill.getBoolean("electag");
                    boolean issucwriteback = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)cdmPayBill.getDynamicObject("company").getLong("id"), (String)"issucwriteback");
                    boolean isDraftallocate = "cdm-draftallocate".equalsIgnoreCase(cdmPayBill.getString("source"));
                    if (isElect && isElectTag || !isAllowmodifydate || !issucwriteback || isDraftallocate) continue;
                    willUpdateSet.add(cdmPayBill.getLong("id"));
                    dateSet.add(cdmPayBill.getDate("bizdate"));
                }
                if (EmptyUtil.isNoEmpty(willUpdateSet)) {
                    this.fillBizFinishDate(dateSet, willUpdateSet);
                    break;
                }
                logger.info("willUpdateSet is null");
                this.callDraftSave();
                break;
            }
            case "bar_drawfail": {
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(new CdmBizResource().getTipInvalidNorow());
                    break;
                }
                OperationResult operationResult = this.getView().invokeOperation("drawbillfail", OperateOption.create());
                if (operationResult.isSuccess()) break;
                logger.info("edit operationResult.getMessage:" + operationResult.getMessage());
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("CONFIRM_UNAUDITBILLTRADELIST_CALLBACK".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getView().invokeOperation("unaudit");
        }
        if ("CONFIRM_SUBMITBILLTRADELIST_CALLBACK".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.confirm = false;
            this.getView().invokeOperation("submit");
        }
        if ("CONFIRM_SAVEDISCOUNT_CALLBACK".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.confirm = false;
            this.getView().invokeOperation("save");
        }
        if ("CONFIRM_SUBMIT_DISCOUNT_CALLBACK".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.confirm = false;
            this.getView().invokeOperation("submit");
        }
    }

    private void fillBizFinishDate(Set<Date> dateSet, Set<Long> willUpdateSet) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("cdm_bizfinishdate");
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cdm_bizfinishdate_back"));
        if (EmptyUtil.isNoEmpty(dateSet) && dateSet.size() == 1) {
            ArrayList<Date> dateList = new ArrayList<Date>(dateSet);
            para.setCustomParam("bizdate", dateList.get(0));
        }
        para.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(para);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (StringUtils.equals((CharSequence)"cdm_bizfinishdate_back", (CharSequence)actionId)) {
            ParamMap dataMap = (ParamMap)returnData;
            if (dataMap != null) {
                IListView listview = (IListView)this.getView();
                ListSelectedRowCollection selectedRows = listview.getSelectedRows();
                Set idsSet = selectedRows.stream().map(e -> e.getPrimaryKeyValue()).collect(Collectors.toSet());
                QFilter qFilter1 = new QFilter("id", "in", idsSet);
                DynamicObject[] cdmPayBillList = BusinessDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id,company,bizdate,electag,drafttype,bizfinishdate,tradetype,source", (QFilter[])new QFilter[]{qFilter1});
                Date payDate = (Date)dataMap.get("finishdate");
                for (DynamicObject cdmBill : cdmPayBillList) {
                    String tradetype = cdmBill.getString("tradetype");
                    if (!DraftTradeTypeEnum.ENDORSE.getValue().equals(tradetype)) continue;
                    String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
                    boolean isAllowmodifydate = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)cdmBill.getDynamicObject("company").getLong("id"), (String)"isallowmodifydate");
                    boolean isElect = Objects.equals(cdmBill.getDynamicObject("drafttype").get("billmedium"), BillMediumEnum.ELECTRIC.getValue());
                    boolean isElectTag = cdmBill.getBoolean("electag");
                    boolean issucwriteback = (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)cdmBill.getDynamicObject("company").getLong("id"), (String)"issucwriteback");
                    boolean isDraftallocate = "cdm-draftallocate".equalsIgnoreCase(cdmBill.getString("source"));
                    if (isElect && isElectTag || !isAllowmodifydate || !issucwriteback || isDraftallocate) continue;
                    cdmBill.set("bizfinishdate", (Object)payDate);
                }
                try (TXHandle tx = TX.requiresNew();){
                    TmcDataServiceHelper.save((DynamicObject[])cdmPayBillList);
                }
            }
            if (dataMap != null) {
                logger.info("list closedCallBack");
                this.callDraftSave();
            }
        }
    }

    private void callDraftSave() {
        OperateOption op = OperateOption.create();
        OperationResult operationResult = this.getView().invokeOperation("drawbillsave", op);
        if (!operationResult.isSuccess()) {
            logger.info("list operationResult.getMessage:" + operationResult.getMessage());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (!this.confirm) {
            return;
        }
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        Object[] pkArr = selectedRows.getPrimaryKeyValues();
        HashSet<Object> set = new HashSet<Object>();
        StringJoiner msg = new StringJoiner("");
        StringJoiner msgStr = new StringJoiner("");
        StringJoiner allMsg = new StringJoiner("");
        DynamicObject[] drafttradebills = BusinessDataServiceHelper.load((Object[])pkArr, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_drafttradebill"));
        if ("submit".equals(opKey)) {
            String allMsgStr;
            for (DynamicObject drafttradebill : drafttradebills) {
                if (!this.isDiscountBill(drafttradebill)) continue;
                set.add(drafttradebill.getDynamicObject("company").getPkValue());
            }
            ArrayList<Long> inElecticdirconset = this.isInElecticdirconset(set.toArray(new Object[0]));
            for (DynamicObject drafttradebill : drafttradebills) {
                DynamicObject bank_cate;
                String busicontractno = drafttradebill.getString("busicontractno");
                Long company = drafttradebill.getDynamicObject("company").getLong("id");
                DynamicObject draftType = drafttradebill.getDynamicObject("drafttype");
                if (!this.isDiscountBill(drafttradebill)) continue;
                DynamicObject reBody = drafttradebill.getDynamicObject("recbody");
                String number = null;
                String billMedium = draftType.getString("billmedium");
                if (!ObjectUtils.isEmpty((Object)reBody) && EmptyUtil.isNoEmpty((DynamicObject)(bank_cate = reBody.getDynamicObject("bank_cate")))) {
                    number = bank_cate.getString("number");
                }
                if (StringUtils.isEmpty((CharSequence)busicontractno) && number != null && number.equals("BC-0032") && BillMediumEnum.ELECTRIC.getValue().equals(billMedium) && inElecticdirconset.contains(company)) {
                    msg.add(drafttradebill.getString("billno"));
                    msg.add(";\r\n");
                } else {
                    boolean isNeedConfirm = TradeBillAmountHelper.notConfirmDisounctInterest((DynamicObject)drafttradebill);
                    if (!isNeedConfirm) {
                        msgStr.add(drafttradebill.getString("billno"));
                        msgStr.add(";\r\n");
                    }
                }
                boolean iseditdiscountentry = drafttradebill.getBoolean("iseditdiscountentry");
                DynamicObjectCollection entry = drafttradebill.getDynamicObjectCollection("entrys");
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)entry) || entry.size() <= 1 || iseditdiscountentry) continue;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6253\u5f00\u7f16\u8f91\u5229\u606f\u660e\u7ec6\u5f00\u5173\u624d\u80fd\u5b8c\u6210\u63d0\u4ea4\u7535\u7968\u5728\u7ebf\u8d34\u73b0\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TradeBillTplEdit_36", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CONFIRM_SUBMIT_DISCOUNT_CALLBACK", (IFormPlugin)this));
                args.setCancel(true);
            }
            String billnoStr = msg.toString();
            String billSaveStr = msgStr.toString();
            if (billnoStr != null && billnoStr.length() > 0) {
                allMsg.add(String.format(ResManager.loadKDString((String)"(%s)\u5355\u636e\u6d66\u53d1\u94f6\u884c\u7535\u7968\u76f4\u8fde\u8d34\u73b0\u5fc5\u987b\u7ef4\u62a4\u4ea4\u6613\u5408\u540c\u53f7\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TradeBillList_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), billnoStr));
            }
            if (billSaveStr != null && billSaveStr.length() > 0) {
                allMsg.add(String.format(ResManager.loadKDString((String)"(%s)\u5b9e\u4ed8\u8d34\u73b0\u5229\u606f\u4e0e\u8d34\u73b0\u8bd5\u7b97\u7ed3\u679c\u4e0d\u4e00\u81f4\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TradeBillList_1_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), billSaveStr));
            }
            if ((allMsgStr = allMsg.toString()) != null && allMsgStr.length() > 0) {
                this.getView().showConfirm(allMsgStr, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CONFIRM_SUBMITBILLTRADELIST_CALLBACK", (IFormPlugin)this));
                this.confirm = false;
                args.setCancel(true);
            }
        }
    }

    private boolean isDiscountBill(DynamicObject drafttradebill) {
        String tradtype = drafttradebill.getString("tradetype");
        return tradtype != null && tradtype.equals(DraftTradeTypeEnum.DISCOUNT.getValue());
    }

    private ArrayList<Long> isInElecticdirconset(Object[] company) {
        ArrayList<Long> ishave = new ArrayList<Long>(8);
        QFilter orgFilter = new QFilter("company", "in", (Object)company);
        orgFilter.and("directconnchannel", "=", (Object)544782186595789012L);
        DynamicObject[] electricDirects = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"defaultaccount,company", (QFilter[])orgFilter.toArray());
        if (electricDirects == null || electricDirects.length < 1) {
            return ishave;
        }
        for (DynamicObject electricDirect : electricDirects) {
            ishave.add(electricDirect.getDynamicObject("company").getLong("id"));
        }
        return ishave;
    }
}

