/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.tradebill;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.constant.CdmBizConstant;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.PayableBillHelp;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeReceivableConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(TradeReceivableConvertPlugin.class);

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntities;
        String autoallocation;
        logger.info("TradeReceivableConvertPlugin is start");
        boolean isFromAoll = false;
        Map variablesMap = this.getOption().getVariables();
        if (EmptyUtil.isNoEmpty((Object)variablesMap) && variablesMap.size() > 0 && EmptyUtil.isNoEmpty((String)(autoallocation = (String)variablesMap.get("autoallocation"))) && "y".equals(autoallocation)) {
            isFromAoll = true;
        }
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity entity : billDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject[] accountBanks;
            DynamicObject TradeReceivableBill = entity.getDataEntity();
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)TradeReceivableBill.getLong("sourcebillid"), (String)"cdm_drafttradebill");
            Object companyId = PayableBillHelp.getCompanyIdByBeen((DynamicObject)obj);
            DynamicObject companyObj = TmcDataServiceHelper.loadSingle((Object)companyId, (String)"bos_org");
            TradeReceivableBill.set("company", (Object)companyObj);
            String bankAcct = obj.getString("bankacct");
            DynamicObject bank = obj.getDynamicObject("bank");
            if (EmptyUtil.isNoEmpty((DynamicObject)bank) && (accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)bankAcct).and(new QFilter("bank.bebank.id", "in", bank.getPkValue()))})).length > 0) {
                TradeReceivableBill.set("bankaccount", (Object)accountBanks[0]);
            }
            Long sourceDraftId = TradeReceivableBill.getLong("sourcedraft");
            this.setTradeReceivableInfo(TradeReceivableBill, sourceDraftId, obj);
            DynamicObject draftBillType = TradeReceivableBill.getDynamicObject("draftbilltype");
            Long billTypeId = 0L;
            String settlementType = draftBillType.getString("settlementtype");
            if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BANK.getValue())) {
                billTypeId = CdmBizConstant.RECEIVABLEBILL_BANK;
                DynamicObject recDny = TmcDataServiceHelper.loadSingle((Object)sourceDraftId, (String)"cdm_receivablebill");
                TradeReceivableBill.set("accepterbebank", recDny.get("accepterbebank"));
            } else if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.BUSINESS.getValue())) {
                billTypeId = CdmBizConstant.RECEIVABLEBILL_BUSINESS;
            } else if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.CHECK.getValue())) {
                billTypeId = CdmBizConstant.RECEIVABLEBILL_CHECK;
            } else if (StringUtils.equals((CharSequence)settlementType, (CharSequence)SettleMentTypeEnum.PROMISSORY.getValue())) {
                billTypeId = CdmBizConstant.RECEIVABLEBILL_PROMISSORY;
            }
            DynamicObject billTypeObj = TmcDataServiceHelper.loadSingle((Object)billTypeId, (String)"bos_billtype");
            TradeReceivableBill.set("billtype", (Object)billTypeObj);
            if (!isFromAoll) continue;
            TradeReceivableBill.set("isfromalloc", (Object)true);
        }
        logger.info("TradeReceivableConvertPlugin is end" + isFromAoll);
    }

    private void setTradeReceivableInfo(DynamicObject tradeReceivableBill, Long sourceDraftId, DynamicObject tradeBill) {
        boolean isSplit;
        DynamicObject draftBill = TmcDataServiceHelper.loadSingle((Object)sourceDraftId, (String)"cdm_receivablebill");
        long draftBillId = draftBill.getLong("id");
        long tradeBillId = tradeBill.getLong("id");
        HashSet<Long> draftBillIdSet = new HashSet<Long>();
        HashSet<Long> tradeBillIdSet = new HashSet<Long>();
        draftBillIdSet.add(draftBillId);
        tradeBillIdSet.add(tradeBillId);
        Map tradeBillIdAndSubBillMap = TradeBillHelper.getTradeBillIdAndSubBillMap(draftBillIdSet, tradeBillIdSet);
        String keyStr = tradeBillId + "_" + draftBillId;
        DynamicObject subRecBill = null;
        if (null != tradeBillIdAndSubBillMap.get(keyStr)) {
            subRecBill = (DynamicObject)tradeBillIdAndSubBillMap.get(keyStr);
        }
        BigDecimal amount = tradeReceivableBill.getBigDecimal("amount");
        BigDecimal supperbillAmount = tradeReceivableBill.getBigDecimal("supperbillamount");
        if (EmptyUtil.isEmpty((BigDecimal)supperbillAmount) || BigDecimal.ZERO.compareTo(supperbillAmount) == 0) {
            tradeReceivableBill.set("supperbillamount", (Object)draftBill.getBigDecimal("supperbillamount"));
        }
        if (isSplit = tradeReceivableBill.getBoolean("issplit")) {
            long subbillstartflag = tradeReceivableBill.getLong("subbillstartflag");
            long quanality = amount.multiply(new BigDecimal("100")).longValue();
            long subbillendflag = subbillstartflag + quanality - 1L;
            tradeReceivableBill.set("subbillquantity", (Object)quanality);
            tradeReceivableBill.set("subbillendflag", (Object)subbillendflag);
            tradeReceivableBill.set("subbillrange", (Object)(subbillstartflag + "-" + subbillendflag));
            if (null != subRecBill) {
                tradeReceivableBill.set("subbillquantity", (Object)subRecBill.getLong("subbillquantity"));
                tradeReceivableBill.set("subbillendflag", (Object)subRecBill.getLong("subbillendflag"));
                tradeReceivableBill.set("subbillrange", (Object)subRecBill.getString("subbillrange"));
                tradeReceivableBill.set("subbillstartflag", (Object)subRecBill.getLong("subbillstartflag"));
            } else {
                logger.info("no subRecBill");
            }
        }
        DynamicObject newDraftBill = (DynamicObject)OrmUtils.clone((Object)draftBill, (IDataEntityType)draftBill.getDataEntityType(), (boolean)true, (boolean)true);
        DynamicObjectCollection endCols = newDraftBill.getDynamicObjectCollection("endorseentry");
        this.setInfo("elccirculatestatus", newDraftBill, tradeReceivableBill);
        this.setInfo("eledraftstatusnew", newDraftBill, tradeReceivableBill);
        this.setInfo("eledraftstatus", newDraftBill, tradeReceivableBill);
        this.setInfo("accepterbank", newDraftBill, tradeReceivableBill);
        this.setInfo("drawerbank", newDraftBill, tradeReceivableBill);
        this.setInfo("receiverbank", newDraftBill, tradeReceivableBill);
        this.setInfo("acceptdate", newDraftBill, tradeReceivableBill);
        this.setInfo("issuepromisertype", newDraftBill, tradeReceivableBill);
        this.setInfo("issuepromiser", newDraftBill, tradeReceivableBill);
        this.setInfo("issuepromisername", newDraftBill, tradeReceivableBill);
        this.setInfo("isspromisetype", newDraftBill, tradeReceivableBill);
        this.setInfo("issuepromiseraccount", newDraftBill, tradeReceivableBill);
        this.setInfo("issuepromiseraddr", newDraftBill, tradeReceivableBill);
        this.setInfo("issuepromiserdate", newDraftBill, tradeReceivableBill);
        this.setInfo("acceptpromisertype", newDraftBill, tradeReceivableBill);
        this.setInfo("acceptpromiser", newDraftBill, tradeReceivableBill);
        this.setInfo("acceptpromisername", newDraftBill, tradeReceivableBill);
        this.setInfo("accpromisetype", newDraftBill, tradeReceivableBill);
        this.setInfo("acceptpromiseraccount", newDraftBill, tradeReceivableBill);
        this.setInfo("acceptpromiseraddr", newDraftBill, tradeReceivableBill);
        this.setInfo("acceptpromiserdate", newDraftBill, tradeReceivableBill);
        this.setInfo("issueticketgrade", newDraftBill, tradeReceivableBill);
        this.setInfo("issueticketcreditlevel", newDraftBill, tradeReceivableBill);
        this.setInfo("issueticketexpiredate", newDraftBill, tradeReceivableBill);
        this.setInfo("promisegrade", newDraftBill, tradeReceivableBill);
        this.setInfo("promisecreditlevel", newDraftBill, tradeReceivableBill);
        this.setInfo("promiseexpiredate", newDraftBill, tradeReceivableBill);
        DynamicObject draftEndObBill = BusinessDataServiceHelper.newDynamicObject((String)"cdm_receivablebill");
        DynamicObjectCollection cashEntityObj = draftEndObBill.getDynamicObjectCollection("endorseentry");
        DynamicObject draftEndObj = cashEntityObj.addNew();
        String draftType = tradeBill.getString("tradetype");
        if (DraftTradeTypeEnum.ENDORSE.getValue().equals(draftType)) {
            draftEndObj.set("endorsetype", (Object)"transfer");
            draftEndObj.set("endorseistransfer", (Object)newDraftBill.getBoolean("istransfer"));
            draftEndObj.set("signdate", (Object)tradeBill.getDate("bizfinishdate"));
            draftEndObj.set("initiatorname", (Object)tradeBill.getDynamicObject("company").getString("name"));
            String payeeTypeText = tradeBill.getString("payeetypetext");
            if ("other".equals(payeeTypeText)) {
                draftEndObj.set("opponentname", (Object)tradeBill.getString("beendorsortext"));
            } else {
                draftEndObj.set("opponentname", (Object)tradeBill.getDynamicObject("beendorsor").getString("name"));
            }
            endCols.add((Object)draftEndObj);
            tradeReceivableBill.set("endorseentry", (Object)endCols);
        }
    }

    private void setInfo(String property, DynamicObject newDraftBill, DynamicObject tradeReceivableBill) {
        tradeReceivableBill.set(property, newDraftBill.get(property));
    }
}

