/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.cdm.common.helper.TradeBillAmountHelper;
import kd.tmc.cdm.common.helper.TradeBillHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DraftBillToTradeBillConvertPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(DraftBillToTradeBillConvertPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterFieldMapping(e);
        String tradeType = this.getOption().getVariableValue("tradeType");
        boolean isFromAuto = this.getOption().containsVariable("isfromauto");
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            targetBill.set("tradetype", (Object)tradeType);
            DynamicObject billType = TmcDataServiceHelper.loadSingle((Object)DraftTradeTypeEnum.getType((String)tradeType), (String)"bos_billtype");
            targetBill.set("billtype", (Object)billType);
            targetBill.set("payeetypetext", (Object)"bd_supplier");
            targetBill.set("payeetype", (Object)"bd_supplier");
            targetBill.set("beendorsor", null);
            this.initFeilds(targetBill);
            TradeBillAmountHelper.calcTradeBillAmount((DynamicObject)targetBill);
            String isPledged = this.getOption().getVariableValue("isPledged", "false");
            if ("true".equals(isPledged)) {
                long tradeBillId = Long.parseLong(this.getOption().getVariableValue("tradeBillId", "0"));
                DynamicObject tradeBill = TmcDataServiceHelper.loadSingle((Object)tradeBillId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_drafttradebill"));
                DynamicObjectCollection entry = tradeBill.getDynamicObjectCollection("entrys");
                Map<Long, Long> draftIdToBillLogIdMap = entry.stream().collect(Collectors.toMap(o -> o.getDynamicObject("draftbill").getLong("id"), o -> o.getLong("billlogid"), (a, b) -> a));
                DynamicObjectCollection sourceEntry = targetBill.getDynamicObjectCollection("entrys");
                BigDecimal amount = BigDecimal.ZERO;
                for (DynamicObject dynamicObject : sourceEntry) {
                    dynamicObject.set("billlogid", (Object)draftIdToBillLogIdMap.get(dynamicObject.getDynamicObject("draftbill").getLong("id")));
                    dynamicObject.set("billamt", (Object)dynamicObject.getDynamicObject("draftbill").getBigDecimal("amount"));
                    amount = amount.add(dynamicObject.getBigDecimal("billamt"));
                }
                targetBill.set("source", (Object)"fromcollect");
                targetBill.set("sourcebillid", (Object)tradeBillId);
                targetBill.set("amount", (Object)amount);
            }
            this.fillDepositEntryWhenAutoCall(tradeType, isFromAuto, targetBill);
        }
    }

    private void fillDepositEntryWhenAutoCall(String tradeType, boolean isFromAuto, DynamicObject targetBill) {
        DynamicObjectCollection selectEntrys;
        boolean depositDeduct;
        if (isFromAuto && "payoff".equals(tradeType) && (depositDeduct = targetBill.getBoolean("depositdeduct")) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(selectEntrys = targetBill.getDynamicObjectCollection("entrys")))) {
            List<Object> draftListIds = new ArrayList();
            draftListIds = selectEntrys.stream().filter(Objects::nonNull).map(o -> o.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toList());
            DynamicObject[] billsList = TmcDataServiceHelper.load((String)"cdm_payablebill", (String)"id,draftbillno,sourcebillid,source", (QFilter[])new QFilter[]{new QFilter("id", "in", draftListIds)});
            logger.info("draftListIds is that is:" + SerializationUtils.toJsonString(draftListIds));
            Map<Long, DynamicObject> billIdAndBillMap = Arrays.stream(billsList).collect(Collectors.toMap(e1 -> e1.getLong("id"), e1 -> e1));
            Map billIdAndSuretyIdMap = TradeBillHelper.loadSurety((DynamicObject[])billsList);
            HashMap dpBillMap = new HashMap();
            HashMap<Long, DynamicObject> dpBillDyMap = new HashMap<Long, DynamicObject>();
            for (Map.Entry entry : billIdAndSuretyIdMap.entrySet()) {
                Long key = (Long)entry.getKey();
                logger.info("key is that:" + key);
                DynamicObject draft = billIdAndBillMap.get(key);
                if (null == draft) {
                    logger.info("draft is null:" + key);
                    continue;
                }
                String billno = draft.getString("draftbillno");
                List dpEntrys = (List)entry.getValue();
                for (DynamicObject depositDyj : dpEntrys) {
                    long dpId = depositDyj.getLong("id");
                    if (dpBillMap.containsKey(dpId)) {
                        ((Set)dpBillMap.get(dpId)).add(billno);
                    } else {
                        HashSet<String> set = new HashSet<String>();
                        set.add(billno);
                        dpBillMap.put(dpId, set);
                    }
                    if (dpBillDyMap.containsKey(dpId)) continue;
                    dpBillDyMap.put(dpId, depositDyj);
                }
            }
            Set longSet = dpBillMap.keySet();
            ArrayList dpIdList = new ArrayList(longSet);
            DynamicObjectCollection depositentrys = targetBill.getDynamicObjectCollection("depositentry");
            for (int i = 0; i < dpIdList.size(); ++i) {
                Long dpId = (Long)dpIdList.get(i);
                Set billNos = (Set)dpBillMap.get(dpId);
                StringJoiner billnoStr = new StringJoiner(";");
                for (String billNo : billNos) {
                    billnoStr.add(billNo);
                }
                String billnosString = billnoStr.toString() + ";";
                DynamicObject depositentry = depositentrys.addNew();
                depositentry.set("dpbillnos_tag", (Object)billnosString);
                String substr = billnosString;
                if (billnosString.length() > 255) {
                    substr = billnosString.substring(0, 245) + "...";
                }
                depositentry.set("dpbillnos", (Object)substr);
                this.createDpDataRow(billNos, (DynamicObject)dpBillDyMap.get(dpId), depositentry);
            }
            this.calcDepositData(targetBill);
        }
    }

    private void calcDepositData(DynamicObject targetBill) {
        DynamicObjectCollection dpEntrys = targetBill.getDynamicObjectCollection("depositentry");
        BigDecimal deductamount = BigDecimal.ZERO;
        for (DynamicObject dpEntry : dpEntrys) {
            BigDecimal dpdeductamount = dpEntry.getBigDecimal("dpdeductamount");
            BigDecimal dinterestamount = dpEntry.getBigDecimal("dinterestamount");
            if (EmptyUtil.isEmpty((BigDecimal)dpdeductamount)) {
                dpdeductamount = BigDecimal.ZERO;
            }
            if (EmptyUtil.isEmpty((BigDecimal)dpdeductamount)) {
                dinterestamount = BigDecimal.ZERO;
            }
            deductamount = deductamount.add(dpdeductamount).add(dinterestamount);
        }
        targetBill.set("deductamount", (Object)deductamount);
    }

    private void createDpDataRow(Set<String> billNos, DynamicObject depositDyj, DynamicObject depositentry) {
        QFilter draftBillNoFilter = new QFilter("draftbillno", "in", billNos);
        QFilter rpTypeFilter = new QFilter("rptype", "=", (Object)"paybill");
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter draftBillStatusFilter = new QFilter("draftbillstatus", "=", (Object)"registered");
        DynamicObject[] payableBills = TmcDataServiceHelper.load((String)"cdm_payablebill", (String)"id,suretymoney", (QFilter[])new QFilter[]{draftBillNoFilter, rpTypeFilter, billStatusFilter, draftBillStatusFilter});
        BigDecimal suretyMoneyTotal = BigDecimal.ZERO;
        for (DynamicObject payableBill : payableBills) {
            suretyMoneyTotal = suretyMoneyTotal.add(payableBill.getBigDecimal("suretymoney"));
        }
        BigDecimal surplusAmount = EmptyUtil.isEmpty((BigDecimal)depositDyj.getBigDecimal("surplusamount")) ? BigDecimal.ZERO : depositDyj.getBigDecimal("surplusamount");
        BigDecimal defaultSuretyAmount = surplusAmount.compareTo(suretyMoneyTotal) >= 0 ? suretyMoneyTotal : surplusAmount;
        depositentry.set("guarantway", (Object)"deposit");
        depositentry.set("dpbillno", (Object)depositDyj);
        depositentry.set("dpremainamount", (Object)depositDyj.getBigDecimal("surplusamount"));
        depositentry.set("dpsource", (Object)"gm");
        depositentry.set("dpdeductamount", (Object)defaultSuretyAmount);
    }

    private void initFeilds(DynamicObject targetBill) {
        HashSet<Object> currencyIds = new HashSet<Object>();
        HashSet<String> recBodyNames = new HashSet<String>();
        DynamicObjectCollection entrys = targetBill.getDynamicObjectCollection("entrys");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
            Set<Object> draftbillId = entrys.stream().map(e -> e.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
            DynamicObject[] draftBills = TmcDataServiceHelper.load((Object[])draftbillId.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
            Map<Long, DynamicObject> draftIdAndDyMap = Arrays.stream(draftBills).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
            for (DynamicObject entry : entrys) {
                DynamicObject selectDraftBill = entry.getDynamicObject("draftbill");
                if (!EmptyUtil.isNoEmpty((DynamicObject)selectDraftBill)) continue;
                DynamicObject draftBill = draftIdAndDyMap.get(selectDraftBill.getLong("id"));
                entry.set("draftbill", (Object)draftBill);
                selectDraftBill = entry.getDynamicObject("draftbill");
                Object curreyId = selectDraftBill.getDynamicObject("currency").getPkValue();
                currencyIds.add(curreyId);
                recBodyNames.add(selectDraftBill.getString("acceptername"));
                entry.set("billamt", (Object)selectDraftBill.getBigDecimal("availableamount"));
            }
        }
        if (currencyIds.size() != 1) {
            targetBill.set("currency", null);
        } else {
            DynamicObject currency = ((DynamicObject)entrys.get(0)).getDynamicObject("draftbill").getDynamicObject("currency");
            targetBill.set("currency", (Object)currency);
        }
        String tradeType = targetBill.getString("tradetype");
        DynamicObject draftType = targetBill.getDynamicObject("drafttype");
        if (null != draftType) {
            String setTlementType = draftType.getString("settlementtype");
            if ((tradeType.equals(DraftTradeTypeEnum.COLLECT.getValue()) || tradeType.equals(DraftTradeTypeEnum.DISCOUNT.getValue())) && SettleMentTypeEnum.BUSINESS.getValue().equals(setTlementType) && recBodyNames.size() != 1) {
                targetBill.set("recbodyname", null);
            }
        }
    }

    private void calcDeInterestAmountAllEntry(DynamicObject targetBill) {
    }
}

