/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.convert;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TradeBill2SplitRecBillConvertPlugin
extends AbstractConvertPlugIn {
    private static final List<String> NEWEleBIllELESTATUSList = Arrays.asList("CS01", "CS02", "CS03", "CS04", "CS05", "CS06");

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("id");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        String descEntity = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(descEntity);
        HashSet<Long> hasMatchEuqalIdSet = new HashSet<Long>();
        for (ExtendedDataEntity dataEntity : billDataEntitys) {
            DynamicObject recBill = dataEntity.getDataEntity();
            List srcRows = (List)dataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"cdm_drafttradebill");
            DynamicObjectCollection entrys = sourceBill.getDynamicObjectCollection("entrys");
            DynamicObject parentBillDy = ((DynamicObject)entrys.get(0)).getDynamicObject("draftbill");
            Long receiververId = parentBillDy.getLong("id");
            DynamicObject draftBill = BusinessDataServiceHelper.loadSingle((Object)receiververId, (String)"cdm_receivablebill");
            String billmedium = draftBill.getDynamicObject("draftbilltype").getString("billmedium");
            String elccirculatestatus = draftBill.getString("elccirculatestatus");
            if ("2".equals(billmedium) && EmptyUtil.isNoEmpty((String)elccirculatestatus)) {
                recBill.set("eledraftstatusnew", (Object)"CS03");
            }
            String claimnoticebillno = draftBill.getString("claimnoticebillno");
            recBill.set("claimnoticebillno", (Object)claimnoticebillno);
            recBill.set("isendorsepay", (Object)Character.valueOf('0'));
            this.setTradeReceivableInfo(recBill, draftBill);
            boolean isgenbysplit = sourceBill.getBoolean("isgenbysplit");
            if (isgenbysplit) {
                recBill.set("supperbillid", (Object)receiververId);
                recBill.set("isfromequalspilt", (Object)Character.valueOf('1'));
                recBill.set("euqaldifferetype", (Object)sourceBill.getString("euqaldifferetype"));
                BigDecimal billAmount = recBill.getBigDecimal("amount");
                BigDecimal equalAmount = sourceBill.getBigDecimal("equalamount");
                if (billAmount.compareTo(equalAmount) == 0 && !hasMatchEuqalIdSet.contains(receiververId)) {
                    recBill.set("isequalbill", (Object)Character.valueOf('1'));
                    recBill.set("sourcebillid", (Object)0);
                    recBill.set("eledraftstatusnew", (Object)draftBill.getString("eledraftstatusnew"));
                    recBill.set("eledraftstatus", (Object)draftBill.getString("eledraftstatus"));
                    hasMatchEuqalIdSet.add(receiververId);
                } else {
                    recBill.set("isequalbill", (Object)Character.valueOf('0'));
                    recBill.set("sourcebillid", (Object)0);
                    recBill.set("elccirculatestatus", (Object)"TF0301");
                    String billoldelestatus = ((DynamicObject)entrys.get(0)).getString("billoldelestatus");
                    if (NEWEleBIllELESTATUSList.contains(billoldelestatus)) {
                        recBill.set("eledraftstatusnew", (Object)billoldelestatus);
                    } else {
                        recBill.set("eledraftstatus", (Object)billoldelestatus);
                    }
                }
            } else {
                recBill.set("supperbillid", (Object)receiververId);
                recBill.set("equaltradebillid", sourceBill.getPkValue());
                recBill.set("isequalbill", (Object)true);
                recBill.set("lockedamount", (Object)BigDecimal.ZERO);
                recBill.set("usedamount", (Object)BigDecimal.ZERO);
            }
            recBill.set("isfromalloc", (Object)false);
        }
    }

    private void setTradeReceivableInfo(DynamicObject tradeReceivableBill, DynamicObject draftBill) {
        DynamicObject newDraftBill = (DynamicObject)OrmUtils.clone((Object)draftBill, (IDataEntityType)draftBill.getDataEntityType(), (boolean)true, (boolean)true);
        DynamicObjectCollection endCols = newDraftBill.getDynamicObjectCollection("endorseentry");
        this.setInfo("accepterbebank", newDraftBill, tradeReceivableBill);
        this.setInfo("acceptername", newDraftBill, tradeReceivableBill);
        this.setInfo("accepterbank", newDraftBill, tradeReceivableBill);
        this.setInfo("ispayinterest", newDraftBill, tradeReceivableBill);
        this.setInfo("elccirculatestatus", newDraftBill, tradeReceivableBill);
        this.setInfo("drawername", newDraftBill, tradeReceivableBill);
        this.setInfo("drawer", newDraftBill, tradeReceivableBill);
        this.setInfo("draweraccountname", newDraftBill, tradeReceivableBill);
        this.setInfo("drawerbank", newDraftBill, tradeReceivableBill);
        this.setInfo("drawerbankno", newDraftBill, tradeReceivableBill);
        this.setInfo("receiverbank", newDraftBill, tradeReceivableBill);
        this.setInfo("bankaccount", newDraftBill, tradeReceivableBill);
        this.setInfo("delivertype", newDraftBill, tradeReceivableBill);
        this.setInfo("delivername", newDraftBill, tradeReceivableBill);
        this.setInfo("deliver", newDraftBill, tradeReceivableBill);
        this.setInfo("deliveraccountbase", newDraftBill, tradeReceivableBill);
        this.setInfo("deliveraccounttext", newDraftBill, tradeReceivableBill);
        this.setInfo("deliveropenbank", newDraftBill, tradeReceivableBill);
        this.setInfo("deliveropenbanknum", newDraftBill, tradeReceivableBill);
        this.setInfo("pledgeenddate", newDraftBill, tradeReceivableBill);
        this.setInfo("pledgeetype", newDraftBill, tradeReceivableBill);
        this.setInfo("pledgeetext", newDraftBill, tradeReceivableBill);
        this.setInfo("pledgeetypebase", newDraftBill, tradeReceivableBill);
        DynamicObject pledgeebase = tradeReceivableBill.getDynamicObject("pledgeebase");
        if (EmptyUtil.isNoEmpty((DynamicObject)pledgeebase)) {
            newDraftBill.set("pledgeebase", pledgeebase.getPkValue());
        }
        this.setInfo("pledgeeaccounttext", newDraftBill, tradeReceivableBill);
        this.setInfo("pledgeeaccount", newDraftBill, tradeReceivableBill);
        this.setInfo("pledgeeopenbank", newDraftBill, tradeReceivableBill);
        this.setInfo("issuepromisertype", newDraftBill, tradeReceivableBill);
        this.setInfo("issuepromiser", newDraftBill, tradeReceivableBill);
        this.setInfo("issuepromisername", newDraftBill, tradeReceivableBill);
        this.setInfo("isspromisetype", newDraftBill, tradeReceivableBill);
        this.setInfo("issuepromiseraccount", newDraftBill, tradeReceivableBill);
        this.setInfo("issuepromiseraddr", newDraftBill, tradeReceivableBill);
        this.setInfo("issuepromiserdate", newDraftBill, tradeReceivableBill);
        this.setInfo("acceptpromisertype", newDraftBill, tradeReceivableBill);
        this.setInfo("acceptpromiser", newDraftBill, tradeReceivableBill);
        this.setInfo("acceptpromisername", newDraftBill, tradeReceivableBill);
        this.setInfo("accpromisetype", newDraftBill, tradeReceivableBill);
        this.setInfo("acceptpromiseraccount", newDraftBill, tradeReceivableBill);
        this.setInfo("acceptpromiseraddr", newDraftBill, tradeReceivableBill);
        this.setInfo("acceptpromiserdate", newDraftBill, tradeReceivableBill);
        this.setInfo("issueticketgrade", newDraftBill, tradeReceivableBill);
        this.setInfo("issueticketcreditlevel", newDraftBill, tradeReceivableBill);
        this.setInfo("issueticketexpiredate", newDraftBill, tradeReceivableBill);
        this.setInfo("promisegrade", newDraftBill, tradeReceivableBill);
        this.setInfo("promisecreditlevel", newDraftBill, tradeReceivableBill);
        this.setInfo("promiseexpiredate", newDraftBill, tradeReceivableBill);
        this.setInfo("auditdate", newDraftBill, tradeReceivableBill);
        tradeReceivableBill.set("createtime", (Object)new Date());
        this.setInfo("modifier", newDraftBill, tradeReceivableBill);
        this.setInfo("sourcedraft", newDraftBill, tradeReceivableBill);
        this.setInfo("sourcebilltype", newDraftBill, tradeReceivableBill);
        this.setInfo("sourcebillid", newDraftBill, tradeReceivableBill);
        this.setInfo("auditor", newDraftBill, tradeReceivableBill);
        this.setInfo("org", newDraftBill, tradeReceivableBill);
        this.setInfo("exchangerate", newDraftBill, tradeReceivableBill);
        this.setInfo("locamt", newDraftBill, tradeReceivableBill);
        this.setInfo("creator", newDraftBill, tradeReceivableBill);
        this.setInfo("rptype", newDraftBill, tradeReceivableBill);
        this.setInfo("recbody", newDraftBill, tradeReceivableBill);
        this.setInfo("beendorsor", newDraftBill, tradeReceivableBill);
        this.setInfo("isrefund", newDraftBill, tradeReceivableBill);
        this.setInfo("use", newDraftBill, tradeReceivableBill);
        this.setInfo("refunddesc", newDraftBill, tradeReceivableBill);
        this.setInfo("billpool", newDraftBill, tradeReceivableBill);
        this.setInfo("intopooltime", newDraftBill, tradeReceivableBill);
        this.setInfo("poollockorg", newDraftBill, tradeReceivableBill);
        this.setInfo("poollockstatus", newDraftBill, tradeReceivableBill);
        this.setInfo("poollocktime", newDraftBill, tradeReceivableBill);
        this.setInfo("billtype", newDraftBill, tradeReceivableBill);
        this.setInfo("eledraftstatus", newDraftBill, tradeReceivableBill);
        this.setInfo("allocbillentryid", newDraftBill, tradeReceivableBill);
        this.setInfo("electag", newDraftBill, tradeReceivableBill);
        this.setInfo("isvoucher", newDraftBill, tradeReceivableBill);
        this.setInfo("vouchernum", newDraftBill, tradeReceivableBill);
        this.setInfo("predictunlocktime", newDraftBill, tradeReceivableBill);
        this.setInfo("returnnotetag", newDraftBill, tradeReceivableBill);
        DynamicObjectCollection endorseentryTarget = tradeReceivableBill.getDynamicObjectCollection("endorseentry");
        DynamicObjectCollection endorseentry = newDraftBill.getDynamicObjectCollection("endorseentry");
        this.fillEndoreseData(endorseentryTarget, endorseentry);
        tradeReceivableBill.set("endorseentry", (Object)endorseentryTarget);
    }

    private void fillEndoreseData(DynamicObjectCollection endorseentryTarget, DynamicObjectCollection endorseentry) {
        for (DynamicObject endorse : endorseentry) {
            DynamicObject draftEndObBill = BusinessDataServiceHelper.newDynamicObject((String)"cdm_receivablebill");
            DynamicObjectCollection cashEntityObj = draftEndObBill.getDynamicObjectCollection("endorseentry");
            DynamicObject draftEndObj = cashEntityObj.addNew();
            this.setInfo("endorsetype", endorse, draftEndObj);
            this.setInfo("initiatorname", endorse, draftEndObj);
            this.setInfo("opponentname", endorse, draftEndObj);
            this.setInfo("signdate", endorse, draftEndObj);
            this.setInfo("pledgereleasedate", endorse, draftEndObj);
            this.setInfo("endorseistransfer", endorse, draftEndObj);
            endorseentryTarget.add((Object)draftEndObj);
        }
    }

    private void setInfo(String property, DynamicObject newDraftBill, DynamicObject tradeReceivableBill) {
        tradeReceivableBill.set(property, newDraftBill.get(property));
    }
}

