/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.convert;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.convert.group.SourceRowsGroupKey;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.TradeBillAmountHelper;

public class TradeBillEqualDifferentConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(TradeBillEqualDifferentConvertPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (DynamicObjectType)this.getSrcMainType());
            logger.info("TradeBillEqualDifferentConvertPlugin is start" + sourceBill.getString("billno"));
            String tradeType = sourceBill.getString("tradetype");
            targetBill.set("euqaldifferetype", (Object)tradeType);
            DynamicObjectCollection sourceBillEntrys = sourceBill.getDynamicObjectCollection("entrys");
            Object sourceRowsGroupKey = billDataEntity.getValue("SourceRowsGroupKey");
            long sourceEntryId = (Long)((SourceRowsGroupKey)sourceRowsGroupKey).getFldValues()[0];
            List sourceEntrys = sourceBillEntrys.stream().filter(x -> x.getLong("id") == sourceEntryId).collect(Collectors.toList());
            DynamicObject sourceEntry = (DynamicObject)sourceEntrys.get(0);
            DynamicObject draftbill = sourceEntry.getDynamicObject("draftbill");
            BigDecimal draftAmount = draftbill.getBigDecimal("amount");
            BigDecimal billAmount = sourceEntry.getBigDecimal("billamt");
            String oldelestatus = sourceEntry.getString("billoldelestatus");
            String draftbillstatus = draftbill.getString("draftbillstatus");
            targetBill.set("amount", (Object)draftAmount);
            targetBill.set("equalamount", (Object)billAmount);
            DynamicObjectCollection entryList = targetBill.getDynamicObjectCollection("entrys");
            entryList.clear();
            DynamicObject selectEntry = entryList.addNew();
            selectEntry.set("draftbill", (Object)draftbill);
            selectEntry.set("billamt", (Object)draftAmount);
            selectEntry.set("billoldelestatus", (Object)oldelestatus);
            String oldSupperBillStatus = DraftHelper.tradeTypeStatus((String)tradeType);
            logger.info("draftbillstatus is start" + draftbillstatus + ",oldSupperBillStatus :" + oldSupperBillStatus + "tradeType" + tradeType);
            selectEntry.set("oldstatus", (Object)oldSupperBillStatus);
            BigDecimal subtractAmount = draftbill.getBigDecimal("amount").subtract(billAmount);
            DynamicObjectCollection subentrysEntrys = targetBill.getDynamicObjectCollection("subentrys");
            Map firstEntryResultMap = TradeBillAmountHelper.addFisrtSplitEntry((DynamicObject)draftbill, (BigDecimal)subtractAmount);
            this.setEntryValue(sourceEntry, subentrysEntrys, firstEntryResultMap);
            Map secondEntryResultMap = TradeBillAmountHelper.addSecondSplitEntry((DynamicObject)draftbill, (BigDecimal)subtractAmount);
            this.setEntryValue(sourceEntry, subentrysEntrys, secondEntryResultMap);
            targetBill.set("rptype", (Object)"receivebill");
            targetBill.set("isgenbysplit", (Object)true);
            targetBill.set("draftcount", (Object)2);
        }
    }

    private void setEntryValue(DynamicObject sourceEntry, DynamicObjectCollection subentrysEntrys, Map<String, Object> firstEntryResultMap) {
        long subbillendflag = (Long)firstEntryResultMap.get("subbillendflag");
        long subbillstartflag = (Long)firstEntryResultMap.get("subbillstartflag");
        long subbillquantity = (Long)firstEntryResultMap.get("subbillquantity");
        String subbillsrange = (String)firstEntryResultMap.get("subbillsrange");
        BigDecimal subbillamount = (BigDecimal)firstEntryResultMap.get("subbillamount");
        DynamicObject draftbill = sourceEntry.getDynamicObject("draftbill");
        DynamicObject firstEntry = subentrysEntrys.addNew();
        firstEntry.set("e_draftbill", (Object)draftbill);
        firstEntry.set("e_subdraftbillstatus", (Object)"registered");
        firstEntry.set("e_billamt", (Object)draftbill.getBigDecimal("supperbillamount"));
        firstEntry.set("e_oldstatus", (Object)sourceEntry.getString("oldstatus"));
        firstEntry.set("e_transtatus", (Object)sourceEntry.getString("transtatus"));
        firstEntry.set("e_subbillendflag", (Object)subbillendflag);
        firstEntry.set("e_subbillstartflag", (Object)subbillstartflag);
        firstEntry.set("e_subbillquantity", (Object)subbillquantity);
        firstEntry.set("e_subbillsrange", (Object)subbillsrange);
        firstEntry.set("e_subbillamount", (Object)subbillamount);
    }
}

