/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.convert;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.TradeBillAmountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class TradeBillReapayConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log LOGGER = LogFactory.getLog(TradeBillReapayConvertPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
    }

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        e.setCustFilterExpression(" entryisrejectrefund = false and entryisrepay = false and transtatus = 'failing' ");
        QFilter qFilter = new QFilter("entryisrejectrefund", "=", (Object)false).and(new QFilter("entryisrepay", "=", (Object)false)).and(new QFilter("transtatus", "=", (Object)DraftTranStatusEnum.FAILING.getValue()));
        e.getCustQFilters().add(qFilter);
        LOGGER.info(e.getCustQFilters().toString());
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        Object[] idArr = Arrays.stream(billDataEntitys).map(o -> o.getDataEntity().getDynamicObjectCollection("entrys")).flatMap(Collection::stream).map(o -> o.getDynamicObject("draftbill").getPkValue()).toArray();
        Map<Object, DynamicObject> draftIdToDraftMap = Arrays.stream(TmcDataServiceHelper.load((Object[])idArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"))).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (DynamicObjectType)this.getSrcMainType());
            DynamicObjectCollection sourceEntryList = sourceBill.getDynamicObjectCollection("entrys");
            HashMap<Long, Boolean> isneedsplitMap = new HashMap<Long, Boolean>();
            for (DynamicObject entry : sourceEntryList) {
                isneedsplitMap.put(entry.getDynamicObject("draftbill").getLong("id"), entry.getBoolean("isneedsplit"));
            }
            String source = targetBill.getString("source");
            long sourceBillId = targetBill.getLong("sourcebillid");
            targetBill.set("rptype", (Object)sourceBill.getString("rptype"));
            DynamicObjectCollection entryList = targetBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entryList) {
                entry.set("transtatus", null);
                DynamicObject draftBill = entry.getDynamicObject("draftbill");
                draftBill = draftIdToDraftMap.get(draftBill.getPkValue());
                entry.set("isneedsplit", isneedsplitMap.get(draftBill.getLong("id")));
                if (SourceEnum.CAS.getValue().equals(source) && sourceBillId > 0L) continue;
                draftBill.set("locksourcebillid", null);
                draftBill.set("locksourcebilltype", null);
                draftBill.set("isendorsepay", (Object)"0");
            }
            TradeBillAmountHelper.calcTradeBillAmount((DynamicObject)targetBill);
        }
        TmcDataServiceHelper.save((DynamicObject[])draftIdToDraftMap.values().toArray(new DynamicObject[0]));
    }
}

