/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.convert;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.LogBizStatusEnum;
import kd.tmc.cdm.common.helper.TradeBillAmountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class TradeBillRejectRefundConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log LOGGER = LogFactory.getLog(TradeBillRejectRefundConvertPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
    }

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        e.setCustFilterExpression(" entryisrejectrefund = false and entryisrepay = false and transtatus = 'failing' ");
        QFilter qFilter = new QFilter("entryisrejectrefund", "=", (Object)false).and(new QFilter("entryisrepay", "=", (Object)false)).and(new QFilter("transtatus", "=", (Object)DraftTranStatusEnum.FAILING.getValue()));
        e.getCustQFilters().add(qFilter);
        LOGGER.info(e.getCustQFilters().toString());
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        Object[] idArr = Arrays.stream(billDataEntitys).map(o -> o.getDataEntity().getDynamicObjectCollection("entrys")).flatMap(Collection::stream).map(o -> o.getDynamicObject("draftbill").getPkValue()).toArray();
        Map<Object, DynamicObject> draftIdToDraftMap = Arrays.stream(TmcDataServiceHelper.load((Object[])idArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"))).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (DynamicObjectType)this.getSrcMainType());
            Map<Long, Long> draftIdAndBillLogIdMap = sourceBill.getDynamicObjectCollection("entrys").stream().collect(Collectors.toMap(o -> o.getDynamicObject("draftbill").getLong("id"), o -> o.getLong("billlogid")));
            String source = targetBill.getString("source");
            long sourceBillId = targetBill.getLong("sourcebillid");
            String rpType = "";
            DynamicObjectCollection entryList = targetBill.getDynamicObjectCollection("entrys");
            HashSet<Long> supperBillLogSet = new HashSet<Long>(8);
            for (DynamicObject entry : entryList) {
                entry.set("transtatus", null);
                DynamicObject draftBill = entry.getDynamicObject("draftbill");
                Long billLogId = draftIdAndBillLogIdMap.get(draftBill.getLong("id"));
                if (EmptyUtil.isNoEmpty((Long)billLogId)) {
                    entry.set("billlogid", (Object)billLogId);
                    supperBillLogSet.add(billLogId);
                }
                draftBill = draftIdToDraftMap.get(draftBill.getPkValue());
                rpType = draftBill.getString("rptype");
            }
            if (EmptyUtil.isNoEmpty(supperBillLogSet)) {
                QFilter idQf = new QFilter("id", "in", supperBillLogSet);
                DynamicObject[] draftLogAllArr = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,issplit,bizstatus,deleteflag,draftid,splitedsubbillid,newchildlogid", (QFilter[])new QFilter[]{idQf});
                HashSet<Long> notLogIdSet = new HashSet<Long>(8);
                HashSet<Long> logIdSet = new HashSet<Long>(8);
                for (DynamicObject draftLog : draftLogAllArr) {
                    Boolean isSplit = draftLog.getBoolean("issplit");
                    Long newChildLogId = draftLog.getLong("newchildlogid");
                    String bizStatus = draftLog.getString("bizstatus");
                    if (isSplit.booleanValue()) {
                        notLogIdSet.add(draftLog.getLong("id"));
                        continue;
                    }
                    if (isSplit.booleanValue() || !EmptyUtil.isNoEmpty((Long)newChildLogId) || newChildLogId <= 0L || !StringUtils.equals((CharSequence)bizStatus, (CharSequence)LogBizStatusEnum.PROCESS.getValue())) continue;
                    logIdSet.add(newChildLogId);
                }
                notLogIdSet.addAll(logIdSet);
                QFilter idQFilter = new QFilter("id", "in", notLogIdSet);
                Object[] draftLogArr = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,issplit,bizstatus,deleteflag,draftid,splitedsubbillid,newchildlogid", (QFilter[])new QFilter[]{idQFilter});
                if (EmptyUtil.isNoEmpty((Object[])draftLogArr)) {
                    Map<Long, DynamicObject> logIdAndDyMap = Arrays.stream(draftLogArr).collect(Collectors.toMap(e1 -> e1.getLong("id"), e1 -> e1));
                    Set<Long> isSplitLogIdSet = logIdAndDyMap.keySet();
                    boolean isRemove = entryList.removeIf(o -> supperBillLogSet.contains(o.getLong("billlogid")));
                    Set splitedSubBillIdSet = Arrays.stream(draftLogArr).map(x -> x.getLong("splitedsubbillid")).collect(Collectors.toSet());
                    if (EmptyUtil.isNoEmpty(splitedSubBillIdSet)) {
                        DynamicObject[] subDrafts;
                        for (DynamicObject subDraft : subDrafts = TmcDataServiceHelper.load((Object[])splitedSubBillIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"))) {
                            DynamicObject newSelectEntry = entryList.addNew();
                            newSelectEntry.set("draftbill", (Object)subDraft);
                            newSelectEntry.set("billamt", (Object)subDraft.getBigDecimal("amount"));
                        }
                    }
                }
            }
            targetBill.set("rptype", (Object)rpType);
            targetBill.set("source", (Object)"drafttradebill");
            targetBill.set("sourcebillid", sourceBill.getPkValue());
            targetBill.set("sourcebilltype", (Object)"cdm_drafttradebill");
            TradeBillAmountHelper.calcTradeBillAmount((DynamicObject)targetBill);
        }
        TmcDataServiceHelper.save((DynamicObject[])draftIdToDraftMap.values().toArray(new DynamicObject[0]));
    }
}

