/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.ebservice.draftbill.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.cdm.business.ebservice.api.IEBServiceFacade;
import kd.tmc.cdm.business.ebservice.draftbill.IElcManager;
import kd.tmc.cdm.common.enums.AsstActTypeEnum;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;

public class ElcManagerImpl
implements IElcManager {
    private static Log logger = LogFactory.getLog(ElcManagerImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NoteResult> payBillToElePayBill(DynamicObject[] dynamicObjects) {
        ArrayList<NoteResult> results = new ArrayList<NoteResult>();
        List recEleBillIdStr = Arrays.stream(dynamicObjects).map(dynamicObject -> String.valueOf(dynamicObject.getLong("id"))).collect(Collectors.toList());
        ArrayList<String> requestIds = new ArrayList<String>();
        ArrayList<Long> requestFailIds = new ArrayList<Long>();
        Map lockResultMap = MutexServiceHelper.batchRequestWithLostTime(recEleBillIdStr, (String)"cdm_receivablebill", (String)"pay-submit");
        try {
            for (Map.Entry entry : lockResultMap.entrySet()) {
                String key = (String)entry.getKey();
                if (((Boolean)entry.getValue()).booleanValue()) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(Long.valueOf(key));
            }
            logger.info(String.format("\u52a0\u9501\u6210\u529f\u6570\uff1a{%s}\uff0c\u52a0\u9501\u5931\u8d25\u6570\uff1a{%s}", requestIds.size(), requestFailIds.size()));
            List<DynamicObject> dynamicObjectsNew = Arrays.stream(dynamicObjects).filter(dynamicObject -> requestIds.contains(String.valueOf(dynamicObject.getLong("id")))).collect(Collectors.toList());
            DynamicObject[] bills = this.transferElcBill(dynamicObjectsNew);
            if (bills == null || bills.length == 0) {
                List<NoteResult> list = null;
                return list;
            }
            TmcDataServiceHelper.save((DynamicObject[])bills);
            for (DynamicObject e : bills) {
                NoteResult result = new NoteResult();
                result.setStatusCode(EBResultStatusCode.SUCCESS);
                result.setBillId(Long.valueOf(e.getLong("id")));
                results.add(result);
            }
            if (requestFailIds.size() > 0) {
                Object var9_12 = null;
                TmcErrorCode tmcErrorCode = new TmcErrorCode();
                for (Long data : requestFailIds) {
                    NoteResult noteResult = new NoteResult();
                    noteResult.setStatusCode(EBResultStatusCode.ERROR);
                    noteResult.setErrMsg(tmcErrorCode.BILL_MUTEX_LOCK_WITH_NUMBER(String.valueOf(data)).getMessage());
                    noteResult.setBillId(data);
                    results.add(noteResult);
                }
            }
        }
        catch (Exception ex) {
            logger.error("ElcManagerImpl.payBillToElePayBill exception\uff1a", (Throwable)ex);
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)"cdm_receivablebill", (String)"pay-submit");
        }
        return results;
    }

    @Override
    public List<NoteResult> remitRegister(List<Long> ids) {
        return this.op(ids, ElcDraftBillOpEnum.REMITREGISTER, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<NoteResult> draftTradeBillToEleRecBill(DynamicObject draftTradeBill) {
        String bizType = draftTradeBill.getString("tradetype");
        ElcDraftBillOpEnum opEnum = this.transferOpEnum(bizType);
        logger.info("ElcManagerImpl.draftTradeBillToEleRecBill tradeType= " + opEnum.getName() + "-" + opEnum.getValue() + " draftTradeBill billNo = " + draftTradeBill.getString("billno"));
        if (ObjectUtils.isEmpty((Object)opEnum)) {
            NoteResult noteResult = new NoteResult();
            noteResult.setStatusCode(EBResultStatusCode.ERROR);
            noteResult.setErrCode(new ErrorCode("EB002", "not suport"));
            noteResult.setErrMsg(ResManager.loadKDString((String)"\u7535\u7968\u6682\u4e0d\u652f\u6301\u5f53\u524d\u4e1a\u52a1\u64cd\u4f5c\u3002", (String)"ElcManagerImpl_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
            return Collections.singletonList(noteResult);
        }
        String settleWay = draftTradeBill.getString("settleway");
        String clearType = draftTradeBill.getString("cleartype");
        DynamicObjectCollection entryList = draftTradeBill.getDynamicObjectCollection("entrys");
        logger.info("\u4e1a\u52a1\u5904\u7406\u5355\u5206\u5f55\u6570\u636e\u7684\u6570\u91cf=" + entryList.size());
        Object[] draftIdArr = entryList.stream().filter(o -> !"success".equals(o.getString("transtatus"))).filter(e -> !e.getBoolean("entryisrejectrefund") && !e.getBoolean("entryisrepay")).map(o -> o.getDynamicObject("draftbill").getPkValue()).toArray();
        DynamicObject[] elcBillIdArr = TmcDataServiceHelper.load((String)"cdm_electronicbill", (String)"sourceid,ebstatus", (QFilter[])new QFilter[]{new QFilter("sourceid", "in", (Object)draftIdArr).and(new QFilter("querydrafttype", "!=", (Object)EleDraftExistCatEnum.HISTORYHOLD.getValue()))});
        if (elcBillIdArr.length > 0) {
            logger.info("\u4e1a\u52a1\u5904\u7406\u5355\u5206\u5f55\u5bf9\u5e94\u7535\u7968\u7684\u6570\u91cf=" + elcBillIdArr.length);
            Map<Object, String> draftIdAndEbStatusMap = Arrays.stream(elcBillIdArr).collect(Collectors.toMap(e -> e.get("sourceid"), e -> e.getString("ebstatus")));
            draftIdArr = Arrays.stream(draftIdArr).filter(draftId -> {
                String ebStatus = (String)draftIdAndEbStatusMap.get(draftId);
                return !EbStatus.EB_PROCESSING.getName().equals(ebStatus) && !EbStatus.BANK_PROCESSING.getName().equals(ebStatus) && !"BANK_UNKNOWN".equals(ebStatus);
            }).toArray();
        }
        logger.info("\u4e1a\u52a1\u5904\u7406\u5355\u5206\u5f55\u8fc7\u6ee4\u6389\u4ea4\u6613\u6210\u529f\u3001\u7535\u7968\u5728\u5904\u7406\u4e2d\u6570\u636e\u7684\u6570\u91cf=" + draftIdArr.length);
        DynamicObject[] draftBillArr = TmcDataServiceHelper.load((Object[])draftIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
        Map<Long, String> draftIdToSplitAmountMap = entryList.stream().collect(Collectors.toMap(o -> o.getDynamicObject("draftbill").getLong("id"), o -> o.getString("billamt"), (a, b) -> a));
        Map<Long, DynamicObject> draftIdToDraftMap = Arrays.stream(draftBillArr).collect(Collectors.toMap(o -> Long.valueOf(o.getPkValue().toString()), o -> o, (a, b) -> a));
        List sourceIds = Arrays.stream(draftIdArr).map(Object::toString).collect(Collectors.toList());
        Map<Object, Object> draftIdToDiscountMap = new HashMap(entryList.size());
        if ("discount".equals(bizType)) {
            DynamicObjectCollection discountList = draftTradeBill.getDynamicObjectCollection("discountentry");
            draftIdToDiscountMap = discountList.stream().collect(Collectors.toMap(o -> o.getDynamicObject("dis_selectbillid").getLong("id"), Function.identity(), (a, b) -> a));
        }
        ArrayList<NoteResult> results = new ArrayList<NoteResult>(10);
        ArrayList<String> requestIds = new ArrayList<String>();
        ArrayList<Long> requestFailIds = new ArrayList<Long>();
        Map lockResultMap = MutexServiceHelper.batchRequestWithLostTime(sourceIds, (String)"cdm_electronicbill", (String)"rec-submit");
        try {
            for (Map.Entry next : lockResultMap.entrySet()) {
                String key = (String)next.getKey();
                if (((Boolean)next.getValue()).booleanValue()) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(Long.valueOf(key));
            }
            if (requestFailIds.size() > 0) {
                for (Long data : requestFailIds) {
                    NoteResult result = new NoteResult();
                    TmcErrorCode tmcErrorCode = new TmcErrorCode();
                    result.setStatusCode(EBResultStatusCode.ERROR);
                    result.setErrMsg(tmcErrorCode.BILL_MUTEX_LOCK_WITH_NUMBER(String.valueOf(data)).getMessage());
                    result.setBillId(data);
                    results.add(result);
                }
            }
            if (requestIds.size() == 0) {
                ArrayList<NoteResult> arrayList = results;
                return arrayList;
            }
            QFilter sourceIdFilter = new QFilter("sourceid", "in", requestIds.stream().map(Long::valueOf).collect(Collectors.toList()));
            elcBillIdArr = TmcDataServiceHelper.load((String)"cdm_electronicbill", (String)"sourceid", (QFilter[])new QFilter[]{sourceIdFilter});
            logger.info("\u4e1a\u52a1\u5904\u7406\u5355\u5206\u5f55\u5bf9\u5e94\u7535\u7968\u7684\u6570\u91cf=" + elcBillIdArr.length);
            Map<Object, Object> draftIdToEleDraftMap = new HashMap();
            if (elcBillIdArr.length > 0) {
                Object[] eleIdArr = Arrays.stream(elcBillIdArr).map(DataEntityBase::getPkValue).toArray();
                elcBillIdArr = TmcDataServiceHelper.load((Object[])eleIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronicbill"));
                draftIdToEleDraftMap = Arrays.stream(elcBillIdArr).collect(Collectors.toMap(o -> o.getLong("sourceid"), o -> o, (a, b) -> a.getBoolean("backflag") ? b : a));
                logger.info("\u4e1a\u52a1\u5904\u7406\u5355\u5206\u5f55\u5bf9\u5e94\u7535\u7968\u53bb\u9664\u5df2\u6253\u56de\u7684\u6570\u91cf=" + draftIdToEleDraftMap.size());
            }
            HashSet<Long> nonEleDraftIdSet = new HashSet<Long>(draftIdToDraftMap.keySet());
            nonEleDraftIdSet.removeAll(draftIdToEleDraftMap.keySet());
            for (Long draftId2 : nonEleDraftIdSet) {
                DynamicObject dynamicObject = draftIdToDraftMap.get(draftId2);
                String draftNumber = dynamicObject.getString("billno");
                NoteResult result = new NoteResult();
                result.setStatusCode(EBResultStatusCode.ERROR);
                result.setErrMsg(String.format(ResManager.loadKDString((String)"\u6240\u9009\u7968\u636e[%s]\u4e0d\u5b58\u5728\u7535\u7968\uff0c\u8bf7\u91cd\u65b0\u9009\u7968", (String)"ElcManagerImpl_4", (String)"tmc-cdm-business", (Object[])new Object[0]), draftNumber));
                result.setBillId(draftId2);
                results.add(result);
            }
            ArrayList<void> needSaveBillList = new ArrayList<void>(10);
            for (DynamicObject dynamicObject : draftIdToEleDraftMap.values()) {
                void var23_29;
                long sourceId = dynamicObject.getLong("sourceid");
                DynamicObject draftBill = draftIdToDraftMap.get(sourceId);
                boolean isSplit = draftBill.getBoolean("issplit");
                if (isSplit) {
                    dynamicObject.set("grdbag", (Object)Boolean.TRUE);
                    dynamicObject.set("amount", (Object)draftBill.getBigDecimal("amount"));
                    dynamicObject.set("locamt", (Object)draftIdToSplitAmountMap.get(sourceId));
                } else {
                    dynamicObject.set("grdbag", (Object)Boolean.FALSE);
                    dynamicObject.set("locamt", (Object)draftBill.getBigDecimal("amount"));
                }
                boolean isBack = dynamicObject.getBoolean("backflag");
                if (isBack) {
                    DynamicObject dynamicObject2 = TmcDataServiceHelper.clone((DynamicObject)dynamicObject);
                    dynamicObject2.set("backflag", (Object)"0");
                    dynamicObject2.set("ticketstatus", (Object)draftBill.getString("eledraftstatus"));
                }
                var23_29.set("bizdate", draftTradeBill.get("bizdate"));
                String beendorsortext = draftTradeBill.getString("beendorsortext");
                if (beendorsortext == null || beendorsortext.length() < 1) {
                    DynamicObject beendorsor = draftTradeBill.getDynamicObject("beendorsor");
                    beendorsortext = beendorsor != null && beendorsor.getString("name") != null ? beendorsor.getString("name") : "";
                }
                if ("discount".equals(bizType) || "collect".equals(bizType)) {
                    var23_29.set("promiseracc", draftTradeBill.get("bankaccount"));
                    boolean isOnlineCal = draftTradeBill.getBoolean("isonlinecalc");
                    var23_29.set("otherinfo", (Object)(isOnlineCal ? "SM00" : "SM01"));
                    if ("discount".equals(bizType)) {
                        BigDecimal discountAmt;
                        BigDecimal roughlyInterest;
                        Long bankId;
                        DynamicObject bank;
                        DynamicObject bankAccount;
                        DynamicObject reBody = draftTradeBill.getDynamicObject("recbody");
                        if (!(ObjectUtils.isEmpty((Object)reBody) || ObjectUtils.isEmpty((Object)reBody.getDynamicObject("bank_cate")) || ObjectUtils.isEmpty((Object)reBody.getDynamicObject("bebank")))) {
                            String number = reBody.getDynamicObject("bank_cate").getString("number");
                            Long beBankId = reBody.getDynamicObject("bebank").getLong("id");
                            DynamicObject beBankColl = QueryServiceHelper.queryOne((String)"bd_bebank", (String)"other_code", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)beBankId)});
                            String otherCode = beBankColl.getString("other_code");
                            if ("BC-0030".equals(number) && StringUtil.isEmpty((String)otherCode)) {
                                var23_29.set("oppcity", (Object)otherCode);
                            }
                        }
                        if (!(ObjectUtils.isEmpty((Object)(bankAccount = draftTradeBill.getDynamicObject("bankaccount"))) || ObjectUtils.isEmpty((Object)(bank = QueryServiceHelper.queryOne((String)"bd_finorginfo", (String)"id,bebank,bank_cate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(bankId = Long.valueOf(bankAccount.getDynamicObject("bank").getLong("id"))))})).getLong("bank_cate")) || ObjectUtils.isEmpty((Object)bank.getLong("bebank")))) {
                            DynamicObject bankCat = QueryServiceHelper.queryOne((String)"bd_bankcgsetting", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bank.getLong("bank_cate"))});
                            String number = bankCat.getString("number");
                            Long beBankId = bank.getLong("bebank");
                            DynamicObject beBank = QueryServiceHelper.queryOne((String)"bd_bebank", (String)"other_code", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)beBankId)});
                            String otherCode = beBank.getString("other_code");
                            if ("BC-0030".equals(number) && StringUtil.isEmpty((String)otherCode)) {
                                var23_29.set("promiseorgno", (Object)otherCode);
                            }
                        }
                        var23_29.set("tradeoppname", (Object)(draftTradeBill.getDynamicObject("recbody") != null ? draftTradeBill.getDynamicObject("recbody").getString("name") : draftTradeBill.getString("recbodyname")));
                        boolean isPayByAgree = draftTradeBill.getBoolean("ispaybyagree");
                        if (isPayByAgree) {
                            BigDecimal agreeRate = draftTradeBill.getBigDecimal("agreerate");
                            if (agreeRate.compareTo(new BigDecimal("100")) == 0) {
                                var23_29.set("discountpaytype", (Object)"2");
                            } else {
                                var23_29.set("discountpaytype", (Object)"3");
                            }
                            var23_29.set("increaserate", (Object)agreeRate);
                        } else {
                            var23_29.set("increaserate", (Object)"");
                            var23_29.set("discountpaytype", (Object)"1");
                        }
                        DynamicObject discount = (DynamicObject)draftIdToDiscountMap.get(sourceId);
                        if (!ObjectUtils.isEmpty((Object)discount)) {
                            roughlyInterest = discount.getBigDecimal("dis_interest");
                            var23_29.set("interest", (Object)roughlyInterest.setScale(2, RoundingMode.HALF_UP));
                            discountAmt = discount.getBigDecimal("dis_discamt");
                            var23_29.set("actdiscountamount", (Object)discountAmt.setScale(2, RoundingMode.HALF_UP));
                            var23_29.set("invctype", (Object)discount.getString("invctype"));
                            var23_29.set("invcno", (Object)discount.getString("invcno"));
                            var23_29.set("invccode", (Object)discount.getString("invccode"));
                            var23_29.set("invcchkno", (Object)discount.getString("invcchkno"));
                            var23_29.set("invcamt", (Object)discount.getBigDecimal("invcamt"));
                            var23_29.set("invcdate", (Object)discount.getDate("invcdate"));
                        } else {
                            roughlyInterest = draftTradeBill.getBigDecimal("discount_interest");
                            var23_29.set("interest", (Object)roughlyInterest.setScale(2, RoundingMode.HALF_UP));
                            discountAmt = draftTradeBill.getBigDecimal("discamt");
                            var23_29.set("actdiscountamount", (Object)discountAmt.setScale(2, RoundingMode.HALF_UP));
                        }
                    } else {
                        var23_29.set("tradeoppname", (Object)draftBill.getString("acceptername"));
                    }
                    DynamicObject[] recBodys = BusinessDataServiceHelper.load((Object[])new Object[]{draftTradeBill.getDynamicObject("recbody").getPkValue()}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_finorginfo"));
                    DynamicObject recBody = recBodys == null ? null : recBodys[0];
                    var23_29.set("oppaccname", (Object)(recBody == null ? "" : recBody.getString("name")));
                    var23_29.set("oppaccno", (Object)0);
                    var23_29.set("oppcnapscode", (Object)(recBody == null ? "" : recBody.getString("union_number")));
                    var23_29.set("oppbankname", (Object)(recBody == null ? "" : recBody.getString("name")));
                    var23_29.set("oppcountry", (Object)(recBody == null ? "" : recBody.getDynamicObject("country").getString("name")));
                    var23_29.set("oppprovince", (Object)(recBody == null ? "" : recBody.getDynamicObject("province").getString("name")));
                    var23_29.set("oppcity", (Object)(recBody == null ? "" : recBody.getDynamicObject("city").getString("name")));
                    var23_29.set("autoaccept", (Object)draftTradeBill.getBoolean("isonlinecalc"));
                    if ("collect".equals(bizType)) {
                        var23_29.set("oppaccname", (Object)draftBill.getString("acceptername"));
                        var23_29.set("oppaccno", (Object)draftBill.getString("accepteraccount"));
                        var23_29.set("oppcnapscode", (Object)draftBill.getString("accepterbankno"));
                    }
                } else if ("pledge".equals(bizType)) {
                    String pledgeeType = draftTradeBill.getString("pledgeetype");
                    if ("bd_finorginfo".equals(pledgeeType)) {
                        var23_29.set("pledgeetype", (Object)"1");
                    } else {
                        var23_29.set("pledgeetype", (Object)"2");
                    }
                    if (AsstActTypeEnum.OTHER.getValue().equals(pledgeeType) || "bd_finorginfo".equals(pledgeeType)) {
                        var23_29.set("oppaccno", (Object)draftTradeBill.getString("pledgeeaccounttext"));
                        var23_29.set("oppaccname", (Object)draftTradeBill.getString("pledgeetext"));
                    } else {
                        var23_29.set("oppaccno", (Object)draftTradeBill.getString("pledgeeaccount"));
                        var23_29.set("oppaccname", (Object)draftTradeBill.getString("beendorsortext"));
                    }
                    var23_29.set("oppbankname", (Object)draftTradeBill.getDynamicObject("pledgeeopenbank").getString("name"));
                    var23_29.set("oppcnapscode", (Object)draftTradeBill.getString("pledgeeopenbanknumber"));
                    var23_29.set("othercode", (Object)draftTradeBill.getDynamicObject("pledgeeopenbank").getString("other_code"));
                    var23_29.set("tradeoppname", (Object)(draftTradeBill.getDynamicObject("pledgeebase") != null ? draftTradeBill.getDynamicObject("pledgeebase").getString("name") : draftTradeBill.getString("pledgeetext")));
                } else {
                    String oppProvince;
                    String oppCountry;
                    var23_29.set("oppaccname", (Object)beendorsortext);
                    String payeeTypeText = draftTradeBill.getString("payeetypetext");
                    if ("endorse".equals(bizType) && ("bd_supplier".equals(payeeTypeText) || "bd_customer".equals(payeeTypeText) || "bos_org".equals(payeeTypeText))) {
                        var23_29.set("oppaccname", draftTradeBill.get("oppaccname"));
                    }
                    var23_29.set("indorsename", (Object)beendorsortext);
                    var23_29.set("oppaccno", draftTradeBill.get("bankacct"));
                    var23_29.set("oppcnapscode", draftTradeBill.get("bankcode"));
                    String oppBankName = draftTradeBill.get("bank") == null ? null : ((DynamicObject)draftTradeBill.get("bank")).getString("name");
                    var23_29.set("oppbankname", (Object)oppBankName);
                    String string = draftTradeBill.get("bank") == null ? null : (oppCountry = ((DynamicObject)draftTradeBill.get("bank")).getDynamicObject("country") == null ? null : ((DynamicObject)draftTradeBill.get("bank")).getDynamicObject("country").getString("name"));
                    String string2 = draftTradeBill.get("bank") == null ? null : (oppProvince = ((DynamicObject)draftTradeBill.get("bank")).getDynamicObject("province") == null ? null : ((DynamicObject)draftTradeBill.get("bank")).getDynamicObject("province").getString("name"));
                    String oppCity = draftTradeBill.get("bank") == null ? null : (((DynamicObject)draftTradeBill.get("bank")).getDynamicObject("city") == null ? null : ((DynamicObject)draftTradeBill.get("bank")).getDynamicObject("city").getString("name"));
                    var23_29.set("oppcountry", (Object)oppCountry);
                    var23_29.set("oppprovince", (Object)oppProvince);
                    var23_29.set("oppcity", oppCity);
                    var23_29.set("tradeoppname", (Object)(draftTradeBill.getDynamicObject("beendorsor") != null ? draftTradeBill.getDynamicObject("beendorsor").getString("name") : draftTradeBill.getString("beendorsortext")));
                }
                if ("discount".equals(bizType) || "collect".equals(bizType) || "endorse".equals(bizType) || "pledge".equals(bizType)) {
                    var23_29.set("settleway", (Object)(EmptyUtil.isEmpty((String)settleWay) ? "ST01" : settleWay));
                    var23_29.set("cleartype", (Object)(EmptyUtil.isEmpty((String)clearType) ? "CT01" : clearType));
                }
                var23_29.set("tradecontractno", (Object)draftTradeBill.getString("busicontractno"));
                var23_29.set("tradetype", (Object)opEnum.getValue());
                var23_29.set("discountrate", draftTradeBill.get("rate"));
                Object description = draftTradeBill.get("description");
                if (!ObjectUtils.isEmpty((Object)description) && description instanceof OrmLocaleValue) {
                    OrmLocaleValue descriptionObj = (OrmLocaleValue)description;
                    var23_29.set("explain", (Object)descriptionObj.getLocaleValue_zh_CN());
                } else {
                    var23_29.set("explain", (Object)"");
                }
                var23_29.set("traderemarks", draftTradeBill.get("remarks"));
                needSaveBillList.add(var23_29);
            }
            TmcDataServiceHelper.save((DynamicObject[])draftIdToEleDraftMap.values().toArray(new DynamicObject[0]));
            TmcDataServiceHelper.save((DynamicObject[])needSaveBillList.toArray(new DynamicObject[0]));
            results.addAll(this.op(needSaveBillList.stream().map(e -> e.getLong("id")).collect(Collectors.toList()), opEnum, false));
            logger.info("\u4e1a\u52a1\u5904\u7406\u5355\u63d0\u4ea4\u7535\u7968\u6210\u529f\u7684\u6570\u91cf=" + needSaveBillList.size());
        }
        catch (Exception ex) {
            logger.error("\u4e1a\u52a1\u5904\u7406\u5355\u63d0\u4ea4\u7535\u7968\u8f6c\u6362\u5f02\u5e38\uff1a" + ex);
            throw ex;
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)"cdm_electronicbill", (String)"rec-submit");
        }
        return results;
    }

    List<NoteResult> op(List<Long> ids, ElcDraftBillOpEnum opEnum, Boolean isPay) {
        IEBServiceFacade bankService = EBServiceFacadeFactory.getBankService();
        return isPay != false ? bankService.draftPayBillOp(opEnum.getValue(), ids) : bankService.draftBillOp(opEnum.getValue(), ids);
    }

    public DynamicObject[] transferElcBill(List<DynamicObject> dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return null;
        }
        DynamicObject[] bills = new DynamicObject[dynamicObjects.size()];
        int returnDataCounts = 0;
        Map<Long, List<DynamicObject>> payEleBillS = this.getPaybills(dynamicObjects);
        Map<Long, DynamicObject> bankcgSettings = this.getBankcgsetting(dynamicObjects);
        Map<Long, DynamicObject> beBanks = this.getBeBanks(dynamicObjects);
        Map<Long, DynamicObject> acceptFinOrgInfos = this.getAcceptFinOrgInfo(dynamicObjects);
        Map<Long, DynamicObject> acceptBeBanks = this.getAcceptBeBank(dynamicObjects);
        for (int i = 0; i < bills.length; ++i) {
            String receiverBankProvince;
            String receiverBankCountry;
            Long beBankId;
            DynamicObject data = dynamicObjects.get(i);
            Long id = data.getLong("id");
            List<DynamicObject> payEleBill = payEleBillS.get(id);
            if (payEleBill != null && payEleBill.size() > 0) {
                ++returnDataCounts;
                bills[i] = payEleBill.get(0);
                continue;
            }
            ++returnDataCounts;
            DynamicObject elcBill = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_electronicbill"));
            boolean isSplit = data.getBoolean("issplit");
            if (isSplit) {
                elcBill.set("grdbag", (Object)Boolean.TRUE);
            } else {
                elcBill.set("grdbag", (Object)Boolean.FALSE);
            }
            elcBill.set("notestatus", (Object)data.getString("eledraftstatusnew"));
            elcBill.set("subrange", (Object)data.getString("subbillrange"));
            elcBill.set("sourceid", (Object)data.getLong("id"));
            elcBill.set("sourcenumber", (Object)data.getString("billno"));
            elcBill.set("company", (Object)data.getLong("company.id"));
            String settlementType = data.getDynamicObject("draftbilltype").getString("settlementtype");
            if (SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
                elcBill.set("drafttype", (Object)"AC01");
                DynamicObject accepterFinOrg = data.getDynamicObject("accepterfinorg");
                if (!ObjectUtils.isEmpty((Object)accepterFinOrg) && accepterFinOrg.getDynamicObject("bank_cate") != null) {
                    Long bankCatId = accepterFinOrg.getDynamicObject("bank_cate").getLong("id");
                    DynamicObject bankCat = bankcgSettings.get(bankCatId);
                    if (accepterFinOrg.getDynamicObject("bebank") != null) {
                        beBankId = accepterFinOrg.getDynamicObject("bebank").getLong("id");
                        DynamicObject beBank = beBanks.get(beBankId);
                        String otherCode = beBank.getString("other_code");
                        elcBill.set("promiseorgno", (Object)otherCode);
                    }
                }
            } else {
                elcBill.set("drafttype", (Object)"AC02");
                DynamicObject accepterAccountId = data.getDynamicObject("accepteraccountid");
                if (!ObjectUtils.isEmpty((Object)accepterAccountId) && accepterAccountId.getDynamicObject("bank") != null) {
                    Long bankId = accepterAccountId.getDynamicObject("bank").getLong("id");
                    DynamicObject bank = acceptFinOrgInfos.get(bankId);
                    logger.info("ElcManagerImpl.transferElcBill bank is null {}", (Object)(bank == null ? 1 : 0));
                    if (!ObjectUtils.isEmpty((Object)bank) && bank.getDynamicObject("bebank") != null) {
                        beBankId = bank.getDynamicObject("bebank").getLong("id");
                        Long bankCateId = bank.getDynamicObject("bank_cate") == null ? 0L : bank.getDynamicObject("bank_cate").getLong("id");
                        DynamicObject bankCat = QueryServiceHelper.queryOne((String)"bd_bankcgsetting", (String)"id,type_code", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bankCateId)});
                        String typeCode = bankCat == null ? "" : bankCat.getString("type_code");
                        logger.info("ElcManagerImpl.transferElcBill bankCat is null {}", (Object)(bankCat == null ? 1 : 0));
                        DynamicObject beBank = acceptBeBanks.get(beBankId);
                        logger.info("ElcManagerImpl.transferElcBill beBank is null {}", (Object)(beBank == null ? 1 : 0));
                        if (!ObjectUtils.isEmpty((Object)beBank) && "303".equals(typeCode)) {
                            String otherCode = beBank.getString("other_code");
                            elcBill.set("promiseorgno", (Object)otherCode);
                        } else {
                            elcBill.set("promiseorgno", data.get("accepterbankno"));
                        }
                    }
                }
            }
            elcBill.set("istransfer", data.get("istransfer"));
            elcBill.set("backflag", (Object)"0");
            elcBill.set("billstatus", (Object)"C");
            elcBill.set("rptype", data.get("rptype"));
            if (ReceivePayTypeEnum.PAYBILL.getValue().equals(data.get("rptype"))) {
                elcBill.set("issueticketpromise", (Object)ResManager.loadKDString((String)"\u672c\u6c47\u7968\u8bf7\u4e88\u4ee5\u627f\u5151\uff0c\u5230\u671f\u65e0\u6761\u4ef6\u4ed8\u6b3e", (String)"EleDraftBillCreator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            elcBill.set("tradetype", (Object)ElcDraftBillOpEnum.REMITREGISTER.getValue());
            elcBill.set("ticketstatus", (Object)"");
            elcBill.set("bizdate", data.get("bizdate"));
            elcBill.set("issueticketdate", data.get("issuedate"));
            elcBill.set("exchangebillexpiredate", data.get("draftbillexpiredate"));
            elcBill.set("applicanttext", data.get("drawername"));
            elcBill.set("applicantacctext", data.getDynamicObject("draweraccount").get("number"));
            elcBill.set("applicantbanktext", data.get("drawerbankname"));
            elcBill.set("issueticketertext", data.get("drawername"));
            elcBill.set("issueticketacctext", data.getDynamicObject("draweraccount").get("number"));
            elcBill.set("issueticketbanktext", data.get("drawerbankname"));
            elcBill.set("issueticketbankno", data.get("drawerbankno"));
            elcBill.set("collectionertext", data.get("receivername"));
            elcBill.set("collectionacctext", data.get("receiveraccount"));
            elcBill.set("collectionbanktext", data.getDynamicObject("receiverbank").get("name"));
            elcBill.set("collectionbankno", data.get("receiverbankno"));
            String string = data.getDynamicObject("receiverbank") == null ? null : (receiverBankCountry = data.getDynamicObject("receiverbank").getDynamicObject("country") == null ? null : data.getDynamicObject("receiverbank").getDynamicObject("country").getString("name"));
            String string2 = data.getDynamicObject("receiverbank") == null ? null : (receiverBankProvince = data.getDynamicObject("receiverbank").getDynamicObject("province") == null ? null : data.getDynamicObject("receiverbank").getDynamicObject("province").getString("name"));
            String receiverBankCity = data.getDynamicObject("receiverbank") == null ? null : (data.getDynamicObject("receiverbank").getDynamicObject("city") == null ? null : data.getDynamicObject("receiverbank").getDynamicObject("city").getString("name"));
            elcBill.set("acceptorcountry", (Object)receiverBankCountry);
            elcBill.set("acceptorprovince", (Object)receiverBankProvince);
            elcBill.set("acceptorcity", (Object)receiverBankCity);
            elcBill.set("collectionorgno", data.getDynamicObject("receiverbank").get("other_code"));
            if (SettleMentTypeEnum.BUSINESS.getValue().equals(settlementType)) {
                DynamicObject accepterAccountId = data.getDynamicObject("accepteraccountid");
                String accepterAccountName = accepterAccountId == null ? "" : accepterAccountId.getString("acctname");
                elcBill.set("promisertext", (Object)accepterAccountName);
            } else {
                elcBill.set("promisertext", data.get("acceptername"));
            }
            elcBill.set("promiseracctext", data.get("accepteraccount"));
            elcBill.set("promiserbanktext", data.get("accepterbankname"));
            elcBill.set("promiserbankno", data.get("accepterbankno"));
            elcBill.set("conectno", data.getDynamicObject("draweraccount").get("number"));
            elcBill.set("currencytext", data.getDynamicObject("currency").get("name"));
            elcBill.set("currency", data.getDynamicObject("currency").getPkValue());
            elcBill.set("amount", (Object)data.getBigDecimal("amount"));
            elcBill.set("locamt", (Object)data.getBigDecimal("amount"));
            elcBill.set("tradecontractno", data.get("contractno"));
            elcBill.set("issuepromisername", data.get("issuepromisername"));
            elcBill.set("issuepromiseraccount", data.get("issuepromiseraccount"));
            elcBill.set("issuepromiseraddr", data.get("issuepromiseraddr"));
            elcBill.set("acceptpromisername", data.get("acceptpromisername"));
            elcBill.set("acceptpromiseraccount", data.get("acceptpromiseraccount"));
            elcBill.set("acceptpromiseraddr", data.get("acceptpromiseraddr"));
            elcBill.set("issueticketcreditlevel", data.get("issueticketcreditlevel"));
            elcBill.set("issueticketexpiredate", data.get("issueticketexpiredate"));
            if (data.getDynamicObject("issueticketgrade") != null) {
                elcBill.set("issueticketgrade", data.getDynamicObject("issueticketgrade").get("name"));
            }
            if (data.getDynamicObject("promisegrade") != null) {
                elcBill.set("promisegrade", data.getDynamicObject("promisegrade").get("name"));
            }
            elcBill.set("promisecreditlevel", data.get("promisecreditlevel"));
            elcBill.set("promiseexpiredate", data.get("promiseexpiredate"));
            elcBill.set("explain", data.get("description"));
            elcBill.set("autoaccept", data.get("autoaccept"));
            elcBill.set("autoreceive", data.get("autoreceive"));
            elcBill.set("acpFlg", data.get("acpflg"));
            elcBill.set("acpFer", data.get("acpfer"));
            elcBill.set("balTyp", data.get("baltyp"));
            elcBill.set("balEac", data.get("baleac"));
            bills[i] = elcBill;
        }
        if (returnDataCounts == 0) {
            return null;
        }
        return bills;
    }

    private Map<Long, DynamicObject> getAcceptFinOrgInfo(List<DynamicObject> dynamicObjects) {
        Map<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        Set<Long> accepterAccountIds = dynamicObjects.stream().filter(k -> EmptyUtil.isNoEmpty((DynamicObject)k.getDynamicObject("accepteraccountid"))).map(o -> o.getDynamicObject("accepteraccountid").getDynamicObject("bank").getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(accepterAccountIds)) {
            QFilter qFilter = new QFilter("id", "in", (Object)accepterAccountIds.toArray(new Long[0]));
            DynamicObject[] banks = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"id,bebank,bank_cate", (QFilter[])new QFilter[]{qFilter});
            map = Arrays.stream(banks).collect(Collectors.toMap(k -> k.getLong("id"), o -> o));
        }
        return map;
    }

    private Map<Long, DynamicObject> getAcceptBeBank(List<DynamicObject> dynamicObjects) {
        Map<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        Set<Long> accepterAccountIds = dynamicObjects.stream().filter(k -> EmptyUtil.isNoEmpty((DynamicObject)k.getDynamicObject("accepteraccountid"))).map(o -> o.getDynamicObject("accepteraccountid").getDynamicObject("bank").getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(accepterAccountIds)) {
            QFilter qFilter = new QFilter("id", "in", (Object)accepterAccountIds.toArray(new Long[0]));
            DynamicObjectCollection banks = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id,bebank", (QFilter[])new QFilter[]{qFilter});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)banks)) {
                Set<Long> beBankIds = banks.stream().filter(k -> EmptyUtil.isNoEmpty((Long)k.getLong("bebank"))).map(o -> o.getLong("bebank")).collect(Collectors.toSet());
                if (beBankIds.size() == 0) {
                    return map;
                }
                QFilter qFilter2 = new QFilter("id", "in", (Object)beBankIds.toArray(new Long[0]));
                DynamicObject[] bebanks = BusinessDataServiceHelper.load((String)"bd_bebank", (String)"id,union_number,other_code", (QFilter[])new QFilter[]{qFilter2});
                map = Arrays.stream(bebanks).collect(Collectors.toMap(k -> k.getLong("id"), o -> o));
            }
        }
        return map;
    }

    private Map<Long, DynamicObject> getBeBanks(List<DynamicObject> dynamicObjects) {
        Map<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        Set<Long> beBankIds = dynamicObjects.stream().filter(k -> EmptyUtil.isNoEmpty((DynamicObject)k.getDynamicObject("accepterfinorg")) && SettleMentTypeEnum.BANK.getValue().equals(k.getDynamicObject("draftbilltype").getString("settlementtype")) && EmptyUtil.isNoEmpty((DynamicObject)k.getDynamicObject("accepterfinorg").getDynamicObject("bank_cate")) && EmptyUtil.isNoEmpty((DynamicObject)k.getDynamicObject("accepterfinorg").getDynamicObject("bebank"))).map(o -> o.getDynamicObject("accepterfinorg").getDynamicObject("bebank").getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(beBankIds)) {
            QFilter qFilter = new QFilter("id", "in", (Object)beBankIds.toArray(new Long[0]));
            Object[] bebanks = BusinessDataServiceHelper.load((String)"bd_bebank", (String)"id,other_code", (QFilter[])new QFilter[]{qFilter});
            if (EmptyUtil.isNoEmpty((Object[])bebanks)) {
                map = Arrays.stream(bebanks).collect(Collectors.toMap(k -> k.getLong("id"), o -> o));
            }
        }
        return map;
    }

    private Map<Long, DynamicObject> getBankcgsetting(List<DynamicObject> dynamicObjects) {
        Map<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        Set<Long> bankCatIds = dynamicObjects.stream().filter(k -> EmptyUtil.isNoEmpty((DynamicObject)k.getDynamicObject("accepterfinorg")) && SettleMentTypeEnum.BANK.getValue().equals(k.getDynamicObject("draftbilltype").getString("settlementtype")) && EmptyUtil.isNoEmpty((DynamicObject)k.getDynamicObject("accepterfinorg").getDynamicObject("bank_cate"))).map(o -> o.getDynamicObject("accepterfinorg").getDynamicObject("bank_cate").getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(bankCatIds)) {
            QFilter qFilter = new QFilter("id", "in", (Object)bankCatIds.toArray(new Long[0]));
            Object[] bankcgsettings = BusinessDataServiceHelper.load((String)"bd_bankcgsetting", (String)"id,number,type_code", (QFilter[])new QFilter[]{qFilter});
            if (EmptyUtil.isNoEmpty((Object[])bankcgsettings)) {
                map = Arrays.stream(bankcgsettings).collect(Collectors.toMap(k -> k.getLong("id"), o -> o));
            }
        }
        return map;
    }

    private Map<Long, List<DynamicObject>> getPaybills(List<DynamicObject> dynamicObjects) {
        HashMap<Long, List<DynamicObject>> map = new HashMap<Long, List<DynamicObject>>(4);
        if (EmptyUtil.isEmpty(dynamicObjects)) {
            return map;
        }
        Set<Long> payIds = dynamicObjects.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("sourceid", "in", (Object)payIds.toArray(new Long[0]));
        qFilter.and(new QFilter("backflag", "!=", (Object)"1"));
        qFilter.and(new QFilter("ticketstatus", "!=", (Object)EleDraftBillStatusEnum.DESTROY.getValue()));
        Object[] payEleBills = BusinessDataServiceHelper.load((String)"cdm_electronicbill", (String)"id,sourceid", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((Object[])payEleBills)) {
            return map;
        }
        for (Object payEleBill : payEleBills) {
            ArrayList<Object> list;
            Long sourceid = payEleBill.getLong("sourceid");
            if (map.containsKey(sourceid)) {
                list = (ArrayList<Object>)map.get(sourceid);
                list.add(payEleBill);
                map.put(sourceid, list);
                continue;
            }
            list = new ArrayList<Object>(4);
            list.add(payEleBill);
            map.put(sourceid, list);
        }
        return map;
    }

    ElcDraftBillOpEnum transferOpEnum(String bizType) {
        switch (bizType) {
            case "endorse": {
                return ElcDraftBillOpEnum.NOTEENDORSE;
            }
            case "discount": {
                return ElcDraftBillOpEnum.NOTEDISCOUNT;
            }
            case "pledge": {
                return ElcDraftBillOpEnum.PLEDGENOTE;
            }
            case "rlspledge": {
                return ElcDraftBillOpEnum.REMOVEPLEDGE;
            }
            case "collect": {
                return ElcDraftBillOpEnum.PRESENTPAYMENT;
            }
        }
        return null;
    }
}

