/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.ebservice.draftbill.impl;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.ebservice.draftbill.IEleDraftBillUpdater;
import kd.tmc.cdm.business.helper.ElectRecClaimRuleHelper;
import kd.tmc.cdm.business.service.EleBillCommonHelper;
import kd.tmc.cdm.common.enums.DraftBillOpStatusEnum;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.cdm.common.enums.EleDraftIsNewECDS;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.helper.ReturnNoteSetHelper;
import kd.tmc.fbp.common.helper.DateFormatUtil;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.op.DraftRecBillNoteDetail;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.query.DraftBillInfo;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.query.ReciteInfo;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.sync.DraftBillSyncDetail;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;
import org.apache.commons.lang3.StringUtils;

public class EleDraftBillUpdater
implements IEleDraftBillUpdater<DraftBillInfo, DraftRecBillNoteDetail, DraftBillSyncDetail> {
    private static final Log logger = LogFactory.getLog(EleDraftBillUpdater.class);
    private static EleDraftBillUpdater instance;

    private EleDraftBillUpdater() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EleDraftBillUpdater getInstance() {
        Class<EleDraftBillUpdater> clazz = EleDraftBillUpdater.class;
        synchronized (EleDraftBillUpdater.class) {
            if (instance == null) {
                instance = new EleDraftBillUpdater();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void queryUpdate(DynamicObject draftBill, DraftBillInfo queryData, String connectNo, String bizSubType) {
        DynamicObject[] accountBank;
        logger.info("EleDraftBillUpdater queryUpdate connectNo = {},bizSubType = {}", (Object)connectNo, (Object)bizSubType);
        if (EleDraftExistCatEnum.REPLY.getValue().equalsIgnoreCase(bizSubType)) {
            draftBill.set("querydrafttype", (Object)EleDraftExistCatEnum.REPLY.getValue());
            String ebStatus = draftBill.getString("ebstatus");
            String tradeType = draftBill.getString("tradetype");
            if (EbStatus.BANK_SUCCESS.getName().equals(ebStatus) && ElcDraftBillOpEnum.NOTESIGNINREJECT.getValue().equals(tradeType)) {
                logger.info("EleDraftBillUpdater queryUpdate:noteNo = {},bankMsg = {}", (Object)draftBill.getString("billno"), (Object)draftBill.getString("bankmsg"));
                draftBill.set("tradetype", (Object)"");
                draftBill.set("ebstatus", (Object)"");
                draftBill.set("bankmsg", (Object)"");
            }
        }
        draftBill.set("amount", (Object)queryData.getAmount());
        draftBill.set("opstatus", (Object)DraftBillOpStatusEnum.INIT.getValue());
        draftBill.set("drafttype", (Object)queryData.getDraftType());
        draftBill.set("interfacetype", (Object)(EleDraftIsNewECDS.NEW.getValue().equals(queryData.getIsNewECDS()) ? EleDraftIsNewECDS.NEW.getValue() : EleDraftIsNewECDS.OLD.getValue()));
        if (EleDraftIsNewECDS.NEW.getValue().equals(queryData.getIsNewECDS())) {
            EleDraftNoteStatusEnum newNoteStatus = EleDraftNoteStatusEnum.getByValue((String)queryData.getNoteStatus());
            draftBill.set("notestatus", (Object)(null == newNoteStatus ? queryData.getNoteStatus() : newNoteStatus.getValue()));
            this.newEleInterfaceFields(draftBill, queryData, null);
        } else {
            EleDraftBillStatusEnum byEbValue = EleDraftBillStatusEnum.getByEbValue((String)queryData.getNoteStatus());
            draftBill.set("ticketstatus", (Object)(null == byEbValue ? queryData.getNoteStatus() : byEbValue.getValue()));
        }
        draftBill.set("modifytime", (Object)new Date());
        draftBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
        if (!StringUtil.isEmpty((String)connectNo)) {
            draftBill.set("applicantacctext", (Object)connectNo);
        }
        if ((accountBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank,company,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)connectNo)})).length > 0) {
            DynamicObject directConnChannel;
            draftBill.set("applicanttext", (Object)accountBank[0].getDynamicObject("company").getString("name"));
            draftBill.set("draftaccount", (Object)accountBank[0]);
            DynamicObject electDirectConnect = BusinessDataServiceHelper.loadSingle((String)"cdm_electicdirconset", (String)"id,directconnchannel,defaultaccount", (QFilter[])new QFilter[]{new QFilter("defaultaccount.id", "=", accountBank[0].getPkValue())});
            if (!ObjectUtils.isEmpty((Object)electDirectConnect) && EmptyUtil.isNoEmpty((DynamicObject)(directConnChannel = electDirectConnect.getDynamicObject("directconnchannel")))) {
                logger.info("EleDraftBillUpdater queryUpdate directConnChannel is not null");
                draftBill.set("connchannel", directConnChannel.getPkValue());
            }
        }
        draftBill.set("applicantbanknotext", (Object)queryData.getApplicantBankCnaps());
        draftBill.set("bizcode", (Object)queryData.getBusinessCode());
        draftBill.set("bankconsultno", (Object)queryData.getBankRefKey());
        draftBill.set("bankrefdate", (Object)queryData.getBankRefDate());
        draftBill.set("customerconsultno", (Object)queryData.getCoustomerRefKey());
        draftBill.set("customeropstatus", (Object)queryData.getCoustomerStutus());
        draftBill.set("customeropstatus", (Object)queryData.getCoustomerStutus());
        DynamicObjectCollection currency = QueryServiceHelper.query((String)"bd_currency", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)queryData.getCurrency())});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currency)) {
            draftBill.set("currency", (Object)((DynamicObject)currency.get(0)).getLong("id"));
            draftBill.set("currencytext", (Object)((DynamicObject)currency.get(0)).getString("name"));
        }
        draftBill.set("issueticketdate", (Object)DateFormatUtil.FormatDate((String)queryData.getIssueDate()));
        draftBill.set("exchangebillexpiredate", (Object)DateFormatUtil.FormatDate((String)queryData.getDueDate()));
        draftBill.set("istransfer", (Object)("EM01".equals(queryData.getTransferFlag()) ? "0" : "1"));
        draftBill.set("invoicenumber", (Object)queryData.getInvoiceNumer());
        draftBill.set("contractnumber", (Object)queryData.getContractNumber());
        draftBill.set("keepflag", (Object)("1".equals(queryData.getKeepFlag()) ? "1" : "0"));
        draftBill.set("autoaccept", (Object)("1".equals(queryData.getAutoAccept()) ? "1" : "0"));
        draftBill.set("autoreceive", (Object)("1".equals(queryData.getAutoReceive()) ? "1" : "0"));
        draftBill.set("explain", (Object)queryData.getExplain());
        draftBill.set("remark", (Object)queryData.getRemark());
        draftBill.set("pretypeflag", (Object)("1".equals(queryData.getPreTypeFlag()) ? "1" : "0"));
        draftBill.set("indorsename", (Object)queryData.getIndorseName());
        draftBill.set("discountrate", (Object)queryData.getDisCountRate());
        draftBill.set("loanamount", (Object)queryData.getLoanAmount());
        draftBill.set("issueticketacctext", (Object)queryData.getDrawerAccNo());
        draftBill.set("issueticketertext", (Object)queryData.getDrawerAccName());
        draftBill.set("issueticketbanktext", (Object)queryData.getDrawerBankName());
        draftBill.set("issueticketbankno", (Object)queryData.getDrawerCnapsCode());
        draftBill.set("promiseracctext", (Object)queryData.getAcceptorAccNo());
        draftBill.set("promisertext", (Object)queryData.getAcceptorAccName());
        draftBill.set("promiserbanktext", (Object)queryData.getAcceptorBankName());
        draftBill.set("promiserbankno", (Object)queryData.getAcceptorCnapsCode());
        draftBill.set("collectionacctext", (Object)queryData.getPayeeAccNo());
        draftBill.set("collectionertext", (Object)queryData.getPayeeAccName());
        draftBill.set("collectionbanktext", (Object)queryData.getPayeeBankName());
        draftBill.set("collectionbankno", (Object)queryData.getPayeeCnapsCode());
        draftBill.set("holderaccno", (Object)queryData.getHolderAccNo());
        draftBill.set("holderbankname", (Object)queryData.getHolderBankName());
        draftBill.set("holdercnapscode", (Object)queryData.getHolderCnapsCode());
        DynamicObjectCollection entry = draftBill.getDynamicObjectCollection("entryentity");
        List sideInfos = queryData.getNoteSidesInfo();
        logger.info("EleDraftBillUpdater sideInfos.size = {} ", (Object)sideInfos.size());
        if (sideInfos.size() > 0) {
            entry.clear();
            sideInfos = sideInfos.stream().sorted(Comparator.comparing(o -> Integer.valueOf(StringUtils.isEmpty((CharSequence)o.getResv1()) ? "0" : o.getResv1()))).collect(Collectors.toList());
            for (int i = 0; i < sideInfos.size(); ++i) {
                ReciteInfo side = (ReciteInfo)sideInfos.get(i);
                DynamicObject newEntry = entry.addNew();
                newEntry.set("seq", (Object)(i + 1));
                newEntry.set("noteno", (Object)side.getNoteNo());
                newEntry.set("detailseq", (Object)side.getDetailSeq());
                newEntry.set("businesscode", (Object)side.getBusinessCode());
                newEntry.set("subtype", (Object)side.getSubType());
                newEntry.set("initiatororg", (Object)side.getInitiatorORG());
                newEntry.set("initiatorname", (Object)side.getInitiatorName());
                newEntry.set("initiatorbankcnaps", (Object)side.getInitiatorBankCnaps());
                newEntry.set("initiatoracno", (Object)side.getInitiatorAcNo());
                newEntry.set("opponentorg", (Object)side.getOpponentORG());
                newEntry.set("opponentname", (Object)side.getOpponentName());
                newEntry.set("opponentbankcnaps", (Object)side.getOpponentBankCnaps());
                newEntry.set("opponentcl", (Object)side.getOpponentCL());
                newEntry.set("opponentlorg", (Object)side.getOpponentLORG());
                newEntry.set("opponentduedate", (Object)side.getOpponentDueDate());
                newEntry.set("signdate", (Object)side.getSignDate());
                newEntry.set("replycode", (Object)side.getReplyCode());
                newEntry.set("dealno", (Object)side.getDealNo());
                newEntry.set("invoiceno", (Object)side.getInvoiceNo());
                newEntry.set("contractno", (Object)side.getContractNo());
                newEntry.set("paymentorder", (Object)side.getPaymentOrder());
                newEntry.set("paymentaccept", (Object)side.getPaymentAccept());
                newEntry.set("transferflag", (Object)side.getTransferFlag());
                newEntry.set("olclearingflag", (Object)side.getOlclearingFlag());
                newEntry.set("discounttype", (Object)side.getDiscountType());
                newEntry.set("discountrateentry", (Object)side.getDiscountRate());
                newEntry.set("discountamount", (Object)side.getDiscountAmount());
                newEntry.set("redemptionsdate", (Object)side.getRedemptionSDate());
                newEntry.set("disredrate", (Object)side.getDisRedRate());
                newEntry.set("disredamount", (Object)side.getDisRedAmount());
                newEntry.set("pre4paydate", (Object)side.getPre4PayDate());
                newEntry.set("currencyentry", (Object)side.getCurrency());
                newEntry.set("tradeamount", (Object)side.getAmount());
                newEntry.set("defaultfpcode", (Object)side.getDefaultFPCode());
                newEntry.set("remarkentry", (Object)side.getRemark());
                newEntry.set("tracktype", (Object)side.getTrackType());
                newEntry.set("trackdate", (Object)side.getTrackDate());
                newEntry.set("cleardate", (Object)side.getClearDate());
                newEntry.set("acountbankcnaps", (Object)side.getAcountBankCnaps());
                newEntry.set("accountno", (Object)side.getAccountNo());
                newEntry.set("endorser", (Object)side.getInitiatorName());
                newEntry.set("endorsee", (Object)side.getOpponentName());
                Date signDate = side.getSignDate() == null ? new Date() : (side.getSignDate().length() == 8 ? DateUtils.stringToDate((String)side.getSignDate(), (String)"yyyyMMdd") : DateUtils.stringToDate((String)side.getSignDate(), (String)"yyyy-MM-dd"));
                newEntry.set("endorsedate", (Object)signDate);
            }
            if (accountBank.length > 0 && !EleDraftBillStatusEnum.ACCEPTANCE.getValue().equals(draftBill.getString("ticketstatus")) && !EleDraftBillStatusEnum.INVOICE.getValue().equals(draftBill.getString("ticketstatus"))) {
                DynamicObject company = accountBank[0].getDynamicObject("company");
                boolean isReturnNote = ReturnNoteSetHelper.isReturnNote((DynamicObject)company, (DynamicObject)draftBill);
                draftBill.set("returnnotetag", (Object)isReturnNote);
            }
            draftBill.set("backinfoseries", (Object)EleBillCommonHelper.isBackInfoSeries(entry));
            draftBill.set("seriescheckdate", (Object)new Date());
        } else {
            draftBill.set("backinfoseries", (Object)Boolean.TRUE);
            draftBill.set("seriescheckdate", (Object)new Date());
        }
        if (StringUtil.isEmpty((String)queryData.getPreHolderName()) && !EleDraftBillStatusEnum.INVOICE.getValue().equals(draftBill.getString("ticketstatus")) && !EleDraftExistCatEnum.INFO.getValue().equalsIgnoreCase(bizSubType)) {
            if ((sideInfos = sideInfos.stream().filter(o -> !"02".equals(o.getBusinessCode()) && !"03".equals(o.getBusinessCode())).sorted(Comparator.comparing(o -> Integer.valueOf(StringUtils.isEmpty((CharSequence)o.getResv1()) ? "0" : o.getResv1()))).collect(Collectors.toList())).size() > 0) {
                String initiatorNameStr = "";
                if (EleDraftExistCatEnum.REPLY.getValue().equalsIgnoreCase(bizSubType)) {
                    initiatorNameStr = "301".equals(EleDraftBillUpdater.getBankCateTypeCode(connectNo)) ? ((ReciteInfo)sideInfos.get(0)).getInitiatorName() : ((ReciteInfo)sideInfos.get(0)).getOpponentName();
                } else if (EleDraftExistCatEnum.HOLD.getValue().equalsIgnoreCase(bizSubType)) {
                    initiatorNameStr = ((ReciteInfo)sideInfos.get(0)).getInitiatorName();
                }
                draftBill.set("preholdername", (Object)initiatorNameStr);
            } else if (draftBill.getString("collectionacctext").equals(draftBill.getString("conectno"))) {
                draftBill.set("preholdername", (Object)queryData.getDrawerAccName());
            } else {
                draftBill.set("preholdername", (Object)queryData.getPayeeAccName());
            }
        } else if (!EleDraftExistCatEnum.INFO.getValue().equalsIgnoreCase(bizSubType)) {
            draftBill.set("preholdername", (Object)(StringUtil.isEmpty((String)queryData.getPreHolderName()) ? queryData.getApplicantAcName() : queryData.getPreHolderName()));
        }
        DynamicObject ruleResult = ElectRecClaimRuleHelper.getClaimInfoByNoticeRule(draftBill, "");
        if (!ObjectUtils.isEmpty((Object)ruleResult)) {
            String handleScheme = ruleResult.getString("e_handlescheme");
            String refuseRemark = ruleResult.getString("e_refuseremark");
            draftBill.set("autoexecuteop", (Object)handleScheme);
            if ("notesigninreject".equals(handleScheme) && StringUtils.isNotEmpty((CharSequence)refuseRemark)) {
                draftBill.set("signopinion", (Object)"reject");
            } else if ("notesignin".equals(handleScheme)) {
                draftBill.set("signopinion", (Object)"sign");
            }
        } else {
            boolean isAutoSignIn = EleBillCommonHelper.isInternalUnit(draftBill.getString("preholdername"), draftBill.getDynamicObject("company"));
            draftBill.set("isautosignin", (Object)isAutoSignIn);
        }
        draftBill.set("oppaccname", (Object)draftBill.getString("preholdername"));
        draftBill.set("explain", (Object)queryData.getExplain());
        draftBill.set("remark", (Object)(StringUtils.isEmpty((CharSequence)queryData.getRemark()) && !ObjectUtils.isEmpty((Object)ruleResult) ? ruleResult.getString("e_refuseremark") : queryData.getRemark()));
        draftBill.set("isnotesideserror", (Object)"Y".equals(queryData.getIsNoteSidesError()));
        logger.info("EleDraftBillUpdater queryUpdate sideInfos:PreHolderName=" + draftBill.get("preholdername"));
    }

    @Override
    public void operateUpdate(DynamicObject draftBill, DraftRecBillNoteDetail operateData) {
        if (draftBill != null && operateData != null) {
            draftBill.set("modifytime", (Object)new Date());
            draftBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
            draftBill.set("operationcode", (Object)operateData.getOperationCode());
            draftBill.set("detailseqid", (Object)operateData.getDetailSeqID());
            draftBill.set("detailbizno", (Object)operateData.getDetailBizNo());
            draftBill.set("adddate", (Object)operateData.getAddDate());
            draftBill.set("ebseqid", (Object)operateData.getEbSeqID());
            draftBill.set("ebstatus", (Object)operateData.getEbStatus());
            draftBill.set("ebstatusmsg", (Object)operateData.getEbStatusMsg());
            draftBill.set("bankstatus", (Object)operateData.getBankStatus());
            draftBill.set("bankmsg", (Object)operateData.getBankMsg());
            draftBill.set("flowserialno", (Object)operateData.getFlowSerialNo());
            draftBill.set("rqstserialno", (Object)operateData.getRqstSerialNo());
            draftBill.set("rspserialno", (Object)operateData.getRspSerialNo());
        }
    }

    @Override
    public void syncUpdate(DynamicObject draftBill, DraftBillSyncDetail syncData) {
        if (draftBill != null && syncData != null) {
            draftBill.set("modifytime", (Object)new Date());
            draftBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
            draftBill.set("detailseqid", (Object)syncData.getDetailSeqID());
            draftBill.set("detailbizno", (Object)syncData.getDetailBizNo());
            draftBill.set("promiserbanktext", (Object)(StringUtil.isEmpty((String)syncData.getAcceptorBankName()) ? draftBill.getString("promiserbanktext") : syncData.getAcceptorBankName()));
            draftBill.set("drafttype", (Object)syncData.getDraftType());
            draftBill.set("istransfer", (Object)("EM01".equals(syncData.getTransferFlag()) ? "0" : "1"));
            draftBill.set("otherinfo", (Object)syncData.getOtherInfo());
            draftBill.set("operationname", (Object)syncData.getOperationName());
            draftBill.set("bankconsultno", (Object)syncData.getBankRefKey());
            logger.info("EB status:" + syncData.getEbStatus() + ",NoteStatus:" + syncData.getNoteStatus());
            if (EleDraftIsNewECDS.NEW.getValue().equals(syncData.getIsNewECDS())) {
                EleDraftNoteStatusEnum newNoteStatusEnum = EleDraftNoteStatusEnum.getByValue((String)syncData.getNoteStatus());
                draftBill.set("notestatus", (Object)(null == newNoteStatusEnum ? syncData.getNoteStatus() : newNoteStatusEnum.getValue()));
                this.newEleInterfaceFields(draftBill, null, syncData);
            } else {
                EleDraftBillStatusEnum byEbValue = EleDraftBillStatusEnum.getByEbValue((String)syncData.getNoteStatus());
                draftBill.set("ticketstatus", (Object)(null == byEbValue ? syncData.getNoteStatus() : byEbValue.getValue()));
            }
            draftBill.set("ebseqid", (Object)syncData.getEbSeqID());
            draftBill.set("ebstatus", (Object)syncData.getEbStatus());
            draftBill.set("ebstatusmsg", (Object)syncData.getEbStatusMsg());
            draftBill.set("bankstatus", (Object)syncData.getBankStatus());
            draftBill.set("bankmsg", (Object)syncData.getBankMsg());
            draftBill.set("flowserialno", (Object)syncData.getFlowSerialNo());
            draftBill.set("rqstserialno", (Object)syncData.getRqstSerialNo());
            draftBill.set("rspserialno", (Object)syncData.getRspSerialNo());
            draftBill.set("bankrefdate", (Object)syncData.getBankRefDate());
        }
    }

    private static String getBankCateTypeCode(String connectNo) {
        String bankCateTypeCode = "";
        if (StringUtils.isEmpty((CharSequence)connectNo)) {
            return bankCateTypeCode;
        }
        QFilter qFilter = new QFilter("defaultaccount.bankaccountnumber", "=", (Object)connectNo);
        DynamicObjectCollection eleConSets = QueryServiceHelper.query((String)"cdm_electicdirconset", (String)"directconnchannel", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)eleConSets)) {
            Long directconnchannelId = ((DynamicObject)eleConSets.get(0)).getLong("directconnchannel") == 0L ? 0L : ((DynamicObject)eleConSets.get(0)).getLong("directconnchannel");
            if (EmptyUtil.isNoEmpty((Object)directconnchannelId)) {
                logger.info("directconnchannelId is:{}", (Object)directconnchannelId);
                DynamicObjectCollection bankCateTypeCodeDy = QueryServiceHelper.query((String)"bd_bankcgsetting", (String)"type_code", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)directconnchannelId)});
                bankCateTypeCode = EmptyUtil.isEmpty((DynamicObjectCollection)bankCateTypeCodeDy) ? "" : ((DynamicObject)bankCateTypeCodeDy.get(0)).getString("type_code");
            } else {
                logger.info("directconnchannelId is null");
            }
        }
        logger.info("\u6839\u636e\u76f4\u8fde\u8d26\u53f7 {} \u83b7\u53d6\u94f6\u884c\u7c7b\u522b\u7684bankCateTypeCode = {}", (Object)connectNo, (Object)bankCateTypeCode);
        return bankCateTypeCode;
    }
}

