/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.ebservice.draftbill.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.business.ebservice.draftbill.IEleDraftBillCreator;
import kd.tmc.cdm.common.enums.DataSourceMethodEnum;
import kd.tmc.cdm.common.enums.DraftBillOpStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.cdm.common.enums.EleDraftIsNewECDS;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.helper.EleDraftHelper;
import kd.tmc.fbp.common.helper.DateFormatUtil;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.query.DraftBillInfo;

public class EleDraftPayBillCreator
implements IEleDraftBillCreator<DraftBillInfo> {
    private static final Log logger = LogFactory.getLog(EleDraftPayBillCreator.class);
    private static EleDraftPayBillCreator instance;

    private EleDraftPayBillCreator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EleDraftPayBillCreator getInstance() {
        Class<EleDraftPayBillCreator> clazz = EleDraftPayBillCreator.class;
        synchronized (EleDraftPayBillCreator.class) {
            if (instance == null) {
                instance = new EleDraftPayBillCreator();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public List<DynamicObject> createDraftBill(List<DraftBillInfo> queryDataList, String connectNo, String status, String bizSubType) {
        ArrayList<DynamicObject> draftBillList = new ArrayList<DynamicObject>(queryDataList.size());
        if (!CollectionUtils.isEmpty(queryDataList)) {
            MainEntityType draftBillEntityType = EntityMetadataCache.getDataEntityType((String)"cdm_electronic_pay_deal");
            for (DraftBillInfo info : queryDataList) {
                draftBillList.add(this.genDynamicObject(draftBillEntityType, info, connectNo, status, bizSubType));
            }
            if (draftBillList.size() > 0) {
                return draftBillList;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public DynamicObject createDraftBill(DraftBillInfo queryData, String conectNo, String status) {
        if (queryData != null) {
            MainEntityType draftBillEntityType = EntityMetadataCache.getDataEntityType((String)"cdm_electronicbill");
            return this.genDynamicObject(draftBillEntityType, queryData, conectNo, status, "");
        }
        return null;
    }

    private DynamicObject genDynamicObject(MainEntityType draftBillEntityType, DraftBillInfo info, String connectNo, String status, String bizSubType) {
        String bankName;
        DynamicObject beBank;
        DynamicObject bank;
        DynamicObject[] drawerAccountBank;
        logger.info("EleDraftPayBillCreator connectNo = {},status = {},bizSubType = {}", new Object[]{connectNo, status, bizSubType});
        long pkId = DB.genLongId((String)draftBillEntityType.getAlias());
        DynamicObject draftBill = new DynamicObject((DynamicObjectType)draftBillEntityType, (Object)pkId);
        if (EleDraftExistCatEnum.PREREGISTER.getValue().equalsIgnoreCase(bizSubType)) {
            draftBill.set("querydrafttype", (Object)EleDraftExistCatEnum.PREREGISTER.getValue());
        }
        if (EleDraftIsNewECDS.NEW.getValue().equals(info.getIsNewECDS())) {
            EleDraftNoteStatusEnum newNoteStatus = EleDraftNoteStatusEnum.getByValue((String)info.getNoteStatus());
            draftBill.set("notestatus", (Object)(null == newNoteStatus ? info.getNoteStatus() : newNoteStatus.getValue()));
            this.newEleInterfaceFields(draftBill, info);
            draftBill.set("grdbag", (Object)("0".equals(info.getGrdBag()) ? "0" : "1"));
            if ((StringUtils.isEmpty((CharSequence)draftBill.getString("subrange")) || "0".equals(draftBill.getString("subrange"))) && StringUtils.isNotEmpty((CharSequence)info.getAmount()) && draftBill.getBoolean("grdbag")) {
                draftBill.set("subrange", (Object)String.join((CharSequence)"-", "1", String.valueOf(new BigDecimal(info.getAmount()).multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString())));
            }
            draftBill.set("uniquecode", (Object)(info.getSubRange().indexOf(",") > 0 ? info.getNoteNo() + "-" + EleDraftHelper.tranSubRangeStyle((String)info.getSubRange()) : info.getNoteNo()));
        } else {
            EleDraftBillStatusEnum byEbValue = EleDraftBillStatusEnum.getByEbValue((String)info.getNoteStatus());
            draftBill.set("ticketstatus", (Object)(null == byEbValue ? info.getNoteStatus() : byEbValue.getValue()));
            draftBill.set("uniquecode", (Object)info.getNoteNo());
        }
        draftBill.set("initsubrange", (Object)EleDraftHelper.tranSubRangeStyle((String)info.getSubRange()));
        draftBill.set("initamount", (Object)info.getAmount());
        draftBill.set("tradecontractno", (Object)info.getContractNo());
        draftBill.set("conectno", (Object)connectNo);
        draftBill.set("rptype", (Object)ReceivePayTypeEnum.PAYBILL.getValue());
        draftBill.set("backflag", (Object)"0");
        draftBill.set("billstatus", (Object)"C");
        draftBill.set("modifytime", (Object)new Date());
        draftBill.set("createtime", (Object)new Date());
        draftBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        draftBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
        draftBill.set("billno", (Object)info.getNoteNo());
        draftBill.set("amount", (Object)info.getAmount());
        draftBill.set("opstatus", (Object)DraftBillOpStatusEnum.INIT.getValue());
        draftBill.set("drafttype", (Object)info.getDraftType());
        draftBill.set("applicantacctext", (Object)connectNo);
        DynamicObject[] accountBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank,company,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)connectNo)});
        if (accountBank.length > 0) {
            draftBill.set("company", (Object)accountBank[0].getDynamicObject("company"));
            draftBill.set("applicanttext", (Object)accountBank[0].getDynamicObject("company").getString("name"));
            draftBill.set("draftaccount", (Object)accountBank[0]);
            DynamicObject electDirectConnect = BusinessDataServiceHelper.loadSingle((String)"cdm_electicdirconset", (String)"id,directconnchannel,defaultaccount", (QFilter[])new QFilter[]{new QFilter("defaultaccount.id", "=", accountBank[0].getPkValue())});
            if (!ObjectUtils.isEmpty((Object)electDirectConnect)) {
                draftBill.set("connchannel", electDirectConnect.getDynamicObject("directconnchannel").getPkValue());
            }
        }
        draftBill.set("applicantbanknotext", (Object)info.getApplicantBankCnaps());
        draftBill.set("bizdate", (Object)new Date());
        draftBill.set("bizcode", (Object)info.getBusinessCode());
        draftBill.set("bankconsultno", (Object)info.getBankRefKey());
        draftBill.set("bankrefdate", (Object)info.getBankRefDate());
        draftBill.set("customerconsultno", (Object)info.getCoustomerRefKey());
        draftBill.set("customeropstatus", (Object)info.getCoustomerStutus());
        DynamicObject[] currency = BusinessDataServiceHelper.load((String)"bd_currency", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)info.getCurrency())});
        if (currency.length > 0) {
            draftBill.set("currency", currency[0].getPkValue());
            draftBill.set("currencytext", (Object)currency[0].getString("name"));
        }
        DynamicObject dynamicObject = new DynamicObject();
        draftBill.set("issueticketdate", (Object)DateFormatUtil.FormatDate((String)info.getIssueDate()));
        draftBill.set("exchangebillexpiredate", (Object)DateFormatUtil.FormatDate((String)info.getDueDate()));
        draftBill.set("istransfer", (Object)("EM01".equals(info.getTransferFlag()) ? "0" : "1"));
        draftBill.set("invoicenumber", (Object)info.getInvoiceNumer());
        draftBill.set("contractnumber", (Object)info.getContractNumber());
        draftBill.set("keepflag", (Object)("1".equals(info.getKeepFlag()) ? "1" : "0"));
        draftBill.set("autoaccept", (Object)("1".equals(info.getAutoAccept()) ? "1" : "0"));
        draftBill.set("autoreceive", (Object)("1".equals(info.getAutoReceive()) ? "1" : "0"));
        draftBill.set("explain", (Object)info.getExplain());
        draftBill.set("remark", (Object)info.getRemark());
        draftBill.set("pretypeflag", (Object)("1".equals(info.getPreTypeFlag()) ? "1" : "0"));
        draftBill.set("indorsename", (Object)info.getIndorseName());
        draftBill.set("discountrate", (Object)info.getDisCountRate());
        draftBill.set("loanamount", (Object)info.getLoanAmount());
        draftBill.set("issueticketertext", (Object)info.getDrawerAccName());
        draftBill.set("issueticketbanktext", (Object)info.getDrawerBankName());
        draftBill.set("issueticketbankno", (Object)info.getDrawerCnapsCode());
        draftBill.set("issueticketacctext", (Object)info.getDrawerAccNo());
        if (StringUtils.isEmpty((CharSequence)draftBill.getString("issueticketbankno")) && (drawerAccountBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)info.getDrawerAccNo())})).length > 0 && !ObjectUtils.isEmpty((Object)(bank = drawerAccountBank[0].getDynamicObject("bank")))) {
            String unionNumber = bank.getString("union_number");
            draftBill.set("issueticketbankno", (Object)unionNumber);
        }
        if (StringUtils.isEmpty((CharSequence)draftBill.getString("issueticketbanktext")) && (drawerAccountBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)info.getDrawerAccNo())})).length > 0 && !ObjectUtils.isEmpty((Object)(bank = drawerAccountBank[0].getDynamicObject("bank")))) {
            beBank = bank.getDynamicObject("bebank");
            bankName = beBank == null ? "" : beBank.getString("name");
            draftBill.set("issueticketbanktext", (Object)bankName);
        }
        draftBill.set("promiseracctext", (Object)info.getAcceptorAccNo());
        draftBill.set("promisertext", (Object)info.getAcceptorAccName());
        draftBill.set("promiserbanktext", (Object)info.getAcceptorBankName());
        draftBill.set("promiserbankno", (Object)info.getAcceptorCnapsCode());
        draftBill.set("collectionacctext", (Object)info.getPayeeAccNo());
        draftBill.set("collectionertext", (Object)info.getPayeeAccName());
        draftBill.set("collectionbanktext", (Object)info.getPayeeBankName());
        draftBill.set("collectionbankno", (Object)info.getPayeeCnapsCode());
        if (StringUtils.isEmpty((CharSequence)draftBill.getString("collectionbanktext")) && (drawerAccountBank = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)info.getPayeeAccNo())})).length > 0 && !ObjectUtils.isEmpty((Object)(bank = drawerAccountBank[0].getDynamicObject("bank")))) {
            beBank = bank.getDynamicObject("bebank");
            bankName = beBank == null ? "" : beBank.getString("name");
            draftBill.set("collectionbanktext", (Object)bankName);
        }
        draftBill.set("holderaccno", (Object)info.getHolderAccNo());
        draftBill.set("holderbankname", (Object)info.getHolderBankName());
        draftBill.set("holdercnapscode", (Object)info.getHolderCnapsCode());
        draftBill.set("applicantbanktext", (Object)info.getApplicantBankName());
        draftBill.set("issueticketpromise", (Object)ResManager.loadKDString((String)"\u672c\u6c47\u7968\u8bf7\u4e88\u4ee5\u627f\u5151\uff0c\u5230\u671f\u65e0\u6761\u4ef6\u4ed8\u6b3e", (String)"EleDraftBillCreator_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
        draftBill.set("promiseinfo", (Object)ResManager.loadKDString((String)"\u672c\u6c47\u7968\u5df2\u7ecf\u627f\u5151\uff0c\u5230\u671f\u65e0\u6761\u4ef6\u4ed8\u6b3e", (String)"EleDraftBillCreator_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
        draftBill.set("promisedate", (Object)DateFormatUtil.FormatDate((String)info.getIssueDate()));
        draftBill.set("oppaccname", (Object)draftBill.getString("preholdername"));
        logger.info("EleDraftPayBillCreator sideInfos:PreHolderName=" + draftBill.get("preholdername"));
        draftBill.set("datasource", (Object)DataSourceMethodEnum.BANK.getValue());
        draftBill.set("explain", (Object)info.getExplain());
        draftBill.set("remark", (Object)info.getRemark());
        return draftBill;
    }
}

