/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.ebservice.mock;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.tmc.cdm.business.ebservice.mock.MockEBRequestHandler;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.BeiServiceConfigHelper;
import kd.tmc.fbp.service.ebservice.enums.EBErrorCodeEnum;
import kd.tmc.fbp.service.ebservice.errorcode.EBBizErrorCode;
import kd.tmc.fbp.service.ebservice.exception.EBBizException;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.exception.EBRollBackableException;
import kd.tmc.fbp.service.ebservice.log.BankLogService;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.service.ebservice.service.IEBServiceExecutor;
import kd.tmc.fbp.service.ebservice.service.executor.EBServiceExecutor;
import kd.tmc.fbp.webapi.ebentity.EBRequest;

public class EBServiceMockExecutor
implements IEBServiceExecutor {
    private static final Log logger = LogFactory.getLog(EBServiceExecutor.class);
    private BankLogService logService;

    public <R> R execute(IEBService<R> service) {
        String resultBody;
        MockEBRequestHandler requestHandler;
        int timeout;
        EBRequest request;
        this.logService = new BankLogService(service.getBankLogInfo());
        try {
            boolean isValid = service.validate();
            if (!isValid) {
                return (R)service.getEBResult();
            }
            service.beforeRequest();
            request = service.getRequestBuilder().buildRequest();
            DynamicObject serviceConfig = BeiServiceConfigHelper.getServiceConfig();
            timeout = serviceConfig == null || serviceConfig.getInt("timeout") == 0 ? 600000 : serviceConfig.getInt("timeout") * 60 * 1000;
            requestHandler = new MockEBRequestHandler(this.logService);
            request.getHeader().setCustomId(requestHandler.getCustomerId());
            this.logService.setRequest(request);
            this.logService.save();
        }
        catch (Exception e) {
            this.logService.setBizException(e);
            try {
                service.rollback(e.getMessage(), e);
                this.logService.setBankayState(BeBillStatusEnum.SF.getValue(), BeBillStatusEnum.TF.getValue());
            }
            catch (Exception e1) {
                logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e1));
            }
            this.logService.save();
            return (R)service.getEBResult();
        }
        try {
            String respStr = requestHandler.executeEBRequest(request, service.getServiceUrl(), timeout);
            this.logService.setResponse(respStr);
            this.checkException(respStr);
            JSONObject response = JSON.parseObject((String)respStr);
            resultBody = JSONObject.toJSONString((Object)response.get((Object)"body"));
        }
        catch (Exception e) {
            this.logService.setResponseException(e);
            try {
                if (e instanceof EBRollBackableException) {
                    service.rollback(e.getMessage(), e);
                    this.logService.setBankayState(BeBillStatusEnum.SF.getValue(), BeBillStatusEnum.TF.getValue());
                } else {
                    service.handleEBException(null, e.getMessage(), e);
                }
            }
            catch (Exception e1) {
                this.logService.setBizException(e1);
                logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e1));
            }
            this.logService.update();
            return (R)service.getEBResult();
        }
        try {
            service.handleResultBody(resultBody);
        }
        catch (Exception e) {
            this.logService.setBizException(e);
            try {
                service.handleEBException(resultBody, e.getMessage(), e);
            }
            catch (Exception e1) {
                this.logService.setBizException(e1);
                logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e1));
            }
        }
        this.logService.update();
        return (R)service.getEBResult();
    }

    protected void checkException(String responseStr) {
        logger.info("\u8fd4\u56de\u7684\u5b57\u7b26\u4e32 responseStr = " + responseStr);
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            throw new EBBizNCException(new EBBizErrorCode().RESPONSE_ISNULL());
        }
        JSONObject response = JSON.parseObject((String)responseStr);
        logger.info("responseStr\u8f6cJson response == " + response);
        JSONObject exception = null;
        if (response.containsKey((Object)"exception")) {
            exception = (JSONObject)response.get((Object)"exception");
        }
        if (exception != null) {
            String errorCode = (String)exception.get((Object)"errorCode");
            String message = (String)exception.get((Object)"message");
            logger.info("-------\u94f6\u4f01\u670d\u52a1\u8bf7\u6c42\u8c03\u7528\u8fd4\u56de\u5f02\u5e38\uff1aerrorCode=" + errorCode + "\uff1bmessage=" + message + "------");
            if (StringUtils.isEmpty((CharSequence)errorCode)) {
                if (StringUtils.isEmpty((CharSequence)message)) {
                    throw new EBBizNCException(new EBBizErrorCode().EC_ISNULL());
                }
                throw new EBBizNCException(new EBBizErrorCode().EC_ISNULL_P(), new Object[]{message});
            }
            if (EBErrorCodeEnum.preException.name().equals(errorCode)) {
                throw new EBBizException(new EBBizErrorCode().PRE_PROCESS(), new Object[]{message});
            }
            if (EBErrorCodeEnum.serviceException.name().equals(errorCode)) {
                throw new EBBizNCException(new EBBizErrorCode().PROCESSING(), new Object[]{message});
            }
            if (EBErrorCodeEnum.afterException.name().equals(errorCode)) {
                throw new EBBizNCException(new EBBizErrorCode().AFTER_PROCESS(), new Object[]{message});
            }
            if (EBErrorCodeEnum.unknown_batch.name().equals(errorCode)) {
                throw new EBBizNCException(new EBBizErrorCode().UNKNOWN_BATCH(), new Object[]{message});
            }
            throw new EBBizNCException(new EBBizErrorCode().EC_UNKNOW(), new Object[]{message});
        }
    }
}

