/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.ebservice.service.draftbill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.business.ebservice.draftbill.impl.EleDraftBillUpdater;
import kd.tmc.cdm.business.ebservice.log.BankLogInfoElcFactory;
import kd.tmc.cdm.business.ebservice.request.builder.draftbill.EleDraftBillOpRequestBuilder;
import kd.tmc.cdm.business.ebservice.request.datasource.draftbill.EleDraftBillBatchRequestDataSource;
import kd.tmc.cdm.business.service.EleBillCommonHelper;
import kd.tmc.cdm.common.enums.DraftBillOpStatusEnum;
import kd.tmc.cdm.common.helper.BankCateHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.service.ebservice.utils.BeServiceHelper;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.op.DraftBillOpResponseBody;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.op.DraftRecBillNoteDetail;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;

public class EleDraftBillBatchOpServiceImpl
implements IEBService<List<NoteResult>> {
    private static final Log logger = LogFactory.getLog(EleDraftBillBatchOpServiceImpl.class);
    private final List<DynamicObject> bills;
    private final String op;
    private final List<NoteResult> result;

    public EleDraftBillBatchOpServiceImpl(String op, List<DynamicObject> bills) {
        this.bills = bills;
        this.op = op;
        this.result = new ArrayList<NoteResult>(bills.size());
        for (DynamicObject bill : bills) {
            NoteResult noteResult = new NoteResult();
            noteResult.setBillId(Long.valueOf(bill.getLong("id")));
            this.result.add(noteResult);
        }
    }

    public boolean validate() {
        return EleBillCommonHelper.isCorrectTimeToEB(this.result, this.bills.get(0).getDynamicObject("company").getLong("id"));
    }

    public void beforeRequest() {
        String serialNumber = BeServiceHelper.generateSerialNumber();
        for (DynamicObject bill : this.bills) {
            bill.set("prebatchseqid", (Object)bill.getString("batchseqid"));
            bill.set("pretradetype", (Object)bill.getString("tradetype"));
            if (StringUtils.isEmpty((CharSequence)bill.getString("batchseqid")) || StringUtils.isNotEmpty((CharSequence)this.op.replace("_", ""))) {
                bill.set("batchseqid", (Object)serialNumber);
                bill.set("detailseqid", bill.getPkValue());
            }
            bill.set("tradetypetime", (Object)new Date());
        }
        try (TXHandle tx = TX.requiresNew();){
            TmcDataServiceHelper.save((DynamicObject[])this.bills.toArray(new DynamicObject[0]));
        }
    }

    public void rollback(String errMsg, Exception e) {
        for (NoteResult noteResult : this.result) {
            noteResult.setStatusCode(EBResultStatusCode.ROLLBACK);
            noteResult.setErrMsg(errMsg);
        }
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        for (NoteResult noteResult : this.result) {
            noteResult.setStatusCode(EBResultStatusCode.ERROR);
            noteResult.setErrMsg(errMsg);
        }
    }

    public void handleResultBody(String resultBody) {
        logger.info(" resultBody:" + resultBody);
        DraftBillOpResponseBody draftBillOpResponseBody = (DraftBillOpResponseBody)JSON.parseObject((String)resultBody, DraftBillOpResponseBody.class);
        List detailList = draftBillOpResponseBody.getDetails();
        Map DraftRecBillNoteDetailMap = detailList.stream().collect(Collectors.toMap(DraftRecBillNoteDetail::getDetailSeqID, Function.identity(), (k1, k2) -> k1));
        Map noteResultMap = this.result.stream().collect(Collectors.toMap(NoteResult::getBillId, Function.identity(), (k1, k2) -> k1));
        for (DynamicObject bill : this.bills) {
            DynamicObject[] opInfo = (DynamicObject[])DraftRecBillNoteDetailMap.get(bill.getString("detailseqid"));
            EleDraftBillUpdater.getInstance().operateUpdate(bill, (DraftRecBillNoteDetail)opInfo);
            bill.set("opstatus", (Object)DraftBillOpStatusEnum.WAIT_SYNC.getValue());
            bill.set("tradetype", (Object)this.op.replace("_", ""));
            logger.info("EleDraftBillOpServiceImpl handleResultBody save success tradetype = {},ebstatus = {}", bill.get("tradetype"), bill.get("ebstatus"));
            ((NoteResult)noteResultMap.get(bill.getLong("id"))).setStatusCode(EBResultStatusCode.SUCCESS);
        }
        List recBillIds = this.bills.stream().map(o -> o.getLong("sourceid")).collect(Collectors.toList());
        DynamicObject[] recBills = BusinessDataServiceHelper.load((Object[])recBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill"));
        if (recBills.length > 0) {
            for (DynamicObject recBill : recBills) {
                recBill.set("tradetype", (Object)this.op.replace("_", ""));
                recBill.set("ebstatus", (Object)EbStatus.EB_PROCESSING.getName());
            }
        }
        try (TXHandle tx = TX.requiresNew();){
            TmcDataServiceHelper.save((DynamicObject[])this.bills.toArray(new DynamicObject[0]));
            TmcDataServiceHelper.save((DynamicObject[])recBills);
        }
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new EleDraftBillOpRequestBuilder(new EleDraftBillBatchRequestDataSource(this.op, this.bills));
    }

    public String getEntityName() {
        return "cdm_electronicbill";
    }

    public BankLogInfo getBankLogInfo() {
        return BankLogInfoElcFactory.generateBatchBankLog(this.bills);
    }

    public List<NoteResult> getEBResult() {
        return this.result;
    }

    public String getServiceUrl() {
        return "/kapi/app/note/notePayable";
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((String)this.bills.get(0).getString("applicantacctext"));
    }
}

