/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.ebservice.service.draftbill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.business.ebservice.draftbill.impl.EleDraftPayBillUpdater;
import kd.tmc.cdm.business.ebservice.log.BankLogInfoElcFactory;
import kd.tmc.cdm.business.ebservice.request.builder.draftbill.ElePayDraftBillOpRequestBuilder;
import kd.tmc.cdm.business.ebservice.request.datasource.draftbill.EleDraftBillBatchRequestDataSource;
import kd.tmc.cdm.business.service.EleBillCommonHelper;
import kd.tmc.cdm.common.enums.DraftBillOpStatusEnum;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftIsNewECDS;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.helper.BankCateHelper;
import kd.tmc.cdm.common.helper.EleDraftHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.service.ebservice.utils.BeServiceHelper;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.op.DraftPayBillNoteDetail;
import kd.tmc.fbp.webapi.ebentity.biz.draftbill.op.DraftPayBillOpResponseBody;

public class ElePayDraftBillBatchOpServiceImpl
implements IEBService<List<NoteResult>> {
    private static final Log logger = LogFactory.getLog(ElePayDraftBillBatchOpServiceImpl.class);
    private final List<DynamicObject> bills;
    private final String op;
    private final List<NoteResult> result;

    public ElePayDraftBillBatchOpServiceImpl(String op, List<DynamicObject> bills) {
        this.bills = bills;
        this.op = op;
        this.result = new ArrayList<NoteResult>(bills.size());
        for (DynamicObject bill : bills) {
            NoteResult noteResult = new NoteResult();
            noteResult.setBillId(Long.valueOf(bill.getLong("id")));
            this.result.add(noteResult);
        }
    }

    public boolean validate() {
        return EleBillCommonHelper.isCorrectTimeToEB(this.result, this.bills.get(0).getDynamicObject("company").getLong("id"));
    }

    public void beforeRequest() {
        try (TXHandle tx = TX.requiresNew();){
            String serialNumber = BeServiceHelper.generateSerialNumber();
            for (DynamicObject bill : this.bills) {
                bill.set("prebatchseqid", (Object)bill.getString("batchseqid"));
                if (StringUtils.isEmpty((CharSequence)bill.getString("batchseqid")) || StringUtils.isNotEmpty((CharSequence)this.op.replace("_", ""))) {
                    bill.set("batchseqid", (Object)serialNumber);
                    bill.set("detailseqid", bill.getPkValue());
                }
                String noteStatus = bill.getString("notestatus");
                String cirStatus = bill.getString("cirstatus");
                String subRange = bill.getString("subrange");
                String isNewECDS = EleDraftHelper.isNewECDs((String)noteStatus, (String)subRange);
                if ((ElcDraftBillOpEnum.REMITREVOCATION.getValue().equals(this.op.replace("_", "")) || ElcDraftBillOpEnum.REMITCANCLE.getValue().equals(this.op.replace("_", ""))) && EleDraftIsNewECDS.NEW.getValue().equals(isNewECDS)) {
                    String operationCode = this.getRemitRevocationOperationCode(noteStatus, cirStatus, bill);
                    bill.set("operationcode", (Object)operationCode);
                }
                bill.set("tradetype", (Object)this.op.replace("_", ""));
                bill.set("tradetypetime", (Object)new Date());
                bill.set("backflag", (Object)"0");
            }
            TmcDataServiceHelper.save((DynamicObject[])this.bills.toArray(new DynamicObject[0]));
        }
    }

    public void rollback(String errMsg, Exception e) {
        for (NoteResult noteResult : this.result) {
            noteResult.setStatusCode(EBResultStatusCode.ROLLBACK);
            noteResult.setErrMsg(errMsg);
        }
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        for (NoteResult noteResult : this.result) {
            noteResult.setStatusCode(EBResultStatusCode.ERROR);
            noteResult.setErrMsg(errMsg);
        }
    }

    public void handleResultBody(String resultBody) {
        logger.info(" resultBody:" + resultBody);
        DraftPayBillOpResponseBody draftBillOpResponseBody = (DraftPayBillOpResponseBody)JSON.parseObject((String)resultBody, DraftPayBillOpResponseBody.class);
        List detailList = draftBillOpResponseBody.getDetails();
        Map DraftPayBillNoteDetailMap = detailList.stream().collect(Collectors.toMap(DraftPayBillNoteDetail::getDetailSeqID, Function.identity(), (k1, k2) -> k1));
        Map noteResultMap = this.result.stream().collect(Collectors.toMap(NoteResult::getBillId, Function.identity(), (k1, k2) -> k1));
        try (TXHandle tx = TX.requiresNew();){
            for (DynamicObject bill : this.bills) {
                DraftPayBillNoteDetail opInfo = (DraftPayBillNoteDetail)DraftPayBillNoteDetailMap.get(bill.getString("detailseqid"));
                EleDraftPayBillUpdater.getInstance().operateUpdate(bill, opInfo);
                bill.set("opstatus", (Object)DraftBillOpStatusEnum.WAIT_SYNC.getValue());
                ((NoteResult)noteResultMap.get(bill.getLong("id"))).setStatusCode(EBResultStatusCode.SUCCESS);
            }
            TmcDataServiceHelper.save((DynamicObject[])this.bills.toArray(new DynamicObject[0]));
        }
    }

    public IEBRequestBuilder getRequestBuilder() {
        return new ElePayDraftBillOpRequestBuilder(new EleDraftBillBatchRequestDataSource(this.op, this.bills));
    }

    public String getEntityName() {
        return "cdm_electronicbill";
    }

    public BankLogInfo getBankLogInfo() {
        return BankLogInfoElcFactory.generateBatchBankLog(this.bills);
    }

    public List<NoteResult> getEBResult() {
        return this.result;
    }

    public String getServiceUrl() {
        return "/kapi/app/note/notePayable";
    }

    public Long getBankCateId() {
        return BankCateHelper.getBankCateId((String)this.bills.get(0).getString("applicantacctext"));
    }

    private String getRemitRevocationOperationCode(String noteStatus, String cirStatus, DynamicObject bill) {
        String operationCode = "";
        if (EleDraftNoteStatusEnum.CS01.getValue().equals(noteStatus) && EleDraftCirStatusEnum.TF0101.getValue().equals(cirStatus)) {
            operationCode = "01";
        } else if (EleDraftNoteStatusEnum.CS01.getValue().equals(noteStatus) && EleDraftCirStatusEnum.TF0302.getValue().equals(cirStatus)) {
            operationCode = "02";
        } else if (EleDraftNoteStatusEnum.CS02.getValue().equals(noteStatus) && EleDraftCirStatusEnum.TF0101.getValue().equals(cirStatus)) {
            operationCode = "02";
        } else if (EleDraftNoteStatusEnum.CS02.getValue().equals(noteStatus) && EleDraftCirStatusEnum.TF0302.getValue().equals(cirStatus)) {
            operationCode = "03";
        } else if (ElcDraftBillOpEnum.getByValue((String)bill.getString("tradetype")) == null) {
            operationCode = "40";
        }
        return operationCode;
    }
}

