/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.lock;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.business.lock.OnWayDraftInfo;
import kd.tmc.cdm.business.service.DraftAmountLockSubInfo;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.common.enums.LogBizStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DraftLockCompatQuery {
    private static final String LOCK = "lock";
    private static final String RELEASE = "release";

    public static Set<OnWayDraftInfo> queryOnWayDraftIdSet(Set<Long> noBillLogDraftIdSet) {
        DynamicObject[] lockedDraftArr = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,isendorsepay,locksourcebilltype,locksourcebillid,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", noBillLogDraftIdSet), new QFilter("isendorsepay", "=", (Object)"1")});
        HashSet<OnWayDraftInfo> onWayDraftInfoList = new HashSet<OnWayDraftInfo>(8);
        for (DynamicObject lockedDraft : lockedDraftArr) {
            long draftId = lockedDraft.getLong("id");
            long locksourcebillid = lockedDraft.getLong("locksourcebillid");
            String locksourcebilltype = lockedDraft.getString("locksourcebilltype");
            BigDecimal amount = lockedDraft.getBigDecimal("amount");
            OnWayDraftInfo onWayDraftInfo = new OnWayDraftInfo(draftId, locksourcebilltype, locksourcebillid);
            onWayDraftInfo.setAmount(amount);
            onWayDraftInfoList.add(onWayDraftInfo);
        }
        return onWayDraftInfoList;
    }

    public static void getLockAndReleaseList(List<DraftLockInfo> draftLockInfos, List<DraftLockInfo> lockDraftInfoList, List<DraftLockInfo> releaseDraftInfoList) {
        for (DraftLockInfo draftAmountLockNewInfo : draftLockInfos) {
            DraftLockInfo lockInfo;
            List<DraftAmountLockSubInfo> lockSubInfoList = draftAmountLockNewInfo.getLockSubInfoList();
            if (EmptyUtil.isNoEmpty(lockSubInfoList)) {
                List<DraftAmountLockSubInfo> lockSubInfos = lockSubInfoList.stream().filter(e -> LogBizStatusEnum.PROCESS.getValue().equals(e.getBillTradeStatus())).collect(Collectors.toList());
                List<DraftAmountLockSubInfo> releaseSubInfos = lockSubInfoList.stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getOperateType())).collect(Collectors.toList());
                if (EmptyUtil.isNoEmpty(lockSubInfos)) {
                    lockInfo = DraftLockCompatQuery.fillLockInfo(draftAmountLockNewInfo, lockSubInfos);
                    lockInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                    lockDraftInfoList.add(lockInfo);
                }
                if (!EmptyUtil.isNoEmpty(releaseSubInfos)) continue;
                String operateType = ((DraftAmountLockSubInfo)releaseSubInfos.get(0)).getOperateType();
                DraftLockInfo releaseInfo = DraftLockCompatQuery.fillLockInfo(draftAmountLockNewInfo, releaseSubInfos);
                releaseInfo.setOperateType(operateType);
                releaseDraftInfoList.add(releaseInfo);
                continue;
            }
            List<Long> lockBillIdList = draftAmountLockNewInfo.getLockBillIdList();
            List<Long> releaseBillIdList = draftAmountLockNewInfo.getReleaseBillIdList();
            if (EmptyUtil.isNoEmpty(lockBillIdList)) {
                lockInfo = DraftLockCompatQuery.fillLockInfo(draftAmountLockNewInfo, null);
                lockInfo.setLockBillIdList(lockBillIdList);
                lockDraftInfoList.add(lockInfo);
            }
            if (!EmptyUtil.isNoEmpty(releaseBillIdList)) continue;
            DraftLockInfo releaseInfo = DraftLockCompatQuery.fillLockInfo(draftAmountLockNewInfo, null);
            releaseInfo.setReleaseBillIdList(releaseBillIdList);
            releaseDraftInfoList.add(releaseInfo);
        }
    }

    private static DraftLockInfo fillLockInfo(DraftLockInfo draftAmountLockNewInfo, List<DraftAmountLockSubInfo> lockSubInfos) {
        DraftLockInfo lockInfo = new DraftLockInfo();
        lockInfo.setBillTrade(draftAmountLockNewInfo.getBillTrade());
        lockInfo.setBillTradeStatus(draftAmountLockNewInfo.getBillTradeStatus());
        lockInfo.setBizBillNo(draftAmountLockNewInfo.getBizBillNo());
        lockInfo.setSourceBillType(draftAmountLockNewInfo.getSourceBillType());
        lockInfo.setSourceBillId(draftAmountLockNewInfo.getSourceBillId());
        lockInfo.setOnwayData(draftAmountLockNewInfo.getOnwayData());
        lockInfo.setTargetBillId(draftAmountLockNewInfo.getTargetBillId());
        lockInfo.setTargetBillType(draftAmountLockNewInfo.getTargetBillType());
        lockInfo.setOperateType(draftAmountLockNewInfo.getOperateType());
        if (EmptyUtil.isNoEmpty(lockSubInfos)) {
            lockInfo.setLockSubInfoList(lockSubInfos);
        }
        return lockInfo;
    }
}

