/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.lock;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.lock.DraftLockCompatQuery;
import kd.tmc.cdm.business.lock.DraftLogInfo;
import kd.tmc.cdm.business.lock.IDraftLockService;
import kd.tmc.cdm.business.service.DraftAmountLockSubInfo;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.cdm.common.enums.LogBizStatusEnum;
import kd.tmc.cdm.common.enums.OperateTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DraftLockCompatService
implements IDraftLockService {
    private static Log logger = LogFactory.getLog(DraftLockCompatService.class);

    @Override
    public List<LockResult> lock(List<DraftLockInfo> lockInfoList, boolean strickMode) {
        logger.info("DraftLockCompatService lock is start");
        Map<Long, Map<Long, DraftLogInfo>> billAndSourceAndDyMap = this.getNoBillLogDraftData(lockInfoList);
        ArrayList<LockResult> lockResults = new ArrayList<LockResult>(8);
        ArrayList<DraftLockInfo> lockDraftInfoList = new ArrayList<DraftLockInfo>(8);
        ArrayList<DraftLockInfo> releaseDraftInfoList = new ArrayList<DraftLockInfo>(8);
        DraftLockCompatQuery.getLockAndReleaseList(lockInfoList, lockDraftInfoList, releaseDraftInfoList);
        this.lock(billAndSourceAndDyMap, lockResults, lockDraftInfoList, strickMode);
        this.release(billAndSourceAndDyMap, lockResults, releaseDraftInfoList, strickMode);
        logger.info("lockBills is end,lockResults," + JSON.toJSONString(lockResults));
        return lockResults;
    }

    private void release(Map<Long, Map<Long, DraftLogInfo>> billAndSourceAndDyMap, List<LockResult> lockResults, List<DraftLockInfo> releaseDraftInfoList, boolean strickMode) {
        logger.info("release releaseDraftInfoList:" + JSON.toJSONString(releaseDraftInfoList));
        if (EmptyUtil.isNoEmpty(releaseDraftInfoList)) {
            ArrayList<DraftLockInfo> hasLogIdDraftLockList = new ArrayList<DraftLockInfo>(8);
            Set<Long> noLogDraftIdSet = this.getHasLogAndNoLogDraftIdSet(releaseDraftInfoList, hasLogIdDraftLockList, billAndSourceAndDyMap);
            if (EmptyUtil.isNoEmpty(noLogDraftIdSet)) {
                this.updateAmountAndOldLock(noLogDraftIdSet, false);
            }
            if (EmptyUtil.isNoEmpty(hasLogIdDraftLockList)) {
                for (DraftLockInfo releaseDraftInfo : hasLogIdDraftLockList) {
                    this.fillLockInfo(releaseDraftInfo, new HashMap<Long, BigDecimal>(), OperateTypeEnum.DELETE.getValue(), billAndSourceAndDyMap);
                    String operateType = releaseDraftInfo.getOperateType();
                    if (!EmptyUtil.isEmpty((String)operateType)) continue;
                    releaseDraftInfo.setOperateType(OperateTypeEnum.DELETE.getValue());
                }
                if (EmptyUtil.isNoEmpty(releaseDraftInfoList)) {
                    List<LockResult> resultList = LockDraftHelper.updateBills(releaseDraftInfoList, strickMode);
                    if (EmptyUtil.isNoEmpty(lockResults)) {
                        Map<Long, LockResult> sourceIdAndDyMap = lockResults.stream().collect(Collectors.toMap(LockResult::getSourceBillId, e -> e));
                        for (LockResult result : resultList) {
                            long sourceBillId = result.getSourceBillId();
                            LockResult preLockResult = sourceIdAndDyMap.get(sourceBillId);
                            if (EmptyUtil.isNoEmpty((Object)preLockResult)) {
                                Map<Long, Long> preBillIdLogIdMap = preLockResult.getBillIdLogIdMap();
                                Map<Long, Long> billIdLogIdMap = result.getBillIdLogIdMap();
                                preBillIdLogIdMap.putAll(billIdLogIdMap);
                                continue;
                            }
                            lockResults.add(result);
                        }
                    } else {
                        lockResults.addAll(resultList);
                    }
                }
            }
        }
    }

    private void lock(Map<Long, Map<Long, DraftLogInfo>> billAndSourceAndDyMap, List<LockResult> lockResults, List<DraftLockInfo> lockDraftInfoList, boolean strickMode) {
        logger.info("lock lockDraftInfoList:" + JSON.toJSONString(lockDraftInfoList));
        if (EmptyUtil.isNoEmpty(lockDraftInfoList)) {
            Set<Long> noLogDraftIdSet = this.getLockNoBillLogIdSet(billAndSourceAndDyMap, lockDraftInfoList);
            HashMap<Long, BigDecimal> draftIdAndAmountMap = new HashMap(8);
            if (EmptyUtil.isNoEmpty(noLogDraftIdSet)) {
                draftIdAndAmountMap = this.updateAmountAndOldLock(noLogDraftIdSet, true);
            }
            for (DraftLockInfo lockDraftInfo : lockDraftInfoList) {
                this.fillLockInfo(lockDraftInfo, draftIdAndAmountMap, LogBizStatusEnum.PROCESS.getValue(), new HashMap<Long, Map<Long, DraftLogInfo>>());
                lockDraftInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
            }
            if (EmptyUtil.isNoEmpty(lockDraftInfoList)) {
                List<LockResult> resultList = LockDraftHelper.lockBills(lockDraftInfoList, strickMode);
                lockResults.addAll(resultList);
            }
        }
    }

    private Set<Long> getLockNoBillLogIdSet(Map<Long, Map<Long, DraftLogInfo>> billAndSourceAndDyMap, List<DraftLockInfo> lockDraftInfoList) {
        HashSet<Long> noLogDraftIdSet = new HashSet<Long>(8);
        for (DraftLockInfo transfer : lockDraftInfoList) {
            DraftLogInfo draftLogInfo;
            Map<Long, DraftLogInfo> longDraftLogInfoMap;
            Long sourceBillId = transfer.getSourceBillId();
            List<DraftAmountLockSubInfo> lockSubInfoList = transfer.getLockSubInfoList();
            if (EmptyUtil.isNoEmpty(lockSubInfoList)) {
                for (DraftAmountLockSubInfo lockSubInfo : lockSubInfoList) {
                    Long billId = lockSubInfo.getBillId();
                    longDraftLogInfoMap = billAndSourceAndDyMap.get(billId);
                    if (EmptyUtil.isNoEmpty(longDraftLogInfoMap)) {
                        draftLogInfo = longDraftLogInfoMap.get(sourceBillId);
                        if (!EmptyUtil.isEmpty((Object)draftLogInfo)) continue;
                        noLogDraftIdSet.add(billId);
                        continue;
                    }
                    noLogDraftIdSet.add(billId);
                }
                continue;
            }
            List<Long> lockBillIdList = transfer.getLockBillIdList();
            for (Long lockBillId : lockBillIdList) {
                longDraftLogInfoMap = billAndSourceAndDyMap.get(lockBillId);
                if (EmptyUtil.isNoEmpty(longDraftLogInfoMap)) {
                    draftLogInfo = longDraftLogInfoMap.get(sourceBillId);
                    if (!EmptyUtil.isEmpty((Object)draftLogInfo)) continue;
                    noLogDraftIdSet.add(lockBillId);
                    continue;
                }
                noLogDraftIdSet.add(lockBillId);
            }
        }
        return noLogDraftIdSet;
    }

    private Map<Long, BigDecimal> updateAmountAndOldLock(Set<Long> draftBillIdSet, boolean isLock) {
        logger.info("updateAmountAndOldLock isLock:" + isLock);
        Map<Long, BigDecimal> draftIdAndAmountMap = new HashMap<Long, BigDecimal>(8);
        if (EmptyUtil.isEmpty(draftBillIdSet)) {
            return draftIdAndAmountMap;
        }
        DynamicObject[] draftArr = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,amount,isendorsepay,locksourcebillid,locksourcebilltype,availableamount,lockedamount,usedamount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillIdSet)});
        draftIdAndAmountMap = Arrays.stream(draftArr).collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getBigDecimal("amount")));
        for (DynamicObject draft : draftArr) {
            BigDecimal amount = draft.getBigDecimal("amount");
            if (!isLock) {
                draft.set("isendorsepay", (Object)0);
                draft.set("locksourcebillid", (Object)0);
                draft.set("locksourcebilltype", null);
            }
            draft.set("availableamount", (Object)amount);
            draft.set("lockedamount", (Object)BigDecimal.ZERO);
            draft.set("usedamount", (Object)BigDecimal.ZERO);
        }
        SaveServiceHelper.update((DynamicObject[])draftArr);
        return draftIdAndAmountMap;
    }

    @Override
    public List<LockResult> transfer(List<DraftLockInfo> transferList, boolean strickMode) {
        ArrayList<LockResult> lockResults = new ArrayList<LockResult>(8);
        Map<Long, Map<Long, DraftLogInfo>> billAndSourceAndDyMap = this.getNoBillLogDraftData(transferList);
        HashMap<Long, BigDecimal> draftIdAndAmountMap = new HashMap(8);
        HashSet<Long> noLogDraftIdSet = new HashSet<Long>(8);
        ArrayList<DynamicObject> needUpdateBillLogDyList = new ArrayList<DynamicObject>(8);
        for (DraftLockInfo transfer : transferList) {
            DynamicObject billLogDy;
            DraftLogInfo draftLogInfo;
            Map<Long, DraftLogInfo> longDraftLogInfoMap;
            Long sourceBillId = transfer.getSourceBillId();
            String targetBillType = transfer.getTargetBillType();
            Long targetBillId = transfer.getTargetBillId();
            List<DraftAmountLockSubInfo> lockSubInfoList = transfer.getLockSubInfoList();
            if (EmptyUtil.isNoEmpty(lockSubInfoList)) {
                for (DraftAmountLockSubInfo lockSubInfo : lockSubInfoList) {
                    Long billId = lockSubInfo.getBillId();
                    longDraftLogInfoMap = billAndSourceAndDyMap.get(billId);
                    if (EmptyUtil.isNoEmpty(longDraftLogInfoMap)) {
                        draftLogInfo = longDraftLogInfoMap.get(sourceBillId);
                        if (EmptyUtil.isEmpty((Object)draftLogInfo)) {
                            draftLogInfo = longDraftLogInfoMap.get(targetBillId);
                        }
                        if (EmptyUtil.isNoEmpty((Object)draftLogInfo)) {
                            billLogDy = draftLogInfo.getBillLogDy();
                            if (EmptyUtil.isNoEmpty((DynamicObject)billLogDy)) {
                                billLogDy.set("sourcebilltype", (Object)targetBillType);
                                billLogDy.set("sourcebillid", (Object)targetBillId);
                                Long billLogId = lockSubInfo.getBillLogId();
                                if (EmptyUtil.isEmpty((Long)billLogId)) {
                                    long logIdDb = billLogDy.getLong("id");
                                    lockSubInfo.setBillLogId(logIdDb);
                                }
                                needUpdateBillLogDyList.add(billLogDy);
                                continue;
                            }
                            noLogDraftIdSet.add(billId);
                            continue;
                        }
                        noLogDraftIdSet.add(billId);
                        continue;
                    }
                    noLogDraftIdSet.add(billId);
                }
                continue;
            }
            List<Long> lockBillIdList = transfer.getLockBillIdList();
            for (Long lockBillId : lockBillIdList) {
                longDraftLogInfoMap = billAndSourceAndDyMap.get(lockBillId);
                if (EmptyUtil.isNoEmpty(longDraftLogInfoMap)) {
                    draftLogInfo = longDraftLogInfoMap.get(sourceBillId);
                    if (EmptyUtil.isEmpty((Object)draftLogInfo)) {
                        draftLogInfo = longDraftLogInfoMap.get(targetBillId);
                    }
                    if (EmptyUtil.isNoEmpty((Object)draftLogInfo)) {
                        billLogDy = draftLogInfo.getBillLogDy();
                        if (EmptyUtil.isNoEmpty((DynamicObject)billLogDy)) {
                            billLogDy.set("sourcebilltype", (Object)targetBillType);
                            billLogDy.set("sourcebillid", (Object)targetBillId);
                            needUpdateBillLogDyList.add(billLogDy);
                            continue;
                        }
                        noLogDraftIdSet.add(lockBillId);
                        continue;
                    }
                    noLogDraftIdSet.add(lockBillId);
                    continue;
                }
                noLogDraftIdSet.add(lockBillId);
            }
        }
        if (EmptyUtil.isNoEmpty(needUpdateBillLogDyList)) {
            SaveServiceHelper.update((DynamicObject[])needUpdateBillLogDyList.toArray(new DynamicObject[0]));
        }
        if (EmptyUtil.isNoEmpty(noLogDraftIdSet)) {
            draftIdAndAmountMap = this.updateAmountAndOldLock(noLogDraftIdSet, true);
            for (DraftLockInfo transferInfo : transferList) {
                this.fillLockInfo(transferInfo, draftIdAndAmountMap, LogBizStatusEnum.PROCESS.getValue(), new HashMap<Long, Map<Long, DraftLogInfo>>());
                transferInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
            }
            if (EmptyUtil.isNoEmpty(transferList)) {
                List<LockResult> resultList = LockDraftHelper.lockBills(transferList, strickMode);
                lockResults.addAll(resultList);
            }
        }
        return lockResults;
    }

    private void fillLockInfo(DraftLockInfo draftAmountLockNewInfo, Map<Long, BigDecimal> draftIdAndAmountMap, String opStr, Map<Long, Map<Long, DraftLogInfo>> billAndSourceAndDyMap) {
        Long sourceBillId = draftAmountLockNewInfo.getSourceBillId();
        List<DraftAmountLockSubInfo> lockSubInfos = draftAmountLockNewInfo.getLockSubInfoList();
        if (EmptyUtil.isEmpty(lockSubInfos)) {
            List<Object> lockBillIdList = new ArrayList(8);
            lockBillIdList = opStr.equals(LogBizStatusEnum.PROCESS.getValue()) ? draftAmountLockNewInfo.getLockBillIdList() : draftAmountLockNewInfo.getReleaseBillIdList();
            if (EmptyUtil.isNoEmpty(lockBillIdList)) {
                ArrayList<DraftAmountLockSubInfo> draftAmountLockSubList = new ArrayList<DraftAmountLockSubInfo>(8);
                for (Long l : lockBillIdList) {
                    DraftAmountLockSubInfo draftAmountLockSubInfo = new DraftAmountLockSubInfo();
                    draftAmountLockSubInfo.setBillId(l);
                    if (opStr.equals(LogBizStatusEnum.PROCESS.getValue())) {
                        draftAmountLockSubInfo.setBillTradeStatus(opStr);
                        BigDecimal amount = draftIdAndAmountMap.get(l);
                        if (null == amount) {
                            draftAmountLockSubInfo.setDealAmount(BigDecimal.ZERO);
                        } else {
                            draftAmountLockSubInfo.setDealAmount(amount);
                        }
                    } else {
                        draftAmountLockSubInfo.setOperateType(opStr);
                        Map<Long, DraftLogInfo> longDraftLogInfoMap = billAndSourceAndDyMap.get(l);
                        if (EmptyUtil.isNoEmpty(longDraftLogInfoMap)) {
                            DraftLogInfo draftLogInfo = longDraftLogInfoMap.get(sourceBillId);
                            BigDecimal dealAmount = draftLogInfo.getDealAmount();
                            Long billLog = draftLogInfo.getBillLog();
                            draftAmountLockSubInfo.setDealAmount(dealAmount);
                            draftAmountLockSubInfo.setBillLogId(billLog);
                        }
                    }
                    draftAmountLockSubList.add(draftAmountLockSubInfo);
                }
                draftAmountLockNewInfo.setLockSubInfoList(draftAmountLockSubList);
            }
        }
    }

    private Map<Long, Map<Long, DraftLogInfo>> getNoBillLogDraftData(List<DraftLockInfo> lockInfoList) {
        HashSet<DraftLogInfo> draftLogInfoSet = new HashSet<DraftLogInfo>(8);
        HashSet<String> sourceTypeSet = new HashSet<String>(8);
        HashSet<Long> sourceIdSet = new HashSet<Long>(8);
        HashSet<Long> billLogSet = new HashSet<Long>(8);
        HashSet<Long> noLogBillId = new HashSet<Long>(8);
        for (DraftLockInfo lockInfo : lockInfoList) {
            Long sourceBillId = lockInfo.getSourceBillId();
            String sourceBillType = lockInfo.getSourceBillType();
            String targetBillType = lockInfo.getTargetBillType();
            Long targetBillId = lockInfo.getTargetBillId();
            List<DraftAmountLockSubInfo> lockSubInfoDataList = lockInfo.getLockSubInfoList();
            if (EmptyUtil.isEmpty(lockSubInfoDataList)) {
                List<Long> lockBillIdList = lockInfo.getLockBillIdList();
                List<Long> releaseBillIdList = lockInfo.getReleaseBillIdList();
                if (EmptyUtil.isNoEmpty(lockBillIdList)) {
                    sourceTypeSet.add(sourceBillType);
                    sourceIdSet.add(sourceBillId);
                    sourceTypeSet.add(targetBillType);
                    sourceIdSet.add(targetBillId);
                    noLogBillId.addAll(lockBillIdList);
                }
                if (!EmptyUtil.isNoEmpty(releaseBillIdList)) continue;
                sourceTypeSet.add(sourceBillType);
                sourceIdSet.add(sourceBillId);
                sourceTypeSet.add(targetBillType);
                sourceIdSet.add(targetBillId);
                noLogBillId.addAll(releaseBillIdList);
                continue;
            }
            for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoDataList) {
                Long billLogId = draftAmountLockSubInfo.getBillLogId();
                Long billId = draftAmountLockSubInfo.getBillId();
                boolean emptyBillLog = EmptyUtil.isEmpty((Long)billLogId);
                if (emptyBillLog) {
                    sourceTypeSet.add(sourceBillType);
                    sourceTypeSet.add(targetBillType);
                    sourceIdSet.add(targetBillId);
                    sourceIdSet.add(sourceBillId);
                    noLogBillId.add(billId);
                    continue;
                }
                billLogSet.add(billLogId);
            }
        }
        if (EmptyUtil.isNoEmpty(noLogBillId)) {
            QFilter draftidQf = new QFilter("draftid", "in", noLogBillId);
            QFilter typeQf = new QFilter("sourcebilltype", "in", sourceTypeSet);
            QFilter sourceIdQf = new QFilter("sourcebillid", "in", sourceIdSet);
            QFilter deleteflagQf = new QFilter("deleteflag", "=", (Object)"0");
            DynamicObject[] draftLogArr = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,sourcebillid,sourcebilltype,draftid,dealamount", (QFilter[])new QFilter[]{typeQf, draftidQf, sourceIdQf, deleteflagQf});
            this.addLogInfo(draftLogInfoSet, draftLogArr);
        }
        if (EmptyUtil.isNoEmpty(billLogSet)) {
            QFilter idQf = new QFilter("id", "in", billLogSet);
            DynamicObject[] paramHasDraftLogArr = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,sourcebillid,sourcebilltype,draftid,dealamount", (QFilter[])new QFilter[]{idQf});
            this.addLogInfo(draftLogInfoSet, paramHasDraftLogArr);
        }
        HashMap<Long, Map<Long, DraftLogInfo>> billAndSourceAndDyMap = new HashMap<Long, Map<Long, DraftLogInfo>>(8);
        for (DraftLogInfo draftLogInfo : draftLogInfoSet) {
            Long draftId = draftLogInfo.getDraftId();
            Long sourceId = draftLogInfo.getSourceId();
            Map longDraftLogInfoMap = (Map)billAndSourceAndDyMap.get(draftId);
            if (EmptyUtil.isEmpty((Object)longDraftLogInfoMap)) {
                HashMap<Long, DraftLogInfo> map = new HashMap<Long, DraftLogInfo>();
                map.put(sourceId, draftLogInfo);
                billAndSourceAndDyMap.put(draftId, map);
                continue;
            }
            DraftLogInfo logInfoDy = (DraftLogInfo)longDraftLogInfoMap.get(sourceId);
            if (!EmptyUtil.isEmpty((Object)logInfoDy)) continue;
            longDraftLogInfoMap.put(sourceId, draftLogInfo);
        }
        return billAndSourceAndDyMap;
    }

    private void addLogInfo(Set<DraftLogInfo> draftLogInfoSet, DynamicObject[] draftLogArr) {
        for (DynamicObject draftLog : draftLogArr) {
            long id = draftLog.getLong("id");
            String sourcebilltype = draftLog.getString("sourcebilltype");
            long sourcebillid = draftLog.getLong("sourcebillid");
            long draftid = draftLog.getLong("draftid");
            BigDecimal dealamount = draftLog.getBigDecimal("dealamount");
            DraftLogInfo draftBillLogProp = new DraftLogInfo();
            draftBillLogProp.setBillLog(id);
            draftBillLogProp.setBillLogDy(draftLog);
            draftBillLogProp.setDraftId(draftid);
            draftBillLogProp.setSourceId(sourcebillid);
            draftBillLogProp.setSourceType(sourcebilltype);
            draftBillLogProp.setDealAmount(dealamount);
            draftLogInfoSet.add(draftBillLogProp);
        }
    }

    private Set<Long> getHasLogAndNoLogDraftIdSet(List<DraftLockInfo> lockInfoList, List<DraftLockInfo> hasLogIdDraftLockList, Map<Long, Map<Long, DraftLogInfo>> billAndSourceAndDyMap) {
        HashSet<Long> noLogIdBillIdSet = new HashSet<Long>(8);
        for (DraftLockInfo lockInfo : lockInfoList) {
            DraftLogInfo draftLogInfo;
            Map<Long, DraftLogInfo> longDraftLogInfoMap;
            DraftLockInfo hasBillLogDraftLockInfo = new DraftLockInfo();
            Long sourceBillId = lockInfo.getSourceBillId();
            this.setLockInfo(hasBillLogDraftLockInfo, lockInfo);
            List<DraftAmountLockSubInfo> lockSubInfoDataList = lockInfo.getLockSubInfoList();
            if (EmptyUtil.isEmpty(lockSubInfoDataList)) {
                List<Long> releaseBillIdList = lockInfo.getReleaseBillIdList();
                ArrayList<Long> newHasLogLockBillIdSet = new ArrayList<Long>(8);
                for (Long lockBillId : releaseBillIdList) {
                    longDraftLogInfoMap = billAndSourceAndDyMap.get(lockBillId);
                    if (EmptyUtil.isNoEmpty(longDraftLogInfoMap)) {
                        draftLogInfo = longDraftLogInfoMap.get(sourceBillId);
                        if (EmptyUtil.isNoEmpty((Object)draftLogInfo)) {
                            newHasLogLockBillIdSet.add(lockBillId);
                            continue;
                        }
                        noLogIdBillIdSet.add(lockBillId);
                        continue;
                    }
                    noLogIdBillIdSet.add(lockBillId);
                }
                hasBillLogDraftLockInfo.setReleaseBillIdList(newHasLogLockBillIdSet);
            } else {
                ArrayList<DraftAmountLockSubInfo> hasLogSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
                for (DraftAmountLockSubInfo draftAmountLockSubInfo : lockSubInfoDataList) {
                    Long billId = draftAmountLockSubInfo.getBillId();
                    longDraftLogInfoMap = billAndSourceAndDyMap.get(billId);
                    if (EmptyUtil.isNoEmpty(longDraftLogInfoMap)) {
                        draftLogInfo = longDraftLogInfoMap.get(sourceBillId);
                        if (EmptyUtil.isNoEmpty((Object)draftLogInfo)) {
                            hasLogSubInfoList.add(draftAmountLockSubInfo);
                            continue;
                        }
                        noLogIdBillIdSet.add(billId);
                        continue;
                    }
                    noLogIdBillIdSet.add(billId);
                }
                hasBillLogDraftLockInfo.setLockSubInfoList(hasLogSubInfoList);
            }
            hasLogIdDraftLockList.add(hasBillLogDraftLockInfo);
        }
        return noLogIdBillIdSet;
    }

    private void setLockInfo(DraftLockInfo billLogDraftLockInfo, DraftLockInfo lockInfo) {
        Long sourceBillId = lockInfo.getSourceBillId();
        String sourceBillType = lockInfo.getSourceBillType();
        Long targetBillId = lockInfo.getTargetBillId();
        String targetBillType = lockInfo.getTargetBillType();
        billLogDraftLockInfo.setSourceBillId(sourceBillId);
        billLogDraftLockInfo.setSourceBillType(sourceBillType);
        billLogDraftLockInfo.setTargetBillId(targetBillId);
        billLogDraftLockInfo.setTargetBillType(targetBillType);
    }
}

