/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.lock;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.lock.DraftLockCompatQuery;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.lock.DraftOperateInfo;
import kd.tmc.cdm.business.lock.DraftOperateResultInfo;
import kd.tmc.cdm.business.lock.DraftOperateService;
import kd.tmc.cdm.business.lock.DraftOperateSubInfo;
import kd.tmc.cdm.business.lock.IDraftLockService;
import kd.tmc.cdm.business.lock.IDraftOperateService;
import kd.tmc.cdm.business.service.DraftAmountLockSubInfo;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.cdm.common.enums.LogBizStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DraftOperateServiceProxy
implements IDraftOperateService {
    private IDraftOperateService service = new DraftOperateService();
    private IDraftLockService oldLockService = DraftLockServiceFactory.getCompatService();
    private static Log LOGGER = LogFactory.getLog(DraftOperateServiceProxy.class);

    @Override
    public List<DraftOperateResultInfo> confirm(DraftOperateInfo info) {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            List<DraftOperateSubInfo> draftOperateSubInfoList;
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            boolean isOnway = this.getNoBillLogDraftData(info, false);
            LOGGER.info("confirm isOnway is:" + isOnway);
            if (isOnway) {
                List<DraftLockInfo> draftLockInfosList = this.getLockInfos(info, draftLockInfo);
                List<LockResult> resultList = this.oldLockService.lock(draftLockInfosList, false);
                LockResult lockResult = resultList.get(0);
                boolean success = lockResult.isSuccess();
                if (success) {
                    this.fillTradeBillBillLog(info, lockResult);
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7968\u636e\u5360\u7528\u65e5\u5fd7\u64cd\u4f5c\u5931\u8d25\u3002", (String)"DraftOperateServiceProxy_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
            }
            if (EmptyUtil.isNoEmpty(draftOperateSubInfoList = info.getDraftOperateSubInfoList())) {
                Set<Long> longSet = draftOperateSubInfoList.stream().map(e -> e.getDraftbillId()).collect(Collectors.toSet());
                this.updateAmountAndOldLock(longSet);
            }
            List<DraftOperateResultInfo> list = this.service.confirm(info);
            return list;
        }
        catch (Exception e2) {
            try {
                tx.markRollback();
                throw e2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private void fillTradeBillBillLog(DraftOperateInfo info, LockResult lockResult) {
        List<DraftOperateSubInfo> entrys = info.getDraftOperateSubInfoList();
        Map<Long, Long> billIdLogIdMap = lockResult.getBillIdLogIdMap();
        HashSet<Long> billlogIdSet = new HashSet<Long>(billIdLogIdMap.values());
        DynamicObject[] draftLogIdArr = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,dealamount,draftid", (QFilter[])new QFilter[]{new QFilter("id", "in", billlogIdSet)});
        Map<Long, BigDecimal> draftLogIdAndDyMap = Arrays.stream(draftLogIdArr).collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getBigDecimal("dealamount")));
        for (DraftOperateSubInfo entry : entrys) {
            BigDecimal billAmount;
            Long draftId = entry.getDraftbillId();
            Long billLogId = billIdLogIdMap.get(draftId);
            if (!EmptyUtil.isNoEmpty((Long)billLogId)) continue;
            long billlog = entry.getBilllog();
            if (EmptyUtil.isEmpty((Long)billlog)) {
                entry.setBilllog(billLogId);
            }
            if (!EmptyUtil.isEmpty((BigDecimal)(billAmount = entry.getBillamt())) && BigDecimal.ZERO.compareTo(billAmount) != 0) continue;
            BigDecimal transAmount = draftLogIdAndDyMap.get(billLogId);
            entry.setBillamt(transAmount);
        }
    }

    private void updateAmountAndOldLock(Set<Long> draftBillIdSet) {
        LOGGER.info("updateAmountAndOldLock when confrm");
        Object[] draftArr = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,amount,isendorsepay,locksourcebillid,locksourcebilltype,availableamount,lockedamount,usedamount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillIdSet)});
        if (EmptyUtil.isNoEmpty((Object[])draftArr)) {
            for (Object draft : draftArr) {
                draft.set("isendorsepay", (Object)0);
                draft.set("locksourcebillid", (Object)0);
                draft.set("locksourcebilltype", null);
            }
            SaveServiceHelper.update((DynamicObject[])draftArr);
        }
    }

    private List<DraftLockInfo> getLockInfos(DraftOperateInfo info, DraftLockInfo draftLockInfo) {
        String sourceName = info.getDyTypename();
        long sourceId = info.getTradeBillId();
        List<DraftOperateSubInfo> entrys = info.getDraftOperateSubInfoList();
        draftLockInfo.setSourceBillId(sourceId);
        draftLockInfo.setSourceBillType(sourceName);
        draftLockInfo.setBizBillNo(info.getNumber());
        draftLockInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
        draftLockInfo.setBillTrade(info.getTradetype());
        ArrayList<DraftAmountLockSubInfo> draftAmountLockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
        for (DraftOperateSubInfo entry : entrys) {
            DraftAmountLockSubInfo draftAmountLockSubInfo = new DraftAmountLockSubInfo();
            BigDecimal bigDecimal = entry.getBillamt();
            long entryDraftBillId = entry.getDraftbillId();
            draftAmountLockSubInfo.setBillId(entryDraftBillId);
            draftAmountLockSubInfo.setDealAmount(bigDecimal);
            draftAmountLockSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
            draftAmountLockSubInfoList.add(draftAmountLockSubInfo);
        }
        draftLockInfo.getLockSubInfoList().addAll(draftAmountLockSubInfoList);
        ArrayList<DraftLockInfo> draftLockInfosList = new ArrayList<DraftLockInfo>();
        draftLockInfosList.add(draftLockInfo);
        return draftLockInfosList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<DraftOperateResultInfo> cancel(DraftOperateInfo info) {
        ArrayList<DraftOperateResultInfo> cancelResultMap = new ArrayList(8);
        try (TXHandle tx = TX.required();){
            try {
                DraftLockInfo draftLockInfo = new DraftLockInfo();
                boolean isOnway = this.getNoBillLogDraftData(info, true);
                LOGGER.info("cancel isOnway:" + isOnway);
                if (isOnway) {
                    List<DraftLockInfo> draftLockInfosList = this.getLockInfos(info, draftLockInfo);
                    List<LockResult> resultList = LockDraftHelper.lockBills(draftLockInfosList, false);
                    if (!EmptyUtil.isNoEmpty(resultList)) throw new KDBizException(ResManager.loadKDString((String)"\u7968\u636e\u5360\u7528\u65e5\u5fd7\u64cd\u4f5c\u5931\u8d25\u3002", (String)"DraftOperateServiceProxy_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    LockResult lockResult = resultList.get(0);
                    boolean success = lockResult.isSuccess();
                    if (!success) throw new KDBizException(ResManager.loadKDString((String)"\u7968\u636e\u5360\u7528\u65e5\u5fd7\u64cd\u4f5c\u5931\u8d25\u3002", (String)"DraftOperateServiceProxy_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    this.fillTradeBillBillLog(info, lockResult);
                    this.service.confirm(info);
                }
                cancelResultMap = this.service.cancel(info);
                return cancelResultMap;
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    @Override
    public List<DraftOperateResultInfo> split(DraftOperateInfo infoList) {
        return null;
    }

    private boolean getNoBillLogDraftData(DraftOperateInfo info, boolean isCancel) {
        HashSet<Long> noBillLogDraftIdSet = new HashSet<Long>(8);
        Set<Object> lockAndHasLogIdDraftSet = new HashSet(8);
        List<DraftOperateSubInfo> entrys = info.getDraftOperateSubInfoList();
        for (DraftOperateSubInfo entry : entrys) {
            long billLog = entry.getBilllog();
            if (!EmptyUtil.isEmpty((Long)billLog)) continue;
            long draftbillId = entry.getDraftbillId();
            noBillLogDraftIdSet.add(draftbillId);
        }
        if (EmptyUtil.isNoEmpty(noBillLogDraftIdSet)) {
            QFilter deleteflagQf;
            QFilter sourceIdQf;
            QFilter typeQf;
            QFilter draftidQf;
            if (!isCancel) {
                lockAndHasLogIdDraftSet = DraftLockCompatQuery.queryOnWayDraftIdSet(noBillLogDraftIdSet);
                if (EmptyUtil.isNoEmpty(lockAndHasLogIdDraftSet)) {
                    QFilter deleteflagQf2;
                    QFilter sourceIdQf2;
                    draftidQf = new QFilter("draftid", "in", noBillLogDraftIdSet);
                    typeQf = new QFilter("sourcebilltype", "=", (Object)info.getDyTypename());
                    Object[] draftLogArr = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,sourcebillid,sourcebilltype,draftid,dealamount", (QFilter[])new QFilter[]{typeQf, draftidQf, sourceIdQf2 = new QFilter("sourcebillid", "=", (Object)info.getTradeBillId()), deleteflagQf2 = new QFilter("deleteflag", "=", (Object)"0")});
                    if (EmptyUtil.isNoEmpty((Object[])draftLogArr)) {
                        HashMap<Long, Long> dratBillIdAndLogIdMap = new HashMap<Long, Long>(8);
                        for (Object draftLog : draftLogArr) {
                            long draftid = draftLog.getLong("draftid");
                            long logId = draftLog.getLong("id");
                            dratBillIdAndLogIdMap.put(draftid, logId);
                        }
                        for (DraftOperateSubInfo entry : entrys) {
                            long draftbillId;
                            Long logId;
                            long billLog = entry.getBilllog();
                            if (!EmptyUtil.isEmpty((Long)billLog) || !EmptyUtil.isNoEmpty((Long)(logId = (Long)dratBillIdAndLogIdMap.get(draftbillId = entry.getDraftbillId())))) continue;
                            entry.setBilllog(logId);
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }
            draftidQf = new QFilter("draftid", "in", noBillLogDraftIdSet);
            typeQf = new QFilter("sourcebilltype", "=", (Object)info.getDyTypename());
            Object[] draftLogArr = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,sourcebillid,sourcebilltype,draftid,dealamount", (QFilter[])new QFilter[]{typeQf, draftidQf, sourceIdQf = new QFilter("sourcebillid", "=", (Object)info.getTradeBillId()), deleteflagQf = new QFilter("deleteflag", "=", (Object)"0")});
            if (EmptyUtil.isNoEmpty((Object[])draftLogArr)) {
                HashMap<Long, Long> dratBillIdAndLogIdMap = new HashMap<Long, Long>(8);
                for (Object draftLog : draftLogArr) {
                    long draftid = draftLog.getLong("draftid");
                    long logId = draftLog.getLong("id");
                    dratBillIdAndLogIdMap.put(draftid, logId);
                }
                for (DraftOperateSubInfo entry : entrys) {
                    long draftbillId;
                    Long logId;
                    long billLog = entry.getBilllog();
                    if (!EmptyUtil.isEmpty((Long)billLog) || !EmptyUtil.isNoEmpty((Long)(logId = (Long)dratBillIdAndLogIdMap.get(draftbillId = entry.getDraftbillId())))) continue;
                    entry.setBilllog(logId);
                }
                return false;
            }
            return true;
        }
        return false;
    }
}

