/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.allocation.scheduling;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.opservice.allocation.scheduling.AbstractEndorseTask;
import kd.tmc.cdm.business.opservice.allocation.scheduling.SchedulingContext;
import kd.tmc.cdm.business.opservice.allocation.scheduling.SchedulingResult;
import kd.tmc.cdm.common.helper.BotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class Alloc2EndorseBizBillTask
extends AbstractEndorseTask {
    private static Log logger = LogFactory.getLog(Alloc2EndorseBizBillTask.class);

    public Alloc2EndorseBizBillTask(String name) {
        super(name);
    }

    @Override
    public SchedulingResult excute(SchedulingContext ctx) {
        this.context = ctx;
        this.createEndorseBill();
        return this.getResult();
    }

    protected void createEndorseBill() {
        DynamicObject allocBill = this.context.getAllocBill();
        Long entryId = this.context.getEntryId();
        DynamicObject endorseBizBill = null;
        try {
            endorseBizBill = this.createEndorseBizBillByEntry(allocBill, entryId);
        }
        catch (Exception ex) {
            this.result.setFailedOp(this.getName());
            this.result.setSuccess(false);
            this.result.setErrorMessage(ex.getMessage());
            logger.error("createEndorseBill() exception:", (Throwable)ex);
            return;
        }
        endorseBizBill.set("billstatus", (Object)"C");
        OperationResult saveEndorseBizBillResult = this.saveBill("save", endorseBizBill);
        if (saveEndorseBizBillResult.isSuccess()) {
            List ids = saveEndorseBizBillResult.getSuccessPkIds();
            this.getResult().setResultBillId((Long)ids.get(0));
            this.getResult().setSuccess(true);
        } else {
            this.result.setFailedOp(this.getName());
            this.result.setSuccess(false);
            this.result.setErrorMessage(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)saveEndorseBizBillResult));
        }
    }

    private DynamicObject createEndorseBizBillByEntry(DynamicObject allocBill, Long entryId) {
        HashSet<Long> entryIdSet = new HashSet<Long>();
        entryIdSet.add(entryId);
        DynamicObject[] endoseBizBills = BotpHelper.pushBySpecifiedEntry((DynamicObject[])new DynamicObject[]{allocBill}, (String)"entryentity", entryIdSet, (String)"cdm_drafttradebill");
        DynamicObject endoseBizBill = endoseBizBills[0];
        DynamicObject bankacct = allocBill.getDynamicObject("inaccount");
        DynamicObject beendorsor = allocBill.getDynamicObject("incompany");
        if (this.context.isIndrectTransfer()) {
            bankacct = allocBill.getDynamicObject("createpoolaccount");
            DynamicObject billPool = allocBill.getDynamicObject("billpool");
            DynamicObject billPoolOrg = billPool.getDynamicObject("company");
            beendorsor = BusinessDataServiceHelper.loadSingle((Object)billPoolOrg.getPkValue(), (String)"bos_org");
        }
        if (beendorsor == null) {
            throw new KDBizException("endorseor is empty");
        }
        endoseBizBill.set("payeetype", (Object)"bos_org");
        endoseBizBill.set("payeetypetext", (Object)"bos_org");
        endoseBizBill.set("beendorsor", (Object)beendorsor);
        endoseBizBill.set("beendorsortext", (Object)beendorsor.getString("name"));
        if (bankacct != null) {
            endoseBizBill.set("bankacct", (Object)bankacct.getString("bankaccountnumber"));
            DynamicObject bank = bankacct.getDynamicObject("bank");
            DynamicObject finorg = QueryServiceHelper.queryOne((String)"bd_finorginfo", (String)"id,bebank", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bank.getLong("id"))});
            Long bebank = finorg.getLong("bebank");
            if (EmptyUtil.isNoEmpty((Long)bebank)) {
                DynamicObject bebankObj = BusinessDataServiceHelper.loadSingle((Object)bebank, (String)"bd_bebank");
                endoseBizBill.set("bank", (Object)bebankObj);
                endoseBizBill.set("bankcode", (Object)bebankObj.getString("union_number"));
            }
        }
        return endoseBizBill;
    }
}

