/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.bankdrafts;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.helper.CodeRuleHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AddChequeInventoryService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(AddChequeInventoryService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("inventorydate");
        selector.add("org");
        selector.add("bankaccount");
        selector.add("currency");
        selector.add("isinventoryfilled");
        selector.add("datdate");
        selector.add("inventorydate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashSet<DynamicObject> saveCheuqeInventorySet = new HashSet<DynamicObject>(16);
        for (DynamicObject data : dataEntities) {
            DynamicObject orgDy = data.getDynamicObject("org");
            DynamicObject bankaccountDy = data.getDynamicObject("bankaccount");
            Date dataDate = data.getDate("datdate");
            Date inventoryDate = data.getDate("inventorydate");
            DynamicObject currenDy = data.getDynamicObject("currency");
            boolean isByBankAccount = data.getBoolean("isbybankaccount");
            boolean isByFilled = data.getBoolean("isinventoryfilled");
            logger.info("dataDate is:" + dataDate);
            long orgId = orgDy.getLong("id");
            long curreyId = currenDy.getLong("id");
            QFilter orgIdQFilterF7 = new QFilter("org", "=", (Object)orgId);
            QFilter currIdQFilterF7 = new QFilter("currency", "=", (Object)curreyId);
            QFilter dateIdQFilterF7 = new QFilter("purchdate", "<=", (Object)dataDate);
            QFilter paramQFliterF7 = orgIdQFilterF7.and(dateIdQFilterF7).and(currIdQFilterF7);
            HashSet<String> chequeStatusSet = new HashSet<String>(4);
            chequeStatusSet.add("0");
            if (isByBankAccount) {
                long bankAccountid = bankaccountDy.getLong("id");
                QFilter accountIdQFilterF7 = new QFilter("accountbank", "=", (Object)bankAccountid);
                paramQFliterF7.and(accountIdQFilterF7);
            }
            if (isByFilled) {
                chequeStatusSet.add("2");
                chequeStatusSet.add("3");
                QFilter statusQFilter = new QFilter("chequestatus", "in", chequeStatusSet);
                paramQFliterF7.and(statusQFilter);
            }
            DynamicObjectCollection chequeDraftIdArr = QueryServiceHelper.query((String)"cdm_cheque_f7data", (String)"id", (QFilter[])new QFilter[]{paramQFliterF7});
            long pkId = DB.genGlobalLongId();
            DynamicObject chequeInventoryDy = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_chequeinventory"));
            chequeInventoryDy.set("id", (Object)pkId);
            String generateNumber = CodeRuleHelper.generateNumber((String)"cdm_chequeinventory", (DynamicObject)chequeInventoryDy, (String)null, (String)null);
            chequeInventoryDy.set("billno", (Object)generateNumber);
            chequeInventoryDy.set("creator", (Object)RequestContext.get().getCurrUserId());
            chequeInventoryDy.set("company", (Object)orgDy);
            chequeInventoryDy.set("bankaccount", (Object)bankaccountDy);
            chequeInventoryDy.set("currency", (Object)currenDy);
            chequeInventoryDy.set("inventorydate", (Object)inventoryDate);
            chequeInventoryDy.set("bizdate", (Object)dataDate);
            chequeInventoryDy.set("isbybankaccount", (Object)isByBankAccount);
            chequeInventoryDy.set("isinventoryfilled", (Object)isByFilled);
            chequeInventoryDy.set("billstatus", (Object)"A");
            saveCheuqeInventorySet.add(chequeInventoryDy);
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)chequeDraftIdArr)) continue;
            Set<Object> chequeDraftIdSet = chequeDraftIdArr.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            Object[] chequeDraftArr = BusinessDataServiceHelper.load((Object[])chequeDraftIdSet.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_cheque_f7data"));
            if (EmptyUtil.isEmpty((Object[])chequeDraftArr) || chequeDraftArr.length == 0) {
                logger.info("has no cheque data");
                return;
            }
            DynamicObjectCollection blankcheque_ncd_entrys = chequeInventoryDy.getDynamicObjectCollection("blankcheque_ncd_entry");
            DynamicObjectCollection filled_ncd_chequeentrys = chequeInventoryDy.getDynamicObjectCollection("filled_ncdcheque_entry");
            BigDecimal ncd_filledAmountTotal = BigDecimal.ZERO;
            HashSet needUpdateBankDraftSet = new HashSet(16);
            for (Object bankDraft : chequeDraftArr) {
                String chequeStatus = bankDraft.getString("chequestatus");
                if ("0".equalsIgnoreCase(chequeStatus)) {
                    DynamicObject blankcheque_ncd_entry = blankcheque_ncd_entrys.addNew();
                    blankcheque_ncd_entry.set("e_ncd_blankcheque", bankDraft);
                    blankcheque_ncd_entry.set("e_ncd_blankcheckstatus", (Object)"A");
                    continue;
                }
                DynamicObject filled_ncd_chequeentry = filled_ncd_chequeentrys.addNew();
                filled_ncd_chequeentry.set("e_ncd_fillcheque", bankDraft);
                filled_ncd_chequeentry.set("e_ncd_fillcheckstatus", (Object)"A");
                BigDecimal amount = bankDraft.getBigDecimal("relateamount");
                if (!EmptyUtil.isNoEmpty((BigDecimal)amount)) continue;
                ncd_filledAmountTotal = ncd_filledAmountTotal.add(amount);
            }
            int blankDraftCount = blankcheque_ncd_entrys.size();
            int filledDraftCount = filled_ncd_chequeentrys.size();
            chequeInventoryDy.set("blankchequecount", (Object)blankDraftCount);
            chequeInventoryDy.set("blankdifferecount", (Object)(-blankDraftCount));
            chequeInventoryDy.set("filledchequecount", (Object)filledDraftCount);
            chequeInventoryDy.set("filledchequeamount", (Object)ncd_filledAmountTotal);
            chequeInventoryDy.set("filleddiffamount", (Object)BigDecimal.ZERO.subtract(ncd_filledAmountTotal));
            if (!EmptyUtil.isNoEmpty(needUpdateBankDraftSet)) continue;
            SaveServiceHelper.save((DynamicObject[])needUpdateBankDraftSet.toArray(new DynamicObject[0]));
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"cdm_chequeinventory", (DynamicObject[])saveCheuqeInventorySet.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        this.operationResult.setSuccess(true);
        List idList = saveCheuqeInventorySet.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        this.operationResult.getBillNos().put("inventoryBillId", String.valueOf(idList.get(0)));
    }
}

