/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.bankdrafts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AutoInventoryChequeService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(AutoInventoryChequeService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("inventorydate");
        selector.add("company");
        selector.add("bankaccount");
        selector.add("currency");
        selector.add("isbybankaccount");
        selector.add("isinventoryfilled");
        selector.add("bizdate");
        selector.add("inventorydate");
        selector.add("filledacutaiamount");
        selector.add("filledchequeamount");
        selector.add("blankactualcount");
        selector.add("blankchequecount");
        selector.add("filledactualcount");
        selector.add("filledchequecount");
        selector.add("blankactual_ncd_entry");
        selector.add("blankactual_ncd_entry.e_ncd_blankactual");
        selector.add("blankcheque_ncd_entry");
        selector.add("blankcheque_ncd_entry.e_ncd_blankcheque");
        selector.add("blankcheque_ncd_entry.e_ncd_blankcheckstatus");
        selector.add("blankactual_cd_entry");
        selector.add("blankactual_cd_entry.e_cd_blankactualdraft");
        selector.add("blankcheque_cd_entry");
        selector.add("blankcheque_cd_entry.e_cd_blankcheque");
        selector.add("blankcheque_cd_entry.e_cd_blankcheckstatus");
        selector.add("filledactual_ncd_entry");
        selector.add("filledactual_ncd_entry.e_ncd_fiillactual");
        selector.add("filled_ncdcheque_entry");
        selector.add("filled_ncdcheque_entry.e_ncd_fillcheque");
        selector.add("filled_ncdcheque_entry.e_ncd_fillcheckstatus");
        selector.add("filledactual_cd_entry");
        selector.add("filledactual_cd_entry.e_cd_filledactual");
        selector.add("filled_cd_chequeentry");
        selector.add("filled_cd_chequeentry.e_cd_fillcheque");
        selector.add("filled_cd_chequeentry.e_cd_fillcheckstatus");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        MainEntityType typeActualDataF7 = EntityMetadataCache.getDataEntityType((String)"cdm_actualchequef7");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cdm_cheque_f7data");
        HashSet<DynamicObject> needUpdateInventoryDataSet = new HashSet<DynamicObject>(16);
        HashSet needUpdateAcutalDraftsSet = new HashSet(16);
        for (DynamicObject data : dataEntities) {
            DynamicObject[] fillChequeArr;
            DynamicObject[] fillActualDataArr;
            boolean isInventoryFilled = data.getBoolean("isinventoryfilled");
            DynamicObjectCollection actual_ncd_entryentity = data.getDynamicObjectCollection("blankactual_ncd_entry");
            DynamicObjectCollection cheque_ncd_entryentity = data.getDynamicObjectCollection("blankcheque_ncd_entry");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)actual_ncd_entryentity) && actual_ncd_entryentity.size() > 0 && EmptyUtil.isNoEmpty((DynamicObjectCollection)cheque_ncd_entryentity) && cheque_ncd_entryentity.size() > 0) {
                HashMap draftnoSubRangeAndIdMap = new HashMap(16);
                HashSet draftnoSet = new HashSet(16);
                for (DynamicObject actual_ncd_entry : actual_ncd_entryentity) {
                    DynamicObject e_ncd_actualdraft = actual_ncd_entry.getDynamicObject("e_ncd_blankactual");
                    long draftId = e_ncd_actualdraft.getLong("id");
                    String e_draftBillno = e_ncd_actualdraft.getString("billno");
                    if (!draftnoSubRangeAndIdMap.containsKey(e_draftBillno)) {
                        HashSet<Long> entryIdSet = new HashSet<Long>(1);
                        entryIdSet.add(draftId);
                        draftnoSubRangeAndIdMap.put(e_draftBillno, entryIdSet);
                        continue;
                    }
                    ((Set)draftnoSubRangeAndIdMap.get(e_draftBillno)).add(draftId);
                }
                Set<Object> draftbillIdSet = cheque_ncd_entryentity.stream().map(e -> e.getDynamicObject("e_ncd_blankcheque").getLong("id")).collect(Collectors.toSet());
                DynamicObject[] draftBillSet = BusinessDataServiceHelper.load((Object[])draftbillIdSet.toArray(new Object[0]), (DynamicObjectType)type);
                Map<Long, DynamicObject> draftIdAndDyMap = Arrays.stream(draftBillSet).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
                HashSet inventoriedBankDraftSet = new HashSet(16);
                HashSet<Long> inventoriedDraftSet = new HashSet<Long>(16);
                for (DynamicObject cheque_ncd_entry : cheque_ncd_entryentity) {
                    DynamicObject e_ncd_blankCheuqe = cheque_ncd_entry.getDynamicObject("e_ncd_blankcheque");
                    long draftId = e_ncd_blankCheuqe.getLong("id");
                    String draftBillno = e_ncd_blankCheuqe.getString("billno");
                    Set acutalDraftIdSet = (Set)draftnoSubRangeAndIdMap.get(draftBillno);
                    if (!EmptyUtil.isNoEmpty((Object)acutalDraftIdSet)) continue;
                    inventoriedBankDraftSet.addAll(acutalDraftIdSet);
                    inventoriedDraftSet.add(draftId);
                }
                if (EmptyUtil.isNoEmpty(inventoriedBankDraftSet)) {
                    cheque_ncd_entryentity.removeIf(e -> inventoriedDraftSet.contains(e.getDynamicObject("e_ncd_blankcheque").getLong("id")));
                    actual_ncd_entryentity.removeIf(e -> inventoriedBankDraftSet.contains(e.getDynamicObject("e_ncd_blankactual").getLong("id")));
                    DynamicObjectCollection actual_cd_entryentity = data.getDynamicObjectCollection("blankactual_cd_entry");
                    DynamicObjectCollection cheque_cd_entryentity = data.getDynamicObjectCollection("blankcheque_cd_entry");
                    DynamicObject[] actualDataArr = BusinessDataServiceHelper.load((Object[])inventoriedBankDraftSet.toArray(new Object[0]), (DynamicObjectType)typeActualDataF7);
                    for (DynamicObject actualData : actualDataArr) {
                        actualData.set("checkstatus", (Object)"B");
                        DynamicObject cd_actual_entry = actual_cd_entryentity.addNew();
                        cd_actual_entry.set("e_cd_blankactualdraft", (Object)actualData);
                    }
                    needUpdateAcutalDraftsSet.addAll(Arrays.stream(actualDataArr).collect(Collectors.toSet()));
                    for (Long inventoriedDraft : inventoriedDraftSet) {
                        DynamicObject cheque_cd_entry = cheque_cd_entryentity.addNew();
                        DynamicObject draftDy = draftIdAndDyMap.get(inventoriedDraft);
                        cheque_cd_entry.set("e_cd_blankcheque", (Object)draftDy);
                        cheque_cd_entry.set("e_cd_blankcheckstatus", (Object)"B");
                    }
                    needUpdateInventoryDataSet.add(data);
                }
            }
            if (!isInventoryFilled) continue;
            DynamicObjectCollection fillAcutal_ncd_entryentity = data.getDynamicObjectCollection("filledactual_ncd_entry");
            DynamicObjectCollection fillCheque_ncd_entryentity = data.getDynamicObjectCollection("filled_ncdcheque_entry");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)fillAcutal_ncd_entryentity) || fillAcutal_ncd_entryentity.size() <= 0 || !EmptyUtil.isNoEmpty((DynamicObjectCollection)fillCheque_ncd_entryentity) || fillCheque_ncd_entryentity.size() <= 0) continue;
            HashMap draftnoSubRangeAndIdMap = new HashMap(16);
            for (DynamicObject fillacutal_ncd_entry : fillAcutal_ncd_entryentity) {
                DynamicObject e_ncd_actualdraft = fillacutal_ncd_entry.getDynamicObject("e_ncd_fiillactual");
                long actualId = e_ncd_actualdraft.getLong("id");
                String e_draftBillno = e_ncd_actualdraft.getString("billno");
                if (!draftnoSubRangeAndIdMap.containsKey(e_draftBillno)) {
                    HashSet<Long> entryIdSet = new HashSet<Long>(1);
                    entryIdSet.add(actualId);
                    draftnoSubRangeAndIdMap.put(e_draftBillno, entryIdSet);
                    continue;
                }
                ((Set)draftnoSubRangeAndIdMap.get(e_draftBillno)).add(actualId);
            }
            HashSet inventoriedBankDraftSet = new HashSet(16);
            HashSet<Long> inventoriedDraftSet = new HashSet<Long>(16);
            for (DynamicObject cheque_ncd_entry : fillCheque_ncd_entryentity) {
                DynamicObject e_ncd_filledcheque = cheque_ncd_entry.getDynamicObject("e_ncd_fillcheque");
                long chequeId = e_ncd_filledcheque.getLong("id");
                String draftBillno = e_ncd_filledcheque.getString("billno");
                Set bankDraftIdSet = (Set)draftnoSubRangeAndIdMap.get(draftBillno);
                if (!EmptyUtil.isNoEmpty((Object)bankDraftIdSet)) continue;
                inventoriedBankDraftSet.addAll(bankDraftIdSet);
                inventoriedDraftSet.add(chequeId);
            }
            if (!EmptyUtil.isNoEmpty(inventoriedBankDraftSet)) continue;
            fillCheque_ncd_entryentity.removeIf(e -> inventoriedDraftSet.contains(e.getDynamicObject("e_ncd_fillcheque").getLong("id")));
            fillAcutal_ncd_entryentity.removeIf(e -> inventoriedBankDraftSet.contains(e.getDynamicObject("e_ncd_fiillactual").getLong("id")));
            DynamicObjectCollection actual_cd_entryentity = data.getDynamicObjectCollection("filledactual_cd_entry");
            DynamicObjectCollection cheque_cd_entryentity = data.getDynamicObjectCollection("filled_cd_chequeentry");
            for (DynamicObject fillActualData : fillActualDataArr = BusinessDataServiceHelper.load((Object[])inventoriedBankDraftSet.toArray(new Object[0]), (DynamicObjectType)typeActualDataF7)) {
                fillActualData.set("checkstatus", (Object)"B");
                DynamicObject cd_actual_entry = actual_cd_entryentity.addNew();
                cd_actual_entry.set("e_cd_filledactual", (Object)fillActualData);
            }
            needUpdateAcutalDraftsSet.addAll(Arrays.stream(fillActualDataArr).collect(Collectors.toSet()));
            for (DynamicObject fillCheque : fillChequeArr = BusinessDataServiceHelper.load((Object[])inventoriedDraftSet.toArray(new Object[0]), (DynamicObjectType)type)) {
                DynamicObject cheque_cd_entry = cheque_cd_entryentity.addNew();
                cheque_cd_entry.set("e_cd_fillcheque", (Object)fillCheque);
                cheque_cd_entry.set("e_cd_fillcheckstatus", (Object)"B");
            }
            needUpdateInventoryDataSet.add(data);
        }
        if (EmptyUtil.isNoEmpty(needUpdateInventoryDataSet) && needUpdateInventoryDataSet.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])needUpdateInventoryDataSet.toArray(new DynamicObject[0]));
        }
        if (EmptyUtil.isNoEmpty(needUpdateAcutalDraftsSet) && needUpdateAcutalDraftsSet.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])needUpdateAcutalDraftsSet.toArray(new DynamicObject[0]));
        }
    }
}

