/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.bankdrafts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CancelInventoryChequeService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(CancelInventoryChequeService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("inventorydate");
        selector.add("company");
        selector.add("bankaccount");
        selector.add("currency");
        selector.add("isbybankaccount");
        selector.add("isinventoryfilled");
        selector.add("bizdate");
        selector.add("inventorydate");
        selector.add("filledacutaiamount");
        selector.add("filledchequeamount");
        selector.add("blankactualcount");
        selector.add("blankchequecount");
        selector.add("filledactualcount");
        selector.add("filledchequecount");
        selector.add("blankactual_ncd_entry");
        selector.add("blankactual_ncd_entry.e_ncd_blankactual");
        selector.add("blankcheque_ncd_entry");
        selector.add("blankcheque_ncd_entry.e_ncd_blankcheque");
        selector.add("blankcheque_ncd_entry.e_ncd_blankcheckstatus");
        selector.add("blankactual_cd_entry");
        selector.add("blankactual_cd_entry.e_cd_blankactualdraft");
        selector.add("blankcheque_cd_entry");
        selector.add("blankcheque_cd_entry.e_cd_blankcheque");
        selector.add("blankcheque_cd_entry.e_cd_blankcheckstatus");
        selector.add("filledactual_ncd_entry");
        selector.add("filledactual_ncd_entry.e_ncd_fiillactual");
        selector.add("filled_ncdcheque_entry");
        selector.add("filled_ncdcheque_entry.e_ncd_fillcheque");
        selector.add("filled_ncdcheque_entry.e_ncd_fillcheckstatus");
        selector.add("filledactual_cd_entry");
        selector.add("filledactual_cd_entry.e_cd_filledactual");
        selector.add("filled_cd_chequeentry");
        selector.add("filled_cd_chequeentry.e_cd_fillcheque");
        selector.add("filled_cd_chequeentry.e_cd_fillcheckstatus");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashSet<DynamicObject> needUpdateAcutalDraftsSet = new HashSet<DynamicObject>(16);
        for (DynamicObject data : dataEntities) {
            boolean isInventoryFilled = data.getBoolean("isinventoryfilled");
            DynamicObjectCollection actual_cd_entryentity = data.getDynamicObjectCollection("blankactual_cd_entry");
            DynamicObjectCollection actual_ncd_entryentity = data.getDynamicObjectCollection("blankactual_ncd_entry");
            Set<DynamicObject> needUpdateActualSet = this.cancelInventoryActual(actual_cd_entryentity, actual_ncd_entryentity, "e_cd_blankactualdraft", "e_ncd_blankactual");
            needUpdateAcutalDraftsSet.addAll(needUpdateActualSet);
            DynamicObjectCollection cheque_cd_entryentity = data.getDynamicObjectCollection("blankcheque_cd_entry");
            DynamicObjectCollection cheque_ncd_entryentity = data.getDynamicObjectCollection("blankcheque_ncd_entry");
            this.cancelChequeInventory(cheque_ncd_entryentity, cheque_cd_entryentity, "e_cd_blankcheque", "e_ncd_blankcheque", "e_ncd_blankcheckstatus");
            if (!isInventoryFilled) continue;
            DynamicObjectCollection fillAcutal_ncd_entryentity = data.getDynamicObjectCollection("filledactual_ncd_entry");
            DynamicObjectCollection fillAcutal_cd_entryentity = data.getDynamicObjectCollection("filledactual_cd_entry");
            Set<DynamicObject> needUpdateFillActualSet = this.cancelInventoryActual(fillAcutal_cd_entryentity, fillAcutal_ncd_entryentity, "e_cd_filledactual", "e_ncd_fiillactual");
            needUpdateAcutalDraftsSet.addAll(needUpdateFillActualSet);
            DynamicObjectCollection fillCheque_ncd_entryentity = data.getDynamicObjectCollection("filled_ncdcheque_entry");
            DynamicObjectCollection fillCheque_cd_entryentity = data.getDynamicObjectCollection("filled_cd_chequeentry");
            this.cancelChequeInventory(fillCheque_ncd_entryentity, fillCheque_cd_entryentity, "e_cd_fillcheque", "e_ncd_fillcheque", "e_ncd_fillcheckstatus");
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        if (EmptyUtil.isNoEmpty(needUpdateAcutalDraftsSet) && needUpdateAcutalDraftsSet.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])needUpdateAcutalDraftsSet.toArray(new DynamicObject[0]));
        }
    }

    private void cancelChequeInventory(DynamicObjectCollection fillCheque_ncd_entryentity, DynamicObjectCollection fillCheque_cd_entryentity, String eCdFillcheque, String eNcdFillcheque, String eNcdFillcheckstatus) {
        for (DynamicObject fillCheque_cd_entry : fillCheque_cd_entryentity) {
            DynamicObject e_cd_fillCheuqe = fillCheque_cd_entry.getDynamicObject(eCdFillcheque);
            if (!EmptyUtil.isNoEmpty((DynamicObject)e_cd_fillCheuqe)) continue;
            DynamicObject fillCheque_ncd_entry = fillCheque_ncd_entryentity.addNew();
            fillCheque_ncd_entry.set(eNcdFillcheque, (Object)e_cd_fillCheuqe);
            fillCheque_ncd_entry.set(eNcdFillcheckstatus, (Object)"A");
        }
        fillCheque_cd_entryentity.clear();
    }

    private Set<DynamicObject> cancelInventoryActual(DynamicObjectCollection actual_cd_entryentity, DynamicObjectCollection actual_ncd_entryentity, String eCdBlankactualdraft, String eNcdBlankactual) {
        HashSet<DynamicObject> needUpdateAcutalDraftsSet = new HashSet<DynamicObject>(16);
        for (DynamicObject actual_cd_entry : actual_cd_entryentity) {
            DynamicObject e_cd_blankActual = actual_cd_entry.getDynamicObject(eCdBlankactualdraft);
            if (!EmptyUtil.isNoEmpty((DynamicObject)e_cd_blankActual)) continue;
            e_cd_blankActual.set("checkstatus", (Object)"A");
            DynamicObject actual_ncd_entry = actual_ncd_entryentity.addNew();
            actual_ncd_entry.set(eNcdBlankactual, (Object)e_cd_blankActual);
            needUpdateAcutalDraftsSet.add(e_cd_blankActual);
        }
        actual_cd_entryentity.clear();
        return needUpdateAcutalDraftsSet;
    }
}

