/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.bankdrafts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CancelInventoryService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(CancelInventoryService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("inventorydate");
        selector.add("company");
        selector.add("bankaccount");
        selector.add("currency");
        selector.add("ischeckpaybill");
        selector.add("isbybankaccount");
        selector.add("bizdate");
        selector.add("inventorydate");
        selector.add("bank_ncd_entryentity");
        selector.add("bank_ncd_entryentity.e_ncd_bankdraft");
        selector.add("bank_cd_entryentity");
        selector.add("bank_cd_entryentity.e_cd_bankdraft");
        selector.add("rec_ncd_entryentity");
        selector.add("rec_ncd_entryentity.e_ncd_recdraft");
        selector.add("rec_ncd_entryentity.e_ncd_reccheckstatus");
        selector.add("rec_cd_entryentity");
        selector.add("rec_cd_entryentity.e_cd_recdraft");
        selector.add("rec_cd_entryentity.e_cd_reccheckstatus");
        selector.add("bank_ncd_payentryentity");
        selector.add("bank_ncd_payentryentity.e_ncd_paybankdraft");
        selector.add("bank_cd_payentryentity");
        selector.add("bank_cd_payentryentity.e_cd_paybankdraft");
        selector.add("pay_cd_entryentity");
        selector.add("pay_cd_entryentity.e_cd_paydraft");
        selector.add("pay_cd_entryentity.e_cd_paycheckstatus");
        selector.add("pay_ncd_entryentity");
        selector.add("pay_ncd_entryentity.e_ncd_paydraft");
        selector.add("pay_ncd_entryentity.e_ncd_paycheckstatus");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        MainEntityType typeBankDataF7 = EntityMetadataCache.getDataEntityType((String)"cdm_bankdraftdatasf7");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7");
        HashSet<DynamicObject> needUpdateBankDraftsSet = new HashSet<DynamicObject>(16);
        for (DynamicObject data : dataEntities) {
            boolean ischeckPaybill = data.getBoolean("ischeckpaybill");
            DynamicObjectCollection bank_cd_entryentity = data.getDynamicObjectCollection("bank_cd_entryentity");
            DynamicObjectCollection rec_cd_entryentity = data.getDynamicObjectCollection("rec_cd_entryentity");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bank_cd_entryentity) && bank_cd_entryentity.size() > 0) {
                Set cd_bankDraftIdSet = bank_cd_entryentity.stream().map(e -> e.getDynamicObject("e_cd_bankdraft").getLong("id")).collect(Collectors.toSet());
                DynamicObject[] cdBankDraftsArr = BusinessDataServiceHelper.load((Object[])cd_bankDraftIdSet.toArray(), (DynamicObjectType)typeBankDataF7);
                DynamicObjectCollection bank_ncd_entryentity = data.getDynamicObjectCollection("bank_ncd_entryentity");
                for (DynamicObject cdBankDraft : cdBankDraftsArr) {
                    DynamicObject bank_ncd_entry = bank_ncd_entryentity.addNew();
                    bank_ncd_entry.set("e_ncd_bankdraft", (Object)cdBankDraft);
                    cdBankDraft.set("e_checkstatus", (Object)"A");
                    needUpdateBankDraftsSet.add(cdBankDraft);
                }
                bank_cd_entryentity.clear();
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)rec_cd_entryentity) && rec_cd_entryentity.size() > 0) {
                Set cd_recDraftIdSet = rec_cd_entryentity.stream().map(e -> e.getDynamicObject("e_cd_recdraft").getLong("id")).collect(Collectors.toSet());
                DynamicObject[] cdRecDraftsArr = BusinessDataServiceHelper.load((Object[])cd_recDraftIdSet.toArray(), (DynamicObjectType)type);
                DynamicObjectCollection rec_ncd_entryentity = data.getDynamicObjectCollection("rec_ncd_entryentity");
                for (DynamicObject cdBankDraft : cdRecDraftsArr) {
                    DynamicObject rec_ncd_entry = rec_ncd_entryentity.addNew();
                    rec_ncd_entry.set("e_ncd_recdraft", (Object)cdBankDraft);
                    rec_ncd_entry.set("e_ncd_reccheckstatus", (Object)"A");
                }
                rec_cd_entryentity.clear();
            }
            if (!ischeckPaybill) continue;
            DynamicObjectCollection payBank_cd_entryentity = data.getDynamicObjectCollection("bank_cd_payentryentity");
            DynamicObjectCollection pay_cd_entryentity = data.getDynamicObjectCollection("pay_cd_entryentity");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)payBank_cd_entryentity) && payBank_cd_entryentity.size() > 0) {
                Set cd_payBankDraftIdSet = payBank_cd_entryentity.stream().map(e -> e.getDynamicObject("e_cd_paybankdraft").getLong("id")).collect(Collectors.toSet());
                DynamicObject[] cdPayBankDraftsArr = BusinessDataServiceHelper.load((Object[])cd_payBankDraftIdSet.toArray(), (DynamicObjectType)typeBankDataF7);
                DynamicObjectCollection bank_ncd_payEntryentity = data.getDynamicObjectCollection("bank_ncd_payentryentity");
                for (DynamicObject cdPayBankDraft : cdPayBankDraftsArr) {
                    DynamicObject bank_ncd_entry = bank_ncd_payEntryentity.addNew();
                    bank_ncd_entry.set("e_ncd_paybankdraft", (Object)cdPayBankDraft);
                    cdPayBankDraft.set("e_checkstatus", (Object)"A");
                    needUpdateBankDraftsSet.add(cdPayBankDraft);
                }
                payBank_cd_entryentity.clear();
            }
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)pay_cd_entryentity) || pay_cd_entryentity.size() <= 0) continue;
            Set cd_payDraftIdSet = pay_cd_entryentity.stream().map(e -> e.getDynamicObject("e_cd_paydraft").getLong("id")).collect(Collectors.toSet());
            DynamicObject[] cdPayDraftsArr = BusinessDataServiceHelper.load((Object[])cd_payDraftIdSet.toArray(), (DynamicObjectType)type);
            DynamicObjectCollection pay_ncd_entryentity = data.getDynamicObjectCollection("pay_ncd_entryentity");
            for (DynamicObject cdPayBankDraft : cdPayDraftsArr) {
                DynamicObject pay_ncd_entry = pay_ncd_entryentity.addNew();
                pay_ncd_entry.set("e_ncd_paydraft", (Object)cdPayBankDraft);
                pay_ncd_entry.set("e_ncd_paycheckstatus", (Object)"A");
            }
            pay_cd_entryentity.clear();
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        if (EmptyUtil.isNoEmpty(needUpdateBankDraftsSet) && needUpdateBankDraftsSet.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])needUpdateBankDraftsSet.toArray(new DynamicObject[0]));
        }
    }
}

