/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.bankdrafts;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.helper.CodeRuleHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ChequeInventoryAuditService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ChequeInventoryAuditService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("inventorydate");
        selector.add("company");
        selector.add("bankaccount");
        selector.add("currency");
        selector.add("isbybankaccount");
        selector.add("isinventoryfilled");
        selector.add("bizdate");
        selector.add("inventorydate");
        selector.add("filledacutaiamount");
        selector.add("filledchequeamount");
        selector.add("blankactualcount");
        selector.add("blankchequecount");
        selector.add("filledactualcount");
        selector.add("filledchequecount");
        selector.add("draftinventoryreport");
        selector.add("draftinventoryreportid");
        selector.add("description");
        selector.add("blankactual_ncd_entry");
        selector.add("blankactual_ncd_entry.e_ncd_blankactual");
        selector.add("blankcheque_ncd_entry");
        selector.add("blankcheque_ncd_entry.e_ncd_blankcheque");
        selector.add("blankcheque_ncd_entry.e_ncd_blankcheckstatus");
        selector.add("blankactual_cd_entry");
        selector.add("blankactual_cd_entry.e_cd_blankactualdraft");
        selector.add("blankcheque_cd_entry");
        selector.add("blankcheque_cd_entry.e_cd_blankcheque");
        selector.add("blankcheque_cd_entry.e_cd_blankcheckstatus");
        selector.add("filledactual_ncd_entry");
        selector.add("filledactual_ncd_entry.e_ncd_fiillactual");
        selector.add("filled_ncdcheque_entry");
        selector.add("filled_ncdcheque_entry.e_ncd_fillcheque");
        selector.add("filled_ncdcheque_entry.e_ncd_fillcheckstatus");
        selector.add("filledactual_cd_entry");
        selector.add("filledactual_cd_entry.e_cd_filledactual");
        selector.add("filled_cd_chequeentry");
        selector.add("filled_cd_chequeentry.e_cd_fillcheque");
        selector.add("filled_cd_chequeentry.e_cd_fillcheckstatus");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        logger.info("process is start");
        MainEntityType inventoryResultType = EntityMetadataCache.getDataEntityType((String)"cdm_inventoryresult");
        HashSet<DynamicObject> needUpdateInventoryDataSet = new HashSet<DynamicObject>(16);
        for (DynamicObject chequeInventoryDy : dataEntities) {
            boolean isinventoryFilled = chequeInventoryDy.getBoolean("isinventoryfilled");
            DynamicObject inventoryResultDy = this.fillInventoryHeadInfo((DynamicObjectType)inventoryResultType, chequeInventoryDy);
            this.fillRecInventoryInfo(chequeInventoryDy, inventoryResultDy);
            if (isinventoryFilled) {
                this.fillPayInventoryInfo(chequeInventoryDy, inventoryResultDy);
            }
            needUpdateInventoryDataSet.add(inventoryResultDy);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        SaveServiceHelper.save((DynamicObject[])needUpdateInventoryDataSet.toArray(new DynamicObject[0]));
    }

    private DynamicObject fillInventoryHeadInfo(DynamicObjectType inventoryResultType, DynamicObject chequeInventoryDy) {
        boolean ischeckPaybill = chequeInventoryDy.getBoolean("isinventoryfilled");
        DynamicObject bankAcc = chequeInventoryDy.getDynamicObject("bankaccount");
        DynamicObject orgDy = chequeInventoryDy.getDynamicObject("company");
        DynamicObject currencyDy = chequeInventoryDy.getDynamicObject("currency");
        Date inventoryDate = chequeInventoryDy.getDate("inventorydate");
        Date dataDate = chequeInventoryDy.getDate("bizdate");
        boolean isbybankAccount = chequeInventoryDy.getBoolean("isbybankaccount");
        long inventoryId = chequeInventoryDy.getLong("id");
        DynamicObject inventoryResultDy = new DynamicObject(inventoryResultType);
        long pkId = DB.genGlobalLongId();
        inventoryResultDy.set("id", (Object)pkId);
        String generateNumber = CodeRuleHelper.generateNumber((String)"cdm_inventoryresult", (DynamicObject)inventoryResultDy, (String)null, (String)null);
        inventoryResultDy.set("billno", (Object)generateNumber);
        inventoryResultDy.set("bankaccount", (Object)bankAcc);
        inventoryResultDy.set("currency", (Object)currencyDy);
        inventoryResultDy.set("company", (Object)orgDy);
        inventoryResultDy.set("inventorydate", (Object)inventoryDate);
        inventoryResultDy.set("bizdate", (Object)dataDate);
        inventoryResultDy.set("isbybankaccount", (Object)isbybankAccount);
        inventoryResultDy.set("isinventoryfilled", (Object)ischeckPaybill);
        inventoryResultDy.set("sourcebillid", (Object)inventoryId);
        inventoryResultDy.set("inventorytype", (Object)"blank");
        inventoryResultDy.set("billstatus", (Object)"A");
        String description = chequeInventoryDy.getString("description");
        inventoryResultDy.set("description", (Object)description);
        inventoryResultDy.set("creator", (Object)RequestContext.get().getCurrUserId());
        chequeInventoryDy.set("draftinventoryreport", (Object)generateNumber);
        chequeInventoryDy.set("draftinventoryreportid", (Object)pkId);
        return inventoryResultDy;
    }

    private void fillRecInventoryInfo(DynamicObject chequeInventoryDy, DynamicObject inventoryResultDy) {
        DynamicObjectCollection blank_actual_ncd_entrys = chequeInventoryDy.getDynamicObjectCollection("blankactual_ncd_entry");
        DynamicObjectCollection result_blankAcutal_ncd_entrys = inventoryResultDy.getDynamicObjectCollection("blankactual_ncd_entry");
        for (DynamicObject blank_actual_ncd_entry : blank_actual_ncd_entrys) {
            DynamicObject result_blankAcutal_ncd_entry = result_blankAcutal_ncd_entrys.addNew();
            DynamicObject buss_e_ncd_bankdraft = blank_actual_ncd_entry.getDynamicObject("e_ncd_blankactual");
            result_blankAcutal_ncd_entry.set("e_ncd_blankactual", (Object)buss_e_ncd_bankdraft);
        }
        int blank_ncd_actual_countSum = result_blankAcutal_ncd_entrys.size();
        DynamicObjectCollection blank_cheque_ncd_entrys = chequeInventoryDy.getDynamicObjectCollection("blankcheque_ncd_entry");
        DynamicObjectCollection result_cheque_ncd_entrys = inventoryResultDy.getDynamicObjectCollection("blankcheque_ncd_entry");
        for (DynamicObject blank_cheque_ncd_entry : blank_cheque_ncd_entrys) {
            DynamicObject result_cheque_ncd_entry = result_cheque_ncd_entrys.addNew();
            DynamicObject blank_e_ncd_cheque = blank_cheque_ncd_entry.getDynamicObject("e_ncd_blankcheque");
            result_cheque_ncd_entry.set("e_ncd_blankcheque", (Object)blank_e_ncd_cheque);
        }
        int blank_ncd_cheque_countSum = result_cheque_ncd_entrys.size();
        DynamicObjectCollection blankActual_cd_entryentity = chequeInventoryDy.getDynamicObjectCollection("blankactual_cd_entry");
        int blank_cd_actualCount = blankActual_cd_entryentity.size();
        inventoryResultDy.set("blankactualcount", (Object)blank_cd_actualCount);
        inventoryResultDy.set("blankcdchequecount", (Object)blank_ncd_cheque_countSum);
        int blankActualAdjCount = blank_cd_actualCount + blank_ncd_cheque_countSum;
        inventoryResultDy.set("blankactualadjcount", (Object)blankActualAdjCount);
        DynamicObjectCollection blank_cd_chequeEntrys = chequeInventoryDy.getDynamicObjectCollection("blankcheque_cd_entry");
        int blank_cheque_count = blank_cd_chequeEntrys.size();
        inventoryResultDy.set("blankchequecount", (Object)blank_cheque_count);
        inventoryResultDy.set("ncdblankactualcount", (Object)blank_ncd_actual_countSum);
        int blankChequeAdjCount = blank_ncd_actual_countSum + blank_cheque_count;
        inventoryResultDy.set("blankchequeadjcount", (Object)blankChequeAdjCount);
        inventoryResultDy.set("blankdiffcount", (Object)(blankActualAdjCount - blankChequeAdjCount));
    }

    private void fillPayInventoryInfo(DynamicObject chequeInventoryDy, DynamicObject inventoryResultDy) {
        BigDecimal fill_ncd_actual_amountSum = BigDecimal.ZERO;
        DynamicObjectCollection fill_actual_ncd_entrys = chequeInventoryDy.getDynamicObjectCollection("filledactual_ncd_entry");
        DynamicObjectCollection result_fill_actual_ncd_entrys = inventoryResultDy.getDynamicObjectCollection("filledactual_ncd_entry");
        for (DynamicObject fill_actual_ncd_entry : fill_actual_ncd_entrys) {
            DynamicObject result_fill_actual_ncd_entry = result_fill_actual_ncd_entrys.addNew();
            DynamicObject fill_e_ncd_actual = fill_actual_ncd_entry.getDynamicObject("e_ncd_fiillactual");
            result_fill_actual_ncd_entry.set("e_ncd_fiillactual", (Object)fill_e_ncd_actual);
            fill_ncd_actual_amountSum = fill_ncd_actual_amountSum.add(fill_e_ncd_actual.getBigDecimal("payamount"));
        }
        BigDecimal fill_ncd_cheque_amountSum = BigDecimal.ZERO;
        DynamicObjectCollection fill_ncd_chaqueEntitys = chequeInventoryDy.getDynamicObjectCollection("filled_ncdcheque_entry");
        DynamicObjectCollection result_ncd_chequeEntitys = inventoryResultDy.getDynamicObjectCollection("filled_ncdcheque_entry");
        for (DynamicObject fill_ncd_chaqueEntity : fill_ncd_chaqueEntitys) {
            DynamicObject result_ncd_chequeEntity = result_ncd_chequeEntitys.addNew();
            DynamicObject fill_ncd_cheque = fill_ncd_chaqueEntity.getDynamicObject("e_ncd_fillcheque");
            result_ncd_chequeEntity.set("e_ncd_fillcheque", (Object)fill_ncd_cheque);
            fill_ncd_cheque_amountSum = fill_ncd_cheque_amountSum.add(fill_ncd_cheque.getBigDecimal("relateamount"));
        }
        DynamicObjectCollection fill_cd_actualEntrys = chequeInventoryDy.getDynamicObjectCollection("filledactual_cd_entry");
        BigDecimal fill_cd_actualAmountSum = fill_cd_actualEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_cd_filledactual"))).map(v -> v.getDynamicObject("e_cd_filledactual").getBigDecimal("payamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        inventoryResultDy.set("fillactualamount", (Object)fill_cd_actualAmountSum);
        inventoryResultDy.set("fillnchequeamount", (Object)fill_ncd_cheque_amountSum);
        BigDecimal fillActualAdjAmount = fill_ncd_cheque_amountSum.add(fill_cd_actualAmountSum);
        inventoryResultDy.set("fillactualadjamount", (Object)fillActualAdjAmount);
        DynamicObjectCollection fill_cd_chequeEntitys = chequeInventoryDy.getDynamicObjectCollection("filled_cd_chequeentry");
        BigDecimal fill_cd_chequeAmountSum = fill_cd_chequeEntitys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_cd_fillcheque"))).map(v -> v.getDynamicObject("e_cd_fillcheque").getBigDecimal("relateamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        inventoryResultDy.set("fillchequeamount", (Object)fill_cd_chequeAmountSum);
        inventoryResultDy.set("fillnactualamount", (Object)fill_ncd_actual_amountSum);
        BigDecimal fillChequeAdjAmount = fill_ncd_actual_amountSum.add(fill_cd_chequeAmountSum);
        inventoryResultDy.set("fillchequeadjamount", (Object)fillChequeAdjAmount);
        inventoryResultDy.set("filldiffamount", (Object)fillActualAdjAmount.subtract(fillChequeAdjAmount));
    }
}

