/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.bankdrafts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DeleteBussinessInventoryService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(DeleteBussinessInventoryService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("inventorydate");
        selector.add("company");
        selector.add("bankaccount");
        selector.add("currency");
        selector.add("ischeckpaybill");
        selector.add("isbybankaccount");
        selector.add("bizdate");
        selector.add("inventorydate");
        selector.add("bank_ncd_entryentity");
        selector.add("bank_ncd_entryentity.e_ncd_bankdraft");
        selector.add("bank_cd_entryentity");
        selector.add("bank_cd_entryentity.e_cd_bankdraft");
        selector.add("rec_ncd_entryentity");
        selector.add("rec_ncd_entryentity.e_ncd_recdraft");
        selector.add("rec_ncd_entryentity.e_ncd_reccheckstatus");
        selector.add("rec_cd_entryentity");
        selector.add("rec_cd_entryentity.e_cd_recdraft");
        selector.add("rec_cd_entryentity.e_cd_reccheckstatus");
        selector.add("bank_ncd_payentryentity");
        selector.add("bank_ncd_payentryentity.e_ncd_paybankdraft");
        selector.add("bank_cd_payentryentity");
        selector.add("bank_cd_payentryentity.e_cd_paybankdraft");
        selector.add("pay_cd_entryentity");
        selector.add("pay_cd_entryentity.e_cd_paydraft");
        selector.add("pay_cd_entryentity.e_cd_paycheckstatus");
        selector.add("pay_ncd_entryentity");
        selector.add("pay_ncd_entryentity.e_ncd_paydraft");
        selector.add("pay_ncd_entryentity.e_ncd_paycheckstatus");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashSet<Long> bankDraftIdSetAll = new HashSet<Long>(16);
        for (DynamicObject data : dataEntities) {
            DynamicObjectCollection bank_ncd_entryentity = data.getDynamicObjectCollection("bank_ncd_entryentity");
            DynamicObjectCollection bank_ncd_payentryentity = data.getDynamicObjectCollection("bank_ncd_payentryentity");
            DynamicObjectCollection bank_cd_bankentryentity = data.getDynamicObjectCollection("bank_cd_entryentity");
            DynamicObjectCollection bank_cd_payentryentity = data.getDynamicObjectCollection("bank_cd_payentryentity");
            this.getBankDraftId(bankDraftIdSetAll, bank_ncd_entryentity, "e_ncd_bankdraft");
            this.getBankDraftId(bankDraftIdSetAll, bank_ncd_payentryentity, "e_ncd_paybankdraft");
            this.getBankDraftId(bankDraftIdSetAll, bank_cd_bankentryentity, "e_cd_bankdraft");
            this.getBankDraftId(bankDraftIdSetAll, bank_cd_payentryentity, "e_cd_paybankdraft");
        }
        if (EmptyUtil.isNoEmpty(bankDraftIdSetAll)) {
            DynamicObject[] bankDraftIdArr;
            for (DynamicObject bankDraft : bankDraftIdArr = BusinessDataServiceHelper.load((String)"cdm_bankdraftdatasf7", (String)"id,e_checkstatus,e_inventorystatus", (QFilter[])new QFilter[]{new QFilter("id", "in", bankDraftIdSetAll)})) {
                bankDraft.set("e_checkstatus", (Object)"A");
                bankDraft.set("e_inventorystatus", (Object)"A");
            }
            SaveServiceHelper.save((DynamicObject[])bankDraftIdArr);
        }
    }

    private void getBankDraftId(Set<Long> bankDraftIdSetAll, DynamicObjectCollection bank_ncd_entryentity, String prop) {
        Set bankDraftIdSet;
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bank_ncd_entryentity) && EmptyUtil.isNoEmpty(bankDraftIdSet = bank_ncd_entryentity.stream().filter(e -> null != e.getDynamicObject(prop)).map(e -> e.getDynamicObject(prop).getLong("id")).collect(Collectors.toSet()))) {
            bankDraftIdSetAll.addAll(bankDraftIdSet);
        }
    }
}

