/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.bankdrafts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.cdm.business.ebservice.api.IEBServiceFacade;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;

public class QueryBankDraftsService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(QueryBankDraftsService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("bankaccount");
        selector.add("org");
        selector.add("biztype");
        selector.add("datadate");
        selector.add("importway");
        selector.add("isonlynewdraft");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject data : dataEntities) {
            DynamicObject orgDy = data.getDynamicObject("org");
            DynamicObject bankaccountDy = data.getDynamicObject("bankaccount");
            String bizTypeStr = data.getString("biztype");
            Date dataDateTime = data.getDate("datadate");
            Date dataDate = DateUtils.stringToDate((String)DateUtils.formatString((Date)dataDateTime, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            String importwayStr = data.getString("importway");
            Boolean isOnlynewDraft = data.getBoolean("isonlynewdraft");
            ArrayList<Long> bankList = new ArrayList<Long>(1);
            bankList.add(bankaccountDy.getLong("id"));
            HashMap<String, List<String>> interfaceTypeMap = new HashMap<String, List<String>>(2);
            List<String> ticStatusEnums = Collections.singletonList("100006");
            interfaceTypeMap.put("0", ticStatusEnums);
            if (!isOnlynewDraft.booleanValue()) {
                interfaceTypeMap.put("1", ticStatusEnums);
            }
            List<String> draftTypeEnums = Arrays.asList("AC01", "AC02");
            OperationResult operationResult = this.queryOp(bankList, interfaceTypeMap, draftTypeEnums, dataDate, bizTypeStr, orgDy.getLong("id"));
        }
    }

    private OperationResult queryOp(List<Long> accountIdSet, Map<String, List<String>> interfaceTypeMap, List<String> draftTypeEnums, Date dataDate, String bizTypeStr, long orgId) {
        OperationResult operationResult = new OperationResult();
        IEBServiceFacade bankService = EBServiceFacadeFactory.getBankService();
        List<NoteResult> noteResults = bankService.queryDraftBillByImportBankData(draftTypeEnums, interfaceTypeMap, accountIdSet, true, dataDate, bizTypeStr, orgId);
        ArrayList<Long> successBillIdList = new ArrayList<Long>(10);
        for (NoteResult noteResult : noteResults) {
            if (EBResultStatusCode.SUCCESS.equals((Object)noteResult.getStatusCode())) {
                successBillIdList.add(noteResult.getBillId());
                operationResult.setSuccess(true);
                continue;
            }
            logger.error(String.format("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0cerrCode:{%s}\uff0cerrMsg:{%s}\u3002", noteResult.getErrCode(), noteResult.getErrMsg()));
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(noteResult.getErrMsg());
            operationResult.addErrorInfo(operateErrorInfo);
            operationResult.setSuccess(false);
        }
        operationResult.setBillCount(noteResults.size());
        operationResult.setSuccessPkIds(successBillIdList);
        return operationResult;
    }
}

