/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.basedata;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.AcceptPromiseTypeEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class RecBillNoticeRuleMigrationService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(RecBillNoticeRuleMigrationService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        DynamicObject[] casRecPayRuleBills;
        logger.info("RecBillNoticeRuleMigrationService start");
        QFilter casRecPayRuleFilter = new QFilter("biztype", "=", (Object)"recticket");
        casRecPayRuleFilter.and(new QFilter("entryentity.e_handlescheme", "=", (Object)"ticket"));
        DynamicObjectCollection casRecPayRuleColl = QueryServiceHelper.query((String)"cas_recpayrule", (String)"id", (QFilter[])new QFilter[]{casRecPayRuleFilter});
        logger.info("RecBillNoticeRuleMigrationService casRecPayRuleColl.size = {},casRecBillFilter = {}", (Object)casRecPayRuleColl.size(), (Object)casRecPayRuleFilter.toString());
        if (casRecPayRuleColl.size() == 0) {
            return;
        }
        Object[] casRecPayRuleIds = casRecPayRuleColl.stream().map(o -> o.getLong("id")).toArray();
        for (DynamicObject casRecPayRuleBill : casRecPayRuleBills = TmcDataServiceHelper.load((Object[])casRecPayRuleIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_recpayrule"))) {
            QFilter cdmRecPayRuleFilter = new QFilter("number", "=", (Object)casRecPayRuleBill.getString("number"));
            cdmRecPayRuleFilter.and(new QFilter("name", "=", (Object)casRecPayRuleBill.getString("name")));
            cdmRecPayRuleFilter.and(new QFilter("rule_entity.e_handlescheme", "=", (Object)"noticeclaim"));
            boolean isExist = QueryServiceHelper.exists((String)"cdm_recbill_noticerule", (QFilter[])new QFilter[]{cdmRecPayRuleFilter});
            if (isExist) {
                logger.info("RecBillNoticeRuleMigrationService isExist = {}", (Object)isExist, (Object)cdmRecPayRuleFilter.toString());
                continue;
            }
            MainEntityType recBillNoticeRuleType = EntityMetadataCache.getDataEntityType((String)"cdm_recbill_noticerule");
            long pkId = DB.genLongId((String)recBillNoticeRuleType.getAlias());
            DynamicObject recBillNoticeRule = new DynamicObject((DynamicObjectType)recBillNoticeRuleType, (Object)pkId);
            recBillNoticeRule.set("number", (Object)casRecPayRuleBill.getString("number"));
            recBillNoticeRule.set("name", (Object)casRecPayRuleBill.getString("name"));
            recBillNoticeRule.set("enable", (Object)(casRecPayRuleBill.getBoolean("enable") ? "1" : "0"));
            recBillNoticeRule.set("creator", (Object)RequestContext.get().getCurrUserId());
            DynamicObjectCollection ruleEntity = recBillNoticeRule.getDynamicObjectCollection("rule_entity");
            DynamicObjectCollection entryEntity = casRecPayRuleBill.getDynamicObjectCollection("entryentity");
            logger.info("RecBillNoticeRuleMigrationService entryEntity.size = {}", (Object)entryEntity.size());
            if (entryEntity.size() > 0) {
                ruleEntity.clear();
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject entryEntityInfo = (DynamicObject)entryEntity.get(i);
                    DynamicObject newEntry = ruleEntity.addNew();
                    newEntry.set("seq", (Object)(i + 1));
                    newEntry.set("e_rulesname", (Object)entryEntityInfo.getString("e_rulesname"));
                    newEntry.set("e_datafilterdesc", (Object)entryEntityInfo.getString("e_datafilterdesc"));
                    newEntry.set("e_datafilter", (Object)entryEntityInfo.getString("e_datafilter"));
                    newEntry.set("e_datafilter_TAG", (Object)entryEntityInfo.getString("e_datafilter_TAG"));
                    newEntry.set("e_handlescheme", (Object)"noticeclaim");
                    DynamicObject receivingType = entryEntityInfo.getDynamicObject("e_receivingtype");
                    newEntry.set("e_receivingtypestr", (Object)(receivingType == null ? "" : receivingType.getString("name")));
                    newEntry.set("e_receivingtype", (Object)receivingType);
                    newEntry.set("e_payertypestr", this.getType(entryEntityInfo.getString("e_payertype")));
                    newEntry.set("e_payertype", (Object)entryEntityInfo.getString("e_payertype"));
                    newEntry.set("e_payerbasetype", (Object)entryEntityInfo.getString("e_payerbasetype"));
                    DynamicObject payerId = entryEntityInfo.getDynamicObject("e_payerid");
                    if (AcceptPromiseTypeEnum.OTHER.getValue().equals(entryEntityInfo.getString("e_payerbasetype"))) {
                        newEntry.set("e_payer", (Object)entryEntityInfo.getString("e_payer"));
                    } else {
                        newEntry.set("e_payer", (Object)(payerId == null ? "" : payerId.getString("name")));
                    }
                    newEntry.set("e_payerid", (Object)entryEntityInfo.getDynamicObject("e_payerid"));
                    DynamicObject fundFlowItem = entryEntityInfo.getDynamicObject("e_fundflowitem");
                    newEntry.set("e_fundflowitemstr", (Object)(fundFlowItem == null ? "" : fundFlowItem.getString("name")));
                    newEntry.set("e_fundflowitem", (Object)fundFlowItem);
                    newEntry.set("e_explain", (Object)entryEntityInfo.getString("e_remark"));
                    newEntry.set("e_notifische", entryEntityInfo.get("e_notifische"));
                    newEntry.set("e_savenotifi", entryEntityInfo.get("e_savenotifi"));
                    newEntry.set("e_savenotifi_TAG", (Object)entryEntityInfo.getString("e_savenotifi_TAG"));
                }
            }
            DynamicObjectCollection cdmOrgEntry = recBillNoticeRule.getDynamicObjectCollection("org_entry");
            DynamicObjectCollection casOrgEntry = casRecPayRuleBill.getDynamicObjectCollection("org_entry");
            logger.info("RecBillNoticeRuleMigrationService casOrgEntry.size = {}", (Object)casOrgEntry.size());
            if (casOrgEntry.size() > 0) {
                cdmOrgEntry.clear();
                for (int i = 0; i < casOrgEntry.size(); ++i) {
                    DynamicObject orgEntityInfo = (DynamicObject)casOrgEntry.get(i);
                    DynamicObject newEntry = cdmOrgEntry.addNew();
                    newEntry.set("seq", (Object)(i + 1));
                    newEntry.set("u_org", (Object)orgEntityInfo.getDynamicObject("u_org"));
                    recBillNoticeRule.set("company", (Object)orgEntityInfo.getDynamicObject("u_org"));
                }
            }
            OperationResult operationResult = TmcOperateServiceHelper.executeOperate((String)"save", (String)"cdm_recbill_noticerule", (DynamicObject[])new DynamicObject[]{recBillNoticeRule}, (OperateOption)OperateOption.create());
            logger.info("RecBillNoticeRuleMigrationService operationResult.isSuccess is {},operationResult = {}", (Object)operationResult.isSuccess(), (Object)RecBillNoticeRuleMigrationService.decodeMultiErrorMessage(operationResult));
        }
        logger.info("RecBillNoticeRuleMigrationService end");
    }

    private static String decodeMultiErrorMessage(OperationResult operationResult) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        StringBuilder stringBuilder = new StringBuilder();
        for (IOperateInfo iOperateInfo : errorInfos) {
            String message = iOperateInfo.getMessage();
            Long pkValue = (Long)iOperateInfo.getPkValue();
            stringBuilder.append(pkValue).append(":");
            stringBuilder.append(message).append(";");
        }
        return stringBuilder.toString();
    }

    private Object getType(String type) {
        String res = "";
        switch (type) {
            case "bos_org": {
                res = AcceptPromiseTypeEnum.BOS_ORG.getName();
                break;
            }
            case "bd_supplier": {
                res = AcceptPromiseTypeEnum.BD_SUPPLIER.getName();
                break;
            }
            case "bd_customer": {
                res = AcceptPromiseTypeEnum.BD_CUSTOMER.getName();
                break;
            }
            case "bos_user": {
                res = AcceptPromiseTypeEnum.BOS_USER.getName();
                break;
            }
            case "other": {
                res = AcceptPromiseTypeEnum.OTHER.getName();
                break;
            }
        }
        return res;
    }
}

