/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.billpoolbiz;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.service.DraftAmountLockSubInfo;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.cdm.common.enums.BizBusinessTypeEnum;
import kd.tmc.cdm.common.enums.OperateTypeEnum;
import kd.tmc.cdm.common.enums.PoolLockStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillPoolBizAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("entryentity");
        selector.add("billpool");
        selector.add("e_draftbill");
        selector.add("draftbilllogid");
        selector.add("e_billamt");
        selector.add("businesstype");
        selector.add("billno");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        String autoAllocationStr = (String)this.getOperationVariable().get("autoallocation");
        String allocationidStr = (String)this.getOperationVariable().get("allocationid");
        Map<Long, DynamicObject> draftIdAndEntryMap = new HashMap<Long, DynamicObject>(8);
        if (EmptyUtil.isNoEmpty((String)allocationidStr)) {
            long allocationid = Long.parseLong(allocationidStr);
            DynamicObject allocBill = BusinessDataServiceHelper.loadSingle((Object)allocationid, (String)"cdm_draftallocation");
            DynamicObjectCollection entryEntity = allocBill.getDynamicObjectCollection("entryentity");
            draftIdAndEntryMap = entryEntity.stream().collect(Collectors.toMap(e -> e.getDynamicObject("e_draftbill").getLong("id"), e -> e));
        }
        boolean autoAllocation = Boolean.parseBoolean(autoAllocationStr);
        List<DraftLockInfo> releaseInfoList = this.getReleaseInfo(dynamicObjects, autoAllocation, draftIdAndEntryMap);
        List<LockResult> lockResultList = DraftLockServiceFactory.getService().lock(releaseInfoList, true);
        LockDraftHelper.checkHasFail(lockResultList);
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject[] draftBillBaseDataArray;
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            Object[] draftBillIds = (Long[])entryEntity.stream().filter(row -> Objects.nonNull(row.get("e_draftbill"))).map(row -> (Long)row.getDynamicObject("e_draftbill").getPkValue()).toArray(Long[]::new);
            for (DynamicObject draftBillBaseData : draftBillBaseDataArray = BusinessDataServiceHelper.load((Object[])draftBillIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"))) {
                if (Objects.equals(dynamicObject.get("businesstype"), BizBusinessTypeEnum.JOIN.getValue())) {
                    draftBillBaseData.set("billpool", dynamicObject.getDynamicObject("billpool").getPkValue());
                    draftBillBaseData.set("intopooltime", (Object)new Date());
                } else {
                    draftBillBaseData.set("billpool", null);
                    draftBillBaseData.set("intopooltime", null);
                }
                draftBillBaseData.set("poollockstatus", (Object)PoolLockStatusEnum.UNLOCK.getValue());
                draftBillBaseData.set("poollockorg", null);
            }
            TmcOperateServiceHelper.execOperate((String)"save", (String)"cdm_draftbillf7", (DynamicObject[])draftBillBaseDataArray, (OperateOption)OperateOption.create());
            this.unlockPoolDraftBill(dynamicObject, (Long[])draftBillIds);
        }
    }

    private void unlockPoolDraftBill(DynamicObject dynamicObject, Long[] draftBillIds) {
        DynamicObjectCollection poolDraftBills;
        Object[] lockPoolDraftBillIds;
        if (Objects.equals(dynamicObject.get("businesstype"), BizBusinessTypeEnum.OUT.getValue()) && (lockPoolDraftBillIds = (poolDraftBills = QueryServiceHelper.query((String)"cdm_pooldraftbill", (String)"id,poollockstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)draftBillIds)})).stream().filter(poolDraftBill -> Objects.equals(poolDraftBill.get("poollockstatus"), PoolLockStatusEnum.LOCK.getValue())).map(e -> e.getLong("id")).toArray()).length > 0) {
            TmcOperateServiceHelper.execOperate((String)"pooldraftunlock", (String)"cdm_pooldraftbill", (Object[])lockPoolDraftBillIds, (OperateOption)OperateOption.create());
        }
    }

    private List<DraftLockInfo> getReleaseInfo(DynamicObject[] dataEntities, boolean autoAllocation, Map<Long, DynamicObject> draftIdAndEntryMap) {
        String tradeBillType = dataEntities[0].getDataEntityType().getName();
        ArrayList<DraftLockInfo> releaseInfoList = new ArrayList<DraftLockInfo>(8);
        for (DynamicObject tradebill : dataEntities) {
            String businesstype = tradebill.getString("businesstype");
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            long tradeBillId = tradebill.getLong("id");
            String billno = tradebill.getString("billno");
            draftLockInfo.setBillTrade(businesstype);
            draftLockInfo.setSourceBillType(tradeBillType);
            draftLockInfo.setSourceBillId(tradeBillId);
            draftLockInfo.setBizBillNo(billno);
            draftLockInfo.setOperateType(OperateTypeEnum.COMPLETE.getValue());
            DynamicObjectCollection entrys = tradebill.getDynamicObjectCollection("entryentity");
            List lockDraftIds = entrys.stream().map(v -> v.getDynamicObject("e_draftbill").getLong("id")).collect(Collectors.toList());
            HashMap draftIdDealAmountMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("e_draftbill").getLong("id"), o -> o.getBigDecimal("e_billamt"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdLogIdMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("e_draftbill").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
            ArrayList<DraftAmountLockSubInfo> releaseSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (Long lockDraftId : lockDraftIds) {
                DynamicObject allocEntry;
                if (autoAllocation && EmptyUtil.isNoEmpty((DynamicObject)(allocEntry = draftIdAndEntryMap.get(lockDraftId)))) continue;
                DraftAmountLockSubInfo draftAmountreleaseSubInfo = new DraftAmountLockSubInfo();
                draftAmountreleaseSubInfo.setBillId(lockDraftId);
                Long draftLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                draftAmountreleaseSubInfo.setBillLogId(draftLogId);
                BigDecimal dealAmount = draftIdDealAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(lockDraftId);
                draftAmountreleaseSubInfo.setDealAmount(dealAmount);
                draftAmountreleaseSubInfo.setOperateType(OperateTypeEnum.COMPLETE.getValue());
                draftAmountreleaseSubInfo.setBillTrade(businesstype);
                releaseSubInfoList.add(draftAmountreleaseSubInfo);
            }
            if (!EmptyUtil.isNoEmpty(releaseSubInfoList)) continue;
            draftLockInfo.setLockSubInfoList(releaseSubInfoList);
            releaseInfoList.add(draftLockInfo);
        }
        return releaseInfoList;
    }
}

