/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.billpoolbiz;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.service.DraftAmountLockSubInfo;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.cdm.common.enums.OperateTypeEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillPoolBizDeleteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("entryentity");
        selector.add("billpool");
        selector.add("e_draftbill");
        selector.add("draftbilllogid");
        selector.add("e_billamt");
        selector.add("businesstype");
        selector.add("billno");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        List<DraftLockInfo> releaseInfoList = this.getReleaseInfo(dynamicObjects);
        List<LockResult> lockResultList = DraftLockServiceFactory.getService().lock(releaseInfoList, true);
        LockDraftHelper.checkHasFail(lockResultList);
    }

    private List<DraftLockInfo> getReleaseInfo(DynamicObject[] dataEntities) {
        String tradeBillType = dataEntities[0].getDataEntityType().getName();
        ArrayList<DraftLockInfo> releaseInfoList = new ArrayList<DraftLockInfo>(8);
        for (DynamicObject tradebill : dataEntities) {
            String businesstype = tradebill.getString("businesstype");
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            long tradeBillId = tradebill.getLong("id");
            String billno = tradebill.getString("billno");
            draftLockInfo.setBillTrade(businesstype);
            draftLockInfo.setSourceBillType(tradeBillType);
            draftLockInfo.setSourceBillId(tradeBillId);
            draftLockInfo.setBizBillNo(billno);
            draftLockInfo.setOperateType(OperateTypeEnum.DELETE.getValue());
            DynamicObjectCollection entrys = tradebill.getDynamicObjectCollection("entryentity");
            List lockDraftIds = entrys.stream().map(v -> v.getDynamicObject("e_draftbill").getLong("id")).collect(Collectors.toList());
            HashMap draftIdDealAmountMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("e_draftbill").getLong("id"), o -> o.getBigDecimal("e_billamt"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdLogIdMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("e_draftbill").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
            ArrayList<DraftAmountLockSubInfo> releaseSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (Long lockDraftId : lockDraftIds) {
                Long draftLogId;
                DraftAmountLockSubInfo draftAmountreleaseSubInfo = new DraftAmountLockSubInfo();
                draftAmountreleaseSubInfo.setBillId(lockDraftId);
                Long l = draftLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                if (EmptyUtil.isEmpty((Long)draftLogId)) continue;
                draftAmountreleaseSubInfo.setBillLogId(draftLogId);
                BigDecimal dealAmount = draftIdDealAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(lockDraftId);
                draftAmountreleaseSubInfo.setDealAmount(dealAmount);
                draftAmountreleaseSubInfo.setOperateType(OperateTypeEnum.DELETE.getValue());
                draftAmountreleaseSubInfo.setBillTrade(businesstype);
                releaseSubInfoList.add(draftAmountreleaseSubInfo);
            }
            if (!EmptyUtil.isNoEmpty(releaseSubInfoList)) continue;
            draftLockInfo.setLockSubInfoList(releaseSubInfoList);
            releaseInfoList.add(draftLockInfo);
        }
        return releaseInfoList;
    }
}

