/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.billpoolbiz;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillPoolBizSaveService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(BillPoolBizSaveService.class);

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("entryentity");
        selector.add("e_billamt");
        selector.add("e_draftbill");
        selector.add("draftbilllogid");
        selector.add("businesstype");
        selector.add("billno");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        String autoAllocationStr = (String)this.getOperationVariable().get("autoallocation");
        String allocationidStr = (String)this.getOperationVariable().get("allocationid");
        logger.info("BillPoolBizSaveService is start autoAllocationStr is:" + autoAllocationStr + ",allocationidStr is:" + allocationidStr);
        Map<Long, DynamicObject> draftIdAndEntryMap = new HashMap<Long, DynamicObject>(8);
        if (EmptyUtil.isNoEmpty((String)allocationidStr)) {
            long allocationid = Long.parseLong(allocationidStr);
            DynamicObject allocBill = BusinessDataServiceHelper.loadSingle((Object)allocationid, (String)"cdm_draftallocation");
            DynamicObjectCollection entryEntity = allocBill.getDynamicObjectCollection("entryentity");
            draftIdAndEntryMap = entryEntity.stream().collect(Collectors.toMap(e -> e.getDynamicObject("e_draftbill").getLong("id"), e -> e));
        }
        boolean autoAllocation = Boolean.parseBoolean(autoAllocationStr);
        List<DraftLockInfo> releaseInfoList = LockDraftHelper.getPoolLockAndReleaseInfo(dynamicObjects, autoAllocation, draftIdAndEntryMap);
        List<LockResult> lockResultList = DraftLockServiceFactory.getService().lock(releaseInfoList, true);
        LockDraftHelper.checkHasFail(lockResultList);
        this.fillBillLogInfo(dynamicObjects, draftIdAndEntryMap, autoAllocation, lockResultList);
        logger.info("BillPoolBizSaveService is end");
    }

    private void fillBillLogInfo(DynamicObject[] dynamicObjects, Map<Long, DynamicObject> draftIdAndEntryMap, boolean autoAllocation, List<LockResult> lockResultList) {
        Map<Long, LockResult> tradeIdAndDyMap = lockResultList.stream().collect(Collectors.toMap(LockResult::getSourceBillId, x -> x));
        for (DynamicObject data : dynamicObjects) {
            long payBillId = data.getLong("id");
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entryentity");
            BigDecimal newSumAMount = BigDecimal.ZERO;
            for (DynamicObject entry : entrys) {
                Long draftBillId = entry.getDynamicObject("e_draftbill").getLong("id");
                LockResult lockResult = tradeIdAndDyMap.get(payBillId);
                if (EmptyUtil.isNoEmpty((Object)lockResult)) {
                    Map<Long, Long> billIdLogIdMap = lockResult.getBillIdLogIdMap();
                    boolean success = lockResult.isSuccess();
                    Long billLogId = billIdLogIdMap.get(draftBillId);
                    if (EmptyUtil.isNoEmpty((Long)billLogId) && success) {
                        entry.set("draftbilllogid", (Object)billLogId);
                    } else if (EmptyUtil.isEmpty((Long)billLogId)) {
                        this.setLogAndAmountByAlloc(draftIdAndEntryMap, autoAllocation, entry);
                    }
                } else {
                    this.setLogAndAmountByAlloc(draftIdAndEntryMap, autoAllocation, entry);
                }
                BigDecimal entryAmount = entry.getBigDecimal("e_billamt");
                newSumAMount = newSumAMount.add(entryAmount);
            }
            if (!autoAllocation) continue;
            data.set("amount", (Object)newSumAMount);
        }
    }

    private void setLogAndAmountByAlloc(Map<Long, DynamicObject> draftIdAndEntryMap, boolean autoAllocation, DynamicObject entry) {
        Long draftBillId;
        DynamicObject allocEntryDy;
        if (autoAllocation && EmptyUtil.isNoEmpty(draftIdAndEntryMap) && EmptyUtil.isNoEmpty((DynamicObject)(allocEntryDy = draftIdAndEntryMap.get(draftBillId = Long.valueOf(entry.getDynamicObject("e_draftbill").getLong("id")))))) {
            long allocBillLogId = allocEntryDy.getLong("draftbilllogid");
            BigDecimal e_subbillamt = allocEntryDy.getBigDecimal("e_subbillamt");
            entry.set("draftbilllogid", (Object)allocBillLogId);
            entry.set("e_billamt", (Object)e_subbillamt);
        }
    }
}

