/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.billpoolbiz;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.enums.PoolLockOperateTypeEnum;
import kd.tmc.cdm.common.enums.PoolLockStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class PoolDraftLockService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("poollockorg");
        selector.add("poollockstatus");
        selector.add("poollockorg");
        selector.add("poollocktime");
        selector.add("lockbilltime");
        selector.add("predictunlocktime");
        selector.add("lockbilluser");
        selector.add("billpool");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        ArrayList<DynamicObject> poolBillLogs = new ArrayList<DynamicObject>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("poollockstatus", (Object)PoolLockStatusEnum.LOCK.getValue());
            Date currentDate = new Date();
            dynamicObject.set("poollocktime", (Object)currentDate);
            dynamicObject.set("lockbilltime", (Object)currentDate);
            DynamicObject[] dbDataArr = TmcDataServiceHelper.load((String)"cdm_lockrule", (String)"id", null);
            if (dbDataArr.length > 0) {
                Object dbDataId = dbDataArr[0].get("id");
                DynamicObject dbData = TmcDataServiceHelper.loadSingle((Object)dbDataId, (String)"cdm_lockrule");
                boolean boolean1 = dbData.getBoolean("overtimeunlock");
                int workDays = dbData.getInt("workdaynumber");
                if (boolean1) {
                    Date nextDay = DateUtils.getNextDay((Date)currentDate, (int)workDays);
                    dynamicObject.set("predictunlocktime", (Object)nextDay);
                } else {
                    dynamicObject.set("predictunlocktime", null);
                }
            }
            DynamicObject poolBillLog = BusinessDataServiceHelper.newDynamicObject((String)"cdm_pooldraft_log");
            poolBillLog.set("poollockorg", dynamicObject.getDynamicObject("poollockorg").getPkValue());
            poolBillLog.set("billpool", dynamicObject.get("billpool"));
            poolBillLog.set("pooldraft", dynamicObject.getPkValue());
            poolBillLog.set("operatetype", (Object)PoolLockOperateTypeEnum.LOCK.getValue());
            Long userPK = Long.valueOf(RequestContext.get().getUserId());
            poolBillLog.set("creator", (Object)userPK);
            poolBillLog.set("createtime", (Object)new Date());
            poolBillLogs.add(poolBillLog);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        SaveServiceHelper.save((DynamicObject[])poolBillLogs.toArray(new DynamicObject[0]));
    }
}

