/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.billtype;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tmc.cdm.common.constant.CdmBizConstant;
import kd.tmc.cdm.common.enums.BillTypeUnitEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillTypeService
extends AbstractTmcBizOppService {
    private boolean isRpcSuccess;

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("credittype");
        selector.add("name");
        selector.add("validitytime");
        selector.add("defaulttime");
        selector.add("unit");
        selector.add("defaultunit");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        CdmBizConstant cdmBizConstant = new CdmBizConstant();
        for (DynamicObject data : dataEntities) {
            String validitytime = data.getString("validitytime");
            String unit = data.getString("unit");
            String dec = validitytime;
            String defaulttime = data.getString("defaulttime");
            String defaultunit = data.getString("defaultunit");
            String defaulttimedec = defaulttime;
            if (BillTypeUnitEnum.MONTH.getValue().equals(unit)) {
                dec = dec + cdmBizConstant.getUnit();
            }
            if (BillTypeUnitEnum.MONTH.getValue().equals(defaultunit)) {
                defaulttimedec = defaulttimedec + cdmBizConstant.getUnit();
            }
            data.set("validitytimedec", (Object)(dec + BillTypeUnitEnum.getName((String)unit)));
            data.set("defaulttimedec", (Object)(defaulttimedec + BillTypeUnitEnum.getName((String)defaultunit)));
            DynamicObject[] billTyps = TmcDataServiceHelper.load((String)data.getDataEntityType().getName(), (String)"id,credittype", (QFilter[])new QFilter[]{new QFilter("id", "=", data.getPkValue())});
            DynamicObject credittype = null;
            if (billTyps != null && billTyps.length > 0) {
                credittype = billTyps[0].getDynamicObject("credittype");
            }
            HashMap<String, Object> creditMap = new HashMap<String, Object>();
            creditMap.put("bizBaseId", (Long)data.getPkValue());
            creditMap.put("formId", data.getDynamicObjectType().getName());
            if (EmptyUtil.isEmpty((DynamicObject)credittype)) {
                if (!EmptyUtil.isNoEmpty((DynamicObject)data.getDynamicObject("credittype"))) continue;
                creditMap.put("creditTypeId", data.getDynamicObject("credittype").getPkValue());
                this.addCreditVariety(data, creditMap);
                continue;
            }
            if (EmptyUtil.isEmpty((DynamicObject)data.getDynamicObject("credittype"))) {
                if (credittype != null) {
                    creditMap.put("creditTypeId", credittype.getPkValue());
                }
                this.deleteCreditVariety(data, creditMap);
                continue;
            }
            if (credittype == null || credittype.getLong("id") == data.getDynamicObject("credittype").getLong("id")) continue;
            creditMap.put("creditTypeId", credittype.getPkValue());
            this.deleteCreditVariety(data, creditMap);
            creditMap.put("creditTypeId", data.getDynamicObject("credittype").getPkValue());
            this.addCreditVariety(data, creditMap);
        }
    }

    public void addCreditVariety(DynamicObject data, Map<String, Object> creditMap) {
        String addBeanStr = SerializationUtils.toJsonString(creditMap);
        String result = (String)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"creditm", (String)"creditService", (String)"addCreditVariety", (Object[])new Object[]{addBeanStr});
        Map resultMap = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        this.isRpcSuccess = (Boolean)resultMap.get("success");
        if (!this.isRpcSuccess) {
            this.operationResult.setSuccess(false);
            throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{resultMap.get("msg").toString()});
        }
    }

    public void deleteCreditVariety(DynamicObject data, Map<String, Object> delMap) {
        String delBeanStr = SerializationUtils.toJsonString(delMap);
        String result = (String)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"creditm", (String)"creditService", (String)"deleteCreditVariety", (Object[])new Object[]{delBeanStr});
        Map resultMap = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        if (!((Boolean)resultMap.get("success")).booleanValue()) {
            throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{resultMap.get("msg").toString()});
        }
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        super.handlerException(dataEntities);
        if (this.isRpcSuccess) {
            for (DynamicObject data : dataEntities) {
                if (!EmptyUtil.isNoEmpty((DynamicObject)data.getDynamicObject("creditlimit"))) continue;
                HashMap<String, Object> delMap = new HashMap<String, Object>();
                delMap.put("creditTypeId", (Long)data.getPkValue());
                delMap.put("entityName", data.getDataEntityType().getName());
                this.deleteCreditVariety(data, delMap);
            }
        }
    }
}

