/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.draftbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.cdm.business.ebservice.api.IEBServiceFacade;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;

public class ElcDraftBillBusinessPayOpService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ElcDraftBillBusinessPayOpService.class);
    private String opType;

    public ElcDraftBillBusinessPayOpService(String opType) {
        this.opType = opType;
    }

    public ElcDraftBillBusinessPayOpService() {
    }

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("tradecontractno");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        if (StringUtils.isEmpty((CharSequence)this.opType)) {
            this.opType = (String)this.getOperationVariable().get("opType");
        }
        Set pkIds = Arrays.stream(dataEntities).map(e -> (Long)e.getPkValue()).collect(Collectors.toSet());
        logger.info("ElcDraftBillBusinessPayOpService afterProcess selected pkIds = {}", (Object)pkIds.toString());
        if (ElcDraftBillOpEnum.REMITREGISTER.getValue().equals(this.opType) || ElcDraftBillOpEnum.REMITRECEIVE.getValue().equals(this.opType)) {
            Object[] tradeContractNos = Arrays.stream(dataEntities).filter(e -> StringUtils.isNotEmpty((CharSequence)e.getString("tradecontractno"))).map(e -> e.get("tradecontractno")).distinct().toArray();
            if (tradeContractNos.length > 0) {
                QFilter tradeContractNoFilter = new QFilter("tradecontractno", "in", (Object)tradeContractNos);
                DynamicObjectCollection eleSameContractNoPayBills = QueryServiceHelper.query((String)"cdm_electronic_pay_deal", (String)"id", (QFilter[])new QFilter[]{tradeContractNoFilter});
                Set eleSameContractNoPayIds = eleSameContractNoPayBills.stream().filter(Objects::nonNull).map(e -> e.getLong("id")).collect(Collectors.toSet());
                logger.info("ElcDraftBillBusinessPayOpService afterProcess query eleSameContractNoPayIds = {}", (Object)eleSameContractNoPayIds.toString());
                pkIds.addAll(eleSameContractNoPayIds);
            }
            logger.info("ElcDraftBillBusinessPayOpService afterProcess selected and query pkIds = {}", (Object)pkIds.toString());
        }
        ArrayList<Long> pkValues = new ArrayList<Long>(pkIds);
        this.opService(this.opType, pkValues);
    }

    private void opService(String operateKey, List<Long> signInPkIds) {
        OperationResult operationResult = this.getOperationResult();
        IEBServiceFacade bankService = EBServiceFacadeFactory.getBankService();
        List<NoteResult> noteResults = bankService.draftPayBillOp(operateKey, signInPkIds);
        ArrayList<Long> successBillIdList = new ArrayList<Long>(10);
        ArrayList<OperateErrorInfo> operateErrorInfoList = new ArrayList<OperateErrorInfo>(signInPkIds.size());
        if (noteResults != null && noteResults.size() != 0) {
            for (NoteResult noteResult : noteResults) {
                if (EBResultStatusCode.SUCCESS.equals((Object)noteResult.getStatusCode())) {
                    successBillIdList.add(noteResult.getBillId());
                    continue;
                }
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(noteResult.getBillId() + ":" + noteResult.getErrMsg());
                operateErrorInfoList.add(operateErrorInfo);
                operationResult.setAllErrorInfo(operateErrorInfoList);
            }
        }
        operationResult.setSuccessPkIds(successBillIdList);
    }
}

