/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.draftbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.cdm.business.ebservice.api.IEBServiceFacade;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.NoteResult;

public class ElcDraftInfOnlineUpdateService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ElcDraftInfOnlineUpdateService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        List<Long> selectIds = Arrays.stream(dataEntities).map(e -> e.getLong("id")).collect(Collectors.toList());
        this.draftBillOnlineUpdate(selectIds);
    }

    private void draftBillOnlineUpdate(List<Long> selectIds) {
        IEBServiceFacade bankService = EBServiceFacadeFactory.getBankService();
        List<NoteResult> noteResults = bankService.queryDraftBillByIds(selectIds);
        ArrayList<Long> successBillIdList = new ArrayList<Long>(10);
        ArrayList<OperateErrorInfo> operateErrorInfoList = new ArrayList<OperateErrorInfo>(selectIds.size());
        for (NoteResult noteResult : noteResults) {
            if (EBResultStatusCode.SUCCESS.equals((Object)noteResult.getStatusCode())) {
                successBillIdList.add(noteResult.getBillId());
                continue;
            }
            logger.error(String.format("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0cerrCode:{%s}\uff0cerrMsg:{%s}\u3002", noteResult.getErrCode(), noteResult.getErrMsg()));
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(noteResult.getBillId() + ":" + noteResult.getErrMsg());
            operateErrorInfoList.add(operateErrorInfo);
            this.operationResult.setAllErrorInfo(operateErrorInfoList);
        }
        this.operationResult.setBillCount(noteResults.size());
        this.operationResult.setSuccessPkIds(successBillIdList);
    }
}

