/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.draftbill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.business.helper.ElectRecClaimRuleHelper;
import kd.tmc.cdm.common.helper.RecClaimHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcAppCache;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class EleDraftAutoClaimNoticeOpService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(EleDraftAutoClaimNoticeOpService.class);
    private static IAppCache cache = TmcAppCache.get((String)"cas", (String)"intelrec", (String)"claim");

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourceid");
        selector.add("signnoticebill");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
    }

    public void afterProcess(DynamicObject[] dynamicObjects) throws KDException {
        logger.info("\u5f85\u7b7e\u6536\u7968\u636e\u901a\u77e5\u8ba4\u9886\u6570\u636e\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\u5f00\u59cb...");
        try {
            ArrayList<DynamicObject> notifiedList = new ArrayList<DynamicObject>(18);
            ArrayList<DynamicObject> unNotifiedList = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> hasNoticeRuleList = new ArrayList<DynamicObject>(14);
            ArrayList<Long> noNoticeRuleList = new ArrayList<Long>(12);
            HashMap<String, String> hasNoticeRule = new HashMap<String, String>();
            for (DynamicObject electRecBill : dynamicObjects) {
                if (StringUtils.isEmpty((CharSequence)electRecBill.getString("signnoticebill"))) {
                    unNotifiedList.add(electRecBill);
                    continue;
                }
                notifiedList.add(electRecBill);
            }
            for (DynamicObject unNotified : unNotifiedList) {
                String tag;
                DynamicObject ruleResult = ElectRecClaimRuleHelper.getClaimInfoByNoticeRule(unNotified.getLong("id"), "noticeclaim");
                if (ruleResult == null) {
                    noNoticeRuleList.add(unNotified.getLong("id"));
                    continue;
                }
                String string = tag = ruleResult.get("e_savenotifi_TAG") == null ? "" : ruleResult.getString("e_savenotifi_TAG");
                if ("noticeclaim".equals(ruleResult.get("e_handlescheme")) && !StringUtils.isEmpty((CharSequence)tag)) {
                    String idStr = unNotified.getPkValue().toString();
                    hasNoticeRuleList.add(unNotified);
                    cache.put(idStr, (Object)tag);
                } else {
                    noNoticeRuleList.add(unNotified.getLong("id"));
                }
                if (!"noticeclaim".equals(ruleResult.get("e_handlescheme")) || StringUtils.isEmpty((CharSequence)ruleResult.getString("e_rulesname"))) continue;
                cache.put(unNotified.getPkValue().toString() + "rulesname", ruleResult.get("e_rulesname"));
                hasNoticeRule.put(unNotified.getPkValue().toString(), ruleResult.get("e_savenotifi_TAG").toString());
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            Object[] hasNoticeRuleIds = hasNoticeRuleList.stream().map(DataEntityBase::getPkValue).toArray();
            OperationResult operationResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"pushclaimcenterbill", (String)"cdm_electronic_sign_deal", (Object[])hasNoticeRuleIds, (OperateOption)option);
            if (!operationResult.isSuccess()) {
                for (IOperateInfo iOperateInfo : operationResult.getAllErrorOrValidateInfo()) {
                    logger.info("EleDraftAutoClaimNoticeOpService.afterProcess pushclaimcenterbill operationResult id = {} ,message = {}", iOperateInfo.getPkValue(), (Object)iOperateInfo.getMessage());
                }
            }
            if (noNoticeRuleList.size() > 0) {
                logger.info("EleDraftAutoClaimNoticeOpService.afterProcess noNoticeRuleList id = {}", (Object)((Object)noNoticeRuleList).toString());
            }
            this.noticeMessage(hasNoticeRule);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f85\u7b7e\u6536\u7968\u636e\u901a\u77e5\u8ba4\u9886\u6570\u636e\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\u8c03\u5ea6\u4efb\u52a1\u5f02\u5e38%s", (String)"EleDraftBillClaimNoticeTask_0", (String)"tmc-cdm-business", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void noticeMessage(Map<String, String> ruleNotice) {
        HashMap claimTypeMap = new HashMap(ruleNotice.size());
        for (Map.Entry<String, String> rule : ruleNotice.entrySet()) {
            Map map = (Map)SerializationUtils.fromJsonString((String)rule.getValue(), Map.class);
            HashMap<String, List> typeValue = new HashMap<String, List>();
            typeValue.put("usergroupids", (List)map.get("usergroupids"));
            typeValue.put("orgids", (List)map.get("orgids"));
            typeValue.put("roleids", (List)map.get("roleids"));
            typeValue.put("userids", (List)map.get("userids"));
            claimTypeMap.put(rule.getKey(), typeValue);
        }
        RecClaimHelper.sendClaimNoticeMessage(claimTypeMap, (String)"notice");
    }
}

