/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.draftbill;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.service.billstorage.PayEleBillStorageService;
import kd.tmc.cdm.business.service.billstorage.RecEleBillStorageService;
import kd.tmc.cdm.business.service.billstorage.bean.StorageResult;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftCirStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.cdm.common.enums.EleDraftIsNewECDS;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.helper.EleDraftHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;

public class EleDraftOfflineSignInService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(EleDraftOfflineSignInService.class);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(16);
        sic.add("id");
        sic.add("tradetype");
        sic.add("ticketstatus");
        sic.add("ebstatus");
        sic.add("company");
        sic.add("sourceid");
        sic.add("sourcenumber");
        sic.add("querydrafttype");
        sic.add("billno");
        sic.add("preholdername");
        sic.add("grdbag");
        sic.add("bankmsg");
        sic.add("notestatus");
        sic.add("subrange");
        sic.add("cirstatus");
        sic.add("amount");
        sic.add("locamt");
        sic.add("initsubrange");
        sic.add("usedamount");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject signDealBill : dataEntities) {
            try {
                StorageResult storageResult;
                Long billId;
                Object[] recBills;
                signDealBill.set("tradetype", (Object)"notesignin");
                String noteStatus = signDealBill.getString("notestatus");
                String subRange = signDealBill.getString("subrange");
                if (EleDraftIsNewECDS.NEW.getValue().equals(EleDraftHelper.isNewECDs((String)noteStatus, (String)subRange))) {
                    signDealBill.set("notestatus", (Object)EleDraftNoteStatusEnum.CS03.getValue());
                    signDealBill.set("cirstatus", (Object)EleDraftCirStatusEnum.TF0301.getValue());
                } else {
                    String nextTicketStatus = EleDraftBillStatusEnum.getNextDraftBillStatus((String)signDealBill.getString("ticketstatus"));
                    signDealBill.set("ticketstatus", (Object)nextTicketStatus);
                    logger.info("EleDraftOfflineSignInService process start eleBillId = {},billNo = {},ticketStatus = {}", new Object[]{signDealBill.getLong("id"), signDealBill.getString("billno"), nextTicketStatus});
                }
                signDealBill.set("ebstatus", (Object)EbStatus.BANK_SUCCESS.getName());
                signDealBill.set("querydrafttype", (Object)EleDraftExistCatEnum.HOLD.getValue());
                signDealBill.set("bankmsg", (Object)(RequestContext.get().getUserName() + " " + ResManager.loadKDString((String)"\u79bb\u7ebf\u7b7e\u6536", (String)"EleDraftOfflineSignInService_0", (String)"tmc-cdm-business", (Object[])new Object[0])));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{signDealBill});
                boolean isFromAlloc = this.dealSameBillNo(signDealBill);
                ArrayList<Long> arrayList = new ArrayList<Long>(1);
                arrayList.add(signDealBill.getLong("id"));
                List<StorageResult> storage = RecEleBillStorageService.storage(arrayList, signDealBill.getDynamicObject("company"));
                logger.info("EleDraftOfflineSignInService process RecEleBillStorageService storage result = " + storage.size() + "-" + storage.get(0).getBillId() + "-" + storage.get(0).getSuccess());
                if (storage.size() <= 0 || !storage.get(0).getSuccess().booleanValue()) continue;
                signDealBill.set("sourceid", (Object)storage.get(0).getBillId());
                signDealBill.set("sourcenumber", (Object)storage.get(0).getBillNo());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{signDealBill});
                if (!isFromAlloc || !EmptyUtil.isNoEmpty((Object[])(recBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,isfromalloc,billpool,poollockorg,poollockstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(billId = (storageResult = storage.get(0)).getBillId()))})))) continue;
                Object recBill = recBills[0];
                recBill.set("isfromalloc", (Object)true);
                recBill.set("billpool", null);
                recBill.set("poollockstatus", (Object)"");
                recBill.set("poollockorg", null);
                TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{recBill});
            }
            catch (Exception e) {
                logger.error("EleDraftOfflineSignInService error\uff1a" + e);
                throw e;
            }
        }
    }

    private boolean dealSameBillNo(DynamicObject electBill) {
        boolean isFromAlloc = false;
        String tradeType = electBill.getString("tradetype");
        String ebStatus = electBill.getString("ebstatus");
        logger.info("EleDraftOfflineSignInService.dealSameBillNo.dealSameBillNo noteNo = {}, tradeType = {} ,ebStatus = {}", new Object[]{electBill.getString("billno"), tradeType, ebStatus});
        if (ElcDraftBillOpEnum.NOTESIGNIN.getValue().equals(tradeType) && EbStatus.BANK_SUCCESS.getName().equals(ebStatus)) {
            QFilter eleRecQFilter = new QFilter("id", "!=", (Object)electBill.getLong("id"));
            eleRecQFilter.and("billno", "=", (Object)electBill.getString("billno"));
            eleRecQFilter.and(new QFilter("company.name", "=", (Object)electBill.getString("preholdername")));
            eleRecQFilter.and(new QFilter("querydrafttype", "=", (Object)EleDraftExistCatEnum.HOLD.getValue()));
            eleRecQFilter.and(new QFilter("tradetype", "=", (Object)ElcDraftBillOpEnum.NOTEENDORSE.getValue()));
            eleRecQFilter.and(new QFilter("ticketstatus", "=", (Object)EleDraftBillStatusEnum.RECITE.getValue()).or(new QFilter("notestatus", "=", (Object)EleDraftNoteStatusEnum.CS03.getValue())));
            eleRecQFilter.and(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue()));
            DynamicObjectCollection electRecBills = QueryServiceHelper.query((String)"cdm_electronic_sign_deal", (String)"id", (QFilter[])new QFilter[]{eleRecQFilter});
            if (electRecBills.size() == 1) {
                long existEleRecId = ((DynamicObject)electRecBills.get(0)).getLong("id");
                logger.info(String.format("\u5185\u90e8\u8c03\u7968\u80cc\u4e66\u5f85\u7b7e\u6536\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\uff0c\u67e5\u8be2\u540c\u7968\u53f7id = %s", existEleRecId));
                DynamicObject[] existElectRecBills = BusinessDataServiceHelper.load((Object[])new Object[]{existEleRecId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_sign_deal"));
                if (existElectRecBills.length == 0) {
                    return isFromAlloc;
                }
                for (DynamicObject existElectBill : existElectRecBills) {
                    if (existElectBill.getBoolean("grdbag")) {
                        existElectBill.set("notestatus", (Object)EleDraftNoteStatusEnum.CS03.getValue());
                        existElectBill.set("cirstatus", (Object)EleDraftCirStatusEnum.TF0301.getValue());
                    } else {
                        existElectBill.set("ticketstatus", (Object)EleDraftBillStatusEnum.RECITESIGNED.getValue());
                    }
                    existElectBill.set("ebstatus", (Object)electBill.getString("ebstatus"));
                }
                SaveServiceHelper.save((DynamicObject[])existElectRecBills);
                EleDraftHelper.splitBill((DynamicObject)electBill);
                logger.info(String.format("\u5185\u90e8\u8c03\u7968\u80cc\u4e66\u5f85\u7b7e\u6536\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\u8c03\u7528\u6536\u7968\u767b\u8bb0\u5165\u5e93\u63a5\u53e3id = %s", existEleRecId));
                List<StorageResult> recResults = RecEleBillStorageService.storage(Collections.singletonList(existEleRecId), existElectRecBills[0].getDynamicObject("company"));
                for (StorageResult storageResult : recResults) {
                    QFilter qFilter = new QFilter("entrys.draftbill.id", "=", (Object)storageResult.getBillId());
                    qFilter.and(new QFilter("entrys.billamt", "=", (Object)existElectRecBills[0].getLong("locamt")));
                    qFilter.and(new QFilter("isrepay", "=", (Object)"0"));
                    qFilter.and(new QFilter("billstatus", "!=", (Object)"S"));
                    qFilter.and(new QFilter("electag", "=", (Object)Boolean.TRUE));
                    DynamicObject[] draftTradeBills = BusinessDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    logger.info(String.format("\u5185\u90e8\u8c03\u7968\u80cc\u4e66\u5f85\u7b7e\u6536\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\u67e5\u8be2\u80cc\u4e66\u4e1a\u52a1\u5bf9\u5e94\u7684\u4e1a\u52a1\u5904\u7406\u5355draftTradeBills.length= %s", draftTradeBills.length));
                    if (!storageResult.getSuccess().booleanValue() || draftTradeBills.length <= 0) continue;
                    DynamicObject draftTradeBill = TmcDataServiceHelper.loadSingle((Object)draftTradeBills[0].getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_drafttradebill"));
                    String sourceStr = draftTradeBill.getString("source");
                    DynamicObjectCollection entrys = draftTradeBill.getDynamicObjectCollection("entrys");
                    for (DynamicObject entry : entrys) {
                        DynamicObject draftBill = entry.getDynamicObject("draftbill");
                        if (!Objects.equals(storageResult.getBillId(), draftBill.getPkValue())) continue;
                        entry.set("isnotneedgen", (Object)Boolean.TRUE);
                        isFromAlloc = "cdm-draftallocate".equals(sourceStr);
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{draftTradeBill});
                }
                logger.info(String.format("\u5185\u90e8\u8c03\u7968\u80cc\u4e66\u5f85\u7b7e\u6536\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\u8c03\u7528\u6536\u7968\u767b\u8bb0\u5165\u5e93\u63a5\u53e3\u5b8c\u6210\uff0c\u8fd4\u56de\u4fe1\u606f %s", recResults.size() > 0 ? recResults.get(0).getBillId() + "_" + recResults.get(0).getErrMsg() : ""));
            }
            QFilter elePayQFilter = new QFilter("id", "!=", (Object)electBill.getLong("id"));
            elePayQFilter.and("billno", "=", (Object)electBill.getString("billno"));
            elePayQFilter.and(new QFilter("company.name", "=", (Object)electBill.getString("preholdername")));
            elePayQFilter.and(new QFilter("ticketstatus", "=", (Object)EleDraftBillStatusEnum.INVOICE.getValue()));
            elePayQFilter.and(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.PAYBILL.getValue()).or(new QFilter("notestatus", "=", (Object)EleDraftNoteStatusEnum.CS03.getValue())));
            DynamicObjectCollection electPayBills = QueryServiceHelper.query((String)"cdm_electronic_pay_deal", (String)"id", (QFilter[])new QFilter[]{elePayQFilter});
            if (electPayBills.size() == 1) {
                long existElectPayId = ((DynamicObject)electPayBills.get(0)).getLong("id");
                logger.info(String.format("\u5185\u90e8\u8c03\u7968\u63d0\u793a\u6536\u7968\u5f85\u7b7e\u6536\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\uff0c\u67e5\u8be2\u540c\u7968\u53f7id = %s", existElectPayId));
                DynamicObject[] existElectPayBills = BusinessDataServiceHelper.load((Object[])new Object[]{existElectPayId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_pay_deal"));
                if (existElectPayBills.length == 0) {
                    return isFromAlloc;
                }
                for (DynamicObject existElectBill : existElectPayBills) {
                    if (existElectBill.getBoolean("grdbag")) {
                        existElectBill.set("notestatus", (Object)EleDraftNoteStatusEnum.CS03.getValue());
                        existElectBill.set("cirstatus", (Object)EleDraftCirStatusEnum.TF0301.getValue());
                    } else {
                        existElectBill.set("ticketstatus", (Object)EleDraftBillStatusEnum.INVOICESIGNED.getValue());
                    }
                    existElectBill.set("ebstatus", (Object)electBill.getString("ebstatus"));
                }
                SaveServiceHelper.save((DynamicObject[])existElectPayBills);
                logger.info(String.format("\u5185\u90e8\u8c03\u7968\u63d0\u793a\u6536\u7968\u5f85\u7b7e\u6536\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\u8c03\u7528\u6536\u7968\u767b\u8bb0\u5165\u5e93\u63a5\u53e3id = %s", existElectPayId));
                List<StorageResult> results = PayEleBillStorageService.storage(Collections.singletonList(existElectPayId), Boolean.TRUE);
                logger.info(String.format("\u5185\u90e8\u8c03\u7968\u63d0\u793a\u6536\u7968\u5f85\u7b7e\u6536\u66f4\u65b0\u64cd\u4f5c\u7ed3\u679c\u8c03\u7528\u6536\u7968\u767b\u8bb0\u5165\u5e93\u63a5\u53e3\u5b8c\u6210\uff0c\u8fd4\u56de\u4fe1\u606f %s", results.size() > 0 ? results.get(0).getBillId() + "_" + results.get(0).getErrMsg() : ""));
            }
        }
        return isFromAlloc;
    }
}

