/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.draftbill;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.service.billstorage.RecEleBillStorageService;
import kd.tmc.cdm.business.service.billstorage.bean.StorageResult;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class EleDraftSignStorageService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(EleDraftSignStorageService.class);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("company");
        sic.add("sourceid");
        sic.add("sourcenumber");
        return sic;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        for (DynamicObject dynamicObject : dynamicObjects) {
            List<Long> storageDataList = Collections.singletonList(dynamicObject.getLong("id"));
            List<StorageResult> StorageResults = RecEleBillStorageService.storage(storageDataList, dynamicObject.getDynamicObject("company"));
            if (StorageResults.isEmpty()) {
                this.operationResult.setSuccess(false);
                this.operationResult.setMessage(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u6ee1\u8db3\u5165\u5e93\u6761\u4ef6", (String)"EleDraftSignStorageService_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
                continue;
            }
            StringBuilder totalErrMsgSb = new StringBuilder();
            for (StorageResult storageResult : StorageResults) {
                if (!storageResult.getSuccess().booleanValue()) {
                    totalErrMsgSb.append(storageResult.getBillId()).append(":");
                    totalErrMsgSb.append(storageResult.getErrMsg()).append(";");
                    continue;
                }
                dynamicObject.set("sourceid", (Object)storageResult.getBillId());
                dynamicObject.set("sourcenumber", (Object)storageResult.getBillNo());
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
            if (totalErrMsgSb.length() <= 0) continue;
            this.operationResult.setSuccess(false);
            this.operationResult.setMessage(totalErrMsgSb.toString().substring(0, totalErrMsgSb.length() - 1));
        }
    }
}

