/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.draftbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.service.billstorage.PayEleBillStorageService;
import kd.tmc.cdm.business.service.billstorage.RecEleBillStorageService;
import kd.tmc.cdm.business.service.billstorage.bean.StorageResult;
import kd.tmc.cdm.common.enums.ElcDraftBillOpEnum;
import kd.tmc.cdm.common.enums.EleDraftExistCatEnum;
import kd.tmc.cdm.common.helper.EleDraftHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.enums.BankReturnStatusEnum;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;

public class EleEbStatusChangeAuditService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(EleEbStatusChangeAuditService.class);
    private static final String OP_DRAFTSYNC = "draftSync";
    private static final String LOG_PREFIX = "[EleStatusChange]";

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("sourceid");
        sic.add("sourcetype");
        sic.add("billno");
        sic.add("company");
        sic.add("entryentity.bankmsg");
        sic.add("entryentity.tradetype");
        sic.add("entryentity.ebstatus");
        sic.add("entryentity.ticketstatus");
        sic.add("entryentity.afterebstatus");
        sic.add("entryentity.afterticketstatus");
        sic.add("entryentity.operatestatus");
        sic.add("entryentity.afternotestatus");
        sic.add("entryentity.aftercirstatus");
        sic.add("entryentity.bizfinishdate");
        sic.add("entryentity.billsourceid");
        return sic;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
    }

    public void beforeProcess(List<ExtendedDataEntity> dynamicObjects) throws KDException {
        for (ExtendedDataEntity extendedDataEntity : dynamicObjects) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entries = data.getDynamicObjectCollection("entryentity");
            Map sourceIdAndChangeElectBillMap = entries.stream().collect(Collectors.toMap(entry -> entry.get("billsourceid"), Function.identity()));
            List sourceIdList = entries.stream().map(entry -> entry.getLong("billsourceid")).map(Object::toString).collect(Collectors.toList());
            String sourceType = data.getString("sourcetype");
            Map request = MutexServiceHelper.batchRequestWithLostTime(sourceIdList, (String)"cdm_electronicbill", (String)OP_DRAFTSYNC);
            ArrayList errors = new ArrayList();
            List requestIds = MutexServiceHelper.getRequestResultList(sourceIdList, errors, (Map)request);
            try {
                DynamicObject entryEntity;
                DynamicObject[] electBillList;
                if (sourceIdList.size() != requestIds.size()) {
                    ArrayList errorIds = new ArrayList(10);
                    errors.forEach(error -> errorIds.add(error.getPkValue()));
                    throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u72b6\u6001\u53d8\u66f4\u5355\u5ba1\u6838\u65f6\u7533\u8bf7\u5206\u5e03\u9501\u5931\u8d25\uff0c\u5931\u8d25\u7684\u7535\u7968id\uff1a%s", (String)"EleEbStatusChangeAuditService_2", (String)"tmc-cdm-business", (Object[])new Object[]{errorIds}));
                }
                for (DynamicObject electBill2 : electBillList = TmcDataServiceHelper.load((Object[])sourceIdList.stream().map(Long::parseLong).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)sourceType))) {
                    entryEntity = (DynamicObject)sourceIdAndChangeElectBillMap.get(electBill2.getPkValue());
                    if (StringUtils.isNotEmpty((CharSequence)entryEntity.getString("afterebstatus"))) {
                        electBill2.set("ebstatus", (Object)entryEntity.getString("afterebstatus"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)entryEntity.getString("afterticketstatus"))) {
                        electBill2.set("ticketstatus", entryEntity.get("afterticketstatus"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)entryEntity.getString("afternotestatus"))) {
                        electBill2.set("notestatus", entryEntity.get("afternotestatus"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)entryEntity.getString("aftercirstatus"))) {
                        electBill2.set("cirstatus", entryEntity.get("aftercirstatus"));
                    }
                    electBill2.set("bankmsg", (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u72b6\u6001\u53d8\u66f4\u5355\u4fee\u6539\u3002", (String)"EleEbStatusChangeAuditService_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                }
                SaveServiceHelper.save((DynamicObject[])electBillList);
                if ("cdm_electronic_pay_deal".equals(sourceType)) {
                    List<Long> successElectBillList = Arrays.stream(electBillList).filter(electBill -> EbStatus.BANK_SUCCESS.getName().equals(electBill.getString("ebstatus"))).map(electBill -> Long.parseLong(electBill.getPkValue().toString())).collect(Collectors.toList());
                    if (EmptyUtil.isNoEmpty(successElectBillList)) {
                        PayEleBillStorageService.storage(successElectBillList, Boolean.FALSE);
                    }
                } else {
                    for (DynamicObject electBill2 : electBillList) {
                        StorageResult storageResult;
                        List<StorageResult> results;
                        String ebStatus = electBill2.getString("ebstatus");
                        String tradeType = electBill2.getString("tradetype");
                        DynamicObject company = electBill2.getDynamicObject("company");
                        if (EbStatus.BANK_SUCCESS.getName().equals(ebStatus) && !ElcDraftBillOpEnum.NOTESIGNINREJECT.getValue().equals(tradeType) && !ElcDraftBillOpEnum.NOTECANCLE.getValue().equals(tradeType)) {
                            EleDraftHelper.splitBill((DynamicObject)electBill2);
                            results = RecEleBillStorageService.storage(Collections.singletonList(electBill2.getPkValue() == null ? 0L : Long.parseLong(electBill2.getPkValue().toString())), company);
                            if (!EmptyUtil.isNoEmpty(results) || !(storageResult = results.get(0)).getSuccess().booleanValue()) continue;
                            electBill2.set("sourceid", (Object)storageResult.getBillId());
                            electBill2.set("sourcenumber", (Object)storageResult.getBillNo());
                            if (ElcDraftBillOpEnum.NOTESIGNIN.getValue().equals(electBill2.getString("tradetype"))) {
                                electBill2.set("querydrafttype", (Object)EleDraftExistCatEnum.HOLD.getValue());
                            }
                            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{electBill2});
                            continue;
                        }
                        if (!EbStatus.BANK_FAIL.getName().equals(ebStatus) || !EmptyUtil.isNoEmpty(results = RecEleBillStorageService.storage(Collections.singletonList(electBill2.getPkValue() == null ? 0L : Long.parseLong(electBill2.getPkValue().toString())), company)) || !(storageResult = results.get(0)).getSuccess().booleanValue()) continue;
                        electBill2.set("sourceid", (Object)storageResult.getBillId());
                        electBill2.set("sourcenumber", (Object)storageResult.getBillNo());
                        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{electBill2});
                    }
                }
                for (DynamicObject electBill2 : electBillList) {
                    entryEntity = (DynamicObject)sourceIdAndChangeElectBillMap.get(electBill2.getPkValue());
                    entryEntity.set("operatestatus", (Object)"success");
                }
                this.processElectSourceBillData(sourceType, entries, electBillList);
            }
            catch (Exception e) {
                LOGGER.error("\u64cd\u4f5c\u72b6\u6001\u53d8\u66f4\u5355\u5ba1\u6838\u65f6\u5199\u5165\u7535\u7968\u5f02\u5e38\u3002", (Throwable)e);
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{data});
                throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u72b6\u6001\u53d8\u66f4\u5355\u5ba1\u6838\u65f6\u5199\u5165\u7535\u7968\u5f02\u5e38\u3002", (String)"EleEbStatusChangeAuditService_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            finally {
                MutexServiceHelper.batchRelease((List)requestIds, (String)"cdm_electronicbill", (String)OP_DRAFTSYNC);
            }
        }
    }

    private void processElectSourceBillData(String sourceType, DynamicObjectCollection entries, DynamicObject[] electBillList) {
        Map idAndElectBillMap = Arrays.stream(electBillList).filter(electBill -> EmptyUtil.isNoEmpty((Long)electBill.getLong("sourceid"))).collect(Collectors.toMap(entry -> entry.getLong("id"), Function.identity()));
        List electBillSourceIdList = Arrays.stream(electBillList).filter(electBill -> EmptyUtil.isNoEmpty((Long)electBill.getLong("sourceid"))).map(electBill -> electBill.getLong("sourceid")).collect(Collectors.toList());
        LOGGER.info("[EleStatusChange]\u4ece\u6570\u636e\u5e93\u67e5\u8be2\u7684\u7535\u7968\u4fe1\u606f\u5217\u8868\u5927\u5c0f\uff08\u8fc7\u6ee4\u7535\u7968\u6e90\u5355id\u4e3a\u7a7a\uff09\uff1a{}, \u7535\u7968\u6e90\u5355id\uff1a{}", (Object)electBillSourceIdList.size(), electBillSourceIdList);
        if ("cdm_electronic_pay_deal".equals(sourceType)) {
            Object[] payableBillArray = TmcDataServiceHelper.load((Object[])electBillSourceIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_payablebill"));
            if (EmptyUtil.isEmpty((Object[])payableBillArray)) {
                return;
            }
            LOGGER.info("[EleStatusChange]\u5e94\u4ed8\u7968\u636e\u5217\u8868\u5927\u5c0f\uff1a{}", (Object)payableBillArray.length);
            Map idAndPayBillMap = Arrays.stream(payableBillArray).collect(Collectors.toMap(entry -> entry.getLong("id"), Function.identity()));
            ArrayList<DynamicObject> updateResultList = new ArrayList<DynamicObject>(10);
            for (DynamicObject entryEntity : entries) {
                DynamicObject payableBill;
                Long sourceId;
                DynamicObject electBill2;
                String afterebStatus = entryEntity.getString("afterebstatus");
                Date bizFinishDate = entryEntity.getDate("bizfinishdate");
                if (!StringUtils.equals((CharSequence)afterebStatus, (CharSequence)BankReturnStatusEnum.BANK_SUCCESS.getValue()) || EmptyUtil.isEmpty((Object)bizFinishDate) || EmptyUtil.isEmpty((DynamicObject)(electBill2 = (DynamicObject)idAndElectBillMap.get(sourceId = Long.valueOf(entryEntity.getLong("billsourceid"))))) || EmptyUtil.isEmpty((DynamicObject)(payableBill = (DynamicObject)idAndPayBillMap.get(electBill2.getLong("sourceid"))))) continue;
                payableBill.set("issuedate", (Object)bizFinishDate);
                updateResultList.add(payableBill);
            }
            if (EmptyUtil.isNoEmpty(updateResultList)) {
                LOGGER.info("[EleStatusChange]\u6700\u540e\u53cd\u5199\u7ed3\u679c\u5927\u5c0f\uff1a{}\uff0cid\uff1a{}", (Object)updateResultList.size(), updateResultList.stream().map(e -> e.getLong("id")).collect(Collectors.toList()));
                SaveServiceHelper.update((DynamicObject[])updateResultList.toArray(new DynamicObject[0]));
            }
        } else if ("cdm_electronic_sign_deal".equals(sourceType)) {
            Object[] receivableBillArray = TmcDataServiceHelper.load((Object[])electBillSourceIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_receivablebill"));
            if (EmptyUtil.isEmpty((Object[])receivableBillArray)) {
                return;
            }
            LOGGER.info("[EleStatusChange]\u5e94\u6536\u7968\u636e\u5217\u8868\u5927\u5c0f\uff1a{}", (Object)receivableBillArray.length);
            Map idAndReceiveBillMap = Arrays.stream(receivableBillArray).collect(Collectors.toMap(entry -> entry.getLong("id"), Function.identity()));
            ArrayList<DynamicObject> updateResultList = new ArrayList<DynamicObject>(10);
            for (DynamicObject entryEntity : entries) {
                DynamicObject receivableBill;
                Long sourceId;
                DynamicObject electBill3;
                String afterebStatus = entryEntity.getString("afterebstatus");
                Date bizFinishDate = entryEntity.getDate("bizfinishdate");
                if (!StringUtils.equals((CharSequence)afterebStatus, (CharSequence)BankReturnStatusEnum.BANK_SUCCESS.getValue()) || EmptyUtil.isEmpty((Object)bizFinishDate) || EmptyUtil.isEmpty((DynamicObject)(electBill3 = (DynamicObject)idAndElectBillMap.get(sourceId = Long.valueOf(entryEntity.getLong("billsourceid"))))) || EmptyUtil.isEmpty((DynamicObject)(receivableBill = (DynamicObject)idAndReceiveBillMap.get(electBill3.getLong("sourceid"))))) continue;
                receivableBill.set("bizdate", (Object)bizFinishDate);
                updateResultList.add(receivableBill);
            }
            if (EmptyUtil.isNoEmpty(updateResultList)) {
                LOGGER.info("[EleStatusChange]\u6700\u540e\u53cd\u5199\u7ed3\u679c\u5927\u5c0f\uff1a{}\uff0cid\uff1a{}", (Object)updateResultList.size(), updateResultList.stream().map(e -> e.getLong("id")).collect(Collectors.toList()));
                SaveServiceHelper.update((DynamicObject[])updateResultList.toArray(new DynamicObject[0]));
            }
        } else if ("cdm_electronic_rec_deal".equals(sourceType)) {
            Object[] draftTradeBills = TmcDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id,bizfinishdate,entrys,entrys.draftbill", (QFilter[])new QFilter[]{new QFilter("entrys.draftbill.id", "in", electBillSourceIdList)});
            if (EmptyUtil.isEmpty((Object[])draftTradeBills)) {
                return;
            }
            LOGGER.info("[EleStatusChange]\u4e1a\u52a1\u5904\u7406\u5355\u5217\u8868\u5927\u5c0f\uff1a{}", (Object)draftTradeBills.length);
            HashSet<Object> updateResultSet = new HashSet<Object>(10);
            for (DynamicObject entryEntity : entries) {
                Long sourceId;
                DynamicObject electBill4;
                String afterebStatus = entryEntity.getString("afterebstatus");
                Date bizFinishDate = entryEntity.getDate("bizfinishdate");
                if (!StringUtils.equals((CharSequence)afterebStatus, (CharSequence)BankReturnStatusEnum.BANK_SUCCESS.getValue()) || EmptyUtil.isEmpty((Object)bizFinishDate) || EmptyUtil.isEmpty((DynamicObject)(electBill4 = (DynamicObject)idAndElectBillMap.get(sourceId = Long.valueOf(entryEntity.getLong("billsourceid")))))) continue;
                long eleBillSourceId = electBill4.getLong("sourceid");
                for (Object tradeBill : draftTradeBills) {
                    boolean exist = false;
                    DynamicObjectCollection tradeBillEntries = tradeBill.getDynamicObjectCollection("entrys");
                    for (DynamicObject entry2 : tradeBillEntries) {
                        DynamicObject draft = entry2.getDynamicObject("draftbill");
                        if (!EmptyUtil.isNoEmpty((DynamicObject)draft) || eleBillSourceId != draft.getLong("id")) continue;
                        tradeBill.set("bizfinishdate", (Object)bizFinishDate);
                        exist = true;
                        break;
                    }
                    if (!exist) continue;
                    updateResultSet.add(tradeBill);
                }
            }
            if (EmptyUtil.isNoEmpty(updateResultSet)) {
                LOGGER.info("[EleStatusChange]\u6700\u540e\u53cd\u5199\u7ed3\u679c\u5927\u5c0f\uff1a{}\uff0cid\uff1a{}", (Object)updateResultSet.size(), updateResultSet.stream().map(e -> e.getLong("id")).collect(Collectors.toList()));
                SaveServiceHelper.update((DynamicObject[])updateResultSet.toArray(new DynamicObject[0]));
            }
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
    }
}

