/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.business.lock.DraftLockServiceFactory;
import kd.tmc.cdm.business.service.DraftAmountLockSubInfo;
import kd.tmc.cdm.business.service.DraftLockInfo;
import kd.tmc.cdm.business.service.LockResult;
import kd.tmc.cdm.common.enums.LogBizStatusEnum;
import kd.tmc.cdm.common.enums.LogBizTypeEnum;
import kd.tmc.cdm.common.enums.OperateTypeEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DiscountApplySaveService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(DiscountApplySaveService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("draftbill");
        selector.add("isinvalid");
        selector.add("entrys.billamt");
        selector.add("entrys.billlogid");
        selector.add("billno");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List<DraftLockInfo> lockAndReleaseInfoList = this.getLockAndReleaseInfo(dataEntities);
        List<LockResult> lockResultList = DraftLockServiceFactory.getService().lock(lockAndReleaseInfoList, true);
        if (EmptyUtil.isNoEmpty(lockResultList)) {
            List failLockResultList = lockResultList.stream().filter(e -> !e.isSuccess()).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(failLockResultList)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5360\u7528\u66f4\u65b0\u65e5\u5fd7\u5931\u8d25\u3002", (String)"DiscountApplySaveService_0", (String)"tmc-cdm-business", (Object[])new Object[0]));
            }
            Map<Long, LockResult> tradeIdAndDyMap = lockResultList.stream().collect(Collectors.toMap(LockResult::getSourceBillId, x -> x));
            for (DynamicObject data : dataEntities) {
                long payBillId = data.getLong("id");
                DynamicObjectCollection entrys = data.getDynamicObjectCollection("entrys");
                for (DynamicObject entry : entrys) {
                    Long draftBillId = entry.getDynamicObject("draftbill").getLong("id");
                    LockResult lockResult = tradeIdAndDyMap.get(payBillId);
                    if (!EmptyUtil.isNoEmpty((Object)lockResult)) continue;
                    Map<Long, Long> billIdLogIdMap = lockResult.getBillIdLogIdMap();
                    boolean success = lockResult.isSuccess();
                    Long billLogId = billIdLogIdMap.get(draftBillId);
                    if (!EmptyUtil.isNoEmpty((Long)billLogId) || !success) continue;
                    entry.set("billlogid", (Object)billLogId);
                }
            }
        }
    }

    private List<DraftLockInfo> getLockAndReleaseInfo(DynamicObject[] dataEntities) {
        ArrayList<DraftLockInfo> lockAndReleaseInfoList = new ArrayList<DraftLockInfo>(8);
        DynamicObjectType dynamicObjectType = dataEntities[0].getDynamicObjectType();
        String sourceBillTypeStr = dynamicObjectType.getName();
        Set tradeBillIdSet = Arrays.stream(dataEntities).map(e -> e.getLong("id")).collect(Collectors.toSet());
        Object[] tradeBillDyArr = TmcDataServiceHelper.load((Object[])tradeBillIdSet.toArray(), (DynamicObjectType)dynamicObjectType);
        Map<Object, Object> tradeBillIdAndDyMap = new HashMap(8);
        if (EmptyUtil.isNoEmpty((Object[])tradeBillDyArr)) {
            tradeBillIdAndDyMap = Arrays.stream(tradeBillDyArr).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        }
        for (DynamicObject data : dataEntities) {
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            long tradeBillId = data.getLong("id");
            String billNoStr = data.getString("billno");
            draftLockInfo.setBillTrade(LogBizTypeEnum.DISCOUNT.getValue());
            draftLockInfo.setSourceBillId(tradeBillId);
            draftLockInfo.setSourceBillType(sourceBillTypeStr);
            draftLockInfo.setBizBillNo(billNoStr);
            DynamicObjectCollection entrysColl = data.getDynamicObjectCollection("entrys");
            List entrys = entrysColl.stream().filter(e -> !e.getBoolean("isinvalid")).collect(Collectors.toList());
            List lockDraftIds = entrys.stream().map(v -> v.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toList());
            HashMap draftIdDealAmountMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getBigDecimal("billamt"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdLogIdMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getLong("billlogid"), (o1, o2) -> o1, HashMap::new));
            ArrayList<DraftAmountLockSubInfo> lockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (Long lockDraftId : lockDraftIds) {
                DraftAmountLockSubInfo draftAmountLockSubInfo = new DraftAmountLockSubInfo();
                draftAmountLockSubInfo.setBillId(lockDraftId);
                Long billLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                draftAmountLockSubInfo.setBillLogId(billLogId);
                BigDecimal dealAmount = draftIdDealAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(lockDraftId);
                draftAmountLockSubInfo.setDealAmount(dealAmount);
                draftAmountLockSubInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                draftAmountLockSubInfo.setBillTrade(LogBizTypeEnum.DISCOUNT.getValue());
                lockSubInfoList.add(draftAmountLockSubInfo);
            }
            draftLockInfo.setLockSubInfoList(lockSubInfoList);
            DynamicObject tradeBillDB = (DynamicObject)tradeBillIdAndDyMap.get(tradeBillId);
            if (EmptyUtil.isNoEmpty((DynamicObject)tradeBillDB)) {
                DynamicObjectCollection entrysFromDB = tradeBillDB.getDynamicObjectCollection("entrys");
                List entrysDB = entrysFromDB.stream().filter(e -> !e.getBoolean("isinvalid")).collect(Collectors.toList());
                List lockDraftIdsDB = entrysDB.stream().map(v -> v.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toList());
                HashMap draftIdDealAmountMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getBigDecimal("billamt"), (o1, o2) -> o1, HashMap::new));
                HashMap draftIdLogIdMapDB = entrysDB.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbill").getLong("id"), o -> o.getLong("billlogid"), (o1, o2) -> o1, HashMap::new));
                ArrayList<DraftAmountLockSubInfo> releaseSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
                for (Long lockDraftIdDB : lockDraftIdsDB) {
                    if (lockDraftIds.contains(lockDraftIdDB)) continue;
                    DraftAmountLockSubInfo draftAmountreleaseSubInfo = new DraftAmountLockSubInfo();
                    draftAmountreleaseSubInfo.setBillId(lockDraftIdDB);
                    Long draftLogId = draftIdLogIdMapDB.get(lockDraftIdDB) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMapDB.get(lockDraftIdDB);
                    draftAmountreleaseSubInfo.setBillLogId(draftLogId);
                    BigDecimal dealAmount = draftIdDealAmountMapDB.get(lockDraftIdDB) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMapDB.get(lockDraftIdDB);
                    draftAmountreleaseSubInfo.setDealAmount(dealAmount);
                    draftAmountreleaseSubInfo.setOperateType(OperateTypeEnum.DELETE.getValue());
                    draftAmountreleaseSubInfo.setBillTrade(LogBizTypeEnum.DISCOUNT.getValue());
                    releaseSubInfoList.add(draftAmountreleaseSubInfo);
                }
                draftLockInfo.getLockSubInfoList().addAll(releaseSubInfoList);
            }
            lockAndReleaseInfoList.add(draftLockInfo);
        }
        return lockAndReleaseInfoList;
    }
}

