/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableApplyBillBatchUnSubmitService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayableApplyBillBatchUnSubmitService.class);
    private boolean isRpcSuccess;

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("creditlimit");
        sic.add("draftbilltype");
        sic.add("billstatus");
        sic.add("drawercompany");
        sic.add("bizdate");
        sic.add("billno");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataObj : dataEntities) {
            if (!EmptyUtil.isNoEmpty((DynamicObject)dataObj.getDynamicObject("creditlimit"))) continue;
            logger.info("PayableApplyBillBatchUnSubmitService start cancelCreditLimit");
            CreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)dataObj, null, (boolean)true);
            this.isRpcSuccess = creditLimitInfo.isSuccess();
            logger.info("PayableApplyBillBatchUnSubmitService cancelCreditLimit isRpcSuccess:" + this.isRpcSuccess);
            if (this.isRpcSuccess) continue;
            this.operationResult.setSuccess(false);
            throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{creditLimitInfo.getMessage()});
        }
        TmcDataServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        super.handlerException(dataEntities);
        if (this.isRpcSuccess) {
            try {
                for (DynamicObject data : dataEntities) {
                    if (!EmptyUtil.isNoEmpty((DynamicObject)data.getDynamicObject("creditlimit"))) continue;
                    CreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)data, null, (boolean)true, (Date)data.getDate("bizdate"));
                    this.isRpcSuccess = creditLimitInfo.isSuccess();
                    if (this.isRpcSuccess) continue;
                    throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{creditLimitInfo.getMessage()});
                }
            }
            catch (Exception e) {
                logger.error("Exception", (Throwable)e);
                throw e;
            }
        }
    }
}

