/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.common.enums.SettleMentTypeEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillApBatchCreaditSubmitService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayableBillApBatchCreaditSubmitService.class);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("draweraccount");
        sic.add("drawerbankname");
        sic.add("drawerbankno");
        sic.add("creditlimit");
        sic.add("company");
        sic.add("currency");
        sic.add("draftbilltype");
        sic.add("accepterfinorg");
        sic.add("acceptercompany");
        sic.add("creditamount");
        sic.add("creditlimitorg");
        sic.add("creditlimitcompany");
        sic.add("amounttotal");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        logger.info("afterProcess is start");
        for (DynamicObject data : dataEntities) {
            if (EmptyUtil.isNoEmpty((DynamicObject)data.getDynamicObject("creditlimit"))) {
                try {
                    logger.info("start to do cfm");
                    long id = data.getLong("id");
                    DynamicObject creditLimit = data.getDynamicObject("creditlimit");
                    if (EmptyUtil.isEmpty((DynamicObject)creditLimit)) continue;
                    CreditLimitUseBean useBean = this.getCreditLimitUseInfo(data);
                    useBean.setPreOccupy(Boolean.valueOf(true));
                    useBean.setCreditLimitNo(creditLimit.getString("number"));
                    useBean.setCreditLimitId(Long.valueOf(creditLimit.getLong("id")));
                    CreditLimitServiceHelper.autoUseCreditLimit((CreditLimitUseBean)useBean);
                    logger.info("do cfm end");
                }
                catch (Exception e) {
                    logger.error("afterProcess e:", (Throwable)e);
                }
                CreditLimitInfo creditLimitInfo = CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)data, null, (boolean)true, (Date)data.getDate("bizdate"));
                boolean isRpcSuccess = creditLimitInfo.isSuccess();
                if (!isRpcSuccess) {
                    this.operationResult.setSuccess(false);
                    throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{creditLimitInfo.getMessage()});
                }
            }
            logger.info("afterProcess is end");
        }
    }

    private CreditLimitUseBean getCreditLimitUseInfo(DynamicObject bill) {
        CreditLimitUseBean useBean = new CreditLimitUseBean();
        useBean.setPkId(Long.valueOf(bill.getLong("id")));
        useBean.setEntityName(bill.getDataEntityType().getName());
        useBean.setOrgId((Long)bill.getDynamicObject("company").getPkValue());
        useBean.setCurrencyId((Long)bill.getDynamicObject("currency").getPkValue());
        DynamicObject draftbilltype = bill.getDynamicObject("draftbilltype");
        if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltype)) {
            String settlementType = draftbilltype.getString("settlementtype");
            if (SettleMentTypeEnum.BANK.getValue().equals(settlementType)) {
                useBean.setFinOrgId(Long.valueOf(bill.getDynamicObject("creditlimitorg").getLong("id")));
                useBean.setCreditFinType("bd_finorginfo");
            } else if (SettleMentTypeEnum.BUSINESS.getValue().equals(settlementType)) {
                useBean.setFinOrgId(Long.valueOf(bill.getDynamicObject("creditlimitcompany").getLong("id")));
                useBean.setCreditFinType("bos_org");
            }
            DynamicObject credittypeDO = draftbilltype.getDynamicObject("credittype");
            if (EmptyUtil.isNoEmpty((DynamicObject)credittypeDO)) {
                useBean.setCreditTypeId((Long)credittypeDO.getPkValue());
            } else {
                DynamicObject creditType = TmcDataServiceHelper.loadSingle((String)"cfm_credittype", (String)"iscomprehensive", (QFilter[])new QFilter[]{new QFilter("iscomprehensive", "=", (Object)"1")});
                useBean.setCreditTypeId((Long)creditType.getPkValue());
            }
            useBean.setCreditVariety(draftbilltype.getString("name"));
        }
        useBean.setMaxAmt(bill.getBigDecimal("amounttotal"));
        useBean.setStartDate(bill.getDate("bizdate"));
        Date bizdate = bill.getDate("bizdate");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(bizdate);
        calendar.add(2, 13);
        Date afterTime = calendar.getTime();
        useBean.setEndDate(afterTime);
        useBean.setBizAmt(bill.getBigDecimal("creditamount"));
        useBean.setSourceBillId(Long.valueOf(bill.getLong("id")));
        return useBean;
    }

    private BigDecimal getCreditRatio(DynamicObject bill) {
        String entityName = bill.getDataEntityType().getName();
        DynamicObject creditUseBill = CreditLimitServiceHelper.getCreditUseBill((Long)((Long)bill.getPkValue()), (String)entityName);
        if (creditUseBill != null) {
            return creditUseBill.getBigDecimal("creditratio");
        }
        return Constants.ONE_HUNDRED;
    }
}

