/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillApBatchSaveOrSubmitService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayableBillApBatchSaveOrSubmitService.class);
    private Map<String, List<DynamicObject>> bankaccountnumberMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<Long, DynamicObject> bankIdMap = new HashMap<Long, DynamicObject>(16);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("draweraccount");
        sic.add("drawerbankname");
        sic.add("drawerbankno");
        sic.add("amounttotal");
        sic.add("entry_gcontract");
        sic.add("entry_gcontract.gcontract");
        sic.add("entry_gcontract.gcreditguarantee");
        sic.add("entry_gcontract.gamount");
        sic.add("entry_gcontract.gratio");
        sic.add("entry_gcontract.gcontractamount");
        sic.add("entry_gcontract.gcontractcurrency");
        sic.add("entry_gcontract.gexchrate");
        sic.add("entry_gcontract.gcomment");
        sic.add("entry_gcontract.gsrcbillid");
        sic.add("entry_gcontract.gsrcbilltype");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        logger.info("process is start that:" + dataEntities.length);
        this.preDealDatas(dataEntities);
        for (DynamicObject data : dataEntities) {
            this.setDrawerBankNameAndNo(data);
        }
        logger.info("process is end:");
    }

    private void preDealDatas(DynamicObject[] dataEntities) {
        DynamicObjectCollection bankDyColl;
        DynamicObjectCollection accountmains;
        HashSet<String> bankaccountnumberSet = new HashSet<String>(16);
        HashSet<Long> bankIdSet = new HashSet<Long>(16);
        for (DynamicObject data : dataEntities) {
            DynamicObjectCollection entryentity = data.getDynamicObjectCollection("entryentity");
            for (DynamicObject entity : entryentity) {
                DynamicObject drawerAccount = entity.getDynamicObject("draweraccount");
                if (EmptyUtil.isEmpty((DynamicObject)drawerAccount)) continue;
                bankaccountnumberSet.add(drawerAccount.getString("bankaccountnumber"));
                if (!EmptyUtil.isNoEmpty((DynamicObject)drawerAccount.getDynamicObject("bank"))) continue;
                bankIdSet.add(drawerAccount.getDynamicObject("bank").getLong("id"));
            }
        }
        if (EmptyUtil.isNoEmpty(bankaccountnumberSet) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(accountmains = QueryServiceHelper.query((String)"am_accountmaintenance", (String)"id,billbank,billbank.name,billbankname,account.bankaccountnumber", (QFilter[])new QFilter[]{new QFilter("account.bankaccountnumber", "in", bankaccountnumberSet)})))) {
            this.bankaccountnumberMap = accountmains.stream().collect(Collectors.groupingBy(e -> e.getString("account.bankaccountnumber")));
        }
        if (EmptyUtil.isNoEmpty(bankIdSet) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(bankDyColl = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id,bebank,union_number,bebank.union_number,bebank.number", (QFilter[])new QFilter[]{new QFilter("id", "in", bankIdSet)})))) {
            this.bankIdMap = bankDyColl.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
    }

    private void setDrawerBankNameAndNo(DynamicObject data) {
        DynamicObjectCollection entryentity = data.getDynamicObjectCollection("entryentity");
        for (DynamicObject entity : entryentity) {
            DynamicObject drawerAccount = entity.getDynamicObject("draweraccount");
            if (EmptyUtil.isEmpty((DynamicObject)drawerAccount)) continue;
            String bankAccountNumber = drawerAccount.getString("bankaccountnumber");
            List<Object> accountmaintenances = new ArrayList(16);
            if (EmptyUtil.isNoEmpty((String)bankAccountNumber)) {
                accountmaintenances = this.bankaccountnumberMap.get(bankAccountNumber);
            }
            if (!EmptyUtil.isEmpty(accountmaintenances)) {
                DynamicObject accountmaintenance = (DynamicObject)accountmaintenances.get(0);
                long billBank = accountmaintenance.getLong("billbank");
                if (!EmptyUtil.isEmpty((Long)billBank)) {
                    entity.set("drawerbankname", (Object)accountmaintenance.getString("billbank.name"));
                }
                entity.set("drawerbankno", (Object)accountmaintenance.getString("billbankname"));
                logger.info("PayableBillApBatchSaveOrSubmitService accountmaintenances not empty,billbank is \uff1a" + accountmaintenance.getLong("billbank") + ",billbankname is :" + accountmaintenance.getString("billbankname"));
                continue;
            }
            if (EmptyUtil.isEmpty((DynamicObject)drawerAccount.getDynamicObject("bank"))) {
                return;
            }
            DynamicObject bank = drawerAccount.getDynamicObject("bank");
            DynamicObject finOrgInfoDO = this.bankIdMap.get(bank.getLong("id"));
            entity.set("drawerbankname", (Object)bank.getString("name"));
            if (finOrgInfoDO.getLong("bebank") == 0L) {
                entity.set("drawerbankno", (Object)finOrgInfoDO.getString("union_number"));
                continue;
            }
            String union_number = finOrgInfoDO.getString("bebank.union_number");
            if (StringUtils.isEmpty((CharSequence)union_number)) {
                entity.set("drawerbankno", (Object)finOrgInfoDO.getString("bebank.number"));
                continue;
            }
            entity.set("drawerbankno", (Object)union_number);
        }
    }
}

