/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cdm.common.helper.SystemParameterHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillAuditService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayableBillAuditService.class);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("creditlimit");
        sic.add("draftbilltranstatus");
        sic.add("draftbilltype");
        sic.add("drawercompany");
        sic.add("amount");
        sic.add("supperbillamount");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        logger.info("PayableBillAuditService process is start that:" + dataEntities.length);
        Set<Long> openParamOrgIdSet = this.preDealDbData(dataEntities);
        HashSet<Long> willCallDrawPayBillSet = new HashSet<Long>(16);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject drawerCompany = dataEntity.getDynamicObject("drawercompany");
            boolean isElectronicBill = openParamOrgIdSet.contains(drawerCompany.getLong("id"));
            if (!isElectronicBill) {
                willCallDrawPayBillSet.add(dataEntity.getLong("id"));
                continue;
            }
            String draftBillType = dataEntity.getDynamicObject("draftbilltype").getString("billmedium");
            if (!"1".equals(draftBillType)) continue;
            willCallDrawPayBillSet.add(dataEntity.getLong("id"));
        }
        if (EmptyUtil.isNoEmpty(willCallDrawPayBillSet) && willCallDrawPayBillSet.size() > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"drawbillsave", (String)"cdm_payablebill", (Object[])willCallDrawPayBillSet.toArray(new Long[0]), (OperateOption)option);
        }
        logger.info("PayableBillAuditService process is end");
    }

    private Set<Long> preDealDbData(DynamicObject[] dataEntities) {
        HashSet<Long> openParamOrgIdSet = new HashSet<Long>(16);
        HashSet<Long> drawerIdSet = new HashSet<Long>(16);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject drawerCompany = dataEntity.getDynamicObject("drawercompany");
            drawerIdSet.add(drawerCompany.getLong("id"));
        }
        if (EmptyUtil.isNoEmpty(drawerIdSet)) {
            Map paraMaps = SystemParameterHelper.getSysParamMap(drawerIdSet);
            for (Map.Entry paraMap : paraMaps.entrySet()) {
                boolean iselectronicbill;
                String keyId = (String)paraMap.getKey();
                Map valueMap = (Map)paraMap.getValue();
                if (!EmptyUtil.isNoEmpty((Object)valueMap) || !(iselectronicbill = ((Boolean)valueMap.get("iselectronicbill")).booleanValue())) continue;
                openParamOrgIdSet.add(Long.parseLong(keyId));
            }
        }
        logger.info("PayableBillAuditrService preDealDbData is end:");
        return openParamOrgIdSet;
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        logger.info("afterProcess is start");
        super.afterProcess(dataEntities);
        try {
            for (DynamicObject dataEntity : dataEntities) {
                BigDecimal billamount = dataEntity.getBigDecimal("supperbillamount");
                BigDecimal amount = dataEntity.getBigDecimal("amount");
                if (!EmptyUtil.isEmpty((BigDecimal)billamount)) continue;
                dataEntity.set("supperbillamount", (Object)amount);
            }
            TmcDataServiceHelper.save((DynamicObject[])dataEntities);
        }
        catch (Exception e) {
            logger.error("afterProcess has error :", (Throwable)e);
        }
        logger.info("afterProcess is end");
    }
}

