/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.opservice.payablebill.PayableBillCancelRelatedPreBillService;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.EleDraftNoteStatusEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillAutoRelatedPreBillService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(PayableBillCancelRelatedPreBillService.class);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(10);
        sic.add("company");
        sic.add("isrelatedprebill");
        sic.add("relatedelcbillid");
        sic.add("electag");
        sic.add("eledraftstatus");
        sic.add("draftbilltranstatus");
        sic.add("contractno");
        sic.add("eledraftstatusnew");
        sic.add("draftbillno");
        sic.add("elccirculatestatus");
        sic.add("issplit");
        sic.add("subbillrange");
        sic.add("subbillstartflag");
        sic.add("subbillendflag");
        sic.add("subbillquantity");
        sic.add("amount");
        sic.add("originalsubbillrang");
        sic.add("billidentitycode");
        sic.add("originalsubbillamount");
        sic.add("source");
        return sic;
    }

    public void process(DynamicObject[] payablebills) throws KDException {
        QFilter elefilter;
        Object[] electronicPayBills;
        logger.info("PayableBillAutoRelatedPreBillService process is start");
        if (EmptyUtil.isEmpty((Object[])payablebills)) {
            return;
        }
        ArrayList<DynamicObject> updatePaybills = new ArrayList<DynamicObject>(10);
        ArrayList<Object> updateElebills = new ArrayList<Object>(10);
        Map payableAndPrebill = Arrays.stream(payablebills).collect(Collectors.toMap(o -> o.getLong("relatedelcbillid"), Function.identity()));
        Map<Object, Object> preBillsInfo = new HashMap();
        Set<Long> ids = payableAndPrebill.keySet();
        if (EmptyUtil.isNoEmpty(ids) && EmptyUtil.isNoEmpty((Object[])(electronicPayBills = BusinessDataServiceHelper.load((String)"cdm_electronic_pay_deal", (String)"id,sourceid,sourcenumber,rptype,billno,notestatus,ticketstatus,cirstatus,electag,isrelatedprebill,tradecontractno,grdbag,subrange", (QFilter[])new QFilter[]{elefilter = new QFilter("id", "in", (Object)ids.toArray())})))) {
            preBillsInfo = Arrays.stream(electronicPayBills).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
            for (Object object : electronicPayBills) {
                String payableBillNo = ((DynamicObject)payableAndPrebill.get(object.getLong("id"))).getString("billno");
                Long payableBIllId = ((DynamicObject)payableAndPrebill.get(object.getLong("id"))).getLong("id");
                object.set("sourcenumber", (Object)payableBillNo);
                object.set("sourceid", (Object)payableBIllId);
                object.set("rptype", (Object)"paybill");
                updateElebills.add(object);
            }
        }
        for (DynamicObject payablebill : payablebills) {
            Long relatedelcbillid = payablebill.getLong("relatedelcbillid");
            DynamicObject dynamicObject = (DynamicObject)preBillsInfo.get(relatedelcbillid);
            payablebill.set("relatedelcbillid", (Object)dynamicObject.getLong("id"));
            payablebill.set("draftbillno", (Object)dynamicObject.getString("billno"));
            payablebill.set("eledraftstatusnew", (Object)dynamicObject.getString("notestatus"));
            payablebill.set("eledraftstatus", (Object)dynamicObject.getString("ticketstatus"));
            payablebill.set("elccirculatestatus", (Object)dynamicObject.getString("cirstatus"));
            payablebill.set("electag", (Object)true);
            payablebill.set("isrelatedprebill", (Object)true);
            payablebill.set("contractno", (Object)dynamicObject.getString("tradecontractno"));
            payablebill.set("issplit", dynamicObject.get("grdbag"));
            String subRange = dynamicObject.getString("subrange");
            payablebill.set("subbillrange", (Object)subRange);
            if (EmptyUtil.isNoEmpty((String)subRange) && subRange.contains("-")) {
                long subBillStartFlag = Long.parseLong(subRange.split("-")[0]);
                long subBillEndFlag = Long.parseLong(subRange.split("-")[1]);
                payablebill.set("subbillstartflag", (Object)subBillStartFlag);
                payablebill.set("subbillendflag", (Object)subBillEndFlag);
                payablebill.set("subbillquantity", (Object)(subBillEndFlag - subBillStartFlag + 1L));
            }
            DraftHelper.setBillCodeinfo((DynamicObject)payablebill);
            String eledraftstatus = payablebill.getString("eledraftstatus");
            String eledraftstatusnew = payablebill.getString("eledraftstatusnew");
            String draftbilltranstatus = payablebill.getString("draftbilltranstatus");
            if (!EleDraftBillStatusEnum.INVOICESIGNED.getValue().equals(eledraftstatus) && !EleDraftNoteStatusEnum.CS03.getValue().equals(eledraftstatusnew) && !DraftTranStatusEnum.SUCCESS.getValue().equals(draftbilltranstatus) || (EleDraftBillStatusEnum.INVOICESIGNED.getValue().equals(eledraftstatus) || EleDraftNoteStatusEnum.CS03.getValue().equals(eledraftstatusnew)) && EmptyUtil.isNoEmpty((String)draftbilltranstatus) && !DraftTranStatusEnum.SUCCESS.getValue().equals(draftbilltranstatus) && DraftTranStatusEnum.FAILING.getValue().equals(draftbilltranstatus)) {
                payablebill.set("draftbilltranstatus", (Object)DraftTranStatusEnum.HANDLEING.getValue());
            }
            updatePaybills.add(payablebill);
        }
        if (EmptyUtil.isNoEmpty(updatePaybills) && updatePaybills.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updatePaybills.toArray(new DynamicObject[0]));
            logger.info("\u5f00\u7968\u767b\u8bb0\u63d0\u4ea4\u81ea\u52a8\u5173\u8054\u9884\u51fa\u7968\u6210\u529f\uff0c\u66f4\u65b0\u5e94\u4ed8\u7968\u636e" + updatePaybills.size() + "\u6761");
        }
        if (EmptyUtil.isNoEmpty(updateElebills) && updateElebills.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updateElebills.toArray(new DynamicObject[0]));
            logger.info("\u5f00\u7968\u767b\u8bb0\u63d0\u4ea4\u81ea\u52a8\u5173\u8054\u9884\u51fa\u7968\u6210\u529f\uff0c\u66f4\u65b0\u7535\u7968" + updateElebills.size() + "\u6761");
        }
        logger.info("PayableBillCancelRelatedPreBillService process is end");
    }
}

