/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.CasHelper;
import kd.tmc.cdm.common.helper.ChequeHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillDeleteService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(PayableBillDeleteService.class);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("basedraftbillno");
        sic.add("billstatus");
        sic.add("source");
        sic.add("sourcebillid");
        sic.add("draftbillno");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String invalidCdm = (String)this.getOperationVariable().get("invalidcdm");
        if (Objects.isNull(invalidCdm)) {
            for (DynamicObject data : dataEntities) {
                Object billNo = data.get("basedraftbillno");
                if (EmptyUtil.isEmpty((Object)billNo)) continue;
                ChequeHelper.updateByDel((Object)((DynamicObject)billNo).getPkValue());
            }
        }
        Object[] deleteIds = Arrays.stream(dataEntities).filter(o -> !o.get("billstatus").equals("H")).toArray();
        DeleteServiceHelper.delete((IDataEntityType)dataEntities[0].getDataEntityType(), (Object[])deleteIds);
        for (DynamicObject data : dataEntities) {
            String failErrorMsg;
            String sourceBillId = data.getString("sourcebillid");
            if (!EmptyUtil.isNoEmpty((String)sourceBillId)) continue;
            if (SourceEnum.CAS.getValue().equals(data.get("source"))) {
                try (TXHandle tx = TX.requiresNew();){
                    DynamicObject payBill = QueryServiceHelper.queryOne((String)"cas_paybill", (String)"id,sourcebillid,sourcebilltype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(sourceBillId))});
                    if (!EmptyUtil.isNoEmpty((DynamicObject)payBill)) continue;
                    logger.info("payBill is:" + payBill.getLong("id"));
                    CasHelper.removePayApplyCasDraftInfo((DynamicObject)data, (DynamicObject)payBill);
                    continue;
                }
                catch (Exception e) {
                    logger.error("casdel bill has error", (Throwable)e);
                    throw e;
                }
            }
            if (!SourceEnum.IFM.getValue().equals(data.get("source")) || !EmptyUtil.isNoEmpty((String)(failErrorMsg = DraftHelper.callIfmTransBillPayStatus((DynamicObject)data, (String)"A")))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e %1$s \u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u4ed8\u6b3e\u5931\u8d25\uff1a%2$s\u3002", (String)"PayableBillSubmitService_2", (String)"tmc-cdm-business", (Object[])new Object[0]), data.getString("billno"), failErrorMsg));
        }
    }
}

