/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.business.opservice.payablebill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.enums.ChequeStatusEnum;
import kd.tmc.cdm.common.enums.PayBillStatusEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.CasHelper;
import kd.tmc.cdm.common.helper.CasWriteBackHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.SuretyHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayableBillInvalidService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(PayableBillInvalidService.class);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("basedraftbillno");
        sic.add("draftbilltype");
        sic.add("source");
        sic.add("sourcebillid");
        sic.add("billstatus");
        sic.add("isrefund");
        sic.add("releatedcasbillentrys");
        sic.add("draftbillno");
        sic.add("releatedcasbillentrys.rel_billtype");
        sic.add("releatedcasbillentrys.rel_billno");
        sic.add("releatedcasbillentrys.rel_billid");
        sic.add("releatedcasbillentrys.rel_bizdate");
        sic.add("releatedcasbillentrys.rel_billamount");
        sic.add("releatedcasbillentrys.rel_createtime");
        sic.add("releatedcasbillentrys.rel_modifytime");
        sic.add("releatedcasbillentrys.rel_isrefuse");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        logger.info("start invalid bill");
        for (DynamicObject data : dataEntities) {
            Object billNo = data.get("basedraftbillno");
            data.set("billstatus", (Object)"H");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
            if (DraftHelper.isPromissory((Object)data.get("draftbilltype")) && EmptyUtil.isNoEmpty((Object)billNo)) {
                DynamicObject cheque = (DynamicObject)billNo;
                DynamicObject newCheque = TmcDataServiceHelper.loadSingle((Object)cheque.getPkValue(), (String)"cdm_cheque_book");
                newCheque.set("chequestatus", (Object)ChequeStatusEnum.INVALID.getValue());
                newCheque.set("invaliduser", (Object)RequestContext.get().getCurrUserId());
                newCheque.set("invaliddate", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newCheque});
            }
            String sourceBillId = data.getString("sourcebillid");
            long sourCasBillId = Long.parseLong(sourceBillId);
            if (SourceEnum.CAS.getValue().equals(data.get("source")) && EmptyUtil.isNoEmpty((String)sourceBillId)) {
                OperateOption create = OperateOption.create();
                create.setVariableValue("invalidcdm", "invalidcdm");
                create.setVariableValue("isfrombilldelete", "y");
                try (TXHandle tx = TX.requiresNew();){
                    DynamicObject payBill = TmcDataServiceHelper.loadSingle((String)"cas_paybill", (String)"id,billstatus,draftbill,sourcebillid,sourcebilltype,applyorg,entrustorg,draftbillinfo", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(sourceBillId))});
                    if (EmptyUtil.isNoEmpty((DynamicObject)payBill)) {
                        logger.info("payBill is:" + payBill.getLong("id"));
                        DynamicObject srcPaybill = this.querySourceBills(payBill);
                        if (Objects.equals(PayBillStatusEnum.DRAFTING.getValue(), payBill.getString("billstatus"))) {
                            logger.info("writePayStatus  paybill");
                            CasWriteBackHelper.writePayStatus((String)sourceBillId, (String)PayBillStatusEnum.AUDIT.getValue());
                            if (null != srcPaybill && PayBillStatusEnum.DRAFTING.getValue().equals(srcPaybill.getString("billstatus"))) {
                                logger.info("writePayStatus  srcPaybill:" + srcPaybill.getLong("id"));
                                CasWriteBackHelper.writePayStatus((String)srcPaybill.getString("id"), (String)PayBillStatusEnum.AUDIT.getValue());
                            }
                        } else if (!data.getBoolean("isrefund")) {
                            logger.info("cancelpay  srcPaybill:" + sourceBillId);
                            OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Object[]{Long.valueOf(sourceBillId)}, (OperateOption)create);
                        }
                        payBill.set("draftbill", null);
                        payBill.getDynamicObjectCollection("cas_draftinfo").clear();
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payBill});
                        CasHelper.removePayApplyCasDraftInfo((DynamicObject)data, (DynamicObject)payBill);
                    }
                }
                catch (Exception e) {
                    logger.error("cas invalid bill has error", (Throwable)e);
                    this.restorePayBill(data, billNo);
                    throw e;
                }
                String sourceBillType = "cas_paybill";
                HashSet<DynamicObject> billSet = new HashSet<DynamicObject>(1);
                billSet.add(data);
                DraftHelper.updateDratBillCasEntry(billSet, (String)sourceBillType, (String)"delete", (Long)sourCasBillId);
            } else if (SourceEnum.APPLY.getValue().equals(data.get("source")) && EmptyUtil.isNoEmpty((String)sourceBillId)) {
                DynamicObject[] payBills = TmcDataServiceHelper.load((String)"cdm_payablebill_ap_manual", (String)"id,entryentity.payable", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "=", (Object)Long.valueOf(sourceBillId))});
                if (payBills != null && payBills.length > 0) {
                    DynamicObject payBill = payBills[0];
                    try (TXHandle tx = TX.requiresNew();){
                        DynamicObjectCollection entryentity = payBill.getDynamicObjectCollection("entryentity");
                        for (int i = 0; i < entryentity.size(); ++i) {
                            DynamicObject entry = (DynamicObject)entryentity.get(i);
                            String entryId = entry.getPkValue().toString();
                            if (!entryId.equals(sourceBillId)) continue;
                            entry.set("payable", (Object)false);
                        }
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payBill});
                    }
                    catch (Exception e) {
                        logger.error("cdm_payablebill_ap_manual invalid bill has error", (Throwable)e);
                        this.restorePayBill(data, billNo);
                        throw e;
                    }
                }
            } else if (SourceEnum.IFM.getValue().equals(data.get("source")) && EmptyUtil.isNoEmpty((String)sourceBillId)) {
                String failErrorMsg = DraftHelper.callIfmTransBillPayStatus((DynamicObject)data, (String)"A");
                if (EmptyUtil.isNoEmpty((String)failErrorMsg)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7968\u636e %1$s \u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u4ed8\u6b3e\u5931\u8d25\uff1a%2$s\u3002", (String)"PayableBillSubmitService_2", (String)"tmc-cdm-business", (Object[])new Object[0]), data.getString("billno"), failErrorMsg));
                }
                HashSet<DynamicObject> billSet = new HashSet<DynamicObject>(1);
                billSet.add(data);
                DraftHelper.updateDratBillCasEntry(billSet, (String)"ifm_transhandlebill", (String)"delete", (Long)sourCasBillId);
            }
            logger.info("start to update bill draftbillStatus");
            this.updateSuretyInputInfo(dataEntities);
        }
    }

    private void updateSuretyInputInfo(DynamicObject[] dataEntities) {
        Set payableBillIds = Arrays.stream(dataEntities).map(a -> a.getLong("id")).collect(Collectors.toSet());
        QFilter debtBillIdFilter = new QFilter("entry.debtbillid", "in", payableBillIds);
        Object[] suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"id,billno,entry,entry.debtbillno,entry.bizno,entry.applybillno,entry.applybillid,entry.debtbillid,entry.debttype", (QFilter[])new QFilter[]{debtBillIdFilter});
        if (EmptyUtil.isEmpty((Object[])suretyBills)) {
            logger.info("updateSuretyInputInfo,query by sourcebillid");
            Set sourceBillIds = Arrays.stream(dataEntities).map(a -> a.getLong("sourcebillid")).collect(Collectors.toSet());
            QFilter filter = new QFilter("entry.applybillid", "in", sourceBillIds);
            suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"id,billno,entry,entry.debtbillno,entry.bizno,entry.applybillno,entry.applybillid,entry.debtbillid,entry.debttype", (QFilter[])new QFilter[]{filter});
        }
        if (EmptyUtil.isEmpty((Object[])suretyBills)) {
            logger.info("cancelSuretiesLink start");
            SuretyHelper.cancelSuretiesLink((DynamicObject[])dataEntities);
            return;
        }
        logger.info("updateSuretyInputInfo,suretyBills.size:" + suretyBills.length + ",payableBillIds:" + JSON.toJSONString(payableBillIds));
        ArrayList<Object> needUpdateBills = new ArrayList<Object>(8);
        HashMap<String, DynamicObject> payableApplyBillsMap = this.getPayableApplyBillMap((DynamicObject[])suretyBills);
        for (Object suretyBill : suretyBills) {
            DynamicObjectCollection entrys = suretyBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                long applyBillId = entry.getLong("applybillid");
                String applyBillNo = entry.getString("applybillno");
                long debtbillid = entry.getLong("debtbillid");
                if (!EmptyUtil.isEmpty((Long)applyBillId) && !EmptyUtil.isEmpty((String)applyBillNo)) {
                    DynamicObject payableApplyBill = payableApplyBillsMap.get(applyBillNo);
                    if (EmptyUtil.isEmpty((DynamicObject)payableApplyBill) || !payableBillIds.contains(debtbillid)) continue;
                    entry.set("debtbillid", (Object)payableApplyBill.getLong("id"));
                    entry.set("debtbillno", (Object)applyBillNo);
                    entry.set("bizno", (Object)applyBillNo);
                    entry.set("debttype", (Object)"cdm_payablebill_ap_manual");
                    needUpdateBills.add(suretyBill);
                    continue;
                }
                logger.info("cancelSuretiesLink start");
                SuretyHelper.cancelSuretiesLink((DynamicObject[])dataEntities);
            }
        }
        Set suretyBillNos = needUpdateBills.stream().map(a -> a.getString("billno")).collect(Collectors.toSet());
        logger.info("needUpdateBills.size:" + needUpdateBills.size() + ",suretyBillNos:" + JSON.toJSONString(suretyBillNos));
        if (!EmptyUtil.isEmpty(needUpdateBills)) {
            SaveServiceHelper.save((DynamicObject[])needUpdateBills.toArray(new DynamicObject[0]));
        }
    }

    private HashMap<String, DynamicObject> getPayableApplyBillMap(DynamicObject[] suretyBills) {
        HashSet applyBillNoSet = new HashSet(8);
        for (DynamicObject suretyBill : suretyBills) {
            DynamicObjectCollection entrys = suretyBill.getDynamicObjectCollection("entry");
            Set applyBillNos = entrys.stream().map(a -> a.getString("applybillno")).collect(Collectors.toSet());
            applyBillNoSet.addAll(applyBillNos);
        }
        QFilter billNoFilter = new QFilter("billno", "in", applyBillNoSet);
        DynamicObject[] payableApplyBills = TmcDataServiceHelper.load((String)"cdm_payablebill_ap_manual", (String)"id,billno", (QFilter[])new QFilter[]{billNoFilter});
        HashMap payableApplyBillsMap = Arrays.stream(payableApplyBills).collect(Collectors.toMap(v -> v.getString("billno"), o -> o, (o1, o2) -> o1, HashMap::new));
        return payableApplyBillsMap;
    }

    private DynamicObject querySourceBills(DynamicObject paybill) {
        if (EmptyUtil.isEmpty((DynamicObject)paybill)) {
            return null;
        }
        DynamicObject srcPayBill = null;
        String sourcebilltype = paybill.getString("sourcebilltype");
        DynamicObject applyorg = paybill.getDynamicObject("applyorg");
        long sourcebillid = paybill.getLong("sourcebillid");
        if ("cas_paybill".equals(sourcebilltype) && applyorg != null && sourcebillid != 0L) {
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)sourcebillid), new QFilter("entrustorg", "is not null", null), new QFilter("entrustorg", "!=", (Object)0)};
            srcPayBill = TmcDataServiceHelper.loadSingle((String)"cas_paybill", (String)"id,billstatus,draftbill", (QFilter[])qFilters);
        }
        return srcPayBill;
    }

    private void restorePayBill(DynamicObject data, Object billNo) {
        data.set("billstatus", (Object)"A");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
        if (DraftHelper.isPromissory((Object)data.get("draftbilltype")) && EmptyUtil.isNoEmpty((Object)billNo)) {
            DynamicObject cheque = (DynamicObject)billNo;
            DynamicObject newCheque = TmcDataServiceHelper.loadSingle((Object)cheque.getPkValue(), (String)"cdm_cheque_book");
            newCheque.set("chequestatus", (Object)ChequeStatusEnum.FILL.getValue());
            newCheque.set("invaliduser", (Object)0L);
            newCheque.set("invaliddate", null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newCheque});
        }
    }
}

